/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActiveDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActivePromotionDirectDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActivePromotionDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.ActiveRebateDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.ext.GrantDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsUsersDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oa.OaResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.maihe.service.BusStoreService;
import com.yqbsoft.laser.service.ext.maihe.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.maihe.util.ComplianceRebEnums;
import com.yqbsoft.laser.service.ext.maihe.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.maihe.util.RebEnums;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "maihe.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        whWarehouseRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Throwable)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = this.restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        whOpstoreRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = this.restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendGrantToOa(GrantDomain grantDomain) {
        HashMap<String, String> SapMap = new HashMap<String, String>();
        SapMap.put("customerCode", "MH");
        SapMap.put("workCode", "OA-CJ-KH");
        SapMap.put("unitCode", "MH_OA_DMS");
        SapMap.put("userCode", "seeyon2");
        Date date = new Date();
        try {
            SapMap.put("calendar", DateUtils.parseDateToString((Date)date, (String)"yyyy-MM-dd"));
            SapMap.put("planStart", DateUtils.parseDateToString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SapMap.put("pk_robot", "cda96eb3c6cc4c7487ea783cb56d5596");
        SapMap.put("workParam", JsonUtil.buildNormalBinder().toJson((Object)grantDomain));
        String req = JsonUtil.buildNormalBinder().toJson(SapMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode("/oa/amoutApply");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(grantDomain.getTenantCode());
        String url = this.getUrl(grantDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.req", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".sendGrantToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65oa\u4f59\u989d\u7533\u8bf7\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        this.sendLog(logRouterlogDomain);
        if ("0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65a\u4f59\u989d\u7533\u8bf7\u51fa\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    @Override
    public String sendActiveToOa(ActiveDomain activeDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyDate", activeDomain.getApplyDate());
        map.put("applyPerson", activeDomain.getApplyPerson());
        map.put("applyDepart", activeDomain.getApplyDepart());
        map.put("brandName", activeDomain.getBrandName());
        map.put("grantType", activeDomain.getGrantType());
        map.put("startTime", activeDomain.getStartTime());
        map.put("endTime", activeDomain.getEndTime());
        if ("\u8fd4\u5229".equals(activeDomain.getGrantType())) {
            ActiveRebateDomain activeRebate = activeDomain.getActiveRebate();
            if ("1".equals(activeRebate.getRebType())) {
                map.put("rebType", "\u5355\u54c1\u8fd4\u5229");
                List<RebPointsUsersDomain> rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                ArrayList customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        HashMap<String, Object> customerMap = new HashMap<String, Object>();
                        customerMap.put("userSapCode", rebPointsUsersDomain.getPointsUserOp());
                        customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                        customerMap.put("skuName", rebPointsGoodsDomain.getPointsGoodsName());
                        customerMap.put("ratio", rebPointsGoodsDomain.getPointsuserGoodsRatio());
                        customerList.add(customerMap);
                    }
                }
                map.put("subList", customerList);
            } else if ("2".equals(activeRebate.getRebType())) {
                map.put("rebType", "\u6708\u8fd4");
                List<RebPointsUsersDomain> rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                ArrayList customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        HashMap<String, Object> customerMap = new HashMap<String, Object>();
                        customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                        customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                        HashMap<String, Object> skuMap = new HashMap<String, Object>();
                        skuMap.put("tenantCode", activeDomain.getTenantCode());
                        skuMap.put("classtreeCode", rebPointsGoodsDomain.getPointsGoodsTerm());
                        skuMap.put("channelCode", "plat");
                        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(skuMap);
                        if (rsSkuDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                            String skuNames = rsSkuDomainQueryResult.getList().stream().map(RsSkuDomain::getSkuName).collect(Collectors.joining(","));
                            customerMap.put("skuName", skuNames);
                            customerMap.put("ratio", rebPointsGoodsDomain.getPointsuserGoodsRatio());
                        }
                        customerList.add(customerMap);
                    }
                }
                map.put("subList", customerList);
            } else if ("3".equals(activeRebate.getRebType())) {
                map.put("rebType", "\u8fbe\u6807\u8fd4\u5229");
                map.put("rebSubType", ComplianceRebEnums.getNameByCode(activeRebate.getComplianceRebType()));
                List<RebPointsUsersDomain> rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
                ArrayList customerList = new ArrayList();
                for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                    for (RebPointsGoodsDomain rebPointsGoodsDomain : activeRebate.getRebPointsGoodsDomainList()) {
                        HashMap<String, Object> customerMap = new HashMap<String, Object>();
                        customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp());
                        customerMap.put("customerName", rebPointsUsersDomain.getPointsUserName());
                        if ("1".equals(activeRebate.getComplianceRebType())) {
                            customerMap.put("Q1", rebPointsUsersDomain.getPointsUserTerm());
                            customerMap.put("Q2", rebPointsUsersDomain.getPointsUserOp1());
                            customerMap.put("Q3", rebPointsUsersDomain.getPointsUserOp2());
                            customerMap.put("Q4", rebPointsUsersDomain.getPointsUserOp3());
                        } else {
                            customerMap.put("Y", rebPointsUsersDomain.getPointsUserOp());
                        }
                        HashMap<String, Object> skuMap = new HashMap<String, Object>();
                        skuMap.put("tenantCode", activeDomain.getTenantCode());
                        skuMap.put("classtreeCode", rebPointsGoodsDomain.getPointsGoodsTerm());
                        skuMap.put("channelCode", "plat");
                        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(skuMap);
                        if (rsSkuDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                            String skuNames = rsSkuDomainQueryResult.getList().stream().map(RsSkuDomain::getSkuName).collect(Collectors.joining(","));
                            customerMap.put("skuName", skuNames);
                            customerMap.put("ratio", rebPointsGoodsDomain.getPointsuserGoodsRatio());
                        }
                        customerList.add(customerMap);
                    }
                }
                map.put("subList", customerList);
            }
        } else if ("\u6d3b\u52a8\u8d39\u7528".equals(activeDomain.getGrantType())) {
            ActiveRebateDomain activeRebate = activeDomain.getActiveRebate();
            map.put("rebType", RebEnums.getNameByCode(activeRebate.getRebType()));
            List<RebPointsUsersDomain> rebPointsUsersDomainList = activeRebate.getRebPointsUsersDomainList();
            ArrayList customerList = new ArrayList();
            for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
                HashMap<String, String> customerMap = new HashMap<String, String>();
                customerMap.put("sapCode", rebPointsUsersDomain.getPointsUserOp1());
                customerMap.put("customerName", rebPointsUsersDomain.getPointsUserOp2());
                customerList.add(customerMap);
            }
            map.put("subList", customerList);
        } else if ("\u4fc3\u9500".equals(activeDomain.getGrantType())) {
            ActivePromotionDomain activePromotion = activeDomain.getActivePromotion();
            String activePromotionType = activePromotion.getActivePromotionType();
            if ("1".equals(activePromotionType)) {
                ActivePromotionDirectDomain activePromotionDirectDomain = activePromotion.getActivePromotionDirect();
            } else if ("2".equals(activePromotionType) || "3".equals(activePromotionType) || "4".equals(activePromotionType)) {
                // empty if block
            }
            map.put("rebType", RebEnums.getNameByCode(activePromotionType));
        }
        return "success";
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            logger.error(this.SYS_CODE + ".getUrl.param");
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        logger.info(this.SYS_CODE + ".getUrl.field", (Object)field);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public void sendLog(LogRouterlogDomain logRouterlogDomain) {
        String api_code = "log.logRouterlog.saveRouterlog";
        if (null == logRouterlogDomain) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
        this.inAsyncInvoke(api_code, paramMap);
    }
}

