/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelUserService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelUserBaseService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CallBackBean;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.PayToPlatform;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.ServiceMessageHeaderDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util.StringUtils;
import com.yqbsoft.laser.service.ext.channel.pinganbank.service.PinganPayamentService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.IdUtil;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder1;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PingBankUtils;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PinganSdkUtils;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ChannelUserServiceImpl
extends ChannelUserBaseService
implements ChannelUserService {
    @Autowired
    PinganPayamentService payamentService;

    public Object channelUserInsert(Map<String, Object> map) {
        return super.channelUserInsert(map);
    }

    public Object channelUserUpdate(Map<String, Object> map) {
        this.logger.info("channelUserUpdate:" + JSON.toJSONString(map));
        if (StringUtils.isBlank(PayBuilder.getURL())) {
            Map configMap = this.getConfigMap(null, ChannelConfigScope.PRO.getCode(), "pingan", "029", "2020021100000063");
            this.logger.info("configMap:" + JSON.toJSONString((Object)configMap));
            PayBuilder.setURL((String)configMap.get("url"));
        }
        if (map.containsKey("resStream")) {
            String stream = map.get("resStream").toString();
            if (stream.length() > 344) {
                return this.payamentService.callbackDispatcherMethod(stream);
            }
            return "error:stream length less than 344";
        }
        return "error:no stream";
    }

    public Object channelUserDel(Map<String, Object> map) {
        return super.channelUserDel(map);
    }

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> map) {
        Map requestData = channelRequest.getRequestData();
        MemberDomain member = null;
        if (null != map.get("memberCode")) {
            member = this.getMemberDomain(map);
        }
        String channelApiCode = channelRequest.getChannelApiCode();
        String requestParam = "";
        if ("cmc.channelUser.channelUserBlocking".equals(channelApiCode) || "cmc.channelUser.channelUserUnfreeze".equals(channelApiCode)) {
            String func = null == requestData.get("func") ? "" : requestData.get("func").toString();
            String funcFlag = null == requestData.get("funcFlag") ? "" : requestData.get("funcFlag").toString();
            BigDecimal amount = null == requestData.get("amount") ? BigDecimal.ZERO : (BigDecimal)requestData.get("amount");
            String serverType = null == requestData.get("serverType") ? "" : requestData.get("serverType").toString();
            String orderNo = IdUtil.getPinganId(func, funcFlag, serverType);
            PayToPlatform payToPlatform = PayBuilder1.buildPayToPlatform(member, amount, orderNo, funcFlag);
            String content = PayBuilder.toFormatString(payToPlatform);
            requestParam = ChannelUserServiceImpl.buildMessage(func, serverType, orderNo, content);
        } else if ("cmc.channelUser.channelPlatPayAndTake".equals(channelApiCode)) {
            String content = PingBankUtils.toFormatString(this.makeContent(member, map, requestData, channelApiCode));
            if (MapUtil.isEmpty((Map)requestData)) {
                this.logger.error("cmc.ChannelOauthBaseServicesend.channelRequest", (Object)(channelApiCode + " =:= " + channelRequest));
                return ChannelRlRequest.makeMsg((ChannelRlRequest)channelRequest, (String)CallBackBean.returnMsg(CallBackBean.FALSE, "requestData is null", ""));
            }
            requestParam = PingBankUtils.buildMessage((String)requestData.get("func"), (String)requestData.get("serverType"), System.currentTimeMillis() + "", content);
            if (StringUtils.isBlank(requestParam)) {
                this.logger.error("cmc.ChannelOauthBaseServicesend.channelRequest", (Object)(channelApiCode + " =:= " + channelRequest));
                return ChannelRlRequest.makeMsg((ChannelRlRequest)channelRequest, (String)CallBackBean.returnMsg(CallBackBean.FALSE, "requestParam is null! " + content + "=:=" + requestData, ""));
            }
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("requestParam", requestParam);
        channelRequest.setRequestData(requestMap);
        return channelRequest;
    }

    public Map<String, Object> makeContent(MemberDomain member, Map<String, Object> map, Map<String, Object> requestData, String channelApiCode) {
        LinkedHashMap<String, Object> makeParamMap = new LinkedHashMap<String, Object>();
        if ("cmc.channelUser.channelPlatPayAndTake".equals(channelApiCode)) {
            makeParamMap.put("supAcctId", member.getSupAcctId());
            makeParamMap.put("funcFlag", map.get("funcFlag"));
            makeParamMap.put("custAcctId", member.getCustAcctId());
            makeParamMap.put("thirdCustId", member.getThirdCustId());
            makeParamMap.put("tranAmount", map.get("tranAmount"));
            makeParamMap.put("ccyCode", requestData.get("ccyCode"));
            makeParamMap.put("thirdHtId", PingBankUtils.getPinganLogNo(""));
            makeParamMap.put("note", map.get("note"));
            makeParamMap.put("reserve", "");
        }
        return makeParamMap;
    }

    public Map<String, Object> makeResponse(String response, String channelApiCode) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        return map;
    }

    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        if (null == channelRequest || MapUtil.isEmpty(map)) {
            return null;
        }
        String channelApiCode = channelRequest.getChannelApiCode();
        if ("cmc.channelUser.channelUserInsert".equals(channelApiCode)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("FunctionFlag", (Object)"1");
            jsonObject.put("MerSubAcctMemberCode", (Object)("SH_" + map.get("userinfoCode")));
            jsonObject.put("MerSubAcctNickname", map.get("userinfoCompname"));
            jsonObject.put("CommonSubAcctMemberCode", (Object)("00_" + map.get("userinfoCode")));
            jsonObject.put("Mobile", map.get("userinfoBankPhone"));
            jsonObject.put("MemberName", map.get("userinfoCompname"));
            jsonObject.put("MemberGlobalType", map.get("userinfoBankIdtype"));
            jsonObject.put("MemberGlobalId", map.get("userinfoBankIdno"));
            if ("2".equals(String.valueOf(map.get("userinfoType")))) {
                jsonObject.put("IndivBusinessFlag", (Object)"0");
            } else {
                jsonObject.put("IndivBusinessFlag", (Object)"1");
                jsonObject.put("CompanyName", map.get("userinfoCompname"));
                jsonObject.put("CompanyGlobalType", map.get("userinfoBankTidtype"));
                jsonObject.put("CompanyGlobalId", map.get("userinfoBankTidno"));
                jsonObject.put("ShopId", map.get("userinfoCode"));
                jsonObject.put("ShopName", map.get("userinfoCompname"));
                jsonObject.put("RepFlag", map.get("1"));
                jsonObject.put("ReprName", map.get("userinfoBankFname"));
                jsonObject.put("ReprGlobalType", map.get("userinfoBankFidtype"));
                jsonObject.put("ReprGlobalId", map.get("userinfoBankFidno"));
            }
            HttpResult httpResult = PinganSdkUtils.send(jsonObject, channelRequest.getCmFchannelApi().getAppapiCode(), channelRequest.getCmFchannelApi().getFchannelApiMethod(), String.valueOf(map.get("channelCode")), channelRequest.getConfigMap());
            HashMap<String, String> res = new HashMap<String, String>();
            if (httpResult.getCode() != 200) {
                res.put("code", "0001");
                res.put("msg", "\u8bf7\u6c42\u8d85\u65f6");
                return res;
            }
            String data = httpResult.getData();
            Map resMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToObject(data, Map.class);
            if (resMap.get("Errors") == null) {
                Map resSunMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToObject(JsonUtil.buildNonDefaultBinder().toJson(resMap.get("Data")), Map.class);
                res.put("code", "0000");
                res.put("merSubAcctNo", (String)resSunMap.get("MerSubAcctNo"));
                res.put("commonSubAcctNo", (String)resSunMap.get("CommonSubAcctNo"));
                res.put("msg", "\u8bf7\u6c42\u6210\u529f");
                return res;
            }
            Map resSunMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToObject(JsonUtil.buildNonDefaultBinder().toJson(resMap.get("Errors")), Map.class);
            res.put("code", "0002");
            res.put("msg", String.valueOf(resSunMap.get("ErrorMessage")));
            return res;
        }
        String requestUrl = "";
        String requestParam = "";
        if ("cmc.channelUser.channelUserBlocking".equals(channelApiCode)) {
            Map configMap = channelRequest.getConfigMap();
            requestUrl = (String)configMap.get("url");
            Map requestData = channelRequest.getRequestData();
            requestParam = (String)requestData.get("requestParam");
        }
        String responseContent = null;
        try {
            responseContent = WebUtils.doPost(requestUrl, requestParam, 10000, 1000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseContent;
    }

    public static String buildMessage(String func, String serverType, String thridLogNo, String content) {
        CommunicationDomain communicationDomain = new CommunicationDomain();
        Date date = new Date();
        date.setSeconds(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        String time = sdf.format(date);
        String tranDate = time.substring(0, 8);
        String tranTime = time.substring(9);
        communicationDomain.setTranDate(tranDate);
        communicationDomain.setTranTime(tranTime);
        communicationDomain.setCode("9264                ");
        communicationDomain.setOpterator("86301");
        communicationDomain.setServerType(serverType);
        communicationDomain.setThridLogNo(thridLogNo);
        ServiceMessageHeaderDomain serviceMessageHeaderDomain = new ServiceMessageHeaderDomain();
        serviceMessageHeaderDomain.setTranFunc(func);
        serviceMessageHeaderDomain.setServType(serverType);
        serviceMessageHeaderDomain.setMacCode("                ");
        serviceMessageHeaderDomain.setTranDate(tranDate);
        serviceMessageHeaderDomain.setTranTime(tranTime);
        if ("01".equals(serverType)) {
            serviceMessageHeaderDomain.setRspCode("999999");
        } else {
            serviceMessageHeaderDomain.setRspCode("000000");
        }
        serviceMessageHeaderDomain.setRspMsg("                                          ");
        serviceMessageHeaderDomain.setConFlag("0");
        serviceMessageHeaderDomain.setCounterId("EB001");
        serviceMessageHeaderDomain.setThirdLogNo(communicationDomain.getThridLogNo());
        serviceMessageHeaderDomain.setQydm("9264");
        serviceMessageHeaderDomain.setLength(String.format("%08d", content.length()));
        communicationDomain.setContentLenth(String.format("%010d", 122 + content.length()));
        String communicationMessage = communicationDomain.toString();
        String serviceHeader = serviceMessageHeaderDomain.toString();
        String param = communicationMessage + serviceHeader + content;
        return param;
    }

    public MemberDomain getMemberDomain(Map<String, Object> map) {
        UmUserDomain umUser = this.getUmUserByPcode(map.get("tenantCode").toString(), map.get("memberCode").toString());
        if (null == umUser) {
            this.logger.error("cmc.ChannelOauthBaseServicesend.getUmUserByPcode", (Object)(umUser + " =:= " + map));
            return null;
        }
        UmUserinfoQuaDomain umUserinfoQuaDomain = this.getUmUserInfoQuaByOcode(umUser.getTenantCode(), umUser.getUserOcode());
        if (null == umUserinfoQuaDomain) {
            this.logger.error("cmc.ChannelOauthBaseServicesend.getUmUserByPcode", (Object)(umUser + " =:= " + umUser.getUserOcode() + "-" + umUser.getTenantCode()));
            return null;
        }
        return PingBankUtils.getMember(umUserinfoQuaDomain.getUserinfoQuaUrl());
    }

    public String getFchannelCode() {
        return "pingan";
    }
}

