/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.util;

import com.alibaba.fastjson.JSONObject;
import com.pingan.openbank.api.sdk.client.ApiClient;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import com.pingan.openbank.api.sdk.entity.SdkRequest;
import com.pingan.openbank.api.sdk.exception.OpenBankSdkException;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.PropetiesDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util.StringUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PinganSdkUtils {
    protected static final SupperLogUtil logger = new SupperLogUtil(PinganSdkUtils.class);

    public static HttpResult send(JSONObject jsonObject, String txnCode, String serviceId, String channelCode, Map<String, String> configMap) throws OpenBankSdkException {
        ApiClient apiClient = ApiClient.getInstance((Object)"conf/config-4540-fat7.properties");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (jsonObject.get((Object)"CnsmrSeqNo") == null) {
            Random random = new Random();
            String seq = simpleDateFormat.format(new Date()) + "" + random.nextInt(99999999);
            jsonObject.put("CnsmrSeqNo", (Object)seq);
        } else {
            jsonObject.put("CnsmrSeqNo", jsonObject.get((Object)"CnsmrSeqNo"));
        }
        if (jsonObject.get((Object)"TxnTime") == null) {
            jsonObject.put("TxnTime", (Object)simpleDateFormat.format(new Date()));
        } else {
            jsonObject.put("TxnTime", jsonObject.get((Object)"TxnTime"));
        }
        jsonObject.put("TxnCode", (Object)txnCode);
        jsonObject.put("MrchCode", (Object)configMap.get("MrchCode"));
        jsonObject.put("TxnClientNo", (Object)configMap.get("TxnClientNo"));
        jsonObject.put("FundSummaryAcctNo", (Object)configMap.get("FundSummaryAcctNo"));
        SdkRequest sdkRequest = new SdkRequest();
        sdkRequest.setInterfaceName(serviceId);
        sdkRequest.setBody((Object)jsonObject);
        logger.info("PinganSdkUtils.send.invoke.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)sdkRequest));
        HttpResult httpResult = (HttpResult)apiClient.invoke(sdkRequest);
        logger.info("PinganSdkUtils.send.invoke.res", (Object)JsonUtil.buildNormalBinder().toJson((Object)httpResult));
        return httpResult;
    }

    public static String getPath(String channelCode) {
        String remotMap = SupDisUtil.getRemotMap((String)"DdFalgSetting-key", (String)"728243877368496147-pingan-propertiesPath");
        if (StringUtils.isBlank(remotMap)) {
            logger.error("PinganSdkUtils.send.remotMap.isnull", (Object)("key===" + remotMap));
            return null;
        }
        List jsonToList = JsonUtil.buildNonDefaultBinder().getJsonToList(remotMap, PropetiesDomain.class);
        if (CollectionUtils.isEmpty((Collection)jsonToList)) {
            logger.error("PinganSdkUtils.send.jsonToList.isnull", (Object)("key===" + remotMap));
            return null;
        }
        List collect = jsonToList.stream().filter(u -> u.getChannelCode().equals(channelCode)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            logger.error("PinganSdkUtils.send.collect.isnull", (Object)("key===" + remotMap));
            return null;
        }
        return ((PropetiesDomain)collect.get(0)).getPath();
    }
}

