/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.yqbsoft.laser.service.ext.bus.app.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.dis.DisChannelRequest;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.dis.DisChannelResponse;
import com.yqbsoft.laser.service.ext.bus.app.service.BusDisService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.DisBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusDisServiceImpl
extends DisBaseService
implements BusDisService {
    private String SYS_CODE = "app.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusDisServiceImpl.class);
    private String ddcode = "dis";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusDis(DisChannelReDomain disChannelDomain) {
        UmUserinfoReDomain umUserinfoReDomain;
        if (null == disChannelDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusDis.disChannelDomain");
            return "error";
        }
        String tenantCode = disChannelDomain.getTenantCode();
        DisChannelRequest disChannelRequest = new DisChannelRequest();
        disChannelRequest.setOrgTenantCode(tenantCode);
        Map<String, Object> initmap = this.getAppmanger(disChannelDomain.getChannelCode(), tenantCode);
        initmap.put("outsideApiUrl", "busdata.exDis.sendSaveExDisChannel");
        disChannelRequest.init(initmap);
        String memberCode = (String)initmap.get("memberCode");
        if (StringUtils.isNotBlank((String)memberCode) && null != (umUserinfoReDomain = this.getUserinfoByCode(memberCode, tenantCode))) {
            disChannelDomain.setMemberCode(umUserinfoReDomain.getUserinfoOcode());
        }
        disChannelRequest.setOrgTenantCode(disChannelDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(disChannelRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            disChannelDomain.setTenantCode(t);
        }
        disChannelRequest.getSendMap().put("disChannelDomain", JsonUtil.buildNormalBinder().toJson((Object)disChannelDomain));
        DisChannelResponse disChannelResponse = this.restTempfacade.execute(disChannelRequest);
        if (null == disChannelResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusDis.disChannelResponse");
            return "error";
        }
        if (!disChannelResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusDis.umUserinfoResponse", (Object)disChannelResponse.getMsg());
            return disChannelResponse.getMsg();
        }
        return "success";
    }
}

