/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBConfirmGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBRefundDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.RefundOrderDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.RefundOrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.service.BusBankHSBService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.OrderHSBBaseService;
import com.yqbsoft.laser.service.ext.bus.app.util.HttpUtil;
import com.yqbsoft.laser.service.ext.bus.app.util.RSASignUtil;
import com.yqbsoft.laser.service.ext.bus.app.util.SplicingUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class BusBankHSBServiceImpl
extends OrderHSBBaseService
implements BusBankHSBService {
    private String SYS_CODE = "app.BusBankHSBServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusBankHSBServiceImpl.class);
    private String ddcode = "sany.bank";
    @Autowired
    RestTempfacade restTempfacade;

    private Boolean getddflagsetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = "591197526966321228".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        if (StringUtils.isEmpty((String)value) || "true".equals(value)) {
            return true;
        }
        return false;
    }

    @Override
    public String gatherPlaceorder(OrderHSBDomain orderHSBDomain) {
        logger.info(this.SYS_CODE + ".gatherPlaceorder.orderHSBDomain=====" + orderHSBDomain);
        if (orderHSBDomain == null) {
            logger.error(this.SYS_CODE + ".gatherPlaceorder.orderHSBDomain is null " + orderHSBDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.check(orderHSBDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".gatherPlaceorder.msg");
            return this.makeErrorReturn(null, msg);
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            System.out.println("getddflagsetting:" + getddflagsetting);
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)orderHSBDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTQj/NxjKH7rJmpXlgBmjiCb8OZsAC9j87hz1dPehGVmU1ay++0m9ZQuU16ssOc9z9m0HOTy/ScuawihHldXMC7DzSkYM2LSnQu2WCGCTn+595rfjpYB0ybqFFjtQbzGgMj+nRfSKPNs80eqJwiBc5Zlakg8XNUxVj/N15W87M6oh3YH8gcfYq2/UH0WGDn7bHErz1zPyaUgiU88aNLQg8cf26uPchfwhykKQa/JtqDR3lpO6YpvNDVWXCNYrOFphgvcfKVCawl6UHlESdCt2felOpmAo766+N9BFDczR6jZgl0ikuWWOqY/DqwHjh9k8S6dK/NOyQbzAbfKs1+Vi7AgMBAAECggEBAKXk+EWWxkeIYf/JIa8OWX5nOOkONuochTsx0DZQTv4tCf0Q1sV6aoYlyei1IA+RXJCqQtrHxD32jMFFKxiNSmuZJ4oTSn5YqOWIwwWOAC1LosfinfxlxYe86Fe++UF7GpoCyRIAugrMd5o2UykbNWGVw6Qc9k9uVvXVs/WA6rxuYsvNJ6Fq9yEmKdH2Q+jxRSnDI7XhwBOAQWr0orVzWGQ1PSziTN3CrbzxEM6xPjadjRZqN09Gwkr7h37ZhPEaWG4FsJ10kEwCt0yWwV39ZuaIuRA3TfMGI3MZGq4IrUtazg6ULRn4e1xXesF2eeJLIGM7Kf2CDwROSAPA02gPfQECgYEA6gCqEAoq6i+l6OZQxo9H9NuxLx6xQtH3AqEpRsKnzJw3P7K1Kl/PLJZ4ELxDVf2Q7zJrVeRpuspjhz6/dDDeyl2RM+H5R8nTF7IrmpB4n2dEIYw1/bncWpet8O+b+YKq+/WDSWDjMzh6uz+9gdtYVmsC0opfyKBwFlgTm5Ze2YsCgYEA5x4/v625QVNeviHmXwcFRbRsRXz8VnftuOTCHTV/ofDJM2pZtUcAdzh3OArJSLo5tOiDgbwq/JzFXcP2r7EUQqYu2lQsUmxDrhaVIA6RLx4l4cOvBWm5lOf3BncVDg9It3D2q648GiLI5pdOmSVksXibwzzFen/UD5sDtTSKg5ECgYAeb2+vHmNuijv+Cta+vKwTQO/OvSM5Ga4S/Xss5OyGRFs7Qbcmh8eeeQOsyY/Ig25ybhBf35GQ5foEATlNl32ivIDCSsXtfGakUlwxglDuCrRl2KK9GYt7jPbmu4OB9Gjg1JH63UsvwkzURfoUBb97nfeEAtNqeNObVGFYfzpe+QKBgEMBCgpQGz1NJlKJEXjLWEP1Is6ihaWr70eDSqOdNvuEC1DUrF1Z0FDAFhAxUFm9Y62HG1kpbG0AJlgg0Avvkqgf9cVmUdMzgAugkGtSzdSTMPha+wres+bvuTYun/QLilFkdp8fTF1naEcx5p+Pr7mj9cSMgdQZ6yj7EAAg02eBAoGBAMbuYG64E8OdQF1nlMWomU1757FXqrgubuC2Gqp/a0HnAmuYTaCiE3YvaGC2giUenZZsjeWDAxEEdDoyCEqk7rP1aROIu98lduO7jXh7U0H2La7khnRFtbBT/lqMtTQgh0wkC1ME1NYfMkqUkKzbTe5BHAN0wXe/pMQgO9FjdmH/", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf));
                if (b) {
                    return this.makeSuccessReturn(result);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Mkt_Id\":\"43086373608983\",\"Ittparty_Stm_Id\":\"00000\",\"Py_Chnl_Cd\":\"0000000000000000000000000\",\"Opr_No\":\"0001\",\"Pymd_Cd\":\"03\",\"Onln_Ofln_Indcd\":\"1\",\"Ccy\":\"156\",\"Vno\":\"3\",\"Pgfc_Ret_Url_Adr\":\"https://mall.sany.com.cn/wap/finish.html?payment_id=22111710397645272771\",\"Main_Ordr_No\":\"22111710397645272771\",\"Ittparty_Jrnl_No\":\"22111710397645272771\",\"Usr_Id\":497277,\"Ittparty_Tms\":\"20221117103950000\",\"Ordr_Tamt\":\"1372.00\",\"Txn_Tamt\":\"1372.00\",\"Orderlist\":[{\"Mkt_Mrch_Id\":\"43086373608983003060\",\"Cmdty_Ordr_No\":350361,\"Ordr_Amt\":\"1372.00\",\"Txnamt\":\"1372.00\"}],\"Sign_Inf\":\"UFiRNifn+CrRuUfQmWRijMLFcsECsC7KBGcmorebDiKOR8qxhScsHV7i9mmjM/LnHWHwe+oglDD/iAHgO8FVCtv6E6qvnidZ/OGnB2BMa5m6Tw2iNP8xywh2NYVYNLHLaBW2d5AMTsOTuy0UtIEB0aYw/m3pO4BKyyeDexHlICPiDmQoc3h8KAQ4ryrZ39xikCkCTHexrXMPJCSs1ASkX+RTJ1MPduY04xjLBmpHMrsq+uvwjZotT9A8JwjB8MtdBAHFRb2iAOlpBn9PhiqeLLQTKY574QKbqU7lRlPQu81opUEeoG+cyMwbzWy3F6IEn6YNXjLmCiczgSbx7t/9Iw==\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String payOrderNotify(OrderNotifyDomain orderNotifyDomain) {
        logger.info(this.SYS_CODE + ".payOrderNotify.orderNotifyDomain=====" + orderNotifyDomain);
        String jsonString = "";
        String result = JsonUtil.buildNormalBinder().toJson((Object)orderNotifyDomain);
        logger.info("payOrderNotify-----orderNotifyDomain:" + result);
        try {
            jsonString = SplicingUtil.createSign(result);
            logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
            String signInf = orderNotifyDomain.getSign_Inf();
            boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
            logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + b);
            if (b) {
                return "{\"Svc_Res_St\":\"00\"}";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "{\"Svc_Res_St\":\"01\"}";
    }

    @Override
    public String gatherEnquireOrder(QueryOrderHSBDomain queryOrderHSBDomain) {
        logger.info(this.SYS_CODE + ".gatherEnquireOrder.queryOrderHSBDomain=====" + queryOrderHSBDomain);
        if (queryOrderHSBDomain == null) {
            logger.error(this.SYS_CODE + ".gatherEnquireOrder.queryOrderHSBDomain is null " + queryOrderHSBDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)queryOrderHSBDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTQj/NxjKH7rJmpXlgBmjiCb8OZsAC9j87hz1dPehGVmU1ay++0m9ZQuU16ssOc9z9m0HOTy/ScuawihHldXMC7DzSkYM2LSnQu2WCGCTn+595rfjpYB0ybqFFjtQbzGgMj+nRfSKPNs80eqJwiBc5Zlakg8XNUxVj/N15W87M6oh3YH8gcfYq2/UH0WGDn7bHErz1zPyaUgiU88aNLQg8cf26uPchfwhykKQa/JtqDR3lpO6YpvNDVWXCNYrOFphgvcfKVCawl6UHlESdCt2felOpmAo766+N9BFDczR6jZgl0ikuWWOqY/DqwHjh9k8S6dK/NOyQbzAbfKs1+Vi7AgMBAAECggEBAKXk+EWWxkeIYf/JIa8OWX5nOOkONuochTsx0DZQTv4tCf0Q1sV6aoYlyei1IA+RXJCqQtrHxD32jMFFKxiNSmuZJ4oTSn5YqOWIwwWOAC1LosfinfxlxYe86Fe++UF7GpoCyRIAugrMd5o2UykbNWGVw6Qc9k9uVvXVs/WA6rxuYsvNJ6Fq9yEmKdH2Q+jxRSnDI7XhwBOAQWr0orVzWGQ1PSziTN3CrbzxEM6xPjadjRZqN09Gwkr7h37ZhPEaWG4FsJ10kEwCt0yWwV39ZuaIuRA3TfMGI3MZGq4IrUtazg6ULRn4e1xXesF2eeJLIGM7Kf2CDwROSAPA02gPfQECgYEA6gCqEAoq6i+l6OZQxo9H9NuxLx6xQtH3AqEpRsKnzJw3P7K1Kl/PLJZ4ELxDVf2Q7zJrVeRpuspjhz6/dDDeyl2RM+H5R8nTF7IrmpB4n2dEIYw1/bncWpet8O+b+YKq+/WDSWDjMzh6uz+9gdtYVmsC0opfyKBwFlgTm5Ze2YsCgYEA5x4/v625QVNeviHmXwcFRbRsRXz8VnftuOTCHTV/ofDJM2pZtUcAdzh3OArJSLo5tOiDgbwq/JzFXcP2r7EUQqYu2lQsUmxDrhaVIA6RLx4l4cOvBWm5lOf3BncVDg9It3D2q648GiLI5pdOmSVksXibwzzFen/UD5sDtTSKg5ECgYAeb2+vHmNuijv+Cta+vKwTQO/OvSM5Ga4S/Xss5OyGRFs7Qbcmh8eeeQOsyY/Ig25ybhBf35GQ5foEATlNl32ivIDCSsXtfGakUlwxglDuCrRl2KK9GYt7jPbmu4OB9Gjg1JH63UsvwkzURfoUBb97nfeEAtNqeNObVGFYfzpe+QKBgEMBCgpQGz1NJlKJEXjLWEP1Is6ihaWr70eDSqOdNvuEC1DUrF1Z0FDAFhAxUFm9Y62HG1kpbG0AJlgg0Avvkqgf9cVmUdMzgAugkGtSzdSTMPha+wres+bvuTYun/QLilFkdp8fTF1naEcx5p+Pr7mj9cSMgdQZ6yj7EAAg02eBAoGBAMbuYG64E8OdQF1nlMWomU1757FXqrgubuC2Gqp/a0HnAmuYTaCiE3YvaGC2giUenZZsjeWDAxEEdDoyCEqk7rP1aROIu98lduO7jXh7U0H2La7khnRFtbBT/lqMtTQgh0wkC1ME1NYfMkqUkKzbTe5BHAN0wXe/pMQgO9FjdmH/", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf));
                if (b) {
                    return this.makeSuccessReturn(result);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            QueryOrderHSBReDomain queryOrderHSBReDomain = new QueryOrderHSBReDomain();
            queryOrderHSBReDomain.setMain_Ordr_No("22111710397645272771");
            queryOrderHSBReDomain.setPy_Trn_No("10500005398205411180831563820H");
            queryOrderHSBReDomain.setOrdr_Stcd("2");
            result = queryOrderHSBReDomain.toString();
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    public String check(OrderNotifyDomain orderNotifyDomain) {
        if (null != orderNotifyDomain.getMain_Ordr_No()) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getPy_Trn_No()) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getOrdr_Amt()) {
            return "\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getTxnamt()) {
            return "\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getPay_Time()) {
            return "\u652f\u4ed8\u65f6\u95f4\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getOrdr_Stcd()) {
            return "\u8ba2\u5355\u72b6\u6001\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getSign_Inf()) {
            return "\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(OrderHSBConfirmGoodsDomain orderHSBConfirmGoodsDomain) {
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getPrim_Ordr_No())) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (null != orderHSBConfirmGoodsDomain.getSign_Inf()) {
            return "\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a";
        }
        if (null != orderHSBConfirmGoodsDomain.getVno()) {
            return "\u7248\u672c\u53f7\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(RefundOrderNotifyDomain refundOrderNotifyDomain) {
        if (null != refundOrderNotifyDomain.getIttparty_Tms()) {
            return "\u53d1\u8d77\u65b9\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getPy_Trn_No()) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getPy_Trn_No()) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getSuper_Refund_No()) {
            return "\u9000\u6b3e\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getRefund_Rsp_St()) {
            return "\u9000\u6b3e\u54cd\u5e94\u72b6\u6001\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getSign_Inf()) {
            return "\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(OrderHSBDomain orderHSBDomain) {
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getMain_Ordr_No())) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPymd_Cd())) {
            return "\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPy_Ordr_Tpcd())) {
            return "\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getCcy())) {
            return "\u5e01\u79cd\u4e3a\u7a7a";
        }
        if (null != orderHSBDomain.getTxn_Tamt()) {
            return "\u4ea4\u6613\u603b\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null != orderHSBDomain.getVno()) {
            return "\u7248\u672c\u53f7\u4e3a\u7a7a";
        }
        if (null != orderHSBDomain.getSign_Inf()) {
            return "\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(RefundOrderDomain refundOrderDomain) {
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getPy_Trn_No())) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderDomain.getSign_Inf()) {
            return "\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a";
        }
        return "";
    }

    @Override
    protected String makeErrorReturn(String errorCode, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "-1");
        map.put("success", false);
        map.put("dataObj", errorCode);
        map.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    protected String makeSuccessReturn(Object dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "200");
        map.put("success", true);
        map.put("dataObj", dataObj);
        map.put("msg", "\u6210\u529f");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    public String refundOrder(RefundOrderDomain refundOrderDomain) {
        logger.info(this.SYS_CODE + ".refundOrder.refundOrderDomain=====" + refundOrderDomain);
        if (refundOrderDomain == null) {
            logger.error(this.SYS_CODE + ".refundOrder.refundOrderDomain is null " + refundOrderDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)refundOrderDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTQj/NxjKH7rJmpXlgBmjiCb8OZsAC9j87hz1dPehGVmU1ay++0m9ZQuU16ssOc9z9m0HOTy/ScuawihHldXMC7DzSkYM2LSnQu2WCGCTn+595rfjpYB0ybqFFjtQbzGgMj+nRfSKPNs80eqJwiBc5Zlakg8XNUxVj/N15W87M6oh3YH8gcfYq2/UH0WGDn7bHErz1zPyaUgiU88aNLQg8cf26uPchfwhykKQa/JtqDR3lpO6YpvNDVWXCNYrOFphgvcfKVCawl6UHlESdCt2felOpmAo766+N9BFDczR6jZgl0ikuWWOqY/DqwHjh9k8S6dK/NOyQbzAbfKs1+Vi7AgMBAAECggEBAKXk+EWWxkeIYf/JIa8OWX5nOOkONuochTsx0DZQTv4tCf0Q1sV6aoYlyei1IA+RXJCqQtrHxD32jMFFKxiNSmuZJ4oTSn5YqOWIwwWOAC1LosfinfxlxYe86Fe++UF7GpoCyRIAugrMd5o2UykbNWGVw6Qc9k9uVvXVs/WA6rxuYsvNJ6Fq9yEmKdH2Q+jxRSnDI7XhwBOAQWr0orVzWGQ1PSziTN3CrbzxEM6xPjadjRZqN09Gwkr7h37ZhPEaWG4FsJ10kEwCt0yWwV39ZuaIuRA3TfMGI3MZGq4IrUtazg6ULRn4e1xXesF2eeJLIGM7Kf2CDwROSAPA02gPfQECgYEA6gCqEAoq6i+l6OZQxo9H9NuxLx6xQtH3AqEpRsKnzJw3P7K1Kl/PLJZ4ELxDVf2Q7zJrVeRpuspjhz6/dDDeyl2RM+H5R8nTF7IrmpB4n2dEIYw1/bncWpet8O+b+YKq+/WDSWDjMzh6uz+9gdtYVmsC0opfyKBwFlgTm5Ze2YsCgYEA5x4/v625QVNeviHmXwcFRbRsRXz8VnftuOTCHTV/ofDJM2pZtUcAdzh3OArJSLo5tOiDgbwq/JzFXcP2r7EUQqYu2lQsUmxDrhaVIA6RLx4l4cOvBWm5lOf3BncVDg9It3D2q648GiLI5pdOmSVksXibwzzFen/UD5sDtTSKg5ECgYAeb2+vHmNuijv+Cta+vKwTQO/OvSM5Ga4S/Xss5OyGRFs7Qbcmh8eeeQOsyY/Ig25ybhBf35GQ5foEATlNl32ivIDCSsXtfGakUlwxglDuCrRl2KK9GYt7jPbmu4OB9Gjg1JH63UsvwkzURfoUBb97nfeEAtNqeNObVGFYfzpe+QKBgEMBCgpQGz1NJlKJEXjLWEP1Is6ihaWr70eDSqOdNvuEC1DUrF1Z0FDAFhAxUFm9Y62HG1kpbG0AJlgg0Avvkqgf9cVmUdMzgAugkGtSzdSTMPha+wres+bvuTYun/QLilFkdp8fTF1naEcx5p+Pr7mj9cSMgdQZ6yj7EAAg02eBAoGBAMbuYG64E8OdQF1nlMWomU1757FXqrgubuC2Gqp/a0HnAmuYTaCiE3YvaGC2giUenZZsjeWDAxEEdDoyCEqk7rP1aROIu98lduO7jXh7U0H2La7khnRFtbBT/lqMtTQgh0wkC1ME1NYfMkqUkKzbTe5BHAN0wXe/pMQgO9FjdmH/", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf));
                if (b) {
                    return this.makeSuccessReturn(result);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Cust_Rfnd_Trcno\":\"\",\"Ittparty_Jrnl_No\":\"397440053504\",\"Ittparty_Tms\":\"20221118110735709\",\"Refund_Rsp_Inf\":\"\u9000\u6b3e\u6210\u529f\",\"Refund_Rsp_St\":\"00\",\"Rfnd_Trcno\":\"221118035395072\",\"Rsp_Inf\":\"\",\"Sign_Inf\":\"cxq1t54SLyYDcwgFwh9Qj8GXPhcfS0r0/Ocuh2IeAVGccykjK72dRGda/6xiifEruBb/Q9ipbNRCmLTx/2bQwvkq+aK3X84fxtSJOhW3Vzsp2108v3QP0J3j/HY3Kl9OVXQxZxUTIJfTradXE/ZhnbpaAM8XjMhmpU6Yy0uOunZSCmBdv/ZO9yTbzYLveptwAGFIHHyhOUdBAkLC8OeDASRQ81twpCYe3jRJfisgDfnu8EcD5DHI5hq5FArxB9qTHh+/lNg1BZlOUdmKJ7YLsSOUowiyHI0nLuiQZGCvZdrllU10/kEipB6aUnnTASMr4P+usKzrTeywqO9zJwdnWg==\",\"Svc_Rsp_Cd\":\"\",\"Svc_Rsp_St\":\"00\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String refundOrderNotify(RefundOrderNotifyDomain refundOrderNotifyDomain) {
        String jsonString = "";
        String result = JsonUtil.buildNormalBinder().toJson((Object)refundOrderNotifyDomain);
        logger.info("payOrderNotify-----orderNotifyDomain:" + result);
        try {
            jsonString = SplicingUtil.createSign(result);
            logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
            String signInf = refundOrderNotifyDomain.getSign_Inf();
            boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
            logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + b);
            if (b) {
                return "{\"Svc_Res_St\":\"00\",\"Ittparty_Tms\":\"20221118161147806\"}";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "{\"Svc_Res_St\":\"00\",\"Ittparty_Tms\":\"20221118161147806\"}";
    }

    @Override
    public String enquireRefundOrder(QueryOrderHSBRefundDomain queryOrderHSBRefundDomain) {
        logger.info(this.SYS_CODE + ".enquireRefundOrder.queryOrderHSBRefundDomain=====" + queryOrderHSBRefundDomain);
        if (queryOrderHSBRefundDomain == null) {
            logger.error(this.SYS_CODE + ".enquireRefundOrder.queryOrderHSBRefundDomain is null " + queryOrderHSBRefundDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)queryOrderHSBRefundDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTQj/NxjKH7rJmpXlgBmjiCb8OZsAC9j87hz1dPehGVmU1ay++0m9ZQuU16ssOc9z9m0HOTy/ScuawihHldXMC7DzSkYM2LSnQu2WCGCTn+595rfjpYB0ybqFFjtQbzGgMj+nRfSKPNs80eqJwiBc5Zlakg8XNUxVj/N15W87M6oh3YH8gcfYq2/UH0WGDn7bHErz1zPyaUgiU88aNLQg8cf26uPchfwhykKQa/JtqDR3lpO6YpvNDVWXCNYrOFphgvcfKVCawl6UHlESdCt2felOpmAo766+N9BFDczR6jZgl0ikuWWOqY/DqwHjh9k8S6dK/NOyQbzAbfKs1+Vi7AgMBAAECggEBAKXk+EWWxkeIYf/JIa8OWX5nOOkONuochTsx0DZQTv4tCf0Q1sV6aoYlyei1IA+RXJCqQtrHxD32jMFFKxiNSmuZJ4oTSn5YqOWIwwWOAC1LosfinfxlxYe86Fe++UF7GpoCyRIAugrMd5o2UykbNWGVw6Qc9k9uVvXVs/WA6rxuYsvNJ6Fq9yEmKdH2Q+jxRSnDI7XhwBOAQWr0orVzWGQ1PSziTN3CrbzxEM6xPjadjRZqN09Gwkr7h37ZhPEaWG4FsJ10kEwCt0yWwV39ZuaIuRA3TfMGI3MZGq4IrUtazg6ULRn4e1xXesF2eeJLIGM7Kf2CDwROSAPA02gPfQECgYEA6gCqEAoq6i+l6OZQxo9H9NuxLx6xQtH3AqEpRsKnzJw3P7K1Kl/PLJZ4ELxDVf2Q7zJrVeRpuspjhz6/dDDeyl2RM+H5R8nTF7IrmpB4n2dEIYw1/bncWpet8O+b+YKq+/WDSWDjMzh6uz+9gdtYVmsC0opfyKBwFlgTm5Ze2YsCgYEA5x4/v625QVNeviHmXwcFRbRsRXz8VnftuOTCHTV/ofDJM2pZtUcAdzh3OArJSLo5tOiDgbwq/JzFXcP2r7EUQqYu2lQsUmxDrhaVIA6RLx4l4cOvBWm5lOf3BncVDg9It3D2q648GiLI5pdOmSVksXibwzzFen/UD5sDtTSKg5ECgYAeb2+vHmNuijv+Cta+vKwTQO/OvSM5Ga4S/Xss5OyGRFs7Qbcmh8eeeQOsyY/Ig25ybhBf35GQ5foEATlNl32ivIDCSsXtfGakUlwxglDuCrRl2KK9GYt7jPbmu4OB9Gjg1JH63UsvwkzURfoUBb97nfeEAtNqeNObVGFYfzpe+QKBgEMBCgpQGz1NJlKJEXjLWEP1Is6ihaWr70eDSqOdNvuEC1DUrF1Z0FDAFhAxUFm9Y62HG1kpbG0AJlgg0Avvkqgf9cVmUdMzgAugkGtSzdSTMPha+wres+bvuTYun/QLilFkdp8fTF1naEcx5p+Pr7mj9cSMgdQZ6yj7EAAg02eBAoGBAMbuYG64E8OdQF1nlMWomU1757FXqrgubuC2Gqp/a0HnAmuYTaCiE3YvaGC2giUenZZsjeWDAxEEdDoyCEqk7rP1aROIu98lduO7jXh7U0H2La7khnRFtbBT/lqMtTQgh0wkC1ME1NYfMkqUkKzbTe5BHAN0wXe/pMQgO9FjdmH/", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf));
                if (b) {
                    return this.makeSuccessReturn(result);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            QueryOrderHSBRefundReDomain queryOrderHSBRefundReDomain = new QueryOrderHSBRefundReDomain();
            queryOrderHSBRefundReDomain.setIttparty_Jrnl_No("22111710397645272771");
            queryOrderHSBRefundReDomain.setRfnd_Trcno("221118035395072");
            queryOrderHSBRefundReDomain.setRfnd_Amt("22");
            queryOrderHSBRefundReDomain.setRefund_Rsp_St("00");
            result = queryOrderHSBRefundReDomain.toString();
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String mergeNoticeArrival(OrderHSBConfirmGoodsDomain orderHSBConfirmGoodsDomain) {
        logger.info(this.SYS_CODE + ".mergeNoticeArrival.orderHSBConfirmGoodsDomain=====" + orderHSBConfirmGoodsDomain);
        if (orderHSBConfirmGoodsDomain == null) {
            logger.error(this.SYS_CODE + ".mergeNoticeArrival.orderHSBConfirmGoodsDomain is null " + orderHSBConfirmGoodsDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.check(orderHSBConfirmGoodsDomain);
        if (StringUtils.isBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".mergeNoticeArrival.msg");
            return this.makeErrorReturn(null, msg);
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)orderHSBConfirmGoodsDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTQj/NxjKH7rJmpXlgBmjiCb8OZsAC9j87hz1dPehGVmU1ay++0m9ZQuU16ssOc9z9m0HOTy/ScuawihHldXMC7DzSkYM2LSnQu2WCGCTn+595rfjpYB0ybqFFjtQbzGgMj+nRfSKPNs80eqJwiBc5Zlakg8XNUxVj/N15W87M6oh3YH8gcfYq2/UH0WGDn7bHErz1zPyaUgiU88aNLQg8cf26uPchfwhykKQa/JtqDR3lpO6YpvNDVWXCNYrOFphgvcfKVCawl6UHlESdCt2felOpmAo766+N9BFDczR6jZgl0ikuWWOqY/DqwHjh9k8S6dK/NOyQbzAbfKs1+Vi7AgMBAAECggEBAKXk+EWWxkeIYf/JIa8OWX5nOOkONuochTsx0DZQTv4tCf0Q1sV6aoYlyei1IA+RXJCqQtrHxD32jMFFKxiNSmuZJ4oTSn5YqOWIwwWOAC1LosfinfxlxYe86Fe++UF7GpoCyRIAugrMd5o2UykbNWGVw6Qc9k9uVvXVs/WA6rxuYsvNJ6Fq9yEmKdH2Q+jxRSnDI7XhwBOAQWr0orVzWGQ1PSziTN3CrbzxEM6xPjadjRZqN09Gwkr7h37ZhPEaWG4FsJ10kEwCt0yWwV39ZuaIuRA3TfMGI3MZGq4IrUtazg6ULRn4e1xXesF2eeJLIGM7Kf2CDwROSAPA02gPfQECgYEA6gCqEAoq6i+l6OZQxo9H9NuxLx6xQtH3AqEpRsKnzJw3P7K1Kl/PLJZ4ELxDVf2Q7zJrVeRpuspjhz6/dDDeyl2RM+H5R8nTF7IrmpB4n2dEIYw1/bncWpet8O+b+YKq+/WDSWDjMzh6uz+9gdtYVmsC0opfyKBwFlgTm5Ze2YsCgYEA5x4/v625QVNeviHmXwcFRbRsRXz8VnftuOTCHTV/ofDJM2pZtUcAdzh3OArJSLo5tOiDgbwq/JzFXcP2r7EUQqYu2lQsUmxDrhaVIA6RLx4l4cOvBWm5lOf3BncVDg9It3D2q648GiLI5pdOmSVksXibwzzFen/UD5sDtTSKg5ECgYAeb2+vHmNuijv+Cta+vKwTQO/OvSM5Ga4S/Xss5OyGRFs7Qbcmh8eeeQOsyY/Ig25ybhBf35GQ5foEATlNl32ivIDCSsXtfGakUlwxglDuCrRl2KK9GYt7jPbmu4OB9Gjg1JH63UsvwkzURfoUBb97nfeEAtNqeNObVGFYfzpe+QKBgEMBCgpQGz1NJlKJEXjLWEP1Is6ihaWr70eDSqOdNvuEC1DUrF1Z0FDAFhAxUFm9Y62HG1kpbG0AJlgg0Avvkqgf9cVmUdMzgAugkGtSzdSTMPha+wres+bvuTYun/QLilFkdp8fTF1naEcx5p+Pr7mj9cSMgdQZ6yj7EAAg02eBAoGBAMbuYG64E8OdQF1nlMWomU1757FXqrgubuC2Gqp/a0HnAmuYTaCiE3YvaGC2giUenZZsjeWDAxEEdDoyCEqk7rP1aROIu98lduO7jXh7U0H2La7khnRFtbBT/lqMtTQgh0wkC1ME1NYfMkqUkKzbTe5BHAN0wXe/pMQgO9FjdmH/", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxn43vCF2/t41AOHh2AVMkzhZ279eWzgIAG29tfbH9/ujIqygEJ3G1TGhdBVHtvggVXvdB63pWNQBoHxoPksOFzlzbgQumxwJlkwPGVTHQftCTU9n0JSS9HzPhMVekc8sIKYCqub7LJjJ0FtrryV8539UkW3BP6pkru2hbcQixtFSF9tENLRUsaVi+BSPWp4nUcmBCrA+7DW6+iWTLS+KghLVw4/KHxbfn/D1Yk0oVz/2/bmABU6gm7DIQKabr7VxvBc+JD6xEiiSkjQ2mJFSbbBT6wJjWv1IwSIHEaBvawkit7e9+0z3PnCLDx1AMHTlN212MCMW+AGntO9O8cqyPwIDAQAB", jsonString, signInf));
                if (b) {
                    return this.makeSuccessReturn(result);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Rsp_Inf\":\"\u786e\u8ba4\u6536\u8d27\u5904\u7406\u5b8c\u6210\",\"Svc_Rsp_Cd\":\"\",\"Svc_Rsp_St\":\"00\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }
}

