/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBConfirmGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBConfirmGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderHSBReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.OrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBRefundDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.QueryOrderHSBRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.RefundOrderDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.RefundOrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.bank.RefundOrderReDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.service.BusBankHSBService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.OrderHSBBaseService;
import com.yqbsoft.laser.service.ext.bus.app.util.HttpUtil;
import com.yqbsoft.laser.service.ext.bus.app.util.RSASignUtil;
import com.yqbsoft.laser.service.ext.bus.app.util.SplicingUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class BusBankHSBServiceImpl
extends OrderHSBBaseService
implements BusBankHSBService {
    private String SYS_CODE = "app.BusBankHSBServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusBankHSBServiceImpl.class);
    private String ddcode = "sany.bank";
    @Autowired
    RestTempfacade restTempfacade;

    private Boolean getddflagsetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = "591197526966321228".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        if (StringUtils.isEmpty((String)value) || "true".equals(value)) {
            return true;
        }
        return false;
    }

    @Override
    public String gatherPlaceorder(OrderHSBDomain orderHSBDomain) {
        logger.info(this.SYS_CODE + ".gatherPlaceorder.orderHSBDomain=====" + orderHSBDomain);
        if (orderHSBDomain == null) {
            logger.error(this.SYS_CODE + ".gatherPlaceorder.orderHSBDomain is null " + orderHSBDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.check(orderHSBDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".gatherPlaceorder.msg");
            return this.makeErrorReturn(null, msg);
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            System.out.println("getddflagsetting:" + getddflagsetting);
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)orderHSBDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCsSLR61a4P4k9TdDX9e44TuVrgv+85AOWCPHnJbNpVtnPutAIx04NTbfhaZ+f2g7q1LfKxwpsj5TNhMXKxipfATRYhd3TPbNYwEE3KywFOhQhtD4zTBSqr0wxd9QABf525jT6zcXWWG6pHpKuF39fCOzX8a/YMg+9k5KTMvl0tAhiGAM0aI1yQUfMTMqu9wyjIp2gXy+DptzT87ZMyhq7Ug7UzNd+HVj5winy0vIwbu2S6ntCz3hzgHHtvnS3OsNV5daUHK6pJBSFwR9xZdc1RjywGqzwSmYrBOgyAAkRX2sZWeRO1puU8s56ZbDK+fZdMtAV3cIL0QHF8pFm3WO89AgMBAAECggEAJf0mJsvFROVfHoTKfulmq7y8aECKTGSBNxWEuUCSaEICEEmLDleYZqYiFDVDNd1YJylJkZ7avLCGgtD3fGSWD6Yv0hNYI4DZPeHqdWQMFrdI41uBbup9vUOdP36NkMcGDWsyvziud/oDsyaBV9TC66ZIwi9AIwRYnkO4fxkezJSD7N0ilBHOYI7fxcJmPkXdfMA0J5eequQ5Kq/g1CDuxQ5/QyrKtbi/sUFLp4J+QQp8m0o+lV9ZFqQsSf9wyHFSnSsIZSPq+0HovHscxrzsTmmFGsKXMlunzhqwUB6hGme9CP284iFP+Piy7fL3vK1YOQZtnGnx/1Uz7jW9QGkgFQKBgQDfqNNC7tiPcrLCvVaBMhNzMY+198Z5e1YT5hUFxlMzM4jtQzwIEaN36KLMLTnvb9C0U45L9RX85GYi9YTOXQ/7TivILMokgOCE8aKasbTfRs7uu3nksudiz+Z03qAnjuCdPcf47TcXzn1TZ0X0qBrgDJm2Q6qNI5pik8ttexc7xwKBgQDFMh7UEpcywhVy05AZCAIx3jTJGufML2wO81yk8rcyLraAaPf71lx15Feh6vo+7owvgw6SdqW207UEqgBfcihspWMGmrUiqb72aMmxFeSyGyh7t2/gS1OE9/X/Emf9aT94v4ApAq4oVsxyuXDhrKSin6DhFp9H7+BxPQj5u0jU2wKBgFHJLX+zUXObMK0viVtzEVO1UuTqtyQjKsXaA+P5suDtPmvsgx48PPeTFTzuaNoanEnkqAs0kxbH+mVcPHUt6LMv0ajAYCbbDb7vkVNaGlbvUKpR2e/8T8p9Vbt00UHF6HL3bZGkRNoqwv9lq1ocwr8dPHQ+6DX2R/U2MFRXh5ZvAoGBAKdud+h+5GwPiKCXa2kleJ+Y2N7L/nZK6YgEL+xJvSxZp1F+TthAWP8sYw+y8MlQSCzrLQtEvE1wkekk4u4ngpVFE8B+yT9mOyMDNAUs3qIvFv98b/xUWNS0qOTrXuo2W9MNXib0BKVxlWPveh3TNXJy8OlNCO7OiJX9Scqorx0zAoGAAyvTp72dNGdLV6GbWjmsNP21XiebIvUsMgD3KKGWb+X24LpaBvvXz4hlsxl45TP4LQX7fOOhn4RkcrlNGd0nxWQatqoR+e8C/a6Tp0y+VlkHZhRiBca87VDo7zthCvlDQzrXrMkqvy+IuFzVBv8nJ4xkVhzqIo+mm4wDyawFQzs=", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherPlaceorder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf));
                if (b) {
                    OrderHSBReDomain orderHSBReDomain = (OrderHSBReDomain)JSON.parseObject((String)result, OrderHSBReDomain.class);
                    return this.makeSuccessReturn(orderHSBReDomain);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Mkt_Id\":\"43086373608983\",\"Ittparty_Stm_Id\":\"00000\",\"Py_Chnl_Cd\":\"0000000000000000000000000\",\"Opr_No\":\"0001\",\"Pymd_Cd\":\"03\",\"Onln_Ofln_Indcd\":\"1\",\"Ccy\":\"156\",\"Vno\":\"3\",\"Pgfc_Ret_Url_Adr\":\"https://mall.sany.com.cn/wap/finish.html?payment_id=22111710397645272771\",\"Main_Ordr_No\":\"22111710397645272771\",\"Ittparty_Jrnl_No\":\"22111710397645272771\",\"Usr_Id\":497277,\"Ittparty_Tms\":\"20221117103950000\",\"Ordr_Tamt\":\"1372.00\",\"Txn_Tamt\":\"1372.00\",\"Orderlist\":[{\"Mkt_Mrch_Id\":\"43086373608983003060\",\"Cmdty_Ordr_No\":350361,\"Ordr_Amt\":\"1372.00\",\"Txnamt\":\"1372.00\"}],\"Sign_Inf\":\"UFiRNifn+CrRuUfQmWRijMLFcsECsC7KBGcmorebDiKOR8qxhScsHV7i9mmjM/LnHWHwe+oglDD/iAHgO8FVCtv6E6qvnidZ/OGnB2BMa5m6Tw2iNP8xywh2NYVYNLHLaBW2d5AMTsOTuy0UtIEB0aYw/m3pO4BKyyeDexHlICPiDmQoc3h8KAQ4ryrZ39xikCkCTHexrXMPJCSs1ASkX+RTJ1MPduY04xjLBmpHMrsq+uvwjZotT9A8JwjB8MtdBAHFRb2iAOlpBn9PhiqeLLQTKY574QKbqU7lRlPQu81opUEeoG+cyMwbzWy3F6IEn6YNXjLmCiczgSbx7t/9Iw==\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String payOrderNotify(HttpServletRequest request) {
        JSONObject resultJson = new JSONObject();
        String json = "";
        try {
            StringBuffer sb = new StringBuffer();
            ServletInputStream is = request.getInputStream();
            InputStreamReader isr = new InputStreamReader((InputStream)is);
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            json = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            json = "";
        }
        if (StringUtils.isBlank((String)json)) {
            resultJson.put("Svc_Res_St", (Object)"01");
            String result = resultJson.toString();
            return result;
        }
        logger.info(this.SYS_CODE + ".payOrderNotify.json=====" + json);
        String jsonString = "";
        try {
            String result;
            jsonString = SplicingUtil.createSign(json);
            logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
            JSONObject parse = JSON.parseObject((String)json);
            String signInf = (String)parse.get((Object)"Sign_Inf");
            boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
            logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + b);
            if (b) {
                resultJson.put("Svc_Res_St", (Object)"00");
                result = resultJson.toString();
                return result;
            }
            resultJson.put("Svc_Res_St", (Object)"01");
            result = resultJson.toString();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultJson.put("Svc_Res_St", (Object)"01");
            String result = resultJson.toString();
            return result;
        }
    }

    @Override
    public String gatherEnquireOrder(QueryOrderHSBDomain queryOrderHSBDomain) {
        logger.info(this.SYS_CODE + ".gatherEnquireOrder.queryOrderHSBDomain=====" + queryOrderHSBDomain);
        if (queryOrderHSBDomain == null) {
            logger.error(this.SYS_CODE + ".gatherEnquireOrder.queryOrderHSBDomain is null " + queryOrderHSBDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)queryOrderHSBDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCsSLR61a4P4k9TdDX9e44TuVrgv+85AOWCPHnJbNpVtnPutAIx04NTbfhaZ+f2g7q1LfKxwpsj5TNhMXKxipfATRYhd3TPbNYwEE3KywFOhQhtD4zTBSqr0wxd9QABf525jT6zcXWWG6pHpKuF39fCOzX8a/YMg+9k5KTMvl0tAhiGAM0aI1yQUfMTMqu9wyjIp2gXy+DptzT87ZMyhq7Ug7UzNd+HVj5winy0vIwbu2S6ntCz3hzgHHtvnS3OsNV5daUHK6pJBSFwR9xZdc1RjywGqzwSmYrBOgyAAkRX2sZWeRO1puU8s56ZbDK+fZdMtAV3cIL0QHF8pFm3WO89AgMBAAECggEAJf0mJsvFROVfHoTKfulmq7y8aECKTGSBNxWEuUCSaEICEEmLDleYZqYiFDVDNd1YJylJkZ7avLCGgtD3fGSWD6Yv0hNYI4DZPeHqdWQMFrdI41uBbup9vUOdP36NkMcGDWsyvziud/oDsyaBV9TC66ZIwi9AIwRYnkO4fxkezJSD7N0ilBHOYI7fxcJmPkXdfMA0J5eequQ5Kq/g1CDuxQ5/QyrKtbi/sUFLp4J+QQp8m0o+lV9ZFqQsSf9wyHFSnSsIZSPq+0HovHscxrzsTmmFGsKXMlunzhqwUB6hGme9CP284iFP+Piy7fL3vK1YOQZtnGnx/1Uz7jW9QGkgFQKBgQDfqNNC7tiPcrLCvVaBMhNzMY+198Z5e1YT5hUFxlMzM4jtQzwIEaN36KLMLTnvb9C0U45L9RX85GYi9YTOXQ/7TivILMokgOCE8aKasbTfRs7uu3nksudiz+Z03qAnjuCdPcf47TcXzn1TZ0X0qBrgDJm2Q6qNI5pik8ttexc7xwKBgQDFMh7UEpcywhVy05AZCAIx3jTJGufML2wO81yk8rcyLraAaPf71lx15Feh6vo+7owvgw6SdqW207UEqgBfcihspWMGmrUiqb72aMmxFeSyGyh7t2/gS1OE9/X/Emf9aT94v4ApAq4oVsxyuXDhrKSin6DhFp9H7+BxPQj5u0jU2wKBgFHJLX+zUXObMK0viVtzEVO1UuTqtyQjKsXaA+P5suDtPmvsgx48PPeTFTzuaNoanEnkqAs0kxbH+mVcPHUt6LMv0ajAYCbbDb7vkVNaGlbvUKpR2e/8T8p9Vbt00UHF6HL3bZGkRNoqwv9lq1ocwr8dPHQ+6DX2R/U2MFRXh5ZvAoGBAKdud+h+5GwPiKCXa2kleJ+Y2N7L/nZK6YgEL+xJvSxZp1F+TthAWP8sYw+y8MlQSCzrLQtEvE1wkekk4u4ngpVFE8B+yT9mOyMDNAUs3qIvFv98b/xUWNS0qOTrXuo2W9MNXib0BKVxlWPveh3TNXJy8OlNCO7OiJX9Scqorx0zAoGAAyvTp72dNGdLV6GbWjmsNP21XiebIvUsMgD3KKGWb+X24LpaBvvXz4hlsxl45TP4LQX7fOOhn4RkcrlNGd0nxWQatqoR+e8C/a6Tp0y+VlkHZhRiBca87VDo7zthCvlDQzrXrMkqvy+IuFzVBv8nJ4xkVhzqIo+mm4wDyawFQzs=", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/gatherEnquireOrder", jsonObject.toString());
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf));
                if (b) {
                    QueryOrderHSBReDomain orderHSBReDomain = (QueryOrderHSBReDomain)JSON.parseObject((String)result, QueryOrderHSBReDomain.class);
                    return this.makeSuccessReturn(orderHSBReDomain);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            QueryOrderHSBReDomain queryOrderHSBReDomain = new QueryOrderHSBReDomain();
            queryOrderHSBReDomain.setMain_Ordr_No("22111710397645272771");
            queryOrderHSBReDomain.setPy_Trn_No("10500005398205411180831563820H");
            queryOrderHSBReDomain.setOrdr_Stcd("2");
            result = queryOrderHSBReDomain.toString();
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    public String check(OrderNotifyDomain orderNotifyDomain) {
        if (null != orderNotifyDomain.getMain_Ordr_No()) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getPy_Trn_No()) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getOrdr_Amt()) {
            return "\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getTxnamt()) {
            return "\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getPay_Time()) {
            return "\u652f\u4ed8\u65f6\u95f4\u4e3a\u7a7a";
        }
        if (null != orderNotifyDomain.getOrdr_Stcd()) {
            return "\u8ba2\u5355\u72b6\u6001\u4ee3\u7801\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(OrderHSBConfirmGoodsDomain orderHSBConfirmGoodsDomain) {
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBConfirmGoodsDomain.getPrim_Ordr_No())) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (null != orderHSBConfirmGoodsDomain.getVno()) {
            return "\u7248\u672c\u53f7\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(RefundOrderNotifyDomain refundOrderNotifyDomain) {
        if (null != refundOrderNotifyDomain.getIttparty_Tms()) {
            return "\u53d1\u8d77\u65b9\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getPy_Trn_No()) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getPy_Trn_No()) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getSuper_Refund_No()) {
            return "\u9000\u6b3e\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (null != refundOrderNotifyDomain.getRefund_Rsp_St()) {
            return "\u9000\u6b3e\u54cd\u5e94\u72b6\u6001\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(OrderHSBDomain orderHSBDomain) {
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getMain_Ordr_No())) {
            return "\u4e3b\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPymd_Cd())) {
            return "\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getPy_Ordr_Tpcd())) {
            return "\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)orderHSBDomain.getCcy())) {
            return "\u5e01\u79cd\u4e3a\u7a7a";
        }
        if (null == orderHSBDomain.getTxn_Tamt()) {
            return "\u4ea4\u6613\u603b\u91d1\u989d\u4e3a\u7a7a";
        }
        if (null == orderHSBDomain.getVno()) {
            return "\u7248\u672c\u53f7\u4e3a\u7a7a";
        }
        return "";
    }

    public String check(RefundOrderDomain refundOrderDomain) {
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Stm_Id())) {
            return "\u53d1\u8d77\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getPy_Chnl_Cd())) {
            return "\u652f\u4ed8\u6e20\u9053\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Tms())) {
            return "\u65f6\u95f4\u6233\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getIttparty_Jrnl_No())) {
            return "\u53d1\u8d77\u65b9\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getMkt_Id())) {
            return "\u5e02\u573a\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)refundOrderDomain.getPy_Trn_No())) {
            return "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a";
        }
        return "";
    }

    @Override
    protected String makeErrorReturn(String errorCode, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "-1");
        map.put("success", false);
        map.put("dataObj", errorCode);
        map.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    protected String makeSuccessReturn(Object dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "200");
        map.put("success", true);
        map.put("dataObj", dataObj);
        map.put("msg", "\u6210\u529f");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    public String refundOrder(RefundOrderDomain refundOrderDomain) {
        logger.info(this.SYS_CODE + ".refundOrder.refundOrderDomain=====" + refundOrderDomain);
        if (refundOrderDomain == null) {
            logger.error(this.SYS_CODE + ".refundOrder.refundOrderDomain is null " + refundOrderDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)refundOrderDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCsSLR61a4P4k9TdDX9e44TuVrgv+85AOWCPHnJbNpVtnPutAIx04NTbfhaZ+f2g7q1LfKxwpsj5TNhMXKxipfATRYhd3TPbNYwEE3KywFOhQhtD4zTBSqr0wxd9QABf525jT6zcXWWG6pHpKuF39fCOzX8a/YMg+9k5KTMvl0tAhiGAM0aI1yQUfMTMqu9wyjIp2gXy+DptzT87ZMyhq7Ug7UzNd+HVj5winy0vIwbu2S6ntCz3hzgHHtvnS3OsNV5daUHK6pJBSFwR9xZdc1RjywGqzwSmYrBOgyAAkRX2sZWeRO1puU8s56ZbDK+fZdMtAV3cIL0QHF8pFm3WO89AgMBAAECggEAJf0mJsvFROVfHoTKfulmq7y8aECKTGSBNxWEuUCSaEICEEmLDleYZqYiFDVDNd1YJylJkZ7avLCGgtD3fGSWD6Yv0hNYI4DZPeHqdWQMFrdI41uBbup9vUOdP36NkMcGDWsyvziud/oDsyaBV9TC66ZIwi9AIwRYnkO4fxkezJSD7N0ilBHOYI7fxcJmPkXdfMA0J5eequQ5Kq/g1CDuxQ5/QyrKtbi/sUFLp4J+QQp8m0o+lV9ZFqQsSf9wyHFSnSsIZSPq+0HovHscxrzsTmmFGsKXMlunzhqwUB6hGme9CP284iFP+Piy7fL3vK1YOQZtnGnx/1Uz7jW9QGkgFQKBgQDfqNNC7tiPcrLCvVaBMhNzMY+198Z5e1YT5hUFxlMzM4jtQzwIEaN36KLMLTnvb9C0U45L9RX85GYi9YTOXQ/7TivILMokgOCE8aKasbTfRs7uu3nksudiz+Z03qAnjuCdPcf47TcXzn1TZ0X0qBrgDJm2Q6qNI5pik8ttexc7xwKBgQDFMh7UEpcywhVy05AZCAIx3jTJGufML2wO81yk8rcyLraAaPf71lx15Feh6vo+7owvgw6SdqW207UEqgBfcihspWMGmrUiqb72aMmxFeSyGyh7t2/gS1OE9/X/Emf9aT94v4ApAq4oVsxyuXDhrKSin6DhFp9H7+BxPQj5u0jU2wKBgFHJLX+zUXObMK0viVtzEVO1UuTqtyQjKsXaA+P5suDtPmvsgx48PPeTFTzuaNoanEnkqAs0kxbH+mVcPHUt6LMv0ajAYCbbDb7vkVNaGlbvUKpR2e/8T8p9Vbt00UHF6HL3bZGkRNoqwv9lq1ocwr8dPHQ+6DX2R/U2MFRXh5ZvAoGBAKdud+h+5GwPiKCXa2kleJ+Y2N7L/nZK6YgEL+xJvSxZp1F+TthAWP8sYw+y8MlQSCzrLQtEvE1wkekk4u4ngpVFE8B+yT9mOyMDNAUs3qIvFv98b/xUWNS0qOTrXuo2W9MNXib0BKVxlWPveh3TNXJy8OlNCO7OiJX9Scqorx0zAoGAAyvTp72dNGdLV6GbWjmsNP21XiebIvUsMgD3KKGWb+X24LpaBvvXz4hlsxl45TP4LQX7fOOhn4RkcrlNGd0nxWQatqoR+e8C/a6Tp0y+VlkHZhRiBca87VDo7zthCvlDQzrXrMkqvy+IuFzVBv8nJ4xkVhzqIo+mm4wDyawFQzs=", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/refundOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf));
                if (b) {
                    RefundOrderReDomain refundOrderReDomain = (RefundOrderReDomain)JSON.parseObject((String)result, RefundOrderReDomain.class);
                    return this.makeSuccessReturn(refundOrderReDomain);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Cust_Rfnd_Trcno\":\"\",\"Ittparty_Jrnl_No\":\"397440053504\",\"Ittparty_Tms\":\"20221118110735709\",\"Refund_Rsp_Inf\":\"\u9000\u6b3e\u6210\u529f\",\"Refund_Rsp_St\":\"00\",\"Rfnd_Trcno\":\"221118035395072\",\"Rsp_Inf\":\"\",\"Sign_Inf\":\"cxq1t54SLyYDcwgFwh9Qj8GXPhcfS0r0/Ocuh2IeAVGccykjK72dRGda/6xiifEruBb/Q9ipbNRCmLTx/2bQwvkq+aK3X84fxtSJOhW3Vzsp2108v3QP0J3j/HY3Kl9OVXQxZxUTIJfTradXE/ZhnbpaAM8XjMhmpU6Yy0uOunZSCmBdv/ZO9yTbzYLveptwAGFIHHyhOUdBAkLC8OeDASRQ81twpCYe3jRJfisgDfnu8EcD5DHI5hq5FArxB9qTHh+/lNg1BZlOUdmKJ7YLsSOUowiyHI0nLuiQZGCvZdrllU10/kEipB6aUnnTASMr4P+usKzrTeywqO9zJwdnWg==\",\"Svc_Rsp_Cd\":\"\",\"Svc_Rsp_St\":\"00\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String refundOrderNotify(HttpServletRequest request) {
        JSONObject resultJson = new JSONObject();
        String json = "";
        try {
            StringBuffer sb = new StringBuffer();
            ServletInputStream is = request.getInputStream();
            InputStreamReader isr = new InputStreamReader((InputStream)is);
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            json = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            json = "";
        }
        if (StringUtils.isBlank((String)json)) {
            resultJson.put("Svc_Res_St", (Object)"01");
            String result = resultJson.toString();
            return result;
        }
        logger.info(this.SYS_CODE + ".payOrderNotify.json=====" + json);
        String jsonString = "";
        try {
            String result;
            jsonString = SplicingUtil.createSign(json);
            logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
            JSONObject parse = JSON.parseObject((String)json);
            String signInf = (String)parse.get((Object)"Sign_Inf");
            boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
            logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + b);
            if (b) {
                resultJson.put("Svc_Res_St", (Object)"00");
                result = resultJson.toString();
                return result;
            }
            resultJson.put("Svc_Res_St", (Object)"01");
            result = resultJson.toString();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultJson.put("Svc_Res_St", (Object)"01");
            resultJson.put("Svc_Rsp_Cd", (Object)"500");
            resultJson.put("Rsp_Inf", (Object)"\u54cd\u5e94\u4fe1\u606f");
            resultJson.put("Rcv_Tm", (Object)System.currentTimeMillis());
            String result = resultJson.toString();
            return result;
        }
    }

    @Override
    public String enquireRefundOrder(QueryOrderHSBRefundDomain queryOrderHSBRefundDomain) {
        logger.info(this.SYS_CODE + ".enquireRefundOrder.queryOrderHSBRefundDomain=====" + queryOrderHSBRefundDomain);
        if (queryOrderHSBRefundDomain == null) {
            logger.error(this.SYS_CODE + ".enquireRefundOrder.queryOrderHSBRefundDomain is null " + queryOrderHSBRefundDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)queryOrderHSBRefundDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCsSLR61a4P4k9TdDX9e44TuVrgv+85AOWCPHnJbNpVtnPutAIx04NTbfhaZ+f2g7q1LfKxwpsj5TNhMXKxipfATRYhd3TPbNYwEE3KywFOhQhtD4zTBSqr0wxd9QABf525jT6zcXWWG6pHpKuF39fCOzX8a/YMg+9k5KTMvl0tAhiGAM0aI1yQUfMTMqu9wyjIp2gXy+DptzT87ZMyhq7Ug7UzNd+HVj5winy0vIwbu2S6ntCz3hzgHHtvnS3OsNV5daUHK6pJBSFwR9xZdc1RjywGqzwSmYrBOgyAAkRX2sZWeRO1puU8s56ZbDK+fZdMtAV3cIL0QHF8pFm3WO89AgMBAAECggEAJf0mJsvFROVfHoTKfulmq7y8aECKTGSBNxWEuUCSaEICEEmLDleYZqYiFDVDNd1YJylJkZ7avLCGgtD3fGSWD6Yv0hNYI4DZPeHqdWQMFrdI41uBbup9vUOdP36NkMcGDWsyvziud/oDsyaBV9TC66ZIwi9AIwRYnkO4fxkezJSD7N0ilBHOYI7fxcJmPkXdfMA0J5eequQ5Kq/g1CDuxQ5/QyrKtbi/sUFLp4J+QQp8m0o+lV9ZFqQsSf9wyHFSnSsIZSPq+0HovHscxrzsTmmFGsKXMlunzhqwUB6hGme9CP284iFP+Piy7fL3vK1YOQZtnGnx/1Uz7jW9QGkgFQKBgQDfqNNC7tiPcrLCvVaBMhNzMY+198Z5e1YT5hUFxlMzM4jtQzwIEaN36KLMLTnvb9C0U45L9RX85GYi9YTOXQ/7TivILMokgOCE8aKasbTfRs7uu3nksudiz+Z03qAnjuCdPcf47TcXzn1TZ0X0qBrgDJm2Q6qNI5pik8ttexc7xwKBgQDFMh7UEpcywhVy05AZCAIx3jTJGufML2wO81yk8rcyLraAaPf71lx15Feh6vo+7owvgw6SdqW207UEqgBfcihspWMGmrUiqb72aMmxFeSyGyh7t2/gS1OE9/X/Emf9aT94v4ApAq4oVsxyuXDhrKSin6DhFp9H7+BxPQj5u0jU2wKBgFHJLX+zUXObMK0viVtzEVO1UuTqtyQjKsXaA+P5suDtPmvsgx48PPeTFTzuaNoanEnkqAs0kxbH+mVcPHUt6LMv0ajAYCbbDb7vkVNaGlbvUKpR2e/8T8p9Vbt00UHF6HL3bZGkRNoqwv9lq1ocwr8dPHQ+6DX2R/U2MFRXh5ZvAoGBAKdud+h+5GwPiKCXa2kleJ+Y2N7L/nZK6YgEL+xJvSxZp1F+TthAWP8sYw+y8MlQSCzrLQtEvE1wkekk4u4ngpVFE8B+yT9mOyMDNAUs3qIvFv98b/xUWNS0qOTrXuo2W9MNXib0BKVxlWPveh3TNXJy8OlNCO7OiJX9Scqorx0zAoGAAyvTp72dNGdLV6GbWjmsNP21XiebIvUsMgD3KKGWb+X24LpaBvvXz4hlsxl45TP4LQX7fOOhn4RkcrlNGd0nxWQatqoR+e8C/a6Tp0y+VlkHZhRiBca87VDo7zthCvlDQzrXrMkqvy+IuFzVBv8nJ4xkVhzqIo+mm4wDyawFQzs=", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpaykone.dev.jh:8028/online/direct/enquireRefundOrder", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf));
                if (b) {
                    QueryOrderHSBRefundReDomain queryOrderHSBRefundReDomain = (QueryOrderHSBRefundReDomain)JSON.parseObject((String)result, QueryOrderHSBRefundReDomain.class);
                    return this.makeSuccessReturn(queryOrderHSBRefundReDomain);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            QueryOrderHSBRefundReDomain queryOrderHSBRefundReDomain = new QueryOrderHSBRefundReDomain();
            queryOrderHSBRefundReDomain.setIttparty_Jrnl_No("22111710397645272771");
            queryOrderHSBRefundReDomain.setRfnd_Trcno("221118035395072");
            queryOrderHSBRefundReDomain.setRfnd_Amt("22");
            queryOrderHSBRefundReDomain.setRefund_Rsp_St("00");
            result = queryOrderHSBRefundReDomain.toString();
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }

    @Override
    public String mergeNoticeArrival(OrderHSBConfirmGoodsDomain orderHSBConfirmGoodsDomain) {
        logger.info(this.SYS_CODE + ".mergeNoticeArrival.orderHSBConfirmGoodsDomain=====" + orderHSBConfirmGoodsDomain);
        if (orderHSBConfirmGoodsDomain == null) {
            logger.error(this.SYS_CODE + ".mergeNoticeArrival.orderHSBConfirmGoodsDomain is null " + orderHSBConfirmGoodsDomain);
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.check(orderHSBConfirmGoodsDomain);
        if (StringUtils.isBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".mergeNoticeArrival.msg");
            return this.makeErrorReturn(null, msg);
        }
        String result = "";
        try {
            Boolean getddflagsetting = this.getddflagsetting("591197526966321228", "mockFlag", "mockFlag");
            if (getddflagsetting.booleanValue()) {
                String json = JSONUtil.toJsonStr((Object)orderHSBConfirmGoodsDomain);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String jsonString = SplicingUtil.createSign(jsonObject.toString());
                logger.info("\u52a0\u7b7e\u5b57\u7b26\u4e32\uff1a" + jsonString);
                String signInf = RSASignUtil.sign("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCsSLR61a4P4k9TdDX9e44TuVrgv+85AOWCPHnJbNpVtnPutAIx04NTbfhaZ+f2g7q1LfKxwpsj5TNhMXKxipfATRYhd3TPbNYwEE3KywFOhQhtD4zTBSqr0wxd9QABf525jT6zcXWWG6pHpKuF39fCOzX8a/YMg+9k5KTMvl0tAhiGAM0aI1yQUfMTMqu9wyjIp2gXy+DptzT87ZMyhq7Ug7UzNd+HVj5winy0vIwbu2S6ntCz3hzgHHtvnS3OsNV5daUHK6pJBSFwR9xZdc1RjywGqzwSmYrBOgyAAkRX2sZWeRO1puU8s56ZbDK+fZdMtAV3cIL0QHF8pFm3WO89AgMBAAECggEAJf0mJsvFROVfHoTKfulmq7y8aECKTGSBNxWEuUCSaEICEEmLDleYZqYiFDVDNd1YJylJkZ7avLCGgtD3fGSWD6Yv0hNYI4DZPeHqdWQMFrdI41uBbup9vUOdP36NkMcGDWsyvziud/oDsyaBV9TC66ZIwi9AIwRYnkO4fxkezJSD7N0ilBHOYI7fxcJmPkXdfMA0J5eequQ5Kq/g1CDuxQ5/QyrKtbi/sUFLp4J+QQp8m0o+lV9ZFqQsSf9wyHFSnSsIZSPq+0HovHscxrzsTmmFGsKXMlunzhqwUB6hGme9CP284iFP+Piy7fL3vK1YOQZtnGnx/1Uz7jW9QGkgFQKBgQDfqNNC7tiPcrLCvVaBMhNzMY+198Z5e1YT5hUFxlMzM4jtQzwIEaN36KLMLTnvb9C0U45L9RX85GYi9YTOXQ/7TivILMokgOCE8aKasbTfRs7uu3nksudiz+Z03qAnjuCdPcf47TcXzn1TZ0X0qBrgDJm2Q6qNI5pik8ttexc7xwKBgQDFMh7UEpcywhVy05AZCAIx3jTJGufML2wO81yk8rcyLraAaPf71lx15Feh6vo+7owvgw6SdqW207UEqgBfcihspWMGmrUiqb72aMmxFeSyGyh7t2/gS1OE9/X/Emf9aT94v4ApAq4oVsxyuXDhrKSin6DhFp9H7+BxPQj5u0jU2wKBgFHJLX+zUXObMK0viVtzEVO1UuTqtyQjKsXaA+P5suDtPmvsgx48PPeTFTzuaNoanEnkqAs0kxbH+mVcPHUt6LMv0ajAYCbbDb7vkVNaGlbvUKpR2e/8T8p9Vbt00UHF6HL3bZGkRNoqwv9lq1ocwr8dPHQ+6DX2R/U2MFRXh5ZvAoGBAKdud+h+5GwPiKCXa2kleJ+Y2N7L/nZK6YgEL+xJvSxZp1F+TthAWP8sYw+y8MlQSCzrLQtEvE1wkekk4u4ngpVFE8B+yT9mOyMDNAUs3qIvFv98b/xUWNS0qOTrXuo2W9MNXib0BKVxlWPveh3TNXJy8OlNCO7OiJX9Scqorx0zAoGAAyvTp72dNGdLV6GbWjmsNP21XiebIvUsMgD3KKGWb+X24LpaBvvXz4hlsxl45TP4LQX7fOOhn4RkcrlNGd0nxWQatqoR+e8C/a6Tp0y+VlkHZhRiBca87VDo7zthCvlDQzrXrMkqvy+IuFzVBv8nJ4xkVhzqIo+mm4wDyawFQzs=", jsonString);
                jsonObject.put("Sign_Inf", (Object)signInf);
                logger.info("\u4f20\u5165\u7684json\u4e32\uff1a" + json);
                result = HttpUtil.doJsonPost("http://marketpayktwo.dev.jh:8028/online/direct/mergeNoticeArrival", jsonObject.toString());
                logger.info("result=" + result);
                JSONObject jsonObject1 = JSONObject.parseObject((String)result);
                jsonString = SplicingUtil.createSign(result);
                logger.info("\u8f93\u51fa\u7684\u539f\u4e32\u4e3a" + jsonString);
                signInf = jsonObject1.getString("Sign_Inf");
                boolean b = RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf);
                logger.info("\u9a8c\u7b7e\u7ed3\u679c:" + RSASignUtil.verifySign("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve+fdklEkw7yZwWY4fGkFo/Ixn2tcFmv6plZZorf7tPTYXSjfK5THVI4+/YygTxoigIXixoY2DXtSuZPa43vJKWT4jh7jmEpIZK04ix2KxfK70WqUEBPqRgB0Vlc7L0utwN8jnLKmPFrWBzgNg2mW4GMCuISziFWXW49CoiNrS55v7mAwBrQpY+fqu5DG/UFP9QdqVDh5DPuxwacFwIXQzVCUk+ZwOfexz0PMOQl3++GOVfo76vq0GgSLr2zSlokzxOHDGke1LUSr2kf+t3fIy3MttMBG2tku20Xq/Empeg18FFtjiJFtGu44uuYZe9e6y7J4IQ1mFjc27YkAFn/mQIDAQAB", jsonString, signInf));
                if (b) {
                    OrderHSBConfirmGoodsReDomain orderHSBConfirmGoodsReDomain = (OrderHSBConfirmGoodsReDomain)JSON.parseObject((String)result, OrderHSBConfirmGoodsReDomain.class);
                    return this.makeSuccessReturn(orderHSBConfirmGoodsReDomain);
                }
                return this.makeErrorReturn("500", "\u672c\u5730\u9a8c\u7b7e\u5931\u8d25");
            }
            result = "{\"Rsp_Inf\":\"\u786e\u8ba4\u6536\u8d27\u5904\u7406\u5b8c\u6210\",\"Svc_Rsp_Cd\":\"\",\"Svc_Rsp_St\":\"00\"}";
            logger.info("result=" + result);
            return this.makeSuccessReturn(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeErrorReturn("500", e.getMessage());
        }
    }
}

