/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.app.api.ExOrderService;
import com.yqbsoft.laser.service.ext.bus.app.common.RetuenBean;
import com.yqbsoft.laser.service.ext.bus.app.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcPackageDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.bus.app.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ExOrderServiceImpl
extends OrderBaseService
implements ExOrderService {
    private String SYS_CODE = "app.ExOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExOrderServiceImpl.class);

    @Override
    public String sendSaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            msg = this.makeOcContractDomain(ocContractDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", msg);
            }
            RetuenBean retuenBean = this.saveOrder(ocContractDomain);
            if (null == retuenBean) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.contractBillcode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return JsonUtil.buildNormalBinder().toJson((Object)retuenBean);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendContractState(String contractNbillcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type)) {
            logger.error(this.SYS_CODE + ".sendContractState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendContractState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String contractBillcode = null;
        String msg = this.checkQueryContract(contractNbillcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,channelCode", new Object[]{contractNbillcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        contractBillcode = ((OcContractReDomain)qlist.getList().get(0)).getContractBillcode();
        try {
            if (type.equals("AN")) {
                this.orderNext(contractBillcode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.orderBack(contractBillcode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendRefundState(String refundNcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type) || MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendRefundState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = null;
        String msg = this.checkQueryRefund(refundNcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRefundState.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", msg);
        }
        QueryResult<OcRefundReDomain> qlist = this.queryRefundPage(this.getQueryMapParam("refundNcode,tenantCode,channelCode", new Object[]{refundNcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", "refundNcode[" + refundNcode + "]\u4e0d\u5b58\u5728! ");
        }
        refundCode = ((OcRefundReDomain)qlist.getList().get(0)).getRefundCode();
        try {
            if (type.equals("AN")) {
                this.refundNext(refundCode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.refundBack(refundCode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.msg", msg);
        }
        try {
            msg = this.makeOcRefundDomain(ocRefundDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", msg);
            }
            String refundCode = this.saveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.refundCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.refundCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(refundCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e1", e.getMessage());
        }
    }

    @Override
    public String sendQueryExOcContract(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("childFlag")))) {
            map.put("childFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("sendGoodsFlag")))) {
            map.put("sendGoodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("packFlag")))) {
            map.put("packFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("settleFlag")))) {
            map.put("settleFlag", "true");
        }
        return this.makeSuccessReturn(this.queryOrderReDomainPage(map));
    }

    @Override
    public String sendQueryExRefund(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExRefund.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractProFlag")))) {
            map.put("ocContractProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractGoodsFlag")))) {
            map.put("ocContractGoodsFlag", "true");
        }
        return this.makeSuccessReturn(this.queryRefundReDoaminPage(map));
    }

    private String checkQueryMap(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == map.get("startRow")) {
            msg = msg + "startRow\u4e3a\u7a7a! ";
        }
        if (null == map.get("rows")) {
            msg = msg + "rows\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String setDefContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String channelCode = ocContractDomain.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            return "channelCode is null";
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannel(channelCode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return "channelCode:" + channelCode + "tenantCode:" + ocContractDomain.getTenantCode() + " disChannelReDomain";
        }
        String appmanageIcode = disChannelReDomain.getProappCode();
        if (StringUtils.isBlank((String)appmanageIcode)) {
            appmanageIcode = "cs2";
        }
        ocContractDomain.setGoodsClass(disChannelReDomain.getGoodsClass());
        ocContractDomain.setAppmanageIcode(appmanageIcode);
        ocContractDomain.setContractType("50");
        ocContractDomain.setMemberCcode(disChannelReDomain.getMemberCcode());
        ocContractDomain.setMemberCname(disChannelReDomain.getMemberCname());
        ocContractDomain.setMemberBcode(disChannelReDomain.getMemberCode());
        ocContractDomain.setMemberBname(disChannelReDomain.getMemberName());
        ocContractDomain.setMemberCode(disChannelReDomain.getMemberCode());
        ocContractDomain.setMemberName(disChannelReDomain.getMemberName());
        ocContractDomain.setMemberMcode(disChannelReDomain.getMemberMcode());
        ocContractDomain.setMemberMname(disChannelReDomain.getMemberMname());
        ocContractDomain.setChannelName(disChannelReDomain.getChannelName());
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractBillcode())) {
            ocContractDomain.setContractNbillcode(ocContractDomain.getContractBillcode());
            ocContractDomain.setContractBillcode("");
        }
        if (ListUtil.isNotEmpty(ocContractDomain.getPackageList())) {
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                ocPackageDomain.setAppmanageIcode(ocContractDomain.getAppmanageIcode());
                ocPackageDomain.setContractType(ocContractDomain.getContractType());
                ocPackageDomain.setMemberCcode(ocContractDomain.getMemberCcode());
                ocPackageDomain.setMemberCname(ocContractDomain.getMemberCname());
                ocPackageDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
                ocPackageDomain.setMemberCode(ocContractDomain.getMemberCode());
                ocPackageDomain.setMemberName(ocContractDomain.getMemberName());
                ocPackageDomain.setMemberMcode(ocContractDomain.getMemberMcode());
                ocPackageDomain.setMemberMname(ocContractDomain.getMemberMname());
                ocPackageDomain.setTenantCode(ocContractDomain.getTenantCode());
                ocPackageDomain.setChannelCode(ocContractDomain.getChannelCode());
                ocPackageDomain.setChannelName(ocContractDomain.getChannelName());
                if (!ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) continue;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    ocContractGoodsDomain.setGoodsClass(ocContractDomain.getGoodsClass());
                    ocContractGoodsDomain.setAppmanageIcode(ocContractDomain.getAppmanageIcode());
                    ocContractGoodsDomain.setMemberCcode(ocContractDomain.getMemberCcode());
                    ocContractGoodsDomain.setMemberCname(ocContractDomain.getMemberCname());
                    ocContractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                    ocContractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                    ocContractGoodsDomain.setMemberCode(ocContractDomain.getMemberCode());
                    ocContractGoodsDomain.setMemberName(ocContractDomain.getMemberName());
                    ocContractGoodsDomain.setMemberMcode(ocContractDomain.getMemberMcode());
                    ocContractGoodsDomain.setMemberMname(ocContractDomain.getMemberMname());
                    ocContractGoodsDomain.setTenantCode(ocContractDomain.getTenantCode());
                    ocContractGoodsDomain.setChannelCode(ocContractDomain.getChannelCode());
                    ocContractGoodsDomain.setChannelName(ocContractDomain.getChannelName());
                }
            }
        }
        return "";
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        QueryResult<OcContractReDomain> qlist;
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        ocContractDomain.setContractId(null);
        ocContractDomain.setOcContractSettlList(null);
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                ocContractproDomain.setContractproId(null);
                ocContractproDomain.setContractproBillcode(null);
            }
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractBillcode()) && StringUtils.isBlank((String)ocContractDomain.getContractNbillcode())) {
            ocContractDomain.setContractNbillcode(ocContractDomain.getContractBillcode());
        }
        if (StringUtils.isBlank((String)ocContractDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getContractType())) {
            msg = msg + "contractType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractNbillcode()) && null != (qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{ocContractDomain.getContractNbillcode(), ocContractDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "contractNbillcode[" + ocContractDomain.getContractNbillcode() + "]\u91cd\u590d! ";
        }
        if (null == ocContractDomain.getGoodsNum() || ocContractDomain.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "goodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            msg = msg + "packageList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                ++i;
                if (ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) {
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u4e3a\u7a7a! ";
                    continue;
                }
                int j = 0;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    ++j;
                    if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo())) {
                        msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cskuCode\u6216skuNo\u90fd\u4e3a\u7a7a! ";
                    }
                    if (null != ocContractGoodsDomain.getGoodsNum() && ocContractGoodsDomain.getGoodsNum().compareTo(BigDecimal.ZERO) > 0) continue;
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cgoodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
            }
        }
        String m = this.setDefContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)m)) {
            msg = msg + m;
        }
        return msg;
    }

    private String checkQueryContract(String contractNbillcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)contractNbillcode)) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkQueryRefund(String refundNcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)refundNcode)) {
            msg = msg + "refundNcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        QueryResult<OcRefundReDomain> qlist;
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode()) && StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            msg = msg + "contractBillcode\u548ccontractNbillcode\u90fd\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "refundType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundOcode()) && null != (qlist = this.queryRefundPage(this.getQueryMapParam("refundOcode,tenantCode", new Object[]{ocRefundDomain.getRefundOcode(), ocRefundDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "refundOcode[" + ocRefundDomain.getRefundOcode() + "]\u91cd\u590d! ";
        }
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "refundMoney\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "ocRefundGoodsDomainList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                ++i;
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsGtype())) {
                    msg = msg + "\u7b2c" + i + "\u884ccontractGoodsGtype\u4e3a\u7a7a! ";
                }
                if (null != ocRefundGoodsDomain.getRefundGoodsAmt() && ocRefundGoodsDomain.getRefundGoodsAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                msg = msg + "\u7b2c" + i + "\u884crefundGoodsAmt\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
            }
        }
        return msg;
    }

    private String makeOcRefundDomain(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return "\u5546\u54c1\u4e3a\u7a7a";
        }
        String msg = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocRefundDomain.getTenantCode());
        paramMap.put("childFlag", "true");
        if (StringUtils.isNotBlank((String)ocRefundDomain.getContractBillcode())) {
            paramMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        } else {
            paramMap.put("contractNbillcode", ocRefundDomain.getContractNbillcode());
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderReDomainPage(paramMap);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.qlist", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u4e3a\u7a7a! " + paramMap.toString();
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)qlist.getList().get(0);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.copy", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()), (Throwable)e);
            return "\u5f02\u5e38! " + paramMap.toString();
        }
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.goodsList", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a! " + paramMap.toString();
        }
        HashMap<String, OcContractGoodsDomain> contractgoodsMap = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            contractgoodsMap.put(ocContractGoodsDomain.getContractGoodsGtype() + "-" + ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
        }
        BigDecimal reMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractgoodsMap.get(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo());
            if (null == ocContractGoodsDomain) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.ocContractGoodsDomain", (Object)(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo()));
                return "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38! " + ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo();
            }
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reMoney = reMoney.add(ocRefundGoodsDomain.getRefundGoodsAmt());
        }
        ocRefundDomain.setRefundMoney(reMoney);
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(reMoney) != 0) {
            msg = msg + "\u660e\u7ec6\u91d1\u989d\u4e0e\u6c47\u603b\u91d1\u989d";
        }
        return msg;
    }

    private String makeOcContractDomain(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            return "\u5305\u88f9\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            ocContractDomain.setMemberCode(this.getTeananMemberCode(ocContractDomain.getTenantCode()));
            ocContractDomain.setMemberName("\u5e73\u53f0");
        }
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        String msg = "";
        String goodsClass = ocContractDomain.getGoodsClass();
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (ListUtil.isEmpty(contractGoodsList)) {
                return "\u5305\u88f9\u91cc\u7684\u5546\u54c1\u4e3a\u7a7a";
            }
            ocPackageDomain.setPackageCode(null);
            ocPackageDomain.setPackageId(null);
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                ocContractGoodsDomain.setContractGoodsCode(null);
                ocContractGoodsDomain.setContractGoodsId(null);
                msg = this.checkOcContractGoodsDomain(ocContractGoodsDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    return msg;
                }
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
                    paramMap.put("goodsClass", goodsClass);
                    paramMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
                    paramMap.put("channelCode", ocContractDomain.getChannelCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl2", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuCode())) {
                    paramMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl1", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                }
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), ocContractDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.rsResourceGoodsReDomain", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                BigDecimal goodsNum = ocContractGoodsDomain.getGoodsNum();
                BigDecimal goodsWeight = ocContractGoodsDomain.getGoodsWeight();
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                ocContractGoodsDomain.setGoodsNum(goodsNum);
                ocContractGoodsDomain.setGoodsWeight(goodsWeight);
                ocPackageDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                ocPackageDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
                ocPackageDomain.setMemberMcode(ocContractGoodsDomain.getMemberMcode());
                ocPackageDomain.setMemberMname(ocContractGoodsDomain.getMemberMname());
                ocPackageDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocPackageDomain.setMemberName(ocContractGoodsDomain.getMemberName());
                ocContractDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                ocContractDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
                ocContractDomain.setMemberMcode(ocContractGoodsDomain.getMemberMcode());
                ocContractDomain.setMemberMname(ocContractGoodsDomain.getMemberMname());
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
        }
        return msg;
    }

    private String checkOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode())) {
            msg = msg + "skuNo\u548cskuCode\u90fd\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(whGoodsBeanList)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return this.makeErrorReturn(this.SYS_CODE + ".getFreight.param", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = "";
        for (WhGoodsBean whGoodsBean : whGoodsBeanList) {
            if (!StringUtils.isBlank((String)whGoodsBean.getSkuEocode()) && null != whGoodsBean.getGoodsNum()) continue;
            msg = msg + " skuEocode or goodsNum  is null";
        }
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".getFreight.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".getFreight.msg", msg);
        }
        String str = this.getFreightForThird(whGoodsBeanList, areaStr, memberCode, tenantCode);
        return this.makeSuccessReturn(str);
    }

    @Override
    public String getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(whGoodsBeanList)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return this.makeErrorReturn(this.SYS_CODE + ".getNewStockById.param", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = "";
        for (WhGoodsBean whGoodsBean : whGoodsBeanList) {
            if (!StringUtils.isBlank((String)whGoodsBean.getSkuEocode()) && null != whGoodsBean.getGoodsNum()) continue;
            msg = msg + " skuEocode or goodsNum  is null";
        }
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".getNewStockById.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".getNewStockById.msg", msg);
        }
        List<WhGoodsBean> list = this.getNewStockByIdForThird(whGoodsBeanList, areaStr, memberCode, tenantCode);
        return this.makeSuccessReturn(list);
    }
}

