/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.app.client.SapClient;
import com.yqbsoft.laser.service.ext.bus.app.common.RsDeviceInfo;
import com.yqbsoft.laser.service.ext.bus.app.domain.rs.RsDeviceInfoDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.EquipmentDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.EquipmentMaterialReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.MaterialDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.service.BusSisService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.BusBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BusSisServiceImpl
extends BusBaseService
implements BusSisService {
    private String SANY_CODE = "sany.BusSisServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusSisServiceImpl.class);
    private String ddcode = "sany.sis";
    public static final String dd_mockFlag = "crmFlag";
    public static final String DEFAULT_TENANT = "591197526966321228";
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    private static final String URL = "http://poweb.sanygroup.com:8000/RESTAdapter/public/047/equipmentOSBO";
    private static final String TENANTCODE = "591197526966321228";
    @Autowired
    RestTempfacade restTempfacade;

    private Boolean getddflagsetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = "591197526966321228".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
        }
        if (StringUtils.isEmpty((String)value) || "true".equals(value)) {
            return true;
        }
        return false;
    }

    @Override
    public EquipmentMaterialReDomain queryMaterialAndEquipmentInfo(String equipmentCode) throws Exception {
        String result;
        EquipmentMaterialReDomain mockResp = this.getEquipmentMaterialReDomain();
        if (StringUtils.isBlank((String)equipmentCode)) {
            return null;
        }
        if (Boolean.TRUE.equals(this.getddflagsetting("591197526966321228", dd_mockFlag, dd_mockFlag))) {
            logger.info("sany.queryMaterialAndEquipmentInfo.mockFlag", (Object)"mockFlag is open");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("equipmentCode", equipmentCode);
        JsonUtil jsonUtil = JsonUtil.buildNormalBinder();
        try {
            result = SapClient.doPostJson(URL, jsonUtil.toJson(param));
        }
        catch (Exception e) {
            logger.error("sany.queryMaterialAndEquipmentInfo.Exception", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
        logger.debug("sany.queryMaterialAndEquipmentInfo.result", (Object)result);
        return (EquipmentMaterialReDomain)JSON.parseObject((String)result, EquipmentMaterialReDomain.class);
    }

    private EquipmentMaterialReDomain getEquipmentMaterialReDomain() {
        EquipmentMaterialReDomain mockResp = new EquipmentMaterialReDomain();
        EquipmentDomain equipmentDomain = new EquipmentDomain();
        MaterialDomain materialDomain = new MaterialDomain();
        ArrayList<MaterialDomain> list = new ArrayList<MaterialDomain>();
        list.add(materialDomain);
        materialDomain.setId("1210001492087013377");
        materialDomain.setParentPartCode("60320153");
        materialDomain.setParentPartName("\u6392\u6c14\u7ba16WG1X");
        materialDomain.setPartCode("60320028");
        materialDomain.setPartName("\u5e9f\u6c14\u518d\u5faa\u73af\u51b7\u5374\u5668116127-0224");
        materialDomain.setEnPartName("Cooler; egr");
        materialDomain.setComponentsNum(1);
        materialDomain.setBelongLevel(7);
        materialDomain.setCreateTime(new Date());
        materialDomain.setUpdateTime(new Date());
        equipmentDomain.setEquCode("SR285CBK12728");
        equipmentDomain.setDeliveryDate(new Date());
        equipmentDomain.setMatnr("13564694");
        equipmentDomain.setProductModel("SR285RC10\u65cb\u6316\u94bb\u673a\u4e3b\u4f53SR285RC10.0");
        equipmentDomain.setMaterials(list);
        ArrayList<EquipmentDomain> equipmentDomains = new ArrayList<EquipmentDomain>();
        equipmentDomains.add(equipmentDomain);
        mockResp.setCode(0);
        mockResp.setMessage("mock data");
        mockResp.setData(equipmentDomains);
        return mockResp;
    }

    @Override
    public void updateMaterialAndEquipment() throws Exception {
        String queryDeviceInfoPage = "rs.rsDeviceInfo.queryDeviceInfoPage";
        String saveDeviceInfo = "rs.rsDeviceInfo.saveDeviceInfo";
        String updateDeviceInfo = "rs.rsDeviceInfo.updateDeviceInfo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("deviceType", 1);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResult = this.sendReSupObject(queryDeviceInfoPage, paramMap, RsDeviceInfo.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        for (RsDeviceInfo rsDeviceInfo : queryResult.getList()) {
            List<EquipmentDomain> equipmentDomain;
            String deviceModel = rsDeviceInfo.getDeviceModel();
            EquipmentMaterialReDomain equipmentInfo = this.queryMaterialAndEquipmentInfo(deviceModel);
            if (equipmentInfo == null || Objects.equals(3, equipmentInfo.getCode()) || ListUtil.isEmpty(equipmentDomain = equipmentInfo.getData())) continue;
            List<MaterialDomain> materials = equipmentDomain.get(0).getMaterials();
            for (MaterialDomain material : materials) {
                HashMap paramMap0 = new HashMap();
                HashMap<String, String> map0 = new HashMap<String, String>();
                map0.put("deviceModel", material.getPartCode());
                paramMap0.put("map", map0);
                QueryResult materialPage = this.sendReSupObject(queryDeviceInfoPage, paramMap0, RsDeviceInfo.class);
                RsDeviceInfoDomain rsDeviceInfoDomain = new RsDeviceInfoDomain();
                if (materialPage == null || ListUtil.isEmpty((Collection)materialPage.getList())) {
                    this.extracted(rsDeviceInfo, equipmentDomain.get(0), material, rsDeviceInfoDomain);
                    HashMap<String, String> paramMap2 = new HashMap<String, String>();
                    paramMap2.put("rsDeviceInfoDomain", JsonUtil.buildNormalBinder().toJson((Object)rsDeviceInfoDomain));
                    this.internalInvoke(saveDeviceInfo, paramMap2);
                    continue;
                }
                RsDeviceInfo deviceInfo = (RsDeviceInfo)materialPage.getList().get(0);
                BeanUtils.copyProperties((Object)deviceInfo, (Object)rsDeviceInfoDomain);
                this.extracted(rsDeviceInfo, equipmentDomain.get(0), material, rsDeviceInfoDomain);
                HashMap<String, String> paramMap3 = new HashMap<String, String>();
                paramMap3.put("rsDeviceInfoDomain", JsonUtil.buildNormalBinder().toJson((Object)rsDeviceInfoDomain));
                this.internalInvoke(updateDeviceInfo, paramMap3);
            }
        }
    }

    private void extracted(RsDeviceInfo rsDeviceInfo, EquipmentDomain equipmentDomain, MaterialDomain material, RsDeviceInfoDomain rsDeviceInfoDomain) {
        rsDeviceInfoDomain.setDeviceType(2);
        rsDeviceInfoDomain.setDevicePcode(rsDeviceInfo.getDeviceCode());
        rsDeviceInfoDomain.setDeviceName(material.getPartName());
        rsDeviceInfoDomain.setDevicePname(material.getParentPartName());
        rsDeviceInfoDomain.setDeviceLevel(material.getBelongLevel());
        rsDeviceInfoDomain.setDeviceNum(material.getComponentsNum());
        rsDeviceInfoDomain.setDeviceMatnr(equipmentDomain.getMatnr());
        rsDeviceInfoDomain.setDeviceModel(material.getPartCode());
        rsDeviceInfoDomain.setTenantCode("591197526966321228");
    }
}

