/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.supbase;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.app.common.RetuenBean;
import com.yqbsoft.laser.service.ext.bus.app.domain.am.AmAppmanageReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class BusBaseService
extends BaseServiceImpl {
    public static final String SYS_CODE = "app.BusBaseService";

    protected String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected Map<String, Object> getDdMap(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String json = this.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
    }

    protected Map<String, Object> getAppmanger(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "am.appmanage.queryAppmanageList";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", "00000000");
        map.put("uid", channelCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, AmAppmanageReDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error("app.BusBaseService.getAppmanger.qlist", (Object)((Object)map).toString());
            return null;
        }
        AmAppmanageReDomain amAppmanageReDomain = (AmAppmanageReDomain)qlist.getList().get(0);
        HashMap<String, Object> remap = new HashMap<String, Object>();
        remap.put("host", amAppmanageReDomain.getAppmanageCallurl());
        remap.put("clientid", amAppmanageReDomain.getAppmanageAppkey());
        remap.put("clientsecret", amAppmanageReDomain.getAppmanageSecretkey());
        remap.put("memberCode", amAppmanageReDomain.getMemberCode());
        return remap;
    }

    protected String getTenantCodeBuUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            return null;
        }
        return str[6];
    }

    public static void main(String[] args) {
        String url = "http://busmid-dev.qjclouds.com/laserEr/http/post/nm.no.createMaxBillNumber/1.0/00000000/utf-8/shangshu";
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            // empty if block
        }
        System.out.println(str[6]);
    }

    protected String getTeananMemberCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }

    protected DisChannelReDomain getDisChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "dis.channel.getChannelByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisChannelReDomain)this.readObj(apiCode, paramMap, "object", new Object[]{DisChannelReDomain.class});
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected QueryResult<RsSkuDomain> queryRsSkuPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "rs.sku.querySkuPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, RsSkuDomain.class);
    }

    protected RsResourceGoodsReDomain getGoodsByCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceGoodsByCodeStr";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsCode", goodsCode);
        paramMap.put("tenantCode", tenantCode);
        return (RsResourceGoodsReDomain)this.getForObject(apiCode, RsResourceGoodsReDomain.class, paramMap);
    }

    protected String makeErrorReturn(String errorCode, String msg) {
        return JsonUtil.buildNormalBinder().toJson((Object)new RetuenBean(errorCode, msg));
    }

    protected String makeSuccessReturn(Object dataObj) {
        return JsonUtil.buildNormalBinder().toJson((Object)new RetuenBean(dataObj));
    }
}

