/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class RSASignUtil {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";
    public static final int KEY_SIZE = 2048;
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String ENCODE_ALGORITHM = "SHA-256";
    public static final String PLAIN_TEXT = "test string test stringtest stringtest stringtest stringtest stringtest stringtest string";

    public static Map<String, String> generateKeyBytes() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put(PUBLIC_KEY, Base64.encodeBase64String((byte[])publicKey.getEncoded()));
            keyMap.put(PRIVATE_KEY, Base64.encodeBase64String((byte[])privateKey.getEncoded()));
            return keyMap;
        }
        catch (NoSuchAlgorithmException var5) {
            var5.printStackTrace();
            System.out.println("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return null;
        }
    }

    public static PublicKey restorePublicKey(String publicKey) {
        PublicKey pubTypeKey = null;
        try {
            byte[] prikeyByte = Base64.decodeBase64((byte[])publicKey.getBytes("UTF-8"));
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(prikeyByte);
            KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
            pubTypeKey = factory.generatePublic(x509EncodedKeySpec);
            return pubTypeKey;
        }
        catch (NoSuchAlgorithmException var5) {
            var5.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u7f16\u7801");
        }
        catch (InvalidKeySpecException var6) {
            var6.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        catch (UnsupportedEncodingException var7) {
            var7.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u5bc6\u94a5");
        }
        return null;
    }

    public static PrivateKey restorePrivateKey(String privateKey) {
        PrivateKey priTypeKey = null;
        try {
            byte[] prikeyByte = Base64.decodeBase64((byte[])privateKey.getBytes("UTF-8"));
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(prikeyByte);
            KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
            priTypeKey = factory.generatePrivate(pkcs8EncodedKeySpec);
            return priTypeKey;
        }
        catch (NoSuchAlgorithmException var5) {
            var5.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u7f16\u7801");
        }
        catch (InvalidKeySpecException var6) {
            var6.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        catch (UnsupportedEncodingException var7) {
            var7.printStackTrace();
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u5bc6\u94a5");
        }
        return null;
    }

    public static String sign(String privateKey, String plain_text) {
        return Base64.encodeBase64String((byte[])RSASignUtil.sign(RSASignUtil.restorePrivateKey(privateKey), plain_text));
    }

    public static byte[] sign(PrivateKey privateKey, String plain_text) {
        byte[] signed = null;
        try {
            Signature Sign = Signature.getInstance(SIGNATURE_ALGORITHM);
            Sign.initSign(privateKey);
            Sign.update(plain_text.getBytes());
            signed = Sign.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException var4) {
            var4.printStackTrace();
        }
        return signed;
    }

    public static boolean verifySign(String publicKey, String srcMsg, String signed) {
        PublicKey publicTypeKey = RSASignUtil.restorePublicKey(publicKey);
        return RSASignUtil.verifySign(publicTypeKey, srcMsg, signed);
    }

    private static boolean verifySign(PublicKey publicKey, String plain_text, String signed) {
        boolean SignedSuccess = false;
        try {
            Signature verifySign = Signature.getInstance(SIGNATURE_ALGORITHM);
            verifySign.initVerify(publicKey);
            verifySign.update(plain_text.getBytes("UTF-8"));
            SignedSuccess = verifySign.verify(Base64.decodeBase64((byte[])signed.getBytes("UTF-8")));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException var5) {
            var5.printStackTrace();
        }
        catch (UnsupportedEncodingException var6) {
            var6.printStackTrace();
        }
        return SignedSuccess;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src != null && src.length > 0) {
            for (int i = 0; i < src.length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString != null && !hexString.equals("")) {
            int length = hexString.length() / 2;
            char[] hexChars = hexString.toCharArray();
            byte[] d = new byte[length];
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = RSASignUtil.chartobyte(hexChars[pos]);
            }
            return d;
        }
        return null;
    }

    private static byte chartobyte(char c) {
        return (byte)"123456789abcdef".indexOf(c);
    }
}

