/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.util;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class JaxbXmlUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String convertToXml(Object obj, String soapUrl) throws Exception {
        String result = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)DEFAULT_ENCODING);
        StringWriter writer = new StringWriter();
        marshaller.marshal(obj, (Writer)writer);
        result = writer.toString();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String url = "<env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:ns1=\"" + soapUrl + "\">\n";
        sb.append(url);
        sb.append("<env:Body>\n");
        sb.append(result).append("\n");
        sb.append("</env:Body>\n");
        sb.append("</env:Envelope>");
        return sb.toString();
    }

    public static <T> T convertToJavaBean(String xml, Class<T> t) throws Exception {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(new StringReader(xml));
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{t});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement result = unmarshaller.unmarshal(xmlStreamReader, t);
        return (T)result.getValue();
    }

    public static <T> T convertToJavaBean(InputStream inputStream, Class<T> t) throws Exception {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        xmlStreamReader.nextTag();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{t});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement result = unmarshaller.unmarshal(xmlStreamReader, t);
        return (T)result.getValue();
    }
}

