/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.app.client.SapClient;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.logistics.LogisticsReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.logistics.LogisticsInfoResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.logistics.LogisticsResp;
import com.yqbsoft.laser.service.ext.bus.app.service.BusLogisticsService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class BusLogisticsServiceImpl
implements BusLogisticsService {
    private String SANY_CODE = "sany.BusLogisticsServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusLogisticsServiceImpl.class);
    private String ddcode = "sany.logistics";
    private static final String KD100URL = "http://ipaas-esb-test.sany.com.cn";
    private static final String LDWLTESTURL = "http://sim.sany.com.cn:90/crm-gw/pov/api/order/sap/order/view/viewOrder";
    private static final String LDWLPRODURL = "https://sim.sany.com.cn:8443/crm-gw/pov/api/order/sap/order/view/viewOrder";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public LogisticsResp queryLogistics(LogisticsReq logisticsReq) throws Exception {
        JsonUtil jsonUtil = JsonUtil.buildNormalBinder();
        String paramJson = jsonUtil.toJson((Object)logisticsReq);
        logger.error(this.SANY_CODE + ".queryLogistics.logisticsReq", (Object)paramJson);
        if (logisticsReq == null) {
            return null;
        }
        String result = null;
        try {
            result = SapClient.doPostJsonAuth(KD100URL, paramJson);
        }
        catch (Exception e) {
            logger.error(this.SANY_CODE + ".queryLogistics", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        LogisticsResp resp = (LogisticsResp)jsonUtil.getJsonToObject(result, LogisticsResp.class);
        logger.error(this.SANY_CODE + ".queryLogistics.resp", (Object)jsonUtil.toJson((Object)resp));
        return resp;
    }

    @Override
    public LogisticsInfoResp queryLogisticsInfo(String contractBillcode) throws Exception {
        logger.error(this.SANY_CODE + ".queryLogisticsInfo.contractBillcode", (Object)contractBillcode);
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("zzcloudOrdid", contractBillcode);
        String result = SapClient.doPostJsonAuth(LDWLPRODURL, JSON.toJSONString(param));
        logger.error(this.SANY_CODE + ".queryLogisticsInfo.result", (Object)result);
        return (LogisticsInfoResp)JSON.parseObject((String)result, LogisticsInfoResp.class);
    }
}

