/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.client;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AcquireAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AgentAccountReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AreaInfoReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingOrderReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingStockReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.ListAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.MaterialPriceReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.SalesOrganizationReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AcquireAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AgentAccountResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AreaInfoResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingOrderResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingStockResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.ListAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.MaterialPriceResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.SalesOrganizationResp;
import com.yqbsoft.laser.service.ext.bus.app.util.JaxbXmlUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SapClient {
    private static final SupperLogUtil logger = new SupperLogUtil(SapClient.class);
    private static final String SYS_CODE = "SapClient.";
    private static final String TEST_GET_CRM_PRICE_URL = "http://podev01v-ap.sanygroup.com:50000/XISOAPAdapter/MessageServlet?senderParty=&senderService=Srv_MALL&receiverParty=&receiverService=&interface=SI_getmaterialprice_MALL_OB&interfaceNamespace=htp%3A%2F%2Fsany.com%2Fmall%2F008%2Fgetmaterialprice";
    private static final String PRD_GET_CRM_PRICE_URL = "http://poweb.sanygroup.com:8000/XISOAPAdapter/MessageServlet?senderParty=&senderService=Srv_MALL&receiverParty=&receiverService=&interface=SI_getmaterialprice_MALL_OB&interfaceNamespace=htp%3A%2F%2Fsany.com%2Fmall%2F008%2Fgetmaterialprice";

    public FittingStockResp fittingStock(FittingStockReq fittingStockReq) throws Exception {
        String interfaceName = "osFittingStock_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/001/fittingstock";
        String xml = JaxbXmlUtil.convertToXml(fittingStockReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, FittingStockResp.class);
    }

    public AgentAccountResp agentAccount(AgentAccountReq agentAccountReq) throws Exception {
        String interfaceName = "osAgentAccount_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/004/agentaccount";
        String xml = JaxbXmlUtil.convertToXml(agentAccountReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AgentAccountResp.class);
    }

    public FittingOrderResp fittingOrder(FittingOrderReq fittingOrderReq) throws Exception {
        String interfaceName = "osFittingOrder_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/002/fittingorder";
        String xml = JaxbXmlUtil.convertToXml(fittingOrderReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, FittingOrderResp.class);
    }

    public MaterialPriceResp getMaterialPrice(MaterialPriceReq materialPriceReq) throws Exception {
        String interfaceName = "SI_getmaterialprice_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/008/getmaterialprice";
        String xml = JaxbXmlUtil.convertToXml(materialPriceReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, MaterialPriceResp.class);
    }

    public static MaterialPriceResp getMaterialPriceFromCrmToPartMall(String profilesActive, String goodsNo) throws Exception {
        String url = "";
        if ("uat".equals(profilesActive)) {
            url = TEST_GET_CRM_PRICE_URL;
        }
        if ("prd".equals(profilesActive)) {
            url = PRD_GET_CRM_PRICE_URL;
        }
        MaterialPriceReq priceReq = new MaterialPriceReq();
        MaterialPriceReq.Product product = new MaterialPriceReq.Product();
        product.setProductId(goodsNo);
        priceReq.setProduct(product);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/xml");
        post.setHeader("charset", "utf-8");
        String encoding = DatatypeConverter.printBase64Binary((byte[])"srv_pod:pod123456".getBytes(StandardCharsets.UTF_8));
        post.setHeader("Authorization", "Basic " + encoding);
        post.setEntity((HttpEntity)new StringEntity(JaxbXmlUtil.convertToXml(priceReq, "htp://sany.com/mall/008/getmaterialprice")));
        CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)post);
        HttpEntity entity = execute.getEntity();
        BufferedInputStream bis = new BufferedInputStream(entity.getContent());
        byte[] bytes = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int count = 0;
        while ((count = bis.read(bytes)) != -1) {
            bos.write(bytes, 0, count);
        }
        byte[] strByte = bos.toByteArray();
        String responseString = new String(strByte, 0, strByte.length, "utf-8");
        bos.close();
        bis.close();
        logger.info(SYS_CODE, (Object)("\u54cd\u5e94\u7ed3\u679c:" + JsonUtil.buildNormalBinder().getJsonToObject(responseString, MaterialPriceResp.class)));
        return (MaterialPriceResp)JsonUtil.buildNormalBinder().getJsonToObject(responseString, MaterialPriceResp.class);
    }

    public AcquireAgentResp acquireAgentBankInfo(AcquireAgentReq acquireAgentReq) throws Exception {
        String interfaceName = "SI_acquireagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/005/acquireagents";
        String xml = JaxbXmlUtil.convertToXml(acquireAgentReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AcquireAgentResp.class);
    }

    public ListAgentResp listAllAgent(ListAgentReq listAgentReq) throws Exception {
        String interfaceName = "SI_getlistagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/006/getlistagents";
        String xml = JaxbXmlUtil.convertToXml(listAgentReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, ListAgentResp.class);
    }

    public AreaInfoResp listAllArea(AreaInfoReq areaInfoReq) throws Exception {
        String interfaceName = "SI_getssqx_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/009/getssqx";
        String xml = JaxbXmlUtil.convertToXml(areaInfoReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AreaInfoResp.class);
    }

    public SalesOrganizationResp getSalesOrganization(SalesOrganizationReq salesOrganizationReq) throws Exception {
        String interfaceName = "SI_getsalesorganiz_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/007/getsalesorganiz";
        String xml = JaxbXmlUtil.convertToXml(salesOrganizationReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, SalesOrganizationResp.class);
    }

    private String getUrl(String interfaceName, String interfaceNameSpace) {
        String url = null;
        try {
            String encode = URLEncoder.encode(interfaceNameSpace, "UTF-8");
            url = String.format("http://poweb.sanygroup.com:8000/XISOAPAdapter/MessageServlet?senderParty=&senderService=Srv_MALL&receiverParty=&receiverService=&interface=%s&interfaceNamespace=%s", interfaceName, encode);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("SapClient.getUrl.UnsupportedEncodingException", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
        return url;
    }

    private <T> T doPost(String url, String xmlParam, Class<T> t) {
        T t2;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/xml");
        post.setHeader("charset", "utf-8");
        String encoding = DatatypeConverter.printBase64Binary((byte[])"Srv_MALL_POP:M@de&43Lr".getBytes(StandardCharsets.UTF_8));
        post.setHeader("Authorization", "Basic " + encoding);
        InputStream inputStream = null;
        try {
            post.setEntity((HttpEntity)new StringEntity(xmlParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            HttpEntity entity = result.getEntity();
            inputStream = new BufferedInputStream(entity.getContent());
            t2 = JaxbXmlUtil.convertToJavaBean(inputStream, t);
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t2;
    }

    public static String doPost(String url, String xmlParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "text/xml;charset=utf-8");
        post.setHeader("charset", "utf-8");
        String encoding = DatatypeConverter.printBase64Binary((byte[])"Srv_MALL_POP:M@de&43Lr".getBytes(StandardCharsets.UTF_8));
        post.setHeader("Authorization", "Basic " + encoding);
        try {
            post.setEntity((HttpEntity)new StringEntity(xmlParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
    }

    public static String doPostJson(String url, String jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        String encoding = DatatypeConverter.printBase64Binary((byte[])"Srv_MALL_POP:M@de&43Lr".getBytes(StandardCharsets.UTF_8));
        post.setHeader("Authorization", "Basic " + encoding);
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("**** sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
    }

    public static String doPostJsonNormal(String url, String ... params) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("charset", "utf-8");
        EntityBuilder entityBuilder = EntityBuilder.create();
        BasicNameValuePair pair = new BasicNameValuePair("userName", params[0]);
        BasicNameValuePair pair0 = new BasicNameValuePair("passWord", params[1]);
        BasicNameValuePair pair1 = new BasicNameValuePair("type", params[2]);
        HttpEntity build = entityBuilder.setParameters(new NameValuePair[]{pair, pair0, pair1}).build();
        try {
            post.setEntity(build);
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
    }

    public static String doGetJsonNormal(String url) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet get = new HttpGet(url);
        get.setHeader("charset", "utf-8");
        try {
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)get);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
    }

    public static String doPostJsonAuth(String url, String jsonParam) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        post.setHeader("authKey", "874edc52-8adf-4c1b-aa88-55882ee82569");
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                logger.error("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("sap error!" + e.getMessage());
            throw new ApiException((Throwable)e);
        }
    }

    public static String doPostJsonToken(String url, String jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        post.setHeader("TOKEN", "CF8D94B0C5E9DEF9F0140259AE86816A6BE3137A3F36C3CA1E9D52B11CEE18EB");
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                System.out.println("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            System.out.println("sap error!" + e.getMessage());
            return null;
        }
    }

    public static String doPostOperator(String url, String token, String jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        post.setHeader("TOKEN", token);
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                System.out.println("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            System.out.println("sap error!" + e.getMessage());
            return null;
        }
    }

    public static String doPostJsonTokenSMS(String url, String jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        post.setHeader("TOKEN", "5C7D58A32C3EEFDABD7383DA5955B56E44ABB58142E67279A6B7917770F7E1BB");
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                System.out.println("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            System.out.println("sap error!" + e.getMessage());
            return null;
        }
    }

    public static String doPostSMSProdAuth(String url, String jsonParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("content-type", "application/json");
        post.setHeader("charset", "utf-8");
        post.setHeader("authKey", "5c7ff564-e207-4600-895d-7d28e1277608");
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonParam));
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
            if (result == null || result.getStatusLine().getStatusCode() != 200) {
                System.out.println("sap return error result!");
                throw new RuntimeException("sap return error result!");
            }
            return EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            System.out.println("sap error!" + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(SapClient.doPostJsonToken("http://sim.sany.com.cn:90/crm-gw/CrmRfcService/rfc/excuteRfc?rfcName=ZFM_R_GET_CUSTNO_BY_TEL&skip=0&top=0", "{\n    \"IV_TEL\": \"13884047740\"\n}"));
    }
}

