/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.app.client.SapClient;
import com.yqbsoft.laser.service.ext.bus.app.domain.crm.CrmLoginReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.crm.CrmUserInfoDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AcquireAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AgentAccountReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AreaInfoReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingOrderReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingStockReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.ListAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.MaterialPriceReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.SalesOrganizationReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AcquireAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AgentAccountResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AreaInfoResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.CustomerInfoResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingOrderResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingStockResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.ListAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.MaterialPriceResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.SalesOrganizationResp;
import com.yqbsoft.laser.service.ext.bus.app.service.BusCrmService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.bus.app.util.JaxbXmlUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;

public class BusCrmServiceImpl
extends UserinfoBaseService
implements BusCrmService {
    private String SANY_CODE = "sany.BusCrmServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusCrmServiceImpl.class);
    private String ddcode = "sany.crm";
    private static final String ZZORD_SOURCE = "Z24";
    private static final String ERROR = "error";
    private static final String SUCCESS = "success";
    private static final String CRM_USER_LOGIN_URL = "http://sim.sany.com.cn:90/crm-gw/CrmUserService/getToken";
    private static final String CRM_USER_GETINFO_URL = "http://sim.sany.com.cn:90/crm-gw/CrmUserService/getUserInfo";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    @Qualifier(value="orderServiceImpl")
    private OrderBaseService orderBaseService;

    private FittingStockResp getFittingStockMock() {
        FittingStockResp mockResp = new FittingStockResp();
        FittingStockResp.Fit fit = new FittingStockResp.Fit();
        fit.setFitId("10003999");
        fit.setShopId("XXXX");
        fit.setMerchantBank("41060860898016008602");
        fit.setQuantity(784144);
        fit.setAgent("0000165534");
        fit.setAgentDes("\u6e56\u5357\u5927\u9a702333");
        mockResp.setFit(fit);
        return mockResp;
    }

    @Override
    public FittingStockResp fittingStock(FittingStockReq fittingStockReq) throws Exception {
        logger.error("sany.fittingStock.fittingStockReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)fittingStockReq));
        FittingStockResp mockResp = this.getFittingStockMock();
        return mockResp;
    }

    @Override
    public AgentAccountResp agentAccount(AgentAccountReq agentAccountReq) throws Exception {
        AgentAccountResp agentAccountResp;
        AgentAccountResp mockResp = this.getMockResp();
        if (null == agentAccountReq) {
            return mockResp;
        }
        logger.error("sany.agentAccount.agentAccountReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)agentAccountReq));
        String interfaceName = "osAgentAccount_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/004/agentaccount";
        try {
            String xml = JaxbXmlUtil.convertToXml(agentAccountReq, interfaceNameSpace);
            agentAccountResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AgentAccountResp.class);
        }
        catch (Exception e) {
            logger.error("sany.agentAccount.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == agentAccountResp) {
            return mockResp;
        }
        logger.error("sany.agentAccount.agentAccountResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)agentAccountResp));
        return agentAccountResp;
    }

    private AgentAccountResp getMockResp() {
        AgentAccountResp mockResp = new AgentAccountResp();
        AgentAccountResp.EsDetail esDetail = new AgentAccountResp.EsDetail();
        esDetail.setSybbh("CCCC");
        esDetail.setAgent("0000893149");
        esDetail.setSybbhDesc("\u6cf5\u9001\u4e8b\u4e1a\u90e8");
        esDetail.setAgentDesc("\u6e56\u5357\u667a\u6c47");
        esDetail.setBankn("41060860898016008603");
        esDetail.setB2bMerchant("41060860898016008602");
        mockResp.setEsDetail(esDetail);
        return mockResp;
    }

    @Override
    public FittingOrderResp fittingOrder(FittingOrderReq fittingOrderReq) throws Exception {
        FittingOrderResp fittingOrderResp;
        logger.error("sany.fittingOrder.fittingOrderReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)fittingOrderReq));
        FittingOrderResp mockResp = this.getFittingOrderResp();
        if (fittingOrderReq == null) {
            return mockResp;
        }
        logger.error("sany.fittingOrder.fittingOrderReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)fittingOrderReq));
        String interfaceName = "osFittingOrder_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/002/fittingorder";
        try {
            String xml = JaxbXmlUtil.convertToXml(fittingOrderReq, interfaceNameSpace);
            fittingOrderResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, FittingOrderResp.class);
        }
        catch (Exception e) {
            logger.error("sany.fittingOrder.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == fittingOrderResp) {
            return mockResp;
        }
        logger.error("sany.fittingOrder.fittingOrderResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)fittingOrderResp));
        return fittingOrderResp;
    }

    private FittingOrderResp getFittingOrderResp() {
        FittingOrderResp mockResp = new FittingOrderResp();
        mockResp.setMtype("S");
        mockResp.setMsg("5505742247");
        FittingOrderResp.ES es = new FittingOrderResp.ES();
        es.setBpName("\u5f20\u4e1c\u4f1f");
        es.setLgortAddr("\u5c71\u897f\u7701\u8fd0\u57ce\u5e02\u76d0\u6e56\u533a\u7a7a\u6e2f\u5317\u533a\u534e\u7f8e\u793c\u4eea\u5b66\u6821\u5bf9\u9762\u5929\u901a\u8f66\u68c0\u4e2d\u5fc3");
        es.setLgortResp("300000569");
        es.setTelphone("18734598196");
        mockResp.setEs(es);
        return mockResp;
    }

    @Override
    public String ocContractOrderForCrm(OcContractDomain ocContractDomain) throws Exception {
        logger.error("sany.ocContractOrder.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (ocContractDomain == null) {
            return ERROR;
        }
        FittingOrderResp fittingOrderResp = this.fittingOrder(this.makeFittingOrderReq(ocContractDomain));
        if (fittingOrderResp == null) {
            return ERROR;
        }
        if (Objects.equals("S", fittingOrderResp.getMtype())) {
            String apiCode = "oc.contract.updateContractContractNbillcode";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("contractBillcode", ocContractDomain.getContractBillcode());
            paramMap.put("tenantCode", ocContractDomain.getTenantCode());
            paramMap.put("contractNbillcode", fittingOrderResp.getMsg());
            this.internalInvoke(apiCode, paramMap);
        }
        return SUCCESS;
    }

    @Override
    public String ocRefundOrderForCrm(OcRefundDomain ocRefundDomain) throws Exception {
        logger.error("sany.ocRefundOrder.ocRefundReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (ocRefundDomain == null) {
            return ERROR;
        }
        FittingOrderResp fittingOrderResp = this.fittingOrder(this.makeFittingOrderReq(ocRefundDomain));
        return fittingOrderResp == null ? ERROR : SUCCESS;
    }

    private FittingOrderReq makeFittingOrderReq(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userinfoCode", ocRefundDomain.getMemberCcode());
        param.put("tenantCode", ocRefundDomain.getTenantCode());
        QueryResult<UmUserinfoReDomain> page = this.queryUserinfoPage(param);
        List<OcRefundGoodsDomain> goodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        FittingOrderReq fittingOrderReq = new FittingOrderReq();
        FittingOrderReq.OrderDetail orderDetail = new FittingOrderReq.OrderDetail();
        ArrayList<FittingOrderReq.Item> items = new ArrayList<FittingOrderReq.Item>();
        goodsList.forEach(goods -> {
            FittingOrderReq.Item item = new FittingOrderReq.Item();
            item.setFitId(goods.getSkuNo());
            item.setOrdQty(goods.getGoodsNum().intValue());
            item.setPayAmount(goods.getPricesetNprice());
            items.add(item);
        });
        String apiCode = "oc.refund.getRefund";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("refundId", ocRefundDomain.getRefundId());
        OcRefundReDomain refundReDomain = (OcRefundReDomain)this.getForObject(apiCode, OcRefundReDomain.class, paramMap);
        if (refundReDomain == null) {
            throw new ApiException("\u9000\u5355\u4e3a\u7a7a");
        }
        Integer dataState = refundReDomain.getDataState();
        orderDetail.setOrdType("02");
        orderDetail.setOrdStatus("01");
        if (Objects.equals(dataState, "2")) {
            orderDetail.setOrdType("02");
            orderDetail.setOrdStatus("02");
        } else if (Objects.equals(dataState, "4")) {
            orderDetail.setOrdType("02");
            orderDetail.setOrdStatus("04");
        }
        OcContractReDomain order = this.orderBaseService.getOrderByCode(ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode());
        orderDetail.setShopOrderId(ocRefundDomain.getRefundCode());
        orderDetail.setZzordSource(ZZORD_SOURCE);
        orderDetail.setRefOrdId(ocRefundDomain.getContractBillcode());
        orderDetail.setOrdAmount(order.getContractInmoney());
        orderDetail.setPayAmount(order.getDataBmoney());
        orderDetail.setShipAmount(ocRefundDomain.getGoodsLogmoney());
        if (page != null && !CollectionUtils.isEmpty((Collection)page.getList())) {
            orderDetail.setShopId(((UmUserinfoReDomain)page.getList().get(0)).getUserinfoOcode());
        }
        orderDetail.setDelivery(ocRefundDomain.getContractPumode());
        orderDetail.setRecAddress(ocRefundDomain.getGoodsReceiptArrdess());
        orderDetail.setRecName(ocRefundDomain.getGoodsReceiptMem());
        orderDetail.setContactInfo(ocRefundDomain.getGoodsReceiptPhone());
        orderDetail.setBuyerMsg(ocRefundDomain.getContractRemark());
        fittingOrderReq.setOrderDetail(orderDetail);
        fittingOrderReq.setItemList(items);
        return fittingOrderReq;
    }

    private FittingOrderReq makeFittingOrderReq(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userinfoCode", ocContractDomain.getMemberCcode());
        param.put("tenantCode", ocContractDomain.getTenantCode());
        QueryResult<UmUserinfoReDomain> page = this.queryUserinfoPage(param);
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        FittingOrderReq fittingOrderReq = new FittingOrderReq();
        FittingOrderReq.OrderDetail orderDetail = new FittingOrderReq.OrderDetail();
        ArrayList<FittingOrderReq.Item> items = new ArrayList<FittingOrderReq.Item>();
        goodsList.forEach(goods -> {
            FittingOrderReq.Item item = new FittingOrderReq.Item();
            item.setFitId(goods.getSkuNo());
            item.setOrdQty(goods.getGoodsNum().intValue());
            item.setPayAmount(goods.getPricesetNprice());
            items.add(item);
        });
        orderDetail.setOrdType("01");
        orderDetail.setOrdStatus("01");
        orderDetail.setShopOrderId(ocContractDomain.getContractBillcode());
        orderDetail.setZzordSource(ZZORD_SOURCE);
        orderDetail.setOrdAmount(ocContractDomain.getContractInmoney());
        orderDetail.setPayAmount(ocContractDomain.getDataBmoney());
        orderDetail.setShipAmount(ocContractDomain.getGoodsLogmoney());
        if (page != null && !CollectionUtils.isEmpty((Collection)page.getList())) {
            orderDetail.setShopId(((UmUserinfoReDomain)page.getList().get(0)).getUserinfoOcode());
        }
        orderDetail.setInvoice(ocContractDomain.getContractInvoice());
        orderDetail.setDelivery(ocContractDomain.getContractPumode());
        orderDetail.setRecAddress(ocContractDomain.getGoodsReceiptArrdess());
        orderDetail.setRecName(ocContractDomain.getGoodsReceiptMem());
        orderDetail.setContactInfo(ocContractDomain.getGoodsReceiptPhone());
        orderDetail.setBuyerMsg(ocContractDomain.getContractRemark());
        fittingOrderReq.setOrderDetail(orderDetail);
        fittingOrderReq.setItemList(items);
        return fittingOrderReq;
    }

    @Override
    public MaterialPriceResp getMaterialPrice(MaterialPriceReq materialPriceReq) throws Exception {
        MaterialPriceResp materialPriceResp;
        MaterialPriceResp mockResp = this.getMaterialPriceResp();
        if (materialPriceReq == null) {
            return mockResp;
        }
        logger.error("sany.getMaterialPrice.materialPriceReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)materialPriceReq));
        String interfaceName = "SI_getmaterialprice_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/008/getmaterialprice";
        try {
            String xml = JaxbXmlUtil.convertToXml(materialPriceReq, interfaceNameSpace);
            materialPriceResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, MaterialPriceResp.class);
        }
        catch (Exception e) {
            logger.error("sany.getMaterialPrice.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == materialPriceResp) {
            return mockResp;
        }
        logger.error("sany.getMaterialPrice.materialPriceResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)materialPriceResp));
        return materialPriceResp;
    }

    private MaterialPriceResp getMaterialPriceResp() {
        MaterialPriceResp mockResp = new MaterialPriceResp();
        MaterialPriceResp.ProductPrice productPrice = new MaterialPriceResp.ProductPrice();
        productPrice.setProductId("0000000000000000000000000000000000100001");
        productPrice.setShortText("\u901a\u6986\u6d4b\u8bd5\u6210\u54c1T-1");
        productPrice.setPrice(new BigDecimal(0.0));
        mockResp.setProductPrice(productPrice);
        return mockResp;
    }

    @Override
    public AcquireAgentResp acquireAgentBankInfo(AcquireAgentReq acquireAgentReq) throws Exception {
        AcquireAgentResp acquireAgentResp;
        AcquireAgentResp mockResp = this.getAcquireAgentResp();
        if (acquireAgentReq == null) {
            return mockResp;
        }
        logger.error("sany.acquireAgentBankInfo.acquireAgentReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)acquireAgentReq));
        String interfaceName = "SI_acquireagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/005/acquireagents";
        try {
            String xml = JaxbXmlUtil.convertToXml(acquireAgentReq, interfaceNameSpace);
            acquireAgentResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AcquireAgentResp.class);
        }
        catch (Exception e) {
            logger.error("sany.acquireAgentBankInfo.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == acquireAgentResp) {
            return mockResp;
        }
        logger.error("sany.acquireAgentBankInfo.acquireAgentResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)acquireAgentResp));
        return acquireAgentResp;
    }

    private AcquireAgentResp getAcquireAgentResp() {
        AcquireAgentResp mockResp = new AcquireAgentResp();
        AcquireAgentResp.AgentInfo agentInfo = new AcquireAgentResp.AgentInfo();
        agentInfo.setShopId("XXXX");
        agentInfo.setPlant("0300000201");
        agentInfo.setAgent("0000165534");
        agentInfo.setMerchant("41060860898016008602");
        agentInfo.setSalesModel("\u7ecf\u9500");
        agentInfo.setSalesOrg("O 50000842");
        agentInfo.setLgort("0688");
        mockResp.setAgentInfo(agentInfo);
        return mockResp;
    }

    @Override
    public ListAgentResp listAllAgent(ListAgentReq listAgentReq) throws Exception {
        ListAgentResp listAgentResp;
        ListAgentResp mockResp = this.getListAgentResp();
        if (listAgentReq == null) {
            return mockResp;
        }
        logger.error("sany.listAllAgent.listAgentReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)listAgentReq));
        String interfaceName = "SI_getlistagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/006/getlistagents";
        try {
            String xml = JaxbXmlUtil.convertToXml(listAgentReq, interfaceNameSpace);
            listAgentResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, ListAgentResp.class);
        }
        catch (Exception e) {
            logger.error("sany.listAllAgent.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == listAgentResp) {
            return mockResp;
        }
        logger.error("sany.listAllAgent.listAgentResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)listAgentResp));
        return listAgentResp;
    }

    private ListAgentResp getListAgentResp() {
        ListAgentResp mockResp = new ListAgentResp();
        ArrayList<ListAgentResp.Agent> agents = new ArrayList<ListAgentResp.Agent>();
        ListAgentResp.Agent agent01 = new ListAgentResp.Agent();
        ListAgentResp.Agent agent02 = new ListAgentResp.Agent();
        agent01.setTabName("ZSRV_XZQYPZB");
        agent02.setTabName("ZSRV_XZQYPZB");
        agent01.setNumber("11");
        agent02.setNumber("12");
        agent01.setPlantNumber("0300000201");
        agent02.setPlantNumber("0300000201");
        agent01.setPlantName("\u91cd\u8d77\u4e8b\u4e1a\u90e8");
        agent02.setPlantName("\u91cd\u8d77\u4e8b\u4e1a\u90e8");
        agent01.setAgentNumber("0100019773");
        agent02.setAgentNumber("0100019773");
        agent01.setAgentName("\u76f4\u8425");
        agent02.setAgentName("\u76f4\u8425");
        agent01.setStoreNumber("8000");
        agent02.setStoreNumber("8000");
        agent01.setStoreName("\u91cd\u8d77\u914d\u4ef6\u5e93");
        agent02.setStoreName("\u91cd\u8d77\u914d\u4ef6\u5e93");
        agent01.setProvinceNumber("11");
        agent02.setProvinceNumber("11");
        agent01.setProvince("\u5317\u4eac");
        agent02.setProvince("\u5317\u4eac");
        agent01.setCityNumber("1101");
        agent02.setCityNumber("1101");
        agent01.setCity("\u76f4\u8f96\u5e02");
        agent02.setCity("\u76f4\u8f96\u5e02");
        agent01.setB2bAgentNumber("41060860898016008602");
        agent02.setB2bAgentNumber("41060860898016008603");
        agent01.setShopId("ZZZZ");
        agent02.setShopId("YYYY");
        agent01.setShopName("\u5c65\u5e26\u540a\u76f4\u8425\u5e97");
        agent02.setShopName("\u8d77\u91cd\u673a\u76f4\u8425\u5e97");
        agents.add(agent01);
        agents.add(agent02);
        mockResp.setAgentList(agents);
        return mockResp;
    }

    @Override
    public AreaInfoResp listAllArea(AreaInfoReq areaInfoReq) throws Exception {
        AreaInfoResp areaInfoResp;
        AreaInfoResp mockResp = this.getAreaInfoResp();
        if (areaInfoReq == null) {
            return mockResp;
        }
        logger.error("sany.listAllArea.areaInfoReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)areaInfoReq));
        String interfaceName = "SI_getssqx_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/009/getssqx";
        try {
            String xml = JaxbXmlUtil.convertToXml(areaInfoReq, interfaceNameSpace);
            areaInfoResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AreaInfoResp.class);
        }
        catch (Exception e) {
            logger.error("sany.listAllArea.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == areaInfoResp) {
            return mockResp;
        }
        logger.error("sany.listAllArea.areaInfoResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)areaInfoResp));
        return areaInfoResp;
    }

    private AreaInfoResp getAreaInfoResp() {
        AreaInfoResp mockResp = new AreaInfoResp();
        ArrayList<AreaInfoResp.AreaInfo> areaInfos = new ArrayList<AreaInfoResp.AreaInfo>();
        AreaInfoResp.AreaInfo areaInfo01 = new AreaInfoResp.AreaInfo();
        AreaInfoResp.AreaInfo areaInfo02 = new AreaInfoResp.AreaInfo();
        areaInfo01.setId("000000000011");
        areaInfo02.setId("000000000012");
        areaInfo01.setParentId("000000000000");
        areaInfo02.setParentId("000000000000");
        areaInfo01.setAreaName("\u5317\u4eac\u5e02");
        areaInfo02.setAreaName("\u5929\u6d25\u5e02");
        areaInfo01.setAreaLevel("1");
        areaInfo02.setAreaLevel("1");
        areaInfo01.setProvince("010");
        areaInfo02.setProvince("030");
        areaInfo01.setProvinceShort("BJ");
        areaInfo02.setProvinceShort("TJ");
        areaInfos.add(areaInfo01);
        areaInfos.add(areaInfo02);
        mockResp.setAreaInfoList(areaInfos);
        return mockResp;
    }

    @Override
    public SalesOrganizationResp getSalesOrganization(SalesOrganizationReq salesOrganizationReq) throws Exception {
        SalesOrganizationResp salesOrganizationResp;
        SalesOrganizationResp mockResp = this.getSalesOrganizationResp();
        if (salesOrganizationReq == null) {
            return mockResp;
        }
        logger.error("sany.getSalesOrganization.salesOrganizationReq", (Object)JsonUtil.buildNormalBinder().toJson((Object)salesOrganizationReq));
        String interfaceName = "SI_getsalesorganiz_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/007/getsalesorganiz";
        try {
            String xml = JaxbXmlUtil.convertToXml(salesOrganizationReq, interfaceNameSpace);
            salesOrganizationResp = this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, SalesOrganizationResp.class);
        }
        catch (Exception e) {
            logger.error("sany.getSalesOrganization.Exception", (Throwable)e);
            return mockResp;
        }
        if (null == salesOrganizationResp) {
            return mockResp;
        }
        logger.error("sany.getSalesOrganization.salesOrganizationResp", (Object)JsonUtil.buildNormalBinder().toJson((Object)salesOrganizationResp));
        return salesOrganizationResp;
    }

    private SalesOrganizationResp getSalesOrganizationResp() {
        SalesOrganizationResp mockResp = new SalesOrganizationResp();
        ArrayList<SalesOrganizationResp.SalesOrganization> list = new ArrayList<SalesOrganizationResp.SalesOrganization>();
        SalesOrganizationResp.SalesOrganization org01 = new SalesOrganizationResp.SalesOrganization();
        SalesOrganizationResp.SalesOrganization org02 = new SalesOrganizationResp.SalesOrganization();
        SalesOrganizationResp.SalesOrganization org03 = new SalesOrganizationResp.SalesOrganization();
        org01.setSalesOrgCodOe("O 50000842");
        org01.setSalesOrgName("\u5b81\u4e61\u8d77\u91cd\u673a\u9500\u552e\u7ec4\u7ec7");
        org02.setSalesOrgCodOe("O 50000864");
        org02.setSalesOrgName("\u6d59\u6c5f\u4e09\u4e00\u88c5\u5907\u9500\u552e\u7ec4\u7ec7");
        org03.setSalesOrgCodOe("O 50003943");
        org03.setSalesOrgName("\u6d59\u6c5f\u4e09\u4e00\u94f8\u9020\u9500\u552e\u7ec4\u7ec7");
        list.add(org01);
        list.add(org02);
        list.add(org03);
        mockResp.setSalesOrganizationList(list);
        return mockResp;
    }

    @Override
    public CustomerInfoResp getCustomerInfo(String phone) throws Exception {
        if (StringUtils.isBlank((String)phone)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("IV_TEL", phone);
        JsonUtil jsonUtil = JsonUtil.buildNormalBinder();
        String result = SapClient.doPostJsonToken("http://sim.sany.com.cn:90/crm-gw/CrmRfcService/rfc/excuteRfc?rfcName=ZFM_R_GET_CUSTNO_BY_TEL&skip=0&top=0", jsonUtil.toJson(map));
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return (CustomerInfoResp)JSON.parseObject((String)result, CustomerInfoResp.class);
    }

    @Override
    public CrmLoginReDomain crmUserLogin(String userName, String passWord, Integer type) throws Exception {
        if (StringUtils.isBlank((String)userName) || StringUtils.isBlank((String)passWord)) {
            return null;
        }
        if (StringUtils.isBlank((Integer)type)) {
            type = 1;
        }
        try {
            String result = SapClient.doPostJsonNormal(CRM_USER_LOGIN_URL, userName, passWord, String.valueOf(type));
            if (StringUtils.isBlank((String)result)) {
                return null;
            }
            return (CrmLoginReDomain)JSON.parseObject((String)result, CrmLoginReDomain.class);
        }
        catch (Exception e) {
            logger.error("sany.crmUserLogin.Exception", (Throwable)e);
            throw new ApiException("crm\u7528\u6237\u6821\u9a8c\u5931\u8d25");
        }
    }

    @Override
    public CrmUserInfoDomain queryCrmUserInfo(String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        try {
            String result = SapClient.doGetJsonNormal("http://sim.sany.com.cn:90/crm-gw/CrmUserService/getUserInfo?username=" + username);
            if (StringUtils.isBlank((String)result)) {
                return null;
            }
            return (CrmUserInfoDomain)JSON.parseObject((String)result, CrmUserInfoDomain.class);
        }
        catch (ApiException e) {
            logger.error("sany.queryCrmUserInfo.Exception", (Throwable)e);
            throw new ApiException("\u83b7\u53d6crm\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String getUrl(String interfaceName, String interfaceNameSpace) {
        String url = null;
        try {
            String encode = URLEncoder.encode(interfaceNameSpace, "UTF-8");
            url = String.format("http://podev01v-ap.sanygroup.com:50000/XISOAPAdapter/MessageServlet?senderParty=&senderService=Srv_MALL&receiverParty=&receiverService=&interface=%s&interfaceNamespace=%s", interfaceName, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doPost(String url, String xmlParam, Class<T> t) {
        block13: {
            T t2;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(url);
            post.setHeader("content-type", "application/xml");
            post.setHeader("charset", "utf-8");
            String encoding = DatatypeConverter.printBase64Binary((byte[])"srv_pod:pod123456".getBytes(StandardCharsets.UTF_8));
            post.setHeader("Authorization", "Basic " + encoding);
            InputStream inputStream = null;
            try {
                post.setEntity((HttpEntity)new StringEntity(xmlParam));
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
                if (result == null || result.getStatusLine().getStatusCode() != 200) {
                    System.out.println("sap return error result!");
                    throw new RuntimeException("sap return error result!");
                }
                HttpEntity entity = result.getEntity();
                inputStream = new BufferedInputStream(entity.getContent());
                t2 = JaxbXmlUtil.convertToJavaBean(inputStream, t);
            }
            catch (Exception e) {
                System.out.println("sap error!" + e.getMessage());
                break block13;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return t2;
        }
        return null;
    }
}

