/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.app.client.SapClient;
import com.yqbsoft.laser.service.ext.bus.app.common.RsDeviceInfo;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.EquipmentDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.EquipmentMaterialReDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.sis.MaterialDomain;
import com.yqbsoft.laser.service.ext.bus.app.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.app.service.BusSisService;
import com.yqbsoft.laser.service.ext.bus.app.supbase.BusBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class BusSisServiceImpl
extends BusBaseService
implements BusSisService {
    private String SANY_CODE = "sany.BusSisServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusSisServiceImpl.class);
    private String ddcode = "sany.sis";
    private static final String URL = "http://10.0.13.66:50000/RESTAdapter/public/047/equipmentOSBO";
    private static final String TENANTCODE = "591197526966321228";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public EquipmentMaterialReDomain queryMaterialAndEquipmentInfo(String equipmentCode) throws Exception {
        String result;
        EquipmentMaterialReDomain mockResp = this.getEquipmentMaterialReDomain();
        if (StringUtils.isBlank((String)equipmentCode)) {
            return mockResp;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("equipmentCode", equipmentCode);
        JsonUtil jsonUtil = JsonUtil.buildNormalBinder();
        try {
            result = SapClient.doPostJson(URL, jsonUtil.toJson(param));
        }
        catch (Exception e) {
            logger.error("sany.queryMaterialAndEquipmentInfo.Exception", (Throwable)e);
            return mockResp;
        }
        if (StringUtils.isBlank((String)result)) {
            return mockResp;
        }
        return (EquipmentMaterialReDomain)jsonUtil.getJsonToObject(result, EquipmentMaterialReDomain.class);
    }

    private EquipmentMaterialReDomain getEquipmentMaterialReDomain() {
        EquipmentMaterialReDomain mockResp = new EquipmentMaterialReDomain();
        EquipmentDomain equipmentDomain = new EquipmentDomain();
        MaterialDomain materialDomain = new MaterialDomain();
        ArrayList<MaterialDomain> list = new ArrayList<MaterialDomain>();
        list.add(materialDomain);
        materialDomain.setId("1210001492087013377");
        materialDomain.setParentPartCode("60320153");
        materialDomain.setParentPartName("\u6392\u6c14\u7ba16WG1X");
        materialDomain.setPartCode("60320028");
        materialDomain.setPartName("\u5e9f\u6c14\u518d\u5faa\u73af\u51b7\u5374\u5668116127-0224");
        materialDomain.setEnPartName("Cooler; egr");
        materialDomain.setComponentsNum(1);
        materialDomain.setBelongLevel(7);
        materialDomain.setCreateTime(new Date());
        materialDomain.setUpdateTime(new Date());
        equipmentDomain.setEquCode("SR285CBK12728");
        equipmentDomain.setDeliveryDate(new Date());
        equipmentDomain.setMatnr("13564694");
        equipmentDomain.setProductModel("SR285RC10\u65cb\u6316\u94bb\u673a\u4e3b\u4f53SR285RC10.0");
        equipmentDomain.setMaterials(list);
        mockResp.setCode("3");
        mockResp.setMessage("mock data");
        mockResp.setData(equipmentDomain);
        return mockResp;
    }

    @Override
    public void updateMaterialAndEquipment() throws Exception {
        String queryDeviceInfoPage = "rs.rsDeviceInfo.queryDeviceInfoPage";
        String deleteDeviceInfoByType = "rs.rsDeviceInfo.deleteDeviceInfoByType";
        HashMap paramMap0 = new HashMap();
        HashMap<String, Integer> map0 = new HashMap<String, Integer>();
        map0.put("deviceType", 1);
        paramMap0.put("map", map0);
        QueryResult queryResult = this.sendReSupObject(queryDeviceInfoPage, paramMap0, RsDeviceInfo.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        String apiCode = "oc.contractEngine.sendContractNext";
        HashMap<String, Object> paramMap1 = new HashMap<String, Object>();
        paramMap1.put("tenantCode", TENANTCODE);
        paramMap1.put("deviceType", 2);
        this.internalInvoke(apiCode, paramMap1);
    }
}

