/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.client;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AcquireAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AgentAccountReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.AreaInfoReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingOrderReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.FittingStockReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.ListAgentReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.MaterialPriceReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.request.crm.SalesOrganizationReq;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AcquireAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AgentAccountResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.AreaInfoResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingOrderResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.FittingStockResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.ListAgentResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.MaterialPriceResp;
import com.yqbsoft.laser.service.ext.bus.app.facade.response.crm.SalesOrganizationResp;
import com.yqbsoft.laser.service.ext.bus.app.util.JaxbXmlUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class SapClient {
    public FittingStockResp fittingStock(FittingStockReq fittingStockReq) throws Exception {
        String interfaceName = "osFittingStock_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/001/fittingstock";
        String xml = JaxbXmlUtil.convertToXml(fittingStockReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, FittingStockResp.class);
    }

    public AgentAccountResp agentAccount(AgentAccountReq agentAccountReq) throws Exception {
        String interfaceName = "osAgentAccount_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/004/agentaccount";
        String xml = JaxbXmlUtil.convertToXml(agentAccountReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AgentAccountResp.class);
    }

    public FittingOrderResp fittingOrder(FittingOrderReq fittingOrderReq) throws Exception {
        String interfaceName = "osFittingOrder_MALL";
        String interfaceNameSpace = "htp://sany.com/mall/002/fittingorder";
        String xml = JaxbXmlUtil.convertToXml(fittingOrderReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, FittingOrderResp.class);
    }

    public MaterialPriceResp getMaterialPrice(MaterialPriceReq materialPriceReq) throws Exception {
        String interfaceName = "SI_getmaterialprice_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/008/getmaterialprice";
        String xml = JaxbXmlUtil.convertToXml(materialPriceReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, MaterialPriceResp.class);
    }

    public AcquireAgentResp acquireAgentBankInfo(AcquireAgentReq acquireAgentReq) throws Exception {
        String interfaceName = "SI_acquireagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/005/acquireagents";
        String xml = JaxbXmlUtil.convertToXml(acquireAgentReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AcquireAgentResp.class);
    }

    public ListAgentResp listAllAgent(ListAgentReq listAgentReq) throws Exception {
        String interfaceName = "SI_getlistagents_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/006/getlistagents";
        String xml = JaxbXmlUtil.convertToXml(listAgentReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, ListAgentResp.class);
    }

    public AreaInfoResp listAllArea(AreaInfoReq areaInfoReq) throws Exception {
        String interfaceName = "SI_getssqx_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/009/getssqx";
        String xml = JaxbXmlUtil.convertToXml(areaInfoReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, AreaInfoResp.class);
    }

    public SalesOrganizationResp getSalesOrganization(SalesOrganizationReq salesOrganizationReq) throws Exception {
        String interfaceName = "SI_getsalesorganiz_MALL_OB";
        String interfaceNameSpace = "htp://sany.com/mall/007/getsalesorganiz";
        String xml = JaxbXmlUtil.convertToXml(salesOrganizationReq, interfaceNameSpace);
        return this.doPost(this.getUrl(interfaceName, interfaceNameSpace), xml, SalesOrganizationResp.class);
    }

    private String getUrl(String interfaceName, String interfaceNameSpace) {
        String url = null;
        try {
            String encode = URLEncoder.encode(interfaceNameSpace, "UTF-8");
            url = String.format("http://podev01v-ap.sanygroup.com:50000/XISOAPAdapter/MessageServlet?senderParty=&senderService=Srv_MALL&receiverParty=&receiverService=&interface=%s&interfaceNamespace=%s", interfaceName, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doPost(String url, String xmlParam, Class<T> t) {
        block13: {
            T t2;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(url);
            post.setHeader("content-type", "application/xml");
            post.setHeader("charset", "utf-8");
            String encoding = DatatypeConverter.printBase64Binary((byte[])"srv_pod:pod123456".getBytes(StandardCharsets.UTF_8));
            post.setHeader("Authorization", "Basic " + encoding);
            InputStream inputStream = null;
            try {
                post.setEntity((HttpEntity)new StringEntity(xmlParam));
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
                if (result == null || result.getStatusLine().getStatusCode() != 200) {
                    System.out.println("sap return error result!");
                    throw new RuntimeException("sap return error result!");
                }
                HttpEntity entity = result.getEntity();
                inputStream = new BufferedInputStream(entity.getContent());
                t2 = JaxbXmlUtil.convertToJavaBean(inputStream, t);
            }
            catch (Exception e) {
                System.out.println("sap error!" + e.getMessage());
                break block13;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return t2;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        SapClient sapClient = new SapClient();
        FittingStockReq.Fit fit = new FittingStockReq.Fit();
        fit.setFitId("123");
        fit.setShopId("321");
        fit.setProvinceCode("123");
        fit.setCityCode("123");
        FittingStockReq fittingStockReq = new FittingStockReq();
        fittingStockReq.setFit(fit);
        FittingStockResp fittingStock = sapClient.fittingStock(fittingStockReq);
        System.out.println(JSON.toJSONString((Object)fittingStock));
        AgentAccountReq req = new AgentAccountReq();
        req.setRegionId("011");
        req.setCityId("000000001101");
        req.setCategoryId("0000100001");
        req.setSybbh("CCCC");
        AgentAccountResp agentAccountResp = sapClient.agentAccount(req);
        System.out.println(JSON.toJSONString((Object)agentAccountResp));
        FittingOrderReq.OrderDetail orderDetail = new FittingOrderReq.OrderDetail();
        orderDetail.setOrdType("01");
        orderDetail.setShopOrderId("3971592000092946");
        orderDetail.setOrdStatus("01");
        orderDetail.setOrdAmount(new BigDecimal("170.00"));
        orderDetail.setPayAmount(new BigDecimal("170.00"));
        orderDetail.setShipAmount(new BigDecimal("0.00"));
        orderDetail.setShopId("XXXX");
        orderDetail.setCustNo("0000000159");
        orderDetail.setRecProvince("11");
        orderDetail.setRecCity("1101");
        orderDetail.setRecAddress("\u5317\u4eac\u5e02\u4e1c\u57ce\u533a01\u53f7");
        orderDetail.setRecName("allen");
        orderDetail.setContactInfo("15623173579");
        orderDetail.setZzflowNumber("3971592000092943");
        orderDetail.setZzordSource("Z01");
        FittingOrderReq.Item item = new FittingOrderReq.Item();
        item.setFitId("10003999");
        item.setOrdQty(1);
        item.setPayAmount(new BigDecimal("170.00"));
        FittingOrderReq fittingOrderReq = new FittingOrderReq();
        fittingOrderReq.setOrderDetail(orderDetail);
        fittingOrderReq.setItemList(Collections.singletonList(item));
        FittingOrderResp fittingOrderResp = sapClient.fittingOrder(fittingOrderReq);
        System.out.println(JSON.toJSONString((Object)fittingOrderResp));
        MaterialPriceReq.Product product = new MaterialPriceReq.Product();
        product.setProductId("0000100001");
        MaterialPriceReq materialPriceReq = new MaterialPriceReq();
        materialPriceReq.setProduct(product);
        materialPriceReq.setSalesOrg("");
        MaterialPriceResp materialPrice = sapClient.getMaterialPrice(materialPriceReq);
        System.out.println(JSON.toJSONString((Object)materialPrice));
        AcquireAgentReq acquireAgentReq = new AcquireAgentReq();
        acquireAgentReq.setCityCode("1101");
        acquireAgentReq.setProvinceCode("11");
        acquireAgentReq.setShopId("XXXX");
        AcquireAgentResp acquireAgentResp = sapClient.acquireAgentBankInfo(acquireAgentReq);
        System.out.println(JSON.toJSONString((Object)acquireAgentResp));
        ListAgentResp listAgentResp = sapClient.listAllAgent(new ListAgentReq());
        System.out.println(JSON.toJSONString((Object)listAgentResp));
        AreaInfoResp areaInfoResp = sapClient.listAllArea(new AreaInfoReq());
        System.out.println("++++++++++++++++++++++++++++++++++++++++++");
        System.out.println("++++++++++++++++++++++++++++++++++++++++++");
        SalesOrganizationReq salesOrganizationReq = new SalesOrganizationReq();
        salesOrganizationReq.setPlantCode("0300000201");
        SalesOrganizationResp salesOrganization = sapClient.getSalesOrganization(salesOrganizationReq);
        System.out.println(JSON.toJSONString((Object)salesOrganization));
    }
}

