/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.api.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.ext.bus.app.ComConstants;
import com.yqbsoft.laser.service.ext.bus.app.api.ExCrmService;
import com.yqbsoft.laser.service.ext.bus.app.domain.crm.OrderAfterSalesNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.crm.OrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.domain.crm.SendOrderNotifyDomain;
import com.yqbsoft.laser.service.ext.bus.app.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExCrmServiceImpl
extends OrderBaseService
implements ExCrmService {
    private static final SupperLogUtil logger = new SupperLogUtil(ExCrmServiceImpl.class);
    private static final String TENANTCODE = "591197526966321228";

    @Override
    public Map<String, Object> sendOrderNotify(SendOrderNotifyDomain sendOrderNotifyDomain) {
        if (null == sendOrderNotifyDomain) {
            return this.makeErrorReturn(ComConstants.ERROR_CODE_01, "param is null");
        }
        logger.error("sany.sendOrderNotify.sendOrderNotifyDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)sendOrderNotifyDomain));
        return this.makeSuccessReturnMap(sendOrderNotifyDomain);
    }

    @Override
    public Map<String, Object> orderAfterSalesNotify(OrderAfterSalesNotifyDomain orderAfterSalesNotifyDomain) {
        if (null == orderAfterSalesNotifyDomain) {
            return this.makeErrorReturn(ComConstants.ERROR_CODE_01, "param is null");
        }
        logger.error("sany.orderAfterSalesNotify.orderAfterSalesNotifyDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)orderAfterSalesNotifyDomain));
        return this.makeSuccessReturnMap(orderAfterSalesNotifyDomain);
    }

    @Override
    public Map<String, Object> orderNotify(OrderNotifyDomain orderNotifyDomain) {
        logger.error("sany.orderNotify.orderNotifyDomain", (Object)JSON.toJSONString((Object)orderNotifyDomain));
        if (null == orderNotifyDomain) {
            return this.makeErrorReturn(ComConstants.ERROR_CODE_01, "param is null");
        }
        JsonUtil jsonUtil = JsonUtil.buildNormalBinder();
        logger.error("sany.orderNotify.orderNotifyDomain", (Object)jsonUtil.toJson((Object)orderNotifyDomain));
        String method = orderNotifyDomain.getMethod();
        String token = orderNotifyDomain.getToken();
        if (StringUtils.isBlank((String)method) || StringUtils.isBlank((String)orderNotifyDomain.getModule())) {
            return this.makeErrorReturn(ComConstants.ERROR_CODE_02, "module or method does not exist");
        }
        if (StringUtils.isBlank((String)token)) {
            return this.makeErrorReturn(ComConstants.ERROR_CODE_03, "token is null");
        }
        Map<String, Object> params = orderNotifyDomain.getParams();
        String jsonParam = jsonUtil.toJson(params);
        if (method.equals("delivery")) {
            SendOrderNotifyDomain sendOrderNotifyDomain = (SendOrderNotifyDomain)jsonUtil.getJsonToObject(jsonParam, SendOrderNotifyDomain.class);
            logger.error("sany.orderNotify.sendOrderNotifyDomain", (Object)jsonUtil.toJson((Object)sendOrderNotifyDomain));
            if (sendOrderNotifyDomain == null) {
                return this.makeErrorReturn(ComConstants.ERROR_CODE_16, "sendOrderNotifyDomain is null");
            }
            String apiCode = "oc.contractEngine.sendContractNext";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expressCode", sendOrderNotifyDomain.getLogisticsCompany());
            map.put("expressName", sendOrderNotifyDomain.getLogisticsList());
            map.put("packageBillno", sendOrderNotifyDomain.getDeliveryId());
            paramMap.put("contractBillcode", sendOrderNotifyDomain.getOrderId());
            paramMap.put("tenantCode", TENANTCODE);
            paramMap.put("map", map);
            try {
                this.internalInvoke(apiCode, paramMap);
            }
            catch (Exception e) {
                logger.error("sany.orderNotify.Exception", (Throwable)e);
                return this.makeErrorReturn(ComConstants.ERROR_CODE_18, e.getMessage());
            }
        }
        if (method.equals("aftersales")) {
            OrderAfterSalesNotifyDomain orderAfterSalesNotifyDomain = (OrderAfterSalesNotifyDomain)jsonUtil.getJsonToObject(jsonParam, OrderAfterSalesNotifyDomain.class);
            logger.error("sany.orderNotify.orderAfterSalesNotifyDomain", (Object)jsonUtil.toJson((Object)orderAfterSalesNotifyDomain));
            if (orderAfterSalesNotifyDomain == null) {
                return this.makeErrorReturn(ComConstants.ERROR_CODE_16, "orderAfterSalesNotifyDomain is null");
            }
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"591197526966321228-refund-refund_audit_sys");
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-refund-refund_audit_sys");
            }
            String apiCode = "oc.refundEngine.sendRefundNext";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("refundCode", orderAfterSalesNotifyDomain.getAftersalesBn());
            paramMap.put("tenantCode", TENANTCODE);
            try {
                if (StringUtils.isBlank((String)httpPath) || Objects.equals(httpPath, "1")) {
                    this.internalInvoke(apiCode, paramMap);
                }
                this.internalInvoke(apiCode, paramMap);
            }
            catch (Exception e) {
                logger.error("sany.orderNotify.Exception", (Throwable)e);
                return this.makeErrorReturn(ComConstants.ERROR_CODE_23, e.getMessage());
            }
        }
        return this.makeSuccessReturnMap(orderNotifyDomain);
    }

    protected Map<String, Object> makeErrorReturn(Object errcode, String errmsg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errcode", errcode);
        map.put("errmsg", errmsg);
        return map;
    }

    protected Map<String, Object> makeSuccessReturnMap(Object dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", ComConstants.SUCCESS_CODE);
        map.put("success", true);
        map.put("dataObj", dataObj);
        map.put("msg", "\u6210\u529f");
        return map;
    }
}

