/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.app.util;

import com.yqbsoft.laser.service.ext.bus.app.client.SapClient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSUtil {
    private static final Logger logger = LoggerFactory.getLogger(SMSUtil.class);
    private static final String SMS_SEND_URL = "http://nsms.sany.com.cn/sms/services/SmsNewOperatoraddsubCode?wsdl";
    public static final String CHINA_REGEX_EXP = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[0-9])|(18[0-9])|(19[1,8,9]))\\d{8}$";
    public static final String HK_REGEX_EXP = "^(5|6|8|9)\\d{7}$";

    public static String SendSms(String sendUrl, String content, String phoneNumber) {
        String result = "";
        String contentType = "text/xml;charset=utf-8";
        StringBuffer xMLcontent = SMSUtil.setSmsInfo(phoneNumber, content);
        try {
            String res = SapClient.doPost(sendUrl, xMLcontent.toString());
            res = StringEscapeUtils.unescapeXml((String)res);
            if (!StringUtils.isEmpty((String)res) && res.contains("smsID")) {
                result = res.substring(res.indexOf("<smsID>"), res.indexOf("</smsID>")).substring("<smsID>".length());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u77ed\u4fe1\u63a8\u9001\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        logger.info("sms result:{}", (Object)result);
        return result;
    }

    public static String SendSms(String content, String phoneNumber) {
        String result = "";
        String contentType = "text/xml;charset=utf-8";
        StringBuffer xMLcontent = SMSUtil.setSmsInfo(phoneNumber, content);
        try {
            String res = SapClient.doPost(SMS_SEND_URL, xMLcontent.toString());
            res = StringEscapeUtils.unescapeXml((String)res);
            if (!StringUtils.isEmpty((String)res) && res.contains("smsID")) {
                result = res.substring(res.indexOf("<smsID>"), res.indexOf("</smsID>")).substring("<smsID>".length());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u77ed\u4fe1\u63a8\u9001\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        logger.info("sms result:{}", (Object)result);
        return result;
    }

    public static StringBuffer setSmsInfo(String phoneNumber, String content) {
        StringBuffer xMLcontent = new StringBuffer();
        xMLcontent.append("<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sms=\"http://smsnewaddsubcode.webservice.ema.ctc.com\">\n");
        xMLcontent.append("<soapenv:Header/>\n");
        xMLcontent.append("<soapenv:Body>\n");
        xMLcontent.append("<sms:sendSms soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n");
        xMLcontent.append("<account xsi:type=\"xsd:string\">sms_fkszh02</account>\n");
        xMLcontent.append("<password xsi:type=\"xsd:string\">218afdace703e8d03ba3072b78edf43f</password>\n");
        xMLcontent.append("<firstDeptId xsi:type=\"xsd:string\">80001375</firstDeptId>\n");
        xMLcontent.append("<secondDeptId xsi:type=\"xsd:string\"></secondDeptId>\n");
        xMLcontent.append("<thirdDeptId xsi:type=\"xsd:string\"></thirdDeptId>\n");
        xMLcontent.append("<message xsi:type=\"urn:MtNewMessage\" xmlns:urn=\"urn:SmsNewOperatoraddsubCode\">\n");
        xMLcontent.append("<smsId xsi:type=\"xsd:string\"></smsId>\n");
        xMLcontent.append("<phoneNumber xsi:type=\"xsd:string\">" + phoneNumber + "</phoneNumber>\n");
        xMLcontent.append("<content xsi:type=\"xsd:string\">" + content + "</content>\n");
        xMLcontent.append("<wapPushUrl xsi:type=\"xsd:string\"></wapPushUrl>\n");
        xMLcontent.append("</message>\n");
        xMLcontent.append("<subCode xsi:type=\"xsd:string\"></subCode>\n");
        xMLcontent.append("<sendResMsg xsi:type=\"xsd:string\"></sendResMsg>\n");
        xMLcontent.append("<errMsg xsi:type=\"xsd:string\"></errMsg>\n");
        xMLcontent.append("</sms:sendSms>\n");
        xMLcontent.append("</soapenv:Body>\n");
        xMLcontent.append("</soapenv:Envelope>");
        return xMLcontent;
    }

    public static boolean isPhoneNum(String str) throws PatternSyntaxException {
        return SMSUtil.isChinaPhoneNum(str) || SMSUtil.isHkPhoneNum(str);
    }

    public static boolean isChinaPhoneNum(String str) throws PatternSyntaxException {
        Pattern p = Pattern.compile(CHINA_REGEX_EXP);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isHkPhoneNum(String str) throws PatternSyntaxException {
        Pattern p = Pattern.compile(HK_REGEX_EXP);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

