/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceCategoryMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceCategoryDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceCategoryReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceCategory;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceCategoryService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceCategoryServiceImpl
extends BaseServiceImpl
implements SksSourceCategoryService {
    private static final String SYS_CODE = "SKS.SksSourceCategoryServiceImpl";
    private SksSourceCategoryMapper sksSourceCategoryMapper;

    public void setSksSourceCategoryMapper(SksSourceCategoryMapper sksSourceCategoryMapper) {
        this.sksSourceCategoryMapper = sksSourceCategoryMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceCategoryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) {
        if (null == sksSourceCategoryDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceCategoryDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsourceCategoryDefault(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return;
        }
        if (null == sksSourceCategory.getDataState()) {
            sksSourceCategory.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceCategory.getGmtCreate()) {
            sksSourceCategory.setGmtCreate(date);
        }
        sksSourceCategory.setGmtModified(date);
        sksSourceCategory.setId(sksSourceCategory.getRequestid());
        if (StringUtils.isBlank((String)sksSourceCategory.getId())) {
            sksSourceCategory.setId(this.getNo(null, "SksSourceCategory", "sksSourceCategory", sksSourceCategory.getTenantCode()));
        }
    }

    private int getsourceCategoryMaxCode() {
        int code = 0;
        try {
            return this.sksSourceCategoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.getsourceCategoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsourceCategoryUpdataDefault(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return;
        }
        sksSourceCategory.setGmtModified(this.getSysDate());
    }

    private void savesourceCategoryModel(SksSourceCategory sksSourceCategory) throws ApiException {
        if (null == sksSourceCategory) {
            return;
        }
        try {
            this.sksSourceCategoryMapper.insert(sksSourceCategory);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.savesourceCategoryModel.ex", (Throwable)e);
        }
    }

    private void savesourceCategoryBatchModel(List<SksSourceCategory> sksSourceCategoryList) throws ApiException {
        if (null == sksSourceCategoryList || sksSourceCategoryList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceCategoryMapper.insertBatch(sksSourceCategoryList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.savesourceCategoryBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceCategory getsourceCategoryModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceCategoryMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.getsourceCategoryModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceCategory getsourceCategoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceCategoryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.getsourceCategoryModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsourceCategoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.delsourceCategoryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.delsourceCategoryModelByCode.num");
        }
    }

    private void deletesourceCategoryModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.deletesourceCategoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.deletesourceCategoryModel.num");
        }
    }

    private void updatesourceCategoryModel(SksSourceCategory sksSourceCategory) throws ApiException {
        if (null == sksSourceCategory) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateByPrimaryKey(sksSourceCategory);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updatesourceCategoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updatesourceCategoryModel.num");
        }
    }

    private void updateStatesourceCategoryModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updateStatesourceCategoryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updateStatesourceCategoryModel.null");
        }
    }

    private void updateStatesourceCategoryModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updateStatesourceCategoryModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updateStatesourceCategoryModelByCode.null");
        }
    }

    private SksSourceCategory makesourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain, SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategoryDomain) {
            return null;
        }
        if (null == sksSourceCategory) {
            sksSourceCategory = new SksSourceCategory();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceCategory, (Object)sksSourceCategoryDomain);
            return sksSourceCategory;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.makesourceCategory", (Throwable)e);
            return null;
        }
    }

    private SksSourceCategoryReDomain makeSksSourceCategoryReDomain(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return null;
        }
        SksSourceCategoryReDomain sksSourceCategoryReDomain = new SksSourceCategoryReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceCategoryReDomain, (Object)sksSourceCategory);
            return sksSourceCategoryReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.makeSksSourceCategoryReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceCategory> querysourceCategoryModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceCategoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.querysourceCategoryModel", (Throwable)e);
            return null;
        }
    }

    private int countsourceCategory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSourceCategoryServiceImpl.countsourceCategory", (Throwable)e);
        }
        return i;
    }

    private SksSourceCategory createSksSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) {
        String msg = this.checksourceCategory(sksSourceCategoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.savesourceCategory.checksourceCategory", msg);
        }
        SksSourceCategory sksSourceCategory = this.makesourceCategory(sksSourceCategoryDomain, null);
        this.setsourceCategoryDefault(sksSourceCategory);
        return sksSourceCategory;
    }

    @Override
    public String savesourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) throws ApiException {
        SksSourceCategory sksSourceCategory = this.createSksSourceCategory(sksSourceCategoryDomain);
        this.savesourceCategoryModel(sksSourceCategory);
        return sksSourceCategory.getRequestid();
    }

    @Override
    public String savesourceCategoryBatch(List<SksSourceCategoryDomain> sksSourceCategoryDomainList) throws ApiException {
        if (null == sksSourceCategoryDomainList || sksSourceCategoryDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceCategory> sksSourceCategoryList = new ArrayList<SksSourceCategory>();
        String code = "";
        for (SksSourceCategoryDomain sksSourceCategoryDomain : sksSourceCategoryDomainList) {
            SksSourceCategory sksSourceCategory = this.createSksSourceCategory(sksSourceCategoryDomain);
            code = sksSourceCategory.getRequestid();
            sksSourceCategoryList.add(sksSourceCategory);
        }
        this.savesourceCategoryBatchModel(sksSourceCategoryList);
        return code;
    }

    @Override
    public void updatesourceCategoryState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStatesourceCategoryModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updatesourceCategoryStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesourceCategoryModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updatesourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) throws ApiException {
        String msg = this.checksourceCategory(sksSourceCategoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updatesourceCategory.checksourceCategory", msg);
        }
        SksSourceCategory oldSksSourceCategory = this.getsourceCategoryModelById(sksSourceCategoryDomain.getId());
        if (null == oldSksSourceCategory) {
            throw new ApiException("SKS.SksSourceCategoryServiceImpl.updatesourceCategory.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceCategory sksSourceCategory = this.makesourceCategory(sksSourceCategoryDomain, oldSksSourceCategory);
        this.setsourceCategoryUpdataDefault(sksSourceCategory);
        this.updatesourceCategoryModel(sksSourceCategory);
    }

    @Override
    public SksSourceCategory getsourceCategory(String id) {
        if (null == id) {
            return null;
        }
        return this.getsourceCategoryModelById(id);
    }

    @Override
    public void deletesourceCategory(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deletesourceCategoryModel(id);
    }

    @Override
    public QueryResult<SksSourceCategory> querysourceCategoryPage(Map<String, Object> map) {
        List<SksSourceCategory> sksSourceCategoryList = this.querysourceCategoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsourceCategory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceCategoryList);
        return queryResult;
    }

    @Override
    public SksSourceCategory getsourceCategoryByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getsourceCategoryModelByCode(map);
    }

    @Override
    public void deletesourceCategoryByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delsourceCategoryModelByCode(map);
    }
}

