/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksGoodsSalesMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.es.StoreDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksGoodsSalesDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksGoodsSalesReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksGoodsSales;
import com.yqbsoft.laser.service.ext.skshu.service.SksGoodsSalesService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksGoodsSalesServiceImpl
extends BaseServiceImpl
implements SksGoodsSalesService {
    private static final String SYS_CODE = "SKS.SksGoodsSalesServiceImpl";
    private SksGoodsSalesMapper sksGoodsSalesMapper;

    public void setSksGoodsSalesMapper(SksGoodsSalesMapper sksGoodsSalesMapper) {
        this.sksGoodsSalesMapper = sksGoodsSalesMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksGoodsSalesMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsSales(SksGoodsSalesDomain sksGoodsSalesDomain) {
        if (null == sksGoodsSalesDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksGoodsSalesDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsSalesDefault(SksGoodsSales sksGoodsSales) {
        if (null == sksGoodsSales) {
            return;
        }
        if (null == sksGoodsSales.getDataState()) {
            sksGoodsSales.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksGoodsSales.getGmtCreate()) {
            sksGoodsSales.setGmtCreate(date);
        }
        sksGoodsSales.setGmtModified(date);
        if (StringUtils.isBlank((String)sksGoodsSales.getSalesCode())) {
            sksGoodsSales.setSalesCode(this.getNo(null, "SksGoodsSales", "sksGoodsSales", sksGoodsSales.getTenantCode()));
        }
    }

    private int getGoodsSalesMaxCode() {
        int code = 0;
        try {
            return this.sksGoodsSalesMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.getGoodsSalesMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsSalesUpdataDefault(SksGoodsSales sksGoodsSales) {
        if (null == sksGoodsSales) {
            return;
        }
        sksGoodsSales.setGmtModified(this.getSysDate());
    }

    private void saveGoodsSalesModel(SksGoodsSales sksGoodsSales) throws ApiException {
        if (null == sksGoodsSales) {
            return;
        }
        try {
            this.sksGoodsSalesMapper.insert(sksGoodsSales);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.saveGoodsSalesModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsSalesBatchModel(List<SksGoodsSales> sksGoodsSalesList) throws ApiException {
        if (null == sksGoodsSalesList || sksGoodsSalesList.isEmpty()) {
            return;
        }
        try {
            this.sksGoodsSalesMapper.insertBatch(sksGoodsSalesList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.saveGoodsSalesBatchModel.ex", (Throwable)e);
        }
    }

    private SksGoodsSales getGoodsSalesModelById(Integer salesId) {
        if (null == salesId) {
            return null;
        }
        try {
            return this.sksGoodsSalesMapper.selectByPrimaryKey(salesId);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.getGoodsSalesModelById", (Throwable)e);
            return null;
        }
    }

    private SksGoodsSales getGoodsSalesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksGoodsSalesMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.getGoodsSalesModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsSalesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.delGoodsSalesModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.delGoodsSalesModelByCode.num");
        }
    }

    private void deleteGoodsSalesModel(Integer salesId) throws ApiException {
        if (null == salesId) {
            return;
        }
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.deleteByPrimaryKey(salesId);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.deleteGoodsSalesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.deleteGoodsSalesModel.num");
        }
    }

    private void updateGoodsSalesModel(SksGoodsSales sksGoodsSales) throws ApiException {
        if (null == sksGoodsSales) {
            return;
        }
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.updateByPrimaryKey(sksGoodsSales);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateGoodsSalesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateGoodsSalesModel.num");
        }
    }

    private void updateStateGoodsSalesModel(Integer salesId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salesId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salesId", salesId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateStateGoodsSalesModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateStateGoodsSalesModel.null");
        }
    }

    private void updateStateGoodsSalesModelByCode(String tenantCode, String salesCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salesCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesCode", salesCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateStateGoodsSalesModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateStateGoodsSalesModelByCode.null");
        }
    }

    private SksGoodsSales makeGoodsSales(SksGoodsSalesDomain sksGoodsSalesDomain, SksGoodsSales sksGoodsSales) {
        if (null == sksGoodsSalesDomain) {
            return null;
        }
        if (null == sksGoodsSales) {
            sksGoodsSales = new SksGoodsSales();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksGoodsSales, (Object)sksGoodsSalesDomain);
            return sksGoodsSales;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.makeGoodsSales", (Throwable)e);
            return null;
        }
    }

    private SksGoodsSalesReDomain makeSksGoodsSalesReDomain(SksGoodsSales sksGoodsSales) {
        if (null == sksGoodsSales) {
            return null;
        }
        SksGoodsSalesReDomain sksGoodsSalesReDomain = new SksGoodsSalesReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksGoodsSalesReDomain, (Object)sksGoodsSales);
            return sksGoodsSalesReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.makeSksGoodsSalesReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksGoodsSales> queryGoodsSalesModelPage(Map<String, Object> parammap) {
        try {
            return this.sksGoodsSalesMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.queryGoodsSalesModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsSales(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksGoodsSalesMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.countGoodsSales", (Throwable)e);
        }
        return i;
    }

    private SksGoodsSales createSksGoodsSales(SksGoodsSalesDomain sksGoodsSalesDomain) {
        String msg = this.checkGoodsSales(sksGoodsSalesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.saveGoodsSales.checkGoodsSales", msg);
        }
        SksGoodsSales sksGoodsSales = this.makeGoodsSales(sksGoodsSalesDomain, null);
        this.setGoodsSalesDefault(sksGoodsSales);
        return sksGoodsSales;
    }

    @Override
    public String saveGoodsSales(SksGoodsSalesDomain sksGoodsSalesDomain) throws ApiException {
        SksGoodsSales sksGoodsSales = this.createSksGoodsSales(sksGoodsSalesDomain);
        this.saveGoodsSalesModel(sksGoodsSales);
        return sksGoodsSales.getSalesCode();
    }

    @Override
    public String saveGoodsSalesBatch(List<SksGoodsSalesDomain> sksGoodsSalesDomainList) throws ApiException {
        if (null == sksGoodsSalesDomainList || sksGoodsSalesDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksGoodsSales> sksGoodsSalesList = new ArrayList<SksGoodsSales>();
        String code = "";
        for (SksGoodsSalesDomain sksGoodsSalesDomain : sksGoodsSalesDomainList) {
            SksGoodsSales sksGoodsSales = this.createSksGoodsSales(sksGoodsSalesDomain);
            code = sksGoodsSales.getSalesCode();
            sksGoodsSalesList.add(sksGoodsSales);
        }
        this.saveGoodsSalesBatchModel(sksGoodsSalesList);
        return code;
    }

    @Override
    public void updateGoodsSalesState(Integer salesId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salesId) {
            return;
        }
        this.updateStateGoodsSalesModel(salesId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsSalesStateByCode(String tenantCode, String salesCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salesCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsSalesModelByCode(tenantCode, salesCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsSales(SksGoodsSalesDomain sksGoodsSalesDomain) throws ApiException {
        String msg = this.checkGoodsSales(sksGoodsSalesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateGoodsSales.checkGoodsSales", msg);
        }
        SksGoodsSales oldSksGoodsSales = this.getGoodsSalesModelById(sksGoodsSalesDomain.getSalesId());
        if (null == oldSksGoodsSales) {
            throw new ApiException("SKS.SksGoodsSalesServiceImpl.updateGoodsSales.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksGoodsSales sksGoodsSales = this.makeGoodsSales(sksGoodsSalesDomain, oldSksGoodsSales);
        this.setGoodsSalesUpdataDefault(sksGoodsSales);
        this.updateGoodsSalesModel(sksGoodsSales);
    }

    @Override
    public SksGoodsSales getGoodsSales(Integer salesId) {
        if (null == salesId) {
            return null;
        }
        return this.getGoodsSalesModelById(salesId);
    }

    @Override
    public void deleteGoodsSales(Integer salesId) throws ApiException {
        if (null == salesId) {
            return;
        }
        this.deleteGoodsSalesModel(salesId);
    }

    @Override
    public QueryResult<SksGoodsSales> queryGoodsSalesPage(Map<String, Object> map) {
        List<SksGoodsSales> sksGoodsSalesList = this.queryGoodsSalesModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsSales(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksGoodsSalesList);
        return queryResult;
    }

    @Override
    public SksGoodsSales getGoodsSalesByCode(String tenantCode, String salesCode) throws ApiException {
        if (StringUtils.isBlank((String)salesCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesCode", salesCode);
        return this.getGoodsSalesModelByCode(map);
    }

    @Override
    public void deleteGoodsSalesByCode(String tenantCode, String salesCode) throws ApiException {
        if (StringUtils.isBlank((String)salesCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesCode", salesCode);
        this.delGoodsSalesModelByCode(map);
    }

    @Override
    public String sendSaveOrderSales(OcContractReDomain ocContractDomain) {
        this.logger.error("SKS.SksGoodsSalesServiceImpl.sendSaveOrderSales.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.sendSaveOrderSales.ocContractDomain", (Object)"isnull");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (goodsList == null || goodsList.isEmpty()) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.sendSaveOrderSales.goodsList", (Object)"isnull or empty");
            return "error";
        }
        ArrayList<StoreDomain> storeDomainList = new ArrayList<StoreDomain>();
        try {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                    ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                }
                if (null == ocContractGoodsDomain.getGoodsCamount()) {
                    ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tenantCode", ocContractDomain.getTenantCode());
                map.put("departCode", ocContractDomain.getDepartCode());
                map.put("skuNo", ocContractGoodsDomain.getSkuNo());
                map.put("memberCode", ocContractDomain.getMemberBcode());
                QueryResult<SksGoodsSales> sksGoodsSalesQueryResult = this.queryGoodsSalesPage(map);
                if (sksGoodsSalesQueryResult.getList() == null || sksGoodsSalesQueryResult.getList().isEmpty()) {
                    SksGoodsSalesDomain sksGoodsSalesDomain = new SksGoodsSalesDomain();
                    BeanUtils.copyAllPropertys((Object)sksGoodsSalesDomain, (Object)ocContractGoodsDomain);
                    sksGoodsSalesDomain.setMemberCode(ocContractDomain.getMemberBcode());
                    sksGoodsSalesDomain.setMemberName(ocContractDomain.getMemberBname());
                    sksGoodsSalesDomain.setRegularGoodsNum(1);
                    sksGoodsSalesDomain.setRegularGoodsSnunm(ocContractGoodsDomain.getGoodsCamount());
                    sksGoodsSalesDomain.setRegularGoodsAmt(ocContractGoodsDomain.getContractGoodsMoney());
                    sksGoodsSalesDomain.setBusinessOrderno(ocContractGoodsDomain.getContractBillcode());
                    String salesCode = this.saveGoodsSales(sksGoodsSalesDomain);
                    if (!StringUtils.isNotBlank((String)salesCode)) continue;
                    StoreDomain storeDomain = new StoreDomain();
                    storeDomain.setBizId(salesCode);
                    storeDomain.setTenantCode(ocContractDomain.getTenantCode());
                    storeDomain.setBizType("goodsSales");
                    storeDomain.setRequestType("insert");
                    storeDomain.setBizId(this.createUUIDString());
                    storeDomain.setStoreObj(JsonUtil.buildNormalBinder().toJson((Object)sksGoodsSalesDomain));
                    storeDomainList.add(storeDomain);
                    continue;
                }
                SksGoodsSales sksGoodsSales = (SksGoodsSales)sksGoodsSalesQueryResult.getList().get(0);
                int currentNum = sksGoodsSales.getRegularGoodsNum();
                sksGoodsSales.setRegularGoodsNum(currentNum + 1);
                BigDecimal currentSnunm = sksGoodsSales.getRegularGoodsSnunm();
                if (currentSnunm == null) {
                    currentSnunm = BigDecimal.ZERO;
                }
                sksGoodsSales.setRegularGoodsSnunm(currentSnunm.add(ocContractGoodsDomain.getGoodsCamount()));
                BigDecimal currentAmt = sksGoodsSales.getRegularGoodsAmt();
                if (currentAmt == null) {
                    currentAmt = BigDecimal.ZERO;
                }
                sksGoodsSales.setRegularGoodsAmt(currentAmt.add(ocContractGoodsDomain.getContractGoodsMoney()));
                this.updateGoodsSalesModel(sksGoodsSales);
                StoreDomain storeDomain = new StoreDomain();
                storeDomain.setBizId(sksGoodsSales.getSalesCode());
                storeDomain.setTenantCode(ocContractDomain.getTenantCode());
                storeDomain.setBizType("goodsSales");
                storeDomain.setRequestType("insert");
                storeDomain.setStoreObj(JsonUtil.buildNormalBinder().toJson((Object)sksGoodsSales));
                storeDomainList.add(storeDomain);
            }
            boolean flag = this.sendEsList(storeDomainList);
            if (!flag) {
                this.logger.error("SKS.SksGoodsSalesServiceImpl.increaseOrderSales.flag", (Object)JsonUtil.buildNormalBinder().toJson(storeDomainList));
                return "error";
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.increaseOrderSales.exception", (Throwable)e);
            return "error";
        }
    }

    private boolean sendEsList(List<StoreDomain> storeDomainList) {
        if (ListUtil.isEmpty(storeDomainList)) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.sendEs.sendEsList.sendEsList", (Object)"isnull");
            return false;
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomainList", JsonUtil.buildNormalBinder().toJson(storeDomainList));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.storeBatch", "1.0", "0", paramMap1);
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            this.logger.error("SKS.SksGoodsSalesServiceImpl.sendEs.result", (Object)(result + "storeDomainList" + JsonUtil.buildNormalBinder().toJson(storeDomainList)));
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

