/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.unionpaywallet.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.ext.channel.unionpaywallet.util.CryptoUtils;
import com.yqbsoft.laser.service.ext.channel.unionpaywallet.util.HttpUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public abstract class GneteGatewayRequestUtils {
    private static final String APP_ID = "5ed70f9c2c07873f0aa9e455560bc553";
    private static final String MCT_PRIVATE_KEY_PATH = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\A0010000-0014.p12";
    private static final String MCT_PRIVATE_KEY_PWD = "123456";
    private static final PrivateKey MCT_PRIVATE_KEY = CryptoUtils.initPrivateKeyFromFile(new File("C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\A0010000-0014.p12"), "123456");
    private static final String GNETE_GATEWAY_URL = "https://testapi.gnete.com:9083/routejson";
    private static final String GNETE_GATEWAY_PUBLIC_KEY_PATH = "C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\2048-cfca.der";
    private static final PublicKey GNETE_GATEWAY_PUBLIC_KEY = CryptoUtils.initPublicKeyFromFile(new File("C:\\Users\\\u5218\u5174\\Desktop\\\u7231\u5a74\u5c9b\\\u63a5\u5165\u8d44\u6599(0114-\u6700\u65b0)\\\u5176\u4ed6\u8d44\u6599\u4e0edemo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\\u4f01\u4e1a\u7535\u5b50\u8d26\u6237java\u63a5\u5165demo\\src\\main\\resources\\cert\\2048-cfca.der"));
    private static final String SIGN_ALG = "SHA1withRSA";

    public static JSONObject callGneteGateway(String method, String bizContent) throws IOException {
        bizContent = URLEncoder.encode(bizContent, "UTF-8");
        String requestBody = GneteGatewayRequestUtils.buildRequestBody(method, bizContent);
        requestBody = GneteGatewayRequestUtils.sign(requestBody);
        System.out.println("-------------------------Request [" + method + "]-------------------------");
        System.out.println("\u53c2\u6570================" + URLDecoder.decode(requestBody, "UTF-8"));
        System.out.println();
        String result = HttpUtils.post(GNETE_GATEWAY_URL, requestBody);
        System.out.println(result);
        GneteGatewayRequestUtils.verifySign(result);
        return JSON.parseObject((String)result);
    }

    private static String buildRequestBody(String method, String bizContent) {
        String timestamp = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        return "app_id=5ed70f9c2c07873f0aa9e455560bc553&timestamp=" + timestamp + "&method=" + method + "&v=1.0.1&biz_content=" + bizContent + "&sign_alg=0";
    }

    private static String sign(String requestBody) {
        String signature = CryptoUtils.sign(SIGN_ALG, requestBody, MCT_PRIVATE_KEY, "UTF-8");
        return requestBody + "&sign=" + signature;
    }

    private static void verifySign(String responseBody) {
        int index = responseBody.lastIndexOf("sign");
        String sign = responseBody.substring(index + 7, responseBody.length() - 2);
        String source = responseBody.substring(0, index - 2) + "}";
        boolean pass = CryptoUtils.verifySign(SIGN_ALG, source, sign, GNETE_GATEWAY_PUBLIC_KEY, "UTF-8");
        if (!pass) {
            throw new RuntimeException("\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
        }
    }

    private static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

