/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wdp.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wdp.domain.OcContractDomain;
import com.yqbsoft.laser.service.wdp.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.wdp.domain.OcContractReDomain;
import com.yqbsoft.laser.service.wdp.service.ContractService;
import com.yqbsoft.laser.service.wdp.utils.DmUtil;
import com.yqbsoft.laser.service.wdp.utils.WdtClient;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ContractServicelmpl
extends BaseServiceImpl
implements ContractService {
    private static final String SYS_CODE = "mid.ContractServicelmpl";

    @Override
    public String sendSaveContract(OcContractDomain ocContractDomain) throws ApiException {
        this.logger.error("mid.ContractServicelmpl.ocContractDomain:ocContractDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            this.logger.error("mid.ContractServicelmpl.saveSendgoods", (Object)"is null");
            return "error";
        }
        String url = "";
        url = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpUrl", "url");
        String sid = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpSid", "app_id");
        String appkey = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpAppsecret", "appsecret");
        String contract = this.getContract(ocContractDomain, sid, appkey, appsecret, url);
        return contract;
    }

    public String getContract(OcContractDomain ocContractDomain, String sid, String appkey, String appsecret, String url) {
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        ArrayList trade_list = new ArrayList();
        ArrayList order_list = new ArrayList();
        HashMap<String, String> contractMap = new HashMap<String, String>();
        HashMap<String, String> contractMapStr = new HashMap<String, String>();
        contractMap.put("contractBillcode", ocContractDomain.getContractBillcode());
        contractMap.put("tenantCode", ocContractDomain.getTenantCode());
        contractMapStr.put("map", JsonUtil.buildNormalBinder().toJson(contractMap));
        String ocContractReDomainStr = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", contractMapStr);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(ocContractReDomainStr, OcContractReDomain.class);
        if (contractReDomain == null) {
            this.logger.error("mid.ContractServicelmpl.oc.contract.getContractByCode", (Object)("\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a" + contractMapStr));
            return "error";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("mid.ContractServicelmpl.goodsList:isnull");
            return "error";
        }
        HashMap<String, Object> trade_1 = new HashMap<String, Object>();
        for (OcContractGoodsDomain goods : ocContractDomain.getGoodsList()) {
            if (null == goods.getContractGoodsPrice()) {
                goods.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (null == goods.getPricesetNprice()) {
                goods.setPricesetNprice(BigDecimal.ZERO);
            }
            HashMap<String, Object> order_1 = new HashMap<String, Object>();
            order_1.put("oid", goods.getContractGoodsCode());
            order_1.put("num", goods.getGoodsCamount());
            order_1.put("price", goods.getPricesetNprice());
            if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == 1) {
                order_1.put("status", 10);
            } else if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == -1) {
                order_1.put("status", 90);
            } else if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == 2) {
                order_1.put("status", 30);
            }
            order_1.put("refund_status", 0);
            order_1.put("goods_id", goods.getGoodsNo());
            order_1.put("spec_id", goods.getSkuNo());
            order_1.put("spec_no", goods.getSkuName());
            order_1.put("goods_name", goods.getGoodsName());
            order_1.put("discount", 0);
            order_1.put("adjust_amount", 0);
            BigDecimal sum = goods.getPricesetNprice().subtract(goods.getContractGoodsPrice());
            order_1.put("share_discount", sum.multiply(goods.getGoodsCamount()));
            order_list.add(order_1);
        }
        if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == 1) {
            trade_1.put("trade_status", 10);
            trade_1.put("pay_status", "0");
        } else if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == -1) {
            trade_1.put("trade_status", 90);
            trade_1.put("pay_status", "0");
        } else if (null != contractReDomain.getDataState() && contractReDomain.getDataState() == 2) {
            trade_1.put("trade_status", 30);
            trade_1.put("pay_status", "2");
        }
        trade_1.put("tid", ocContractDomain.getContractBillcode());
        trade_1.put("delivery_term", 1);
        trade_1.put("trade_time", ocContractDomain.getGmtCreate());
        trade_1.put("buyer_nick", ocContractDomain.getMemberBname());
        String arrdress = ocContractDomain.getGoodsReceiptArrdess();
        String receiver_province = "";
        String receiver_city = "";
        String receiver_district = "";
        String receiver_address = "";
        if (StringUtils.isNotBlank((String)arrdress)) {
            receiver_province = arrdress.substring(0, 2);
            receiver_city = arrdress.substring(2, 5);
            receiver_district = arrdress.substring(5, 8);
            receiver_address = arrdress.substring(8);
        }
        trade_1.put("receiver_province", receiver_province);
        trade_1.put("receiver_city", receiver_city);
        trade_1.put("receiver_district", receiver_district);
        trade_1.put("receiver_address", receiver_address);
        trade_1.put("receiver_mobile", ocContractDomain.getGoodsReceiptPhone());
        trade_1.put("buyer_message", ocContractDomain.getContractRemark());
        trade_1.put("receiver_name", ocContractDomain.getGoodsReceiptMem());
        trade_1.put("post_amount", ocContractDomain.getGoodsLogmoney());
        trade_1.put("cod_amount", BigDecimal.ZERO);
        trade_1.put("other_amount", BigDecimal.ZERO);
        trade_1.put("paid", ocContractDomain.getDataBmoney());
        trade_1.put("order_list", order_list);
        trade_list.add(trade_1);
        String trade_list_json = JsonUtil.buildNormalBinder().toJson(trade_list);
        String shop_no = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpSendgoodsShop_no", "shop_no");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("shop_no", shop_no);
        params.put("trade_list", trade_list_json);
        this.logger.error("mid.ContractServicelmpl.saveSendgoods.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
        String response = "";
        try {
            response = client.execute("trade_push.php", params);
        }
        catch (IOException e) {
            this.logger.error("mid.ContractServicelmpl.saveSendgoods.response", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            return "error";
        }
        if (StringUtils.isNotBlank((String)response)) {
            Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
            if (MapUtil.isEmpty((Map)jsonToMap)) {
                this.logger.error("mid.ContractServicelmpl.saveSendgoods.jsonToMap", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
                return "error";
            }
            if ("0".equals(jsonToMap.get("code"))) {
                return "success";
            }
            this.logger.error("mid.ContractServicelmpl.saveSendgoods.jsonToMapStr", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
            return "error";
        }
        this.logger.error("mid.ContractServicelmpl.saveSendgoods.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
        return "error";
    }

    @Override
    public String returnSaveContract(OcContractDomain ocContractDomain) throws ApiException {
        this.logger.error("mid.ContractServicelmpl.ocContractDomain:ocContractDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            this.logger.error("mid.ContractServicelmpl.saveSendgoods", (Object)"is null");
            return "error";
        }
        String url = "";
        url = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpUrl", "url");
        String sid = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpSid", "app_id");
        String appkey = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocContractDomain.getTenantCode(), "wdpAppsecret", "appsecret");
        String contract = this.returnContract(ocContractDomain, sid, appkey, appsecret, url);
        return contract;
    }

    public String returnContract(OcContractDomain ocContractDomain, String sid, String appkey, String appsecret, String url) {
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        ArrayList trade_list = new ArrayList();
        ArrayList order_list = new ArrayList();
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("mid.ContractServicelmpl.returnContract.goodsList:isnull");
            return "error";
        }
        for (OcContractGoodsDomain goods : ocContractDomain.getGoodsList()) {
            if (null == goods.getContractGoodsPrice()) {
                goods.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (null == goods.getPricesetNprice()) {
                goods.setPricesetNprice(BigDecimal.ZERO);
            }
            HashMap<String, Object> order_1 = new HashMap<String, Object>();
            order_1.put("oid", goods.getContractGoodsCode());
            order_1.put("num", goods.getGoodsCamount());
            order_1.put("price", goods.getPricesetNprice());
            order_1.put("status", 70);
            order_1.put("refund_status", 0);
            order_1.put("goods_id", goods.getGoodsNo());
            order_1.put("spec_id", goods.getSkuNo());
            order_1.put("spec_no", goods.getSkuName());
            order_1.put("goods_name", goods.getGoodsName());
            order_1.put("discount", 0);
            order_1.put("adjust_amount", 0);
            BigDecimal sum = goods.getPricesetNprice().subtract(goods.getContractGoodsPrice());
            order_1.put("share_discount", sum.multiply(goods.getGoodsCamount()));
            order_list.add(order_1);
        }
        HashMap<String, Object> trade_1 = new HashMap<String, Object>();
        trade_1.put("tid", ocContractDomain.getContractBillcode());
        trade_1.put("trade_status", 70);
        trade_1.put("pay_status", "2");
        trade_1.put("delivery_term", 1);
        trade_1.put("trade_time", ocContractDomain.getGmtCreate());
        trade_1.put("buyer_nick", ocContractDomain.getMemberBname());
        String arrdress = ocContractDomain.getGoodsReceiptArrdess();
        String receiver_province = "";
        String receiver_city = "";
        String receiver_district = "";
        String receiver_address = "";
        if (StringUtils.isNotBlank((String)arrdress)) {
            receiver_province = arrdress.substring(0, 2);
            receiver_city = arrdress.substring(2, 5);
            receiver_district = arrdress.substring(5, 8);
            receiver_address = arrdress.substring(8);
        }
        trade_1.put("receiver_province", receiver_province);
        trade_1.put("receiver_city", receiver_city);
        trade_1.put("receiver_district", receiver_district);
        trade_1.put("receiver_address", receiver_address);
        trade_1.put("receiver_mobile", ocContractDomain.getGoodsReceiptPhone());
        trade_1.put("buyer_message", ocContractDomain.getContractRemark());
        trade_1.put("receiver_name", ocContractDomain.getGoodsReceiptMem());
        trade_1.put("post_amount", ocContractDomain.getGoodsLogmoney());
        trade_1.put("cod_amount", BigDecimal.ZERO);
        trade_1.put("other_amount", BigDecimal.ZERO);
        trade_1.put("paid", ocContractDomain.getDataBmoney());
        trade_1.put("order_list", order_list);
        trade_list.add(trade_1);
        String trade_list_json = JsonUtil.buildNormalBinder().toJson(trade_list);
        String shop_no = DmUtil.getUrl(ocContractDomain.getTenantCode(), "zsSendgoodsShop_no", "shop_no");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("shop_no", shop_no);
        params.put("trade_list", trade_list_json);
        String response = "";
        try {
            response = client.execute("trade_push.php", params);
        }
        catch (IOException e) {
            this.logger.error("mid.ContractServicelmpl.returnContract.response", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            return "error";
        }
        this.logger.error("mid.ContractServicelmpl.returnContract.trade_list", (Object)("trade_list" + JsonUtil.buildNonDefaultBinder().toJson(params)));
        if (StringUtils.isNotBlank((String)response)) {
            Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
            this.logger.error("mid.ContractServicelmpl.returnContract.jsonToMap", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
            if (MapUtil.isEmpty((Map)jsonToMap)) {
                this.logger.error("mid.ContractServicelmpl.returnContract.jsonToMap", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
                return "error";
            }
            if ("0".equals(jsonToMap.get("code"))) {
                return "success";
            }
            this.logger.error("mid.ContractServicelmpl.returnContract.jsonToMapStr", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
            return "error";
        }
        this.logger.error("mid.ContractServicelmpl.returnContract.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
        return "error";
    }

    public static void main(String[] args) {
        WdtClient client = new WdtClient("apidevnew2", "zqwc2-test", "1813ad8b8", "https://sandbox.wangdian.cn/openapi2");
        ArrayList trade_list = new ArrayList();
        ArrayList order_list = new ArrayList();
        HashMap<String, Object> order_1 = new HashMap<String, Object>();
        order_1.put("oid", "ghsTest121101");
        order_1.put("num", 1);
        order_1.put("price", 12);
        order_1.put("status", 30);
        order_1.put("refund_status", 0);
        order_1.put("goods_id", "18344");
        order_1.put("spec_id", "18656");
        order_1.put("goods_no", "ghs2");
        order_1.put("spec_no", "ghs201812070212123");
        order_1.put("goods_name", "123");
        order_1.put("discount", 0);
        order_1.put("adjust_amount", 0);
        order_1.put("share_discount", 0);
        order_list.add(order_1);
        HashMap<String, Object> trade_1 = new HashMap<String, Object>();
        trade_1.put("tid", "AT201812110002");
        trade_1.put("trade_status", 20);
        trade_1.put("pay_status", "1");
        trade_1.put("delivery_term", 2);
        trade_1.put("trade_time", "2018-12-11 14:21:00");
        trade_1.put("buyer_nick", "\u4e09\u56fd\u6740");
        trade_1.put("receiver_province", "\u6cb3\u5357\u7701");
        trade_1.put("receiver_city", "\u5468\u53e3\u5e02");
        trade_1.put("receiver_district", "\u5ddd\u6c47\u533a");
        trade_1.put("receiver_address", "123");
        trade_1.put("logistics_type", 4);
        trade_1.put("post_amount", 12);
        trade_1.put("cod_amount", 2);
        trade_1.put("ext_cod_fee", 0);
        trade_1.put("other_amount", 1);
        trade_1.put("paid", 0);
        trade_1.put("order_list", order_list);
        trade_list.add(trade_1);
        String trade_list_json = JsonUtil.buildNormalBinder().toJson(trade_list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("shop_no", "ZQ005");
        params.put("trade_list", trade_list_json);
        String response = "";
        try {
            response = client.execute("trade_push.php", params);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((String)response)) {
            Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
            System.out.println(jsonToMap);
            if (MapUtil.isEmpty((Map)jsonToMap)) {
                // empty if block
            }
            if ("0".equals(jsonToMap.get("code"))) {
                // empty if block
            }
        }
    }
}

