/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatmini.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.wechatmini.sign.MD5;
import com.yqbsoft.laser.service.ext.channel.wechatmini.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatmini.util.WeChatPayNotify;
import com.yqbsoft.laser.service.ext.channel.wechatmini.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.info("cmc.ChannelSignServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        String httpUrl = WeChatPayConfig.url;
        Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        String verCode = "";
        if (null != exmap) {
            Map payMap;
            String pay;
            String spbill_create_ip;
            String openId = (String)exmap.get("openId");
            if (StringUtils.isNotBlank((String)openId)) {
                channelRequest.getRequestData().put("openid", openId);
            }
            if (StringUtils.isNotBlank((String)(spbill_create_ip = (String)exmap.get("client_ip")))) {
                channelRequest.getRequestData().put("spbill_create_ip", spbill_create_ip);
            }
            verCode = (String)exmap.get("verCode");
            String userAccount = (String)exmap.get("userOcode");
            String payJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(channelRequest.getCmChannelClear().getTenantCode() + "-pay_config-pay_config"));
            if (StringUtils.isNotBlank((String)payJson) && StringUtils.isNotBlank((String)(pay = (String)(payMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(payJson, String.class, String.class)).get(userAccount)))) {
                String[] pays = pay.split("-");
                channelRequest.getConfigMap().put("mch_id", pays[0]);
                channelRequest.getConfigMap().put("pay_key", pays[1]);
                channelRequest.getRequestData().put("mch_id", pays[0]);
                channelRequest.getRequestData().put("pay_key", pays[1]);
            }
        }
        httpUrl = this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        if (StringUtils.isNotBlank((String)verCode)) {
            httpUrl = WeChatPayConfig.activeurl;
            channelRequest.getRequestData().put("auth_code", verCode);
            channelRequest.getRequestData().remove("notify_url");
            channelRequest.getRequestData().remove("openid");
            channelRequest.getRequestData().remove("sub_openid");
            channelRequest.getRequestData().remove("trade_type");
            channelRequest.setDebitFlag(true);
        }
        String api_key = (String)channelRequest.getRequestData().get(WeChatPayConfig.pay_key);
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        String resXml = "";
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params));
        try {
            resXml = WebUtils.doPost((String)httpUrl, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes(StandardCharsets.UTF_8), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("ChannelSignServiceImpl.sign.e", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        HashMap<String, String> res = new HashMap<String, String>();
        if (((String)resMap.get("return_code")).equals("SUCCESS") && ((String)resMap.get("result_code")).equals("SUCCESS")) {
            if (StringUtils.isBlank((String)verCode)) {
                res.put("appId", (String)resMap.get("appid"));
                res.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
                res.put("nonceStr", UUID.randomUUID().toString().replace("-", ""));
                res.put("package", "prepay_id=".concat((String)resMap.get("prepay_id")));
                res.put("signType", "MD5");
                res.put(WeChatPayConfig.pay_key, api_key);
                String sign = WeChatPaySubmit.buildRequestMysign(res);
                res.put("paySign", sign);
            } else {
                channelRequest.setDebitResult("SUCCESS");
                channelRequest.setBankSeqno((String)resMap.get("transaction_id"));
                this.processDate(resMap, channelRequest);
            }
        } else if (StringUtils.isNotBlank((String)verCode)) {
            res.put("subMsg", (String)resMap.get("err_code_des"));
            res.put("subCode", (String)resMap.get("err_code"));
            channelRequest.setBankRescode((String)resMap.get("err_code"));
            channelRequest.setBankResmsg((String)resMap.get("err_code_des"));
            channelRequest.setDebitResult((String)resMap.get("err_code"));
        }
        channelRequest.setRequestData(res);
    }

    private String makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        String httpUrl = WeChatPayConfig.url;
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("sub_appid", configMap.get("sub_appid"));
            requestMap.put("sub_openid", requestMap.remove("openid"));
        }
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
        if (configMap != null && configMap.containsKey("sp_appid")) {
            httpUrl = WeChatPayConfig.service_v3_url;
            requestMap.remove("trade_type");
            requestMap.remove("ptradpdeCode");
            HashMap<String, String> amount = new HashMap<String, String>();
            amount.put("total", requestMap.remove("total_fee"));
            HashMap<String, String> payer = new HashMap<String, String>();
            payer.put("sp_openid", requestMap.remove("openid"));
            requestMap.put("payer", JsonUtil.buildNormalBinder().toJson(payer));
            requestMap.put("amount", JsonUtil.buildNormalBinder().toJson(amount));
        }
        return httpUrl;
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public static void main(String[] args) {
        String req_info = "C2ZBMuk7e9KQ754WH983zdAiYLSfaQ1ufvYJj8sTzitgSGwJM5xRvuhKrWDfHr35/XXiiSzhmvPlQxX/o4t3Cd4frJuQl5N20m0gLiJ1OW0X1qyDE2lchiJS8NSK1y6/pVd6kQ2pVg89qvoCnTVGZ8LQfidjK4tTiSVPYLOrXLRwca2lB53u5NwDUNxBYQ7TKnW0D6u3mwtOg6h34BqqHMYVTC0NFgMrFK8Pwcm2y4hDEFaB+7sU9UP4R4OQCP2GmCC+Wp2B+Mb0Nk7qM3OkOa5rFCb7hEOdjLzQdwY7c4GPB/aq0MUUTdiVWKxgYIOWYNI0/EqN5qDO03UFIRkR4wU3R6kk9+KMnABzAQ9xJoZX22tllTj4CgezQAr/HWX7Mi1WWCIHfZhUw53Ue4o1mzi3+rxnNhODalZOk3h+FqazKicFbJFOoVuYuJw+744Uw6O/cn0KEVo60WqqqxQtJcVO7VGVisygrqeNONWlhN855fIdMCp8Rs6b/vsXY/oo87X+EJmQSfVLJC7gXt5J/4T9Bz8k9D6My6hdG6y2Dc0IjezA82CaQrCO4/q/Gc+25bdovsNu80u2KIZG7PowRYv5S2yrHVP9LRJl2Ces3IIN4ixQjbG9QjxVO8V3EEQTa8IH7TaTyrD8ErHca5f7wi63uik0/mD1MIEhbPWAN4I/RPJRFHO26U8KeEmj166WPHDlcAWYxD9n544t5O98q1sW6s5AXwLw3mlX5d676AFLpvxCaDz1He2oFYSRCbx53unEMbkqdl1J4jeGmaG/RiR+QhDrgpxDdlf7qpC6izKItXBwJxiahySOJOjVXfQZdrkZ0LJzgJBdsEbHRK01i4QxBdWSFybMHUgRlRTZIAOkjmCdBs8q8BLRygC5a7sKe+wsHwhZepnbgH8QN75erf901O8ixeLJ2dpPmCyCEHJRB7HBBxEgZ5LEd4nu/5f33DnMeusOSNQt5ZJ0xtwuOtk5bpASdZWtDlUkfkw1k/XaZ50oaFfuDaVMFLP3y10lu6v1YMg9O5yLnETnPY5dXobecs0R2vrixD3GDnCYec/CT6SRejGRaLs4wmjO5feb";
        String pay_key = "20220112SWIFTswiftShanghai202201";
        byte[] reqInfoB = Base64.decodeBase64((String)req_info);
        String md5pay_key = MD5.MD5Encode(pay_key).toLowerCase();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(md5pay_key.getBytes(), "AES");
            cipher.init(2, secretKeySpec);
            String resXml = new String(cipher.doFinal(reqInfoB));
            Map res = XmlUtil.getMapFromXML((String)resXml);
            System.out.println(res);
        }
        catch (Exception e) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.e", "");
        }
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        this.logger.error("cmc.ChannelSignServiceImpl.verifySign.res", (Object)res);
        String resstr = (String)res.get("resStream");
        String pay_key = (String)bankRequest.getConfigMap().get(WeChatPayConfig.pay_key);
        if (StringUtils.isNotBlank((String)resstr) && resstr.indexOf("</req_info>") >= 0 || res.containsKey("req_info")) {
            res = XmlUtil.getMapFromXML((String)resstr);
            String info = (String)res.get("req_info");
            if (StringUtils.isBlank((String)info)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.req_info", "");
            }
            byte[] reqInfoB = Base64.decodeBase64((String)info);
            String md5pay_key = MD5.MD5Encode(pay_key).toLowerCase();
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
                SecretKeySpec secretKeySpec = new SecretKeySpec(md5pay_key.getBytes(), "AES");
                cipher.init(2, secretKeySpec);
                String resXml = new String(cipher.doFinal(reqInfoB));
                res = XmlUtil.getMapFromXML((String)resXml);
            }
            catch (Exception e) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.e", "");
            }
        } else if (bankRequest.isSing()) {
            resstr = (String)res.get("resStream");
            res = XmlUtil.getMapFromXML((String)resstr);
            res.put(WeChatPayConfig.pay_key, pay_key);
            if (!WeChatPayNotify.verify(res)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
            }
        }
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }
}

