/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.yankon.oa.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.router.HttpResponseBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.yankon.oa.common.constant.ResultCodeEnum;
import com.yqbsoft.laser.service.yankon.oa.domain.MemjobDomain;
import com.yqbsoft.laser.service.yankon.oa.domain.RebMemjobDomain;
import com.yqbsoft.laser.service.yankon.oa.domain.ResponseData;
import com.yqbsoft.laser.service.yankon.oa.service.MemjobService;
import com.yqbsoft.laser.service.yankon.oa.utils.ValidatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class MemjobServiceImpl
extends BaseServiceImpl
implements MemjobService {
    ObjectMapper mapper = new ObjectMapper();
    private String SYS_CODE = "yankonOA.MemjobServiceImpl";

    @Override
    public String addMemjob(List<MemjobDomain> memjobDomainList) throws IOException {
        if (CollectionUtils.isEmpty(memjobDomainList)) {
            this.logger.error(this.SYS_CODE + ".addMemjob", (Object)"memjobList is empty!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg()));
        }
        StringBuilder sb = new StringBuilder();
        String str = null;
        for (MemjobDomain memjobDomain : memjobDomainList) {
            str = ValidatorUtil.validateDto(memjobDomain);
            if (!StringUtils.isNotBlank((String)str)) continue;
            sb.append(memjobDomain.getMemjobCode() + "\u53c2\u6570\u9519\u8bef\uff1a" + str);
        }
        if (sb.length() > 0) {
            this.logger.error(this.SYS_CODE + ".addMemjob", (Object)("memjobList param error!\t" + sb.toString()));
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), sb.toString()));
        }
        ArrayList<RebMemjobDomain> memjobList = new ArrayList<RebMemjobDomain>();
        for (MemjobDomain memjobDomain : memjobDomainList) {
            if (StringUtils.isBlank((String)memjobDomain.getMemjobCode())) {
                memjobDomain.setMemjobCode(this.getNo(null, "RebMemjob", "rebMemjob", "00000000"));
            }
            RebMemjobDomain memjob = new RebMemjobDomain();
            BeanUtils.copyProperties((Object)memjobDomain, (Object)memjob);
            memjob.setTenantCode("00000000");
            memjobList.add(memjob);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("rebMemjobDomainList", JsonUtil.buildNormalBinder().toJson(memjobList));
        this.getInternalRouter().inInvoke("reb.memjob.saveMemjobBatch", hashMap);
        for (MemjobDomain memjobDomain : memjobDomainList) {
            hashMap.clear();
            hashMap.put("tenantCode", "00000000");
            hashMap.put("memjobCode", memjobDomain.getMemjobCode());
            hashMap.put("dataState", 1);
            hashMap.put("oldDataState", 0);
            hashMap.put("map", null);
            this.getInternalRouter().inInvoke("reb.memjob.updateMemjobStateByCode", hashMap);
        }
        return this.buildSuccResponse(new ResponseData<Object>());
    }

    private String buildSuccResponse(ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildFailResponse(int httpStatus, ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpStatus(httpStatus);
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }
}

