/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.yankon.oa.utils;

import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RequestUtils {
    public static Map<String, Object> makeHeader(String interfaceId) {
        HashMap<String, Object> apiHeader = new HashMap<String, Object>();
        apiHeader.put("dtsend", DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        apiHeader.put("receiver", "S4");
        apiHeader.put("sender", "MPF");
        apiHeader.put("message_id", UUID.randomUUID().toString());
        apiHeader.put("interface_id", interfaceId);
        return apiHeader;
    }

    public static String makeRequestBody(Map<String, Object> header, Map<String, Object> data) {
        HashMap<String, Map<String, Object>> requestBodyMap = new HashMap<String, Map<String, Object>>();
        requestBodyMap.put("header", header);
        requestBodyMap.put("data", data);
        return JsonUtil.buildNormalBinder().toJson(requestBodyMap);
    }

    public static Map<String, String> makeApiHeader() {
        HashMap<String, String> requestBodyMap = new HashMap<String, String>();
        requestBodyMap.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])"MPF_WS:Swiftpo@2021".getBytes()));
        return requestBodyMap;
    }

    public static ResponseEntity<Map> postForEntity(String url, String requestBody, Map<String, String> apiHeader) {
        RestTemplate client = RequestUtils.getRestTemplate();
        client.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        HttpHeaders headers = RequestUtils.getHttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        return client.postForEntity(url, (Object)requestEntity, Map.class, new Object[0]);
    }

    public static Map<String, Object> getForEntity(String url, Map<String, String> apiHeader) {
        RestTemplate client = RequestUtils.getRestTemplate();
        HttpHeaders headers = RequestUtils.getHttpHeaders();
        for (String headerKey : apiHeader.keySet()) {
            headers.add(headerKey, apiHeader.get(headerKey));
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        factory.setHttpClient((HttpClient)httpClient);
        client.setRequestFactory((ClientHttpRequestFactory)factory);
        Map response = (Map)client.exchange(url, HttpMethod.GET, requestEntity, Map.class, new Object[0]).getBody();
        return response;
    }

    public static RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    public static HttpHeaders getHttpHeaders() {
        return new HttpHeaders();
    }
}

