/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.yankon.oa.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class StringConvertUtil {
    public static BigDecimal getBigDecimal(Object value) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static BigDecimal getBigDecimal(Object value, BigDecimal defaultValue) {
        if (null == value && null == defaultValue) {
            return BigDecimal.ZERO;
        }
        if (null == value && null != defaultValue) {
            return defaultValue;
        }
        return StringConvertUtil.getBigDecimal(value);
    }

    public static String filterOffUtf8Mb4_2(String text) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes("utf-8");
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            short b = bytes[i];
            if (b > 0) {
                buffer.put(bytes[i++]);
                continue;
            }
            if (((b = (short)(b + 256)) >> 5 ^ 6) == 0) {
                buffer.put(bytes, i, 2);
                i += 2;
                continue;
            }
            if ((b >> 4 ^ 0xE) == 0) {
                buffer.put(bytes, i, 3);
                i += 3;
                continue;
            }
            if ((b >> 3 ^ 0x1E) == 0) {
                i += 4;
                continue;
            }
            if ((b >> 2 ^ 0xBE) == 0) {
                i += 5;
                continue;
            }
            i += 6;
        }
        buffer.flip();
        return new String(buffer.array(), "utf-8");
    }

    public static String filterUtf8mb4(String str) {
        int LAST_BMP = 65535;
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int codePoint = str.codePointAt(i);
            if (codePoint < 65535) {
                sb.appendCodePoint(codePoint);
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String valueOf(Object obj) {
        return "null".equals(String.valueOf(obj)) ? "" : String.valueOf(obj);
    }
}

