/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.yankon.oa.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.router.HttpResponseBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.yankon.oa.common.constant.ResultCodeEnum;
import com.yqbsoft.laser.service.yankon.oa.domain.MemjobListDomain;
import com.yqbsoft.laser.service.yankon.oa.domain.RebMemjobListDomain;
import com.yqbsoft.laser.service.yankon.oa.domain.RebUpointsListDomain;
import com.yqbsoft.laser.service.yankon.oa.domain.ResponseData;
import com.yqbsoft.laser.service.yankon.oa.model.RebMemjobList;
import com.yqbsoft.laser.service.yankon.oa.service.MemjobListService;
import com.yqbsoft.laser.service.yankon.oa.utils.ValidatorUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class MemjobListServiceImpl
extends BaseServiceImpl
implements MemjobListService {
    ObjectMapper mapper = new ObjectMapper();
    private String SYS_CODE = "yankonOA.MemjobListServiceImpl";
    private final int MAX_SEND_COUNT = 200;
    private final String OA_MEMJOBLIST_URL = "oa.xxxxxxxxxx.com";

    @Override
    public String addMemjobList(List<MemjobListDomain> memjobListDomainList) throws IOException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(memjobListDomainList)) {
            this.logger.error(this.SYS_CODE + ".addMemjobList", (Object)"memjobList is empty!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg()));
        }
        StringBuilder sb = new StringBuilder();
        String str = null;
        for (MemjobListDomain memjob : memjobListDomainList) {
            Integer dataState;
            str = ValidatorUtil.validateDto(memjob);
            if (StringUtils.isNotBlank((String)str)) {
                sb.append(memjob.getMemjobListCode() + "\u53c2\u6570\u9519\u8bef\uff1a" + str);
            }
            if ((dataState = memjob.getDataState()) == 1 || dataState == 2) continue;
            sb.append("\u5ba1\u6838\u72b6\u6001\u975e\u6cd5;");
        }
        if (sb.length() > 0) {
            this.logger.error(this.SYS_CODE + ".addMemjobList", (Object)("memjobList param error!\t" + sb.toString()));
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), sb.toString()));
        }
        HashMap<String, RebMemjobList> oldRmjlMap = new HashMap<String, RebMemjobList>();
        for (MemjobListDomain memjobListDomain : memjobListDomainList) {
            str = this.getOldMemjobList(memjobListDomain.getMemjobListCode(), "00000000", oldRmjlMap);
            if (!StringUtils.isNotBlank((String)str)) continue;
            this.logger.error(this.SYS_CODE + ".addMemjobList.getMemjobListByCode", (Object)str);
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), str));
        }
        for (MemjobListDomain memjobListDomain : memjobListDomainList) {
            RebMemjobListDomain rebMemjob = new RebMemjobListDomain();
            BeanUtils.copyProperties(oldRmjlMap.get(memjobListDomain.getMemjobListCode()), (Object)rebMemjob);
            BeanUtils.copyProperties((Object)memjobListDomain, (Object)rebMemjob);
            rebMemjob.setTenantCode("00000000");
            paramsMap.clear();
            paramsMap.put("rebMemjobListDomain", JsonUtil.buildNormalBinder().toJson((Object)rebMemjob));
            this.getInternalRouter().inInvoke("reb.memjobList.updateMemjobList", paramsMap);
            paramsMap.clear();
            paramsMap.put("tenantCode", rebMemjob.getTenantCode());
            paramsMap.put("memjobListCode", memjobListDomain.getMemjobListCode());
            paramsMap.put("dataState", memjobListDomain.getDataState());
            paramsMap.put("oldDataState", 0);
            paramsMap.put("map", null);
            this.getInternalRouter().inInvoke("reb.memjobList.updateMemjobListStateByCode", paramsMap);
            if (memjobListDomain.getDataState() != 1) continue;
            RebUpointsListDomain ruld = this.createRebUpointsList((RebMemjobList)oldRmjlMap.get(memjobListDomain.getMemjobListCode()), memjobListDomain);
            paramsMap.clear();
            paramsMap.put("rebUpointsListDomain", JsonUtil.buildNormalBinder().toJson((Object)ruld));
            this.getInternalRouter().inInvoke("reb.upointsClear.saveUpointsByList", paramsMap);
        }
        return this.buildSuccResponse(new ResponseData<Object>());
    }

    private RebUpointsListDomain createRebUpointsList(RebMemjobList oldRmjl, MemjobListDomain newMjld) {
        RebUpointsListDomain ruld = new RebUpointsListDomain();
        BeanUtils.copyProperties((Object)newMjld, (Object)ruld);
        ruld.setUpointsType(oldRmjl.getMemjobType());
        ruld.setUpointsListDirection("0");
        ruld.setUpointsListNum(newMjld.getMemjobListLimit());
        ruld.setUpointsListOpmark(newMjld.getMemjobAuremark());
        ruld.setChannelCode(oldRmjl.getFchannelClassifyCode());
        ruld.setChannelName(oldRmjl.getFchannelClassifyName());
        return ruld;
    }

    private String getOldMemjobList(String memjobListCode, String tenantCode, Map<String, RebMemjobList> map) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String str = "";
        paramsMap.put("memjobListCode", memjobListCode);
        paramsMap.put("tenantCode", tenantCode);
        String json = (String)this.getInternalRouter().inInvoke("reb.memjobList.getMemjobListByCode", paramsMap);
        if (StringUtils.isBlank((String)json)) {
            str = memjobListCode + "\tmemjobList is null!";
            return str;
        }
        RebMemjobList oldMjl = (RebMemjobList)JsonUtil.buildNormalBinder().getJsonToObject(json, RebMemjobList.class);
        if (oldMjl == null) {
            str = memjobListCode + "\tmemjobList not exist!";
            return str;
        }
        if (oldMjl.getDataState() != 0) {
            str = memjobListCode + "\tmemjobList dataState not 0!";
            return str;
        }
        map.put(memjobListCode, oldMjl);
        return str;
    }

    @Override
    public String sendMemjobList(String memjobListCodes) throws IOException {
        this.logger.info(this.SYS_CODE + ".sendMemjobList-1", (Object)memjobListCodes);
        if (StringUtils.isBlank((String)memjobListCodes)) {
            this.logger.error(this.SYS_CODE + ".sendMemjobList", (Object)"memjobListCodes is null!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "memjobListCodes is null!"));
        }
        if (memjobListCodes.split(",").length > 200) {
            this.logger.error(this.SYS_CODE + ".sendMemjobList", (Object)"memjobListCode list must <= 200!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "\u540c\u6b65\u8bb0\u5f55\u8fc7\u591a\uff0c\u6bcf\u6b21\u6700\u591a\u540c\u6b65200\u6761"));
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fuzzy", false);
        map.put("memjobListCode", memjobListCodes);
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("reb.memjobList.queryMemjobListPage", paramsMap);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".json is null ", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "memjobListCodes\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (null == queryResult || CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".sendMemjobList.queryMemjobListPage,memjobListCodes\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01 memjobListCodes:" + memjobListCodes);
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "memjobListCodes\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        String sendResult = this.sendToOA(queryResult.getList());
        if (StringUtils.isNotBlank((String)sendResult)) {
            this.logger.error(this.SYS_CODE + ".sendMemjobList.sendToOA error\uff01 memjobListCodes:" + memjobListCodes, (Object)sendResult);
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "\u540c\u6b65OA\u5931\u8d25"));
        }
        return this.buildSuccResponse(new ResponseData<Object>(ResultCodeEnum.SUCCESS.getResultCode(), "\u6210\u529f\u540c\u6b65OA" + queryResult.getList().size() + "\u6761\uff01"));
    }

    private String sendToOA(List<RebMemjobList> list) {
        return null;
    }

    private String buildSuccResponse(ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildFailResponse(int httpStatus, ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpStatus(httpStatus);
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }
}

