/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.zihexin.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.zihexin.ZihexinConstants;
import com.yqbsoft.laser.service.ext.channel.zihexin.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.zihexin.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.AesUtil;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.Base64Util;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.CharUtil;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.HttpClientUtil;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.RsaUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String CODE = "zihexin.ChannelInServiceImpl";
    private static String billPay = "/ott/billPay";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String getFchannelCode() {
        return ZihexinConstants.CHANNEL_CODE;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelInBaseService.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelInBaseService.sign.null", "");
        }
        String fchannelApiUrl = channelRequest.getCmFchannelApi().getFchannelApiUrl();
        Map configMap = channelRequest.getConfigMap();
        Map requestData = channelRequest.getRequestData();
        HashMap<String, Object> datMap = new HashMap<String, Object>();
        ArrayList goodsList = new ArrayList();
        BigDecimal addCost = BigDecimal.ZERO;
        String ocContractDomain = (String)requestData.get("ocContractDomain");
        String ocContractDomainList = (String)requestData.get("ocContractDomainList");
        if (StringUtils.isNotBlank((String)ocContractDomain)) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractDomain, OcContractReDomain.class);
            for (OcContractGoodsDomain contractGoodsDomain : ocContractReDomain.getGoodsList()) {
                HashMap<String, Object> goodsListMap = new HashMap<String, Object>();
                goodsListMap.put("goodsId", contractGoodsDomain.getSkuNo());
                goodsListMap.put("goodsName", contractGoodsDomain.getGoodsName() + contractGoodsDomain.getSkuName());
                goodsListMap.put("buyCount", contractGoodsDomain.getGoodsCamount().setScale(0, 5));
                BigDecimal cost = contractGoodsDomain.getGoodsCamount().multiply(contractGoodsDomain.getPricesetAsprice()).setScale(2, 5);
                goodsListMap.put("cost", cost);
                addCost = addCost.add(cost);
                goodsList.add(goodsListMap);
            }
            datMap.put("orderNo", channelRequest.getCmChannelClear().getChannelClearSeqno());
            datMap.put("orderAmount", ocContractReDomain.getDataBmoney().setScale(2, 5));
            datMap.put("returnUrl", requestData.get("returnUrl"));
            datMap.put("notifyUrl", configMap.get("notifyUrl"));
            datMap.put("ott_goods_id", requestData.get("ott_goods_id"));
            datMap.put("goodsList", goodsList);
            datMap.put("user_id_ott", requestData.get("user_id_ott"));
            datMap.put("user_id_merchant", ocContractReDomain.getMemberBcode());
            Date now = new Date();
            String time = this.sdf.format(now);
            datMap.put("orderTime", time);
            datMap.put("express", ocContractReDomain.getGoodsLogmoney().setScale(2, 5));
            datMap.put("paymentAmount", addCost.setScale(2, 5));
        }
        if (StringUtils.isNotBlank((String)ocContractDomainList)) {
            String userId = "";
            BigDecimal logmoney = BigDecimal.ZERO;
            BigDecimal dataBmoney = BigDecimal.ZERO;
            List ocContractReDomainList = JsonUtil.buildNormalBinder().getJsonToList(ocContractDomainList, OcContractReDomain.class);
            for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
                for (OcContractGoodsDomain contractGoodsDomain : ocContractReDomain.getGoodsList()) {
                    HashMap<String, Object> goodsListMap = new HashMap<String, Object>();
                    goodsListMap.put("goodsId", contractGoodsDomain.getSkuNo());
                    goodsListMap.put("goodsName", contractGoodsDomain.getGoodsName() + contractGoodsDomain.getSkuName());
                    goodsListMap.put("buyCount", contractGoodsDomain.getGoodsCamount().setScale(0, 5));
                    BigDecimal cost = contractGoodsDomain.getGoodsCamount().multiply(contractGoodsDomain.getPricesetAsprice()).setScale(2, 5);
                    goodsListMap.put("cost", cost);
                    addCost = addCost.add(cost);
                    goodsList.add(goodsListMap);
                }
                userId = ocContractReDomain.getMemberBcode();
                logmoney = logmoney.add(ocContractReDomain.getGoodsLogmoney());
                dataBmoney = dataBmoney.add(ocContractReDomain.getGoodsLogmoney());
            }
            datMap.put("orderNo", channelRequest.getCmChannelClear().getChannelClearSeqno());
            datMap.put("orderAmount", dataBmoney.setScale(2, 5));
            datMap.put("returnUrl", requestData.get("returnUrl"));
            datMap.put("notifyUrl", configMap.get("notifyUrl"));
            datMap.put("ott_goods_id", requestData.get("ott_goods_id"));
            datMap.put("goodsList", goodsList);
            datMap.put("user_id_ott", requestData.get("user_id_ott"));
            datMap.put("user_id_merchant", userId);
            Date now = new Date();
            String time = this.sdf.format(now);
            datMap.put("orderTime", time);
            datMap.put("express", logmoney.setScale(2, 5));
            datMap.put("paymentAmount", addCost.setScale(2, 5));
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("merchantID", configMap.get("merchantID"));
        String privateKey = (String)configMap.get("privateKey");
        String publicKey = (String)configMap.get("publicKey");
        String jsonObject = JsonUtil.buildNormalBinder().toJson(datMap);
        this.logger.error("cmc.ChannelInBaseService.httpInvoke.jsonObject", (Object)jsonObject);
        String aesPassword = CharUtil.createRandomStr(16);
        String paramEncode = null;
        String signEncode = null;
        String keyPassEncode = null;
        try {
            paramEncode = Base64Util.encode(AesUtil.encryptStr(jsonObject, aesPassword).getBytes());
            signEncode = RsaUtil.sign(jsonObject, privateKey, "utf-8", "");
            keyPassEncode = Base64Util.encode(RsaUtil.encrypt(publicKey, aesPassword.getBytes()));
            requestMap.put("data", paramEncode);
            requestMap.put("sign", signEncode);
            requestMap.put("keyPass", keyPassEncode);
            this.logger.error("zihexin.ChannelInServiceImpl.httpInvoke.requestMap", (Object)JsonUtil.buildNormalBinder().toJson(requestMap));
            String postjson = HttpClientUtil.post(fchannelApiUrl + billPay, requestMap, null, null, null);
            this.logger.error("zihexin.ChannelInServiceImpl.httpInvoke.postjson", (Object)postjson);
            Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(postjson, String.class, String.class);
            return this.unCipherPassAndDataD((String)jsonToMap.get("data"), (String)jsonToMap.get("keyPass"), privateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String unCipherPassAndDataD(String data, String keypass, String privateKey) throws Exception {
        keypass = new String(RsaUtil.decrypt(privateKey, Base64Util.decode(keypass)));
        String param = AesUtil.decrypt(new String(Base64Util.decode(data)), keypass);
        this.logger.error("zihexin.ChannelInServiceImpl.unCipherPassAndDataD", (Object)param);
        return param;
    }
}

