/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.sign.service.impl;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.v5_1.req.template.GetSignTemplateListReq;
import com.fasc.open.api.v5_1.req.template.SignTemplateDetailReq;
import com.fasc.open.api.v5_1.res.template.SignTemplateDetailRes;
import com.fasc.open.api.v5_1.res.template.SignTemplateListInfo;
import com.fasc.open.api.v5_1.res.template.SignTemplateListRes;
import com.yqbsoft.laser.bus.ext.data.sign.context.OpenApiExecutionContext;
import com.yqbsoft.laser.bus.ext.data.sign.request.QuerySignTemplateRequest;
import com.yqbsoft.laser.bus.ext.data.sign.service.OpenApiContextService;
import com.yqbsoft.laser.bus.ext.data.sign.service.SignTemplateService;
import com.yqbsoft.laser.bus.ext.data.sign.supbase.BusBaseService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class SignTemplateServiceImpl
extends BusBaseService
implements SignTemplateService {
    private static final String SYS_CODE = "datasign.SignTemplateServiceImpl";
    @Autowired
    private OpenApiContextService openApiContextService;

    @Override
    public QueryResult<SignTemplateListInfo> querySignTemplate(QuerySignTemplateRequest request) throws ApiException {
        String METHOD_NAME = ".querySignTemplate";
        this.logger.info("datasign.SignTemplateServiceImpl.querySignTemplate", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)request)));
        OpenApiExecutionContext context = this.openApiContextService.getExecutionContext(request.getTenantCode());
        GetSignTemplateListReq req = context.initGetSignTemplateListReq();
        req.setListFilter(request.getListFilter());
        req.setListPageNo(request.getPageNo());
        req.setListPageSize(request.getPageSize());
        try {
            BaseRes res = context.getTemplateClient().getSignTemplateList(req);
            this.printLog(SYS_CODE, ".querySignTemplate", res, context.getOpenApiClient().getJsonStrategy());
            SignTemplateListRes signTemplateListRes = (SignTemplateListRes)res.getData();
            QueryResult queryResult = new QueryResult();
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(signTemplateListRes.getTotalCount().intValue());
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(signTemplateListRes.getSignTemplates());
            return queryResult;
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTemplateServiceImpl.querySignTemplate", (Object)"\u83b7\u53d6\u7b7e\u7f72\u6a21\u677f\u5217\u8868\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".querySignTemplate", "\u83b7\u53d6\u7b7e\u7f72\u6a21\u677f\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @Override
    public SignTemplateDetailRes getSignTemplateDetail(String tenantCode, String signTemplateId) throws ApiException {
        String METHOD_NAME = ".getSignTemplateDetail";
        this.logger.info("datasign.SignTemplateServiceImpl.getSignTemplateDetail", (Object)(":params:tenantCode=" + tenantCode + ", signTemplateId=" + signTemplateId));
        OpenApiExecutionContext context = this.openApiContextService.getExecutionContext(tenantCode);
        SignTemplateDetailReq req = context.initSignTemplateDetailReq();
        req.setSignTemplateId(signTemplateId);
        try {
            BaseRes signTemplateDetailResBaseRes = context.getTemplateClient().getSignTemplateDetail(req);
            this.printLog(SYS_CODE, ".getSignTemplateDetail", signTemplateDetailResBaseRes, context.getOpenApiClient().getJsonStrategy());
            return (SignTemplateDetailRes)signTemplateDetailResBaseRes.getData();
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTemplateServiceImpl.getSignTemplateDetail", (Object)"\u67e5\u8be2\u7b7e\u7f72\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".getSignTemplateDetail", "\u67e5\u8be2\u7b7e\u7f72\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff01");
        }
    }
}

