/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.finance.facade.http;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.finance.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.bus.finance.common.SupperFacade;
import com.yqbsoft.laser.service.ext.bus.finance.common.SupperRequest;
import com.yqbsoft.laser.service.ext.bus.finance.common.SupperResponse;
import com.yqbsoft.laser.service.ext.bus.finance.facade.http.RequestUtils;
import com.yqbsoft.laser.service.ext.bus.finance.util.AesUtil;
import com.yqbsoft.laser.service.ext.bus.finance.util.RSAUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service(value="restTempfacade")
public class RestTempfacade
extends SupperFacade {
    private static String SYS_CODE = "extf.RestTempfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(RestTempfacade.class);

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        String json;
        if (null == supperRequest) {
            return null;
        }
        logger.info(SYS_CODE + ".execute.Request", (Object)(supperRequest.getHost() + supperRequest.getOutsideApiUrl()));
        logger.info(SYS_CODE + ".execute.Request.OrderNo", (Object)(supperRequest.getInsideOrderNo() + "===" + supperRequest.getOutsideOrderNo()));
        logger.info(SYS_CODE + ".execute.Request.PARAM", supperRequest.getTextParams());
        Long s = System.currentTimeMillis();
        HashMap<String, String> apiHeader = new HashMap<String, String>();
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode(supperRequest.getOutsideApiUrl());
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        String msg = JsonUtil.buildNormalBinder().toJson(supperRequest.getTextParams());
        logRouterlogDomain.setRouterlogMessage(msg);
        logRouterlogDomain.setRouterlogMesid(supperRequest.getOutsideOrderNo());
        logRouterlogDomain.setRouterlogMespid(supperRequest.getInsideOrderNo());
        logRouterlogDomain.setTenantCode(supperRequest.getOrgTenantCode());
        try {
            String url = supperRequest.getHost();
            url = url.replace("{apiCode}", supperRequest.getOutsideApiUrl());
            logger.info(SYS_CODE + ".execute.url", (Object)url);
            String data = JsonUtil.buildNormalBinder().toJson(supperRequest.getTextParams());
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bizContent = AesUtil.aesEncrypt(data, supperRequest.getAuthorization());
            map.put("bizContent", bizContent);
            String var = RSAUtil.buildOrderedSignStr(map);
            String sign = RSAUtil.sign(var, supperRequest.getClientsecret());
            map.put("sign", sign);
            apiHeader.put("appId", supperRequest.getClientid());
            logger.info(SYS_CODE + ".execute.Request.map", map);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("bizContent", bizContent);
            paramMap.put("sign", sign);
            json = RequestUtils.postForEntity(url, MediaType.APPLICATION_JSON, paramMap, apiHeader);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".execute.post", (Throwable)e);
        }
        Long s1 = System.currentTimeMillis();
        logger.info(SYS_CODE + ".execute.\u8017\u65f6" + (s1 - s));
        logger.info(SYS_CODE + ".execute.Response", (Object)supperRequest.getOutsideApiUrl());
        logger.info(SYS_CODE + ".execute.Response.OrderNo", (Object)(supperRequest.getInsideOrderNo() + "===" + supperRequest.getOutsideOrderNo()));
        if (StringUtils.isBlank((String)json)) {
            logger.error(SYS_CODE + ".execute.null", (Object)"\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("json");
            logRouterlogDomain.setRouterlogReturnstates("json is null");
            logRouterlogDomain.setRouterlogType("2");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(SYS_CODE + ".execute.json", "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        logger.info(SYS_CODE + ".execute.json", (Object)json);
        json = this.decrypt(json, supperRequest.getAccessToken(), supperRequest.getAuthorization());
        logger.info(SYS_CODE + ".execute.json1", (Object)json);
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException(SYS_CODE + ".execute.localResponse", (Throwable)xe);
        }
        localResponse.setMsg(json);
        localResponse.makeDomain(json);
        logRouterlogDomain.setRouterlogReturn(json);
        logRouterlogDomain.setRouterlogReturnstate(localResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(localResponse.getMsg());
        logRouterlogDomain.setRouterlogType(localResponse.getSuccess() != false ? "0" : "1");
        this.sendLog(logRouterlogDomain);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public String decrypt(String content, String pubkey, String aeskey) {
        HashMap rvd = (HashMap)JSON.parseObject((String)content, HashMap.class);
        String sign = (String)rvd.get("sign");
        rvd.remove("sign");
        String data = RSAUtil.buildOrderedSignStr(rvd);
        boolean flag = false;
        try {
            flag = RSAUtil.verify(data, sign, pubkey);
        }
        catch (Exception e) {
            logger.error(SYS_CODE + ".decrypt.e", (Object)(pubkey + "==>" + aeskey), (Throwable)e);
        }
        if (!flag) {
            logger.error(SYS_CODE + ".decrypt.return", (Object)(pubkey + "==>" + aeskey));
            throw new ApiException(SYS_CODE + ".decrypt.return", " sign verify not passed.");
        }
        String bizContent = (String)rvd.get("bizContent");
        String bodyStr = AesUtil.aesDecrypt(bizContent, aeskey);
        return bodyStr;
    }

    public RestTempfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public RestTempfacade(String host, String accessToken) {
        super(host, accessToken);
    }

    public RestTempfacade(String host) {
        super(host);
    }

    public RestTempfacade(Map<String, Object> map) {
        super(map);
    }

    public RestTempfacade() {
    }
}

