/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.finance.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class RSAUtil {
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int KEY_SIZE = 1024;

    public static Map<String, String> initKey() throws Exception {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance(RSA_KEY_ALGORITHM);
        SecureRandom secrand = new SecureRandom();
        secrand.setSeed(UUID.randomUUID().toString().replace("-", "").getBytes());
        keygen.initialize(1024, secrand);
        KeyPair keys = keygen.genKeyPair();
        byte[] pub_key = keys.getPublic().getEncoded();
        String publicKeyString = Base64.encodeBase64String((byte[])pub_key);
        byte[] pri_key = keys.getPrivate().getEncoded();
        String privateKeyString = Base64.encodeBase64String((byte[])pri_key);
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("pubKey", publicKeyString);
        keyPairMap.put("priKey", privateKeyString);
        return keyPairMap;
    }

    public static String encodeBase64String(byte[] key) {
        return Base64.encodeBase64String((byte[])key);
    }

    public static byte[] decodeBase64(String key) {
        return Base64.decodeBase64((String)key);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        return Base64.decodeBase64((byte[])base64Data);
    }

    public static String encryptByPubKey(String data, String publicKey) throws Exception {
        byte[] pubKey = RSAUtil.decodeBase64(publicKey);
        byte[] enSign = RSAUtil.encryptByPubKey(data.getBytes(), pubKey);
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static byte[] encryptByPubKey(byte[] data, byte[] pubKey) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static String encryptByPriKey(String data, String privateKey) throws Exception {
        byte[] priKey = RSAUtil.decodeBase64(privateKey);
        byte[] enSign = RSAUtil.encryptByPriKey(data.getBytes(), priKey);
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static byte[] encryptByPriKey(byte[] data, byte[] priKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPubKey(byte[] data, byte[] pubKey) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        int inputLen = data.length;
        int offLen = 0;
        int i = 0;
        ByteArrayOutputStream bops = new ByteArrayOutputStream();
        while (inputLen - offLen > 0) {
            byte[] cache = inputLen - offLen > 117 ? cipher.doFinal(data, offLen, 117) : cipher.doFinal(data, offLen, inputLen - offLen);
            bops.write(cache);
            offLen = 117 * ++i;
        }
        bops.close();
        byte[] encryptedData = bops.toByteArray();
        return encryptedData;
    }

    public static String decryptByPubKey(String data, String publicKey) throws Exception {
        byte[] pubKey = RSAUtil.decodeBase64(publicKey);
        byte[] design = RSAUtil.decryptByPubKey(Base64.decodeBase64((String)data), pubKey);
        return new String(design);
    }

    public static byte[] decryptByPriKey(byte[] data, byte[] priKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        int inputLen = data.length;
        int offLen = 0;
        int i = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (inputLen - offLen > 0) {
            byte[] cache = inputLen - offLen > 128 ? cipher.doFinal(data, offLen, 128) : cipher.doFinal(data, offLen, inputLen - offLen);
            byteArrayOutputStream.write(cache);
            offLen = 128 * ++i;
        }
        byteArrayOutputStream.close();
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return byteArray;
    }

    public static String decryptByPriKey(String data, String privateKey) throws Exception {
        byte[] priKey = RSAUtil.decodeBase64(privateKey);
        byte[] design = RSAUtil.decryptByPriKey(Base64.decodeBase64((String)data), priKey);
        return new String(design);
    }

    public static String sign(String data, String privateKey) throws Exception {
        byte[] priKey = RSAUtil.decodeBase64(privateKey);
        return RSAUtil.sign(data.getBytes(), priKey);
    }

    public static String sign(byte[] data, byte[] priKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verify(String data, String sign, String publicKey) throws Exception {
        return RSAUtil.verify(data.getBytes(), RSAUtil.decodeBase64(sign.getBytes()), RSAUtil.decodeBase64(publicKey));
    }

    public static boolean verify(byte[] data, byte[] sign, byte[] pubKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKey);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(sign);
    }

    public static String buildOrderedSignStr(Map<String, Object> var1) {
        TreeMap<String, Object> var2 = new TreeMap<String, Object>();
        var2.putAll(var1);
        Set var3 = var2.entrySet();
        boolean var4 = false;
        StringBuilder var5 = new StringBuilder();
        for (Map.Entry var7 : var3) {
            String var8 = (String)var7.getKey();
            String var9 = String.valueOf(var7.getValue());
            if (!StringUtils.isNotEmpty((String)var8) || !StringUtils.isNotEmpty((String)var9)) continue;
            if (var4) {
                var5.append("&");
            } else {
                var4 = true;
            }
            var5.append(var8).append("=").append(var9);
        }
        return var5.toString();
    }
}

