/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.sap.executes;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.yqbsoft.laser.service.ims.sap.executes.JCOProvider;
import java.util.Properties;

public class RfcManager {
    private static final String ABAP_AS_POOLED = "ABAP_AS_POOL";
    private static JCOProvider provider;
    private static JCoDestination destination;

    public static Properties loadProperties() {
        Properties props = new Properties();
        props.setProperty("jco.client.user", "INT_WSC");
        props.setProperty("jco.client.passwd", "L@ncy2022");
        props.setProperty("jco.client.lang", "ZH");
        props.setProperty("jco.client.client", "500");
        props.setProperty("jco.client.sysnr", "01");
        props.setProperty("jco.client.ashost", "192.168.5.17");
        return props;
    }

    public static JCoFunction getFunction(String functionName) {
        JCoFunction function = null;
        try {
            function = RfcManager.getDestination().getRepository().getFunctionTemplate(functionName).getFunction();
        }
        catch (JCoException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return function;
    }

    public static JCoDestination getDestination() throws JCoException {
        if (destination == null) {
            destination = JCoDestinationManager.getDestination((String)ABAP_AS_POOLED);
        }
        return destination;
    }

    public static void execute(JCoFunction function) {
        System.out.println("SAP Function Name : " + function.getName());
        try {
            function.execute(RfcManager.getDestination());
        }
        catch (JCoException e) {
            e.printStackTrace();
        }
    }

    static {
        Properties properties = RfcManager.loadProperties();
        try {
            provider = new JCOProvider();
            Environment.registerDestinationDataProvider((DestinationDataProvider)provider);
            provider.changePropertiesForABAP_AS(ABAP_AS_POOLED, properties);
        }
        catch (IllegalStateException e) {
            System.out.println(e.getMessage());
        }
    }
}

