/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oms.domain.EditSkuDomain;
import com.yqbsoft.laser.service.oms.domain.OcContractReDomain;
import com.yqbsoft.laser.service.oms.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.oms.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.oms.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.oms.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.oms.domain.SkuShopDomain;
import com.yqbsoft.laser.service.oms.service.OrderService;
import com.yqbsoft.laser.service.oms.utils.AddressResolution;
import com.yqbsoft.laser.service.oms.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static final String tenantCode = "2022012800000001";

    @Override
    public SupQueryResult<RsResourceGoodsReDomain> downloadMarketableGoods(String shopCode, String spuCode, String dwStartDate, String dwEndDate, Integer pageIndex, Integer pageSize) {
        this.logger.info("shopCode:" + shopCode + "spuCode:" + spuCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (shopCode == null && spuCode == null) {
            throw new ApiException("\u5e97\u94fa\u7f16\u7801\u548c\u5546\u54c1\u6b3e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (shopCode != null) {
            map.put("memberCode", shopCode);
        }
        if (shopCode == null && spuCode != null) {
            map.put("goodsEocode", spuCode);
        }
        if (dwStartDate != null && dwEndDate != null) {
            map.put("startDate", dwStartDate);
            map.put("endDate", dwEndDate);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsType", "00");
        HashMap<String, String> pMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", "1");
        map.put("fuzzy", true);
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pMap, RsResourceGoodsReDomain.class);
        if (rs == null) {
            throw new ApiException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        rs.getList().forEach(rsResourceGoodsReDomain -> {
            HashMap<String, String> sMap = new HashMap<String, String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            hashMap.put("goodsShowno", rsResourceGoodsReDomain.getGoodsNo());
            hashMap.put("tenantCode", tenantCode);
            hashMap.put("fuzzy", true);
            sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(hashMap));
            QueryResult sku = this.getQueryResutl("rs.sku.querySkuPage", sMap, RsSkuReDomain.class);
            this.logger.info("goodsCode---------" + rsResourceGoodsReDomain.getGoodsCode() + "goodsShowno----------" + rsResourceGoodsReDomain.getGoodsNo());
            List list = sku.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                rsResourceGoodsReDomain.setRsSkuReDomain(list);
            }
        });
        return rs;
    }

    @Override
    public String sendSgSendgoods(String skuCode, Integer goodsNum) {
        if (skuCode == null || goodsNum == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "skuCode:" + skuCode + "goodsNum" + goodsNum);
        }
        HashMap<String, String> skMap = new HashMap<String, String>();
        skMap.put("skuCode", skuCode);
        HashMap<String, String> sMap = new HashMap<String, String>();
        sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(skMap));
        sMap.put("tenantCode", tenantCode);
        QueryResult sku = this.getQueryResutl("rs.sku.querySkuOnePage", sMap, RsSkuReDomain.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (sku != null) {
            try {
                BeanUtils.copyAllPropertys((Object)editSkuDomain, sku.getList().get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.info("-------------------------------editSkuDomain:" + editSkuDomain.getGoodsNum());
        editSkuDomain.setGoodsNum(BigDecimal.valueOf(goodsNum.intValue()));
        editSkuDomain.setGoodsSupplynum(BigDecimal.valueOf(goodsNum.intValue()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        map.put("tenantCode", tenantCode);
        this.logger.info("-------------------------------editSkuDomain:" + editSkuDomain.getGoodsNum());
        this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", map);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public SupQueryResult<OcContractReDomain> downloadContracts(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus) {
        this.logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberName", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("dwStartTime", dwStartTime);
            map.put("dwEndTime", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("childFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("oc.contract.queryContractPageReDomain", pMap, OcContractReDomain.class);
        ocContractReDomainSupQueryResult.getRows().forEach(ocContractReDomain -> {
            Map<String, String> aMap = AddressResolution.addressResolution(ocContractReDomain.getGoodsReceiptArrdess());
            ocContractReDomain.setProvinceName(aMap.get("province"));
            ocContractReDomain.setCityName(aMap.get("city"));
            ocContractReDomain.setCountyName(aMap.get("county"));
        });
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    @Override
    public SupQueryResult<OcRefundReDomain> downloadRefundContracts(String refundType, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, boolean childFlag) {
        this.logger.info("orderStatus:" + orderStatus + "----refundType:" + refundType + "dwStartTime:" + dwStartTime + "page------" + pageIndex + "rows-------" + pageSize);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (refundType == null) {
            throw new ApiException("\u552e\u540e\u7533\u8bf7\u7c7b\u578b\u4e3a\u7a7a");
        }
        map.put("refundType", refundType);
        if (dwStartTime != null && dwEndTime != null) {
            map.put("startDate", dwStartTime);
            map.put("endDate", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("childFlag", childFlag);
        map.put("contractType", "00");
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult supQueryResult = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        supQueryResult.getRows().forEach(sq -> sq.setOrderStatus(sq.getDataState()));
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)supQueryResult));
        return supQueryResult;
    }

    @Override
    public String syncRefundContractsStatus(String refundCode, String contractBillcode) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (refundCode == null || contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        map.put("refundCode", refundCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        if (ocRefundReDomain == null) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ocRefundReDomain.getList().size() < 0) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OcRefundReDomain refundReDomain = (OcRefundReDomain)ocRefundReDomain.getList().get(0);
        HashMap<String, Integer> oMap = new HashMap<String, Integer>();
        oMap.put("refundId", refundReDomain.getRefundId());
        oMap.put("dataState", refundReDomain.getDataState());
        oMap.put("oldDataState", 3);
        HashMap<String, String> lMap = new HashMap<String, String>();
        lMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(oMap));
        this.getInternalRouter().inInvoke("oc.refund.updateRefundState", lMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String syncShippedPackageExpressInfo(String contractBillcode, String packageBillno, String expressCode, String expressName) {
        this.logger.info("contractBillcode:" + contractBillcode + "packageBillno--" + packageBillno + "---expressCode" + expressCode + "--expressName" + expressName);
        HashMap<String, String> map = new HashMap<String, String>();
        if (contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "-contractBillcode:" + contractBillcode);
        }
        map.put("expressCode", expressCode);
        map.put("expressName", expressName);
        map.put("packageBillno", packageBillno);
        map.put("sendgoodsLogName", "\u7269\u6d41\u4fe1\u606f\u540c\u6b65");
        map.put("sendgoodsLogMsg", "\u7269\u6d41\u4fe1\u606f\u540c\u6b65");
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        pMap.put("sendgoodsCode", contractBillcode);
        pMap.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("sg.sendgoodsEngine.sendSendgoodsNext", pMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String backRefundContractsStatus(String contractBillcode, String refundCode, boolean status) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        if (refundCode == null || contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (refundCode == null || contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        map.put("refundCode", refundCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        if (ocRefundReDomain == null) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ocRefundReDomain.getList().size() < 0) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OcRefundReDomain refundReDomain = (OcRefundReDomain)ocRefundReDomain.getList().get(0);
        HashMap<String, Integer> oMap = new HashMap<String, Integer>();
        oMap.put("refundId", refundReDomain.getRefundId());
        oMap.put("dataState", refundReDomain.getDataState());
        oMap.put("oldDataState", status ? 3 : 6);
        HashMap<String, String> lMap = new HashMap<String, String>();
        lMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(oMap));
        this.getInternalRouter().inInvoke("oc.refund.updateRefundState", lMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public List<SkuShopDomain> downloadMarketableGoodsAlter(String shopCode, String spuCode, String dwStartDate, String dwEndDate, Integer pageIndex, Integer pageSize) {
        ArrayList<SkuShopDomain> oList = new ArrayList<SkuShopDomain>();
        this.logger.info("shopCode:" + shopCode + "spuCode:" + spuCode + "--dwStartDate" + dwStartDate + "--dwEndDate" + dwEndDate);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (shopCode == null && spuCode == null) {
            throw new ApiException("\u5e97\u94fa\u7f16\u7801\u548c\u5546\u54c1\u6b3e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (shopCode != null) {
            map.put("memberCode", shopCode);
        }
        if (shopCode == null && spuCode != null) {
            map.put("goodsEocode", spuCode);
        }
        if (dwStartDate != null && dwEndDate != null) {
            map.put("startDate", dwStartDate);
            map.put("endDate", dwEndDate);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsType", "00");
        HashMap<String, String> pMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", "1");
        map.put("fuzzy", true);
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        HashMap goodsMap = new HashMap();
        QueryResult rs = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pMap, RsResourceGoodsReDomain.class);
        if (rs == null) {
            throw new ApiException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        rs.getList().forEach(rsResourceGoodsReDomain -> {
            List<RsResourceGoodsReDomain> rList;
            HashMap<String, String> sMap = new HashMap<String, String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            hashMap.put("goodsShowno", rsResourceGoodsReDomain.getGoodsNo());
            hashMap.put("tenantCode", tenantCode);
            hashMap.put("fuzzy", true);
            sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(hashMap));
            QueryResult sku = this.getQueryResutl("rs.sku.querySkuPage", sMap, RsSkuReDomain.class);
            this.logger.info("goodsCode---------" + rsResourceGoodsReDomain.getGoodsCode() + "goodsShowno----------" + rsResourceGoodsReDomain.getGoodsNo());
            List list = sku.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                rsResourceGoodsReDomain.setRsSkuReDomain(list);
            }
            if (shopCode != null) {
                rsResourceGoodsReDomain.setGoodsEocode(rsResourceGoodsReDomain.getGoodsEocode() == null ? "sku\u7a7a" : rsResourceGoodsReDomain.getGoodsEocode());
                if (goodsMap.containsKey(rsResourceGoodsReDomain.getGoodsEocode())) {
                    rList = (List)goodsMap.get(rsResourceGoodsReDomain.getGoodsEocode());
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getGoodsEocode(), rList);
                } else {
                    rList = new ArrayList<RsResourceGoodsReDomain>();
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getGoodsEocode(), rList);
                }
            }
            if (spuCode != null) {
                rsResourceGoodsReDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode() == null ? "shop\u7a7a" : rsResourceGoodsReDomain.getMemberCode());
                if (goodsMap.containsKey(rsResourceGoodsReDomain.getMemberCode())) {
                    rList = (List)goodsMap.get(rsResourceGoodsReDomain.getMemberCode());
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getMemberCode(), rList);
                } else {
                    rList = new ArrayList();
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getMemberCode(), rList);
                }
            }
        });
        for (Map.Entry m : goodsMap.entrySet()) {
            SkuShopDomain item = new SkuShopDomain();
            item.setSkuOshop((String)m.getKey());
            item.setGoodsList((List)m.getValue());
            item.setTotalCount(rs.getTotal());
            oList.add(item);
        }
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson(oList));
        return oList;
    }

    @Override
    public SupQueryResult<SgSendgoodsReDomain> downloadContractsChange(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, String contractBillcode) {
        this.logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime + "--dwEndTime" + dwEndTime + "--orderStatus" + orderStatus);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberCname", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("startDate", dwStartTime);
            map.put("endDate", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("sg.sendgoods.querySgSendgoodsPageReDomain", pMap, SgSendgoodsReDomain.class);
        if (ocContractReDomainSupQueryResult == null) {
            return new SupQueryResult();
        }
        if (ocContractReDomainSupQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        ocContractReDomainSupQueryResult.getRows().forEach(ocContractReDomain -> {
            Map<String, String> aMap = AddressResolution.addressResolution(ocContractReDomain.getGoodsReceiptArrdess());
            ocContractReDomain.setProvinceName(aMap.get("province"));
            ocContractReDomain.setCityName(aMap.get("city"));
            ocContractReDomain.setCountyName(aMap.get("county").replace(aMap.get("city"), ""));
            ocContractReDomain.setOrderStatus(ocContractReDomain.getDataState());
        });
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }
}

