/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oms.domain.EditSkuDomain;
import com.yqbsoft.laser.service.oms.domain.OcContractReDomain;
import com.yqbsoft.laser.service.oms.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.oms.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.oms.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.oms.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.oms.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.oms.domain.SkuShopDomain;
import com.yqbsoft.laser.service.oms.domain.UmUserinfoChannelReDomain;
import com.yqbsoft.laser.service.oms.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.oms.service.OrderService;
import com.yqbsoft.laser.service.oms.utils.AddressResolution;
import com.yqbsoft.laser.service.oms.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static final String tenantCode = "2022012800000001";

    @Override
    public SupQueryResult<RsResourceGoodsReDomain> downloadMarketableGoods(String shopCode, String spuCode, String dwStartDate, String dwEndDate, Integer pageIndex, Integer pageSize) {
        this.logger.info("shopCode:" + shopCode + "spuCode:" + spuCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)shopCode) && StringUtils.isBlank((String)spuCode)) {
            throw new ApiException("\u5e97\u94fa\u7f16\u7801\u548c\u5546\u54c1\u6b3e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)shopCode)) {
            map.put("memberCode", shopCode);
        }
        if (StringUtils.isBlank((String)shopCode) && StringUtils.isNotBlank((String)spuCode)) {
            map.put("goodsEocode", spuCode);
        }
        if (dwStartDate != null && dwEndDate != null) {
            map.put("startDate", dwStartDate);
            map.put("endDate", dwEndDate);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsType", "00");
        HashMap<String, String> pMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", "1");
        map.put("fuzzy", true);
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pMap, RsResourceGoodsReDomain.class);
        if (rs == null) {
            throw new ApiException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        rs.getList().forEach(rsResourceGoodsReDomain -> {
            HashMap<String, String> sMap = new HashMap<String, String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            hashMap.put("goodsShowno", rsResourceGoodsReDomain.getGoodsNo());
            hashMap.put("tenantCode", tenantCode);
            hashMap.put("fuzzy", true);
            sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(hashMap));
            QueryResult sku = this.getQueryResutl("rs.sku.querySkuPage", sMap, RsSkuReDomain.class);
            this.logger.info("goodsCode---------" + rsResourceGoodsReDomain.getGoodsCode() + "goodsShowno----------" + rsResourceGoodsReDomain.getGoodsNo());
            List list = sku.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                rsResourceGoodsReDomain.setRsSkuReDomain(list);
            }
        });
        return rs;
    }

    @Override
    public String sendSgSendgoods(String skuCode, Integer goodsNum) {
        this.logger.info("-------------------------------sendSgSendgoods:skuCode:" + skuCode + ":goodsNum:" + goodsNum);
        if (StringUtils.isBlank((String)skuCode) || goodsNum == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "skuCode:" + skuCode + "goodsNum" + goodsNum);
        }
        HashMap<String, String> skMap = new HashMap<String, String>();
        skMap.put("skuCode", skuCode);
        skMap.put("tenantCode", tenantCode);
        HashMap<String, String> sMap = new HashMap<String, String>();
        sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(skMap));
        QueryResult sku = this.getQueryResutl("rs.sku.querySkuOnePage", sMap, RsSkuReDomain.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (sku != null) {
            try {
                BeanUtils.copyAllPropertys((Object)editSkuDomain, sku.getList().get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.info("-------------------------------editSkuDomain:" + editSkuDomain.getGoodsNum());
        editSkuDomain.setGoodsNum(BigDecimal.valueOf(goodsNum.intValue()));
        editSkuDomain.setGoodsSupplynum(BigDecimal.valueOf(goodsNum.intValue()));
        editSkuDomain.setGoodsName(null);
        editSkuDomain.setGoodsRemark(null);
        editSkuDomain.setRsGoodsFileDomainList(null);
        editSkuDomain.setRsGoodsShopDomainList(null);
        editSkuDomain.setDataPic(null);
        HashMap<String, String> map = new HashMap<String, String>();
        this.logger.info("-------------------------------editSkuDomain:", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)editSkuDomain));
        map.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        map.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", map);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public SupQueryResult<OcContractReDomain> downloadContracts(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus) {
        this.logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberName", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("dwStartTime", dwStartTime);
            map.put("dwEndTime", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("childFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("oc.contract.queryContractPageReDomain", pMap, OcContractReDomain.class);
        ocContractReDomainSupQueryResult.getRows().forEach(ocContractReDomain -> {
            Map<String, String> aMap = AddressResolution.addressResolution(ocContractReDomain.getGoodsReceiptArrdess());
            ocContractReDomain.setProvinceName(aMap.get("province"));
            ocContractReDomain.setCityName(aMap.get("city"));
            ocContractReDomain.setCountyName(aMap.get("county"));
        });
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    @Override
    public SupQueryResult<OcRefundReDomain> downloadRefundContracts(String refundType, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, boolean childFlag, String brandChannelCode) {
        this.logger.info("orderStatus:" + orderStatus + "----refundType:" + refundType + "dwStartTime:" + dwStartTime + "page------" + pageIndex + "rows-------" + pageSize);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)refundType)) {
            throw new ApiException("\u552e\u540e\u7533\u8bf7\u7c7b\u578b\u4e3a\u7a7a");
        }
        map.put("refundType", refundType);
        if (brandChannelCode != null) {
            map.put("memberMcode", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("childFlag", childFlag);
        map.put("contractType", "00");
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult supQueryResult = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        supQueryResult.getRows().forEach(sq -> sq.setOrderStatus(sq.getDataState()));
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)supQueryResult));
        return supQueryResult;
    }

    @Override
    public String syncRefundContractsStatus(String refundCode, String contractBillcode) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)contractBillcode)) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        map.put("refundCode", refundCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        if (ocRefundReDomain == null) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ocRefundReDomain.getList().size() < 0) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OcRefundReDomain refundReDomain = (OcRefundReDomain)ocRefundReDomain.getList().get(0);
        this.logger.info("refundReDomain:", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundReDomain));
        HashMap oMap = new HashMap();
        HashMap<String, String> lMap = new HashMap<String, String>();
        lMap.put("refundCode", refundCode);
        lMap.put("tenantCode", tenantCode);
        lMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(oMap));
        this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", lMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String syncShippedPackageExpressInfo(String contractBillcode, String packageBillno, String expressCode, String expressName) {
        this.logger.info("contractBillcode:" + contractBillcode + "packageBillno--" + packageBillno + "---expressCode" + expressCode + "--expressName" + expressName);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)contractBillcode)) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "-contractBillcode:" + contractBillcode);
        }
        map.put("expressCode", expressCode);
        map.put("expressName", expressName);
        map.put("packageBillno", packageBillno);
        map.put("sendgoodsLogName", "\u7269\u6d41\u4fe1\u606f\u540c\u6b65");
        map.put("sendgoodsLogMsg", "\u7269\u6d41\u4fe1\u606f\u540c\u6b65");
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        pMap.put("sendgoodsCode", contractBillcode);
        pMap.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("sg.sendgoodsEngine.sendSendgoodsNext", pMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String backRefundContractsStatus(String contractBillcode, String refundCode, boolean status) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)contractBillcode)) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        map.put("refundCode", refundCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
        if (ocRefundReDomain == null) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ocRefundReDomain.getList().size() < 0) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OcRefundReDomain refundReDomain = (OcRefundReDomain)ocRefundReDomain.getList().get(0);
        if (status && refundReDomain.getDataState() == 0) {
            this.logger.info("refundReDomain:", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundReDomain));
            HashMap oMap = new HashMap();
            HashMap<String, String> lMap = new HashMap<String, String>();
            lMap.put("refundCode", refundCode);
            lMap.put("tenantCode", tenantCode);
            lMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(oMap));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", lMap);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public List<SkuShopDomain> downloadMarketableGoodsAlter(String shopCode, String spuCode, String dwStartDate, String dwEndDate, Integer pageIndex, Integer pageSize) {
        List list;
        ArrayList<SkuShopDomain> oList = new ArrayList<SkuShopDomain>();
        this.logger.info("shopCode:" + shopCode + "spuCode:" + spuCode + "--dwStartDate" + dwStartDate + "--dwEndDate" + dwEndDate);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)shopCode) && StringUtils.isBlank((String)spuCode)) {
            throw new ApiException("\u5e97\u94fa\u7f16\u7801\u548c\u5546\u54c1\u6b3e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)shopCode)) {
            map.put("memberCode", shopCode);
        }
        if (StringUtils.isBlank((String)shopCode) && StringUtils.isNotBlank((String)spuCode)) {
            map.put("goodsEocode", spuCode);
        }
        if (dwStartDate != null && dwEndDate != null) {
            map.put("startDate", dwStartDate);
            map.put("endDate", dwEndDate);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsType", "00");
        HashMap<String, String> pMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", "1");
        map.put("fuzzy", true);
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        HashMap goodsMap = new HashMap();
        QueryResult rs = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pMap, RsResourceGoodsReDomain.class);
        if (rs == null || ListUtil.isEmpty((Collection)rs.getList())) {
            throw new ApiException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        this.logger.info("\u67e5\u8be2\u6570\u636e\u6570\u91cf--------" + rs.getList().size());
        String goodsCodes = "";
        String goodsShownos = "";
        for (RsResourceGoodsReDomain rsResourceGoodsReDomain2 : rs.getList()) {
            goodsCodes = goodsCodes + rsResourceGoodsReDomain2.getGoodsCode() + ",";
            goodsShownos = goodsShownos + rsResourceGoodsReDomain2.getGoodsShowno() + ",";
        }
        HashMap<String, String> sMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("goodsCode", goodsCodes);
        hashMap.put("goodsShowno", goodsShownos);
        hashMap.put("tenantCode", tenantCode);
        hashMap.put("fuzzy", true);
        hashMap.put("startRow", 1);
        hashMap.put("endRow", 50000);
        sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(hashMap));
        QueryResult sku = this.getQueryResutl("rs.sku.querySkuPage", sMap, RsSkuReDomain.class);
        HashMap skuMap = new HashMap();
        if (sku != null && !CollectionUtils.isEmpty((Collection)(list = sku.getList()))) {
            list.forEach(l -> {
                l.setSkuEocode(l.getSkuNo());
                if (skuMap.containsKey(l.getGoodsCode() + "-" + l.getGoodsShowno())) {
                    List skuReDomainList = (List)skuMap.get(l.getGoodsCode() + "-" + l.getGoodsShowno());
                    skuReDomainList.add(l);
                    skuMap.put(l.getGoodsCode() + "-" + l.getGoodsShowno(), skuReDomainList);
                } else {
                    ArrayList<RsSkuReDomain> skuReDomainList = new ArrayList<RsSkuReDomain>();
                    skuReDomainList.add((RsSkuReDomain)l);
                    skuMap.put(l.getGoodsCode() + "-" + l.getGoodsShowno(), skuReDomainList);
                }
            });
        }
        rs.getList().forEach(rsResourceGoodsReDomain -> {
            List<RsResourceGoodsReDomain> rList;
            rsResourceGoodsReDomain.setRsSkuReDomain((List)skuMap.get(rsResourceGoodsReDomain.getGoodsCode() + "-" + rsResourceGoodsReDomain.getGoodsShowno()));
            if (shopCode != null) {
                rsResourceGoodsReDomain.setGoodsEocode(rsResourceGoodsReDomain.getGoodsEocode() == null ? "sku\u7a7a" : rsResourceGoodsReDomain.getGoodsEocode());
                if (goodsMap.containsKey(rsResourceGoodsReDomain.getGoodsEocode())) {
                    rList = (List)goodsMap.get(rsResourceGoodsReDomain.getGoodsEocode());
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getGoodsEocode(), rList);
                } else {
                    rList = new ArrayList<RsResourceGoodsReDomain>();
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getGoodsEocode(), rList);
                }
            }
            if (spuCode != null) {
                rsResourceGoodsReDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode() == null ? "shop\u7a7a" : rsResourceGoodsReDomain.getMemberCode());
                if (goodsMap.containsKey(rsResourceGoodsReDomain.getMemberCode())) {
                    rList = (List)goodsMap.get(rsResourceGoodsReDomain.getMemberCode());
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getMemberCode(), rList);
                } else {
                    rList = new ArrayList();
                    rList.add((RsResourceGoodsReDomain)rsResourceGoodsReDomain);
                    goodsMap.put(rsResourceGoodsReDomain.getMemberCode(), rList);
                }
            }
        });
        for (Map.Entry m : goodsMap.entrySet()) {
            SkuShopDomain item = new SkuShopDomain();
            item.setSkuOshop((String)m.getKey());
            item.setGoodsList((List)m.getValue());
            item.setTotalCount(rs.getTotal());
            oList.add(item);
        }
        return oList;
    }

    @Override
    public SupQueryResult<SgSendgoodsReDomain> downloadContractsChange(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, String contractBillcode) {
        this.logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime + "--dwEndTime" + dwEndTime + "--orderStatus" + orderStatus);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberCode", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("contractType", "00");
        map.put("goodsFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("sg.sendgoods.querySgSendgoodsPageReDomain", pMap, SgSendgoodsReDomain.class);
        if (ocContractReDomainSupQueryResult == null) {
            return new SupQueryResult();
        }
        if (ocContractReDomainSupQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        String contractBillcodes = "";
        for (SgSendgoodsReDomain sgSendgoodsReDomain : ocContractReDomainSupQueryResult.getList()) {
            contractBillcodes = contractBillcodes + sgSendgoodsReDomain.getContractBbillcode() + ",";
        }
        Map<String, OrgDepartDomain> departDomainMap = this.getdepartMap(page, rows, contractBillcodes);
        ocContractReDomainSupQueryResult.getRows().forEach(ocContractReDomain -> {
            Map<String, String> aMap = AddressResolution.addressResolution(ocContractReDomain.getGoodsReceiptArrdess());
            ocContractReDomain.setProvinceName(aMap.get("province"));
            ocContractReDomain.setCityName(aMap.get("city"));
            ocContractReDomain.setCountyName(aMap.get("county").replace(aMap.get("city"), ""));
            ocContractReDomain.setOrderStatus(ocContractReDomain.getDataState());
            OrgDepartDomain orgDepartDomain = (OrgDepartDomain)departDomainMap.get(ocContractReDomain.getContractBbillcode());
            if (orgDepartDomain != null) {
                ocContractReDomain.setShopCode(orgDepartDomain.getDepartOcode());
                ocContractReDomain.setShopName(orgDepartDomain.getDepartName());
            }
            ocContractReDomain.setBrandChannelCode(ocContractReDomain.getMemberCcode());
            ocContractReDomain.setBrandChannelName(ocContractReDomain.getMemberCname());
            HashMap<String, String> userChannelMap = new HashMap<String, String>();
            userChannelMap.put("tenantCode", tenantCode);
            userChannelMap.put("userinfoCode", ocContractReDomain.getMemberGcode());
            userChannelMap.put("qualityCode", "dis");
            HashMap<String, String> puMap = new HashMap<String, String>();
            puMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(userChannelMap));
            QueryResult umUserinfoChannelReDomainSupQueryResult = this.getQueryResutl("um.umUserinfoChannel.queryUserinfoChannelPage", puMap, UmUserinfoChannelReDomain.class);
            List list = umUserinfoChannelReDomainSupQueryResult.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                UmUserinfoChannelReDomain umUserinfoChannelReDomain = (UmUserinfoChannelReDomain)list.get(0);
                this.logger.info("\u5bfc\u8d2d\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelReDomain));
                ocContractReDomain.setEmployeeCode(umUserinfoChannelReDomain.getUserinfoChannelVaule());
                ocContractReDomain.setEmployeeName(umUserinfoChannelReDomain.getUserinfoCompname());
            }
            ocContractReDomain.getSgSendgoodsGoodsDomainList().forEach(sgSendgoodsGoodsDomain -> {
                sgSendgoodsGoodsDomain.setGoodsEocode(sgSendgoodsGoodsDomain.getGoodsEocode() == null ? sgSendgoodsGoodsDomain.getGoodsNo() : sgSendgoodsGoodsDomain.getGoodsEocode());
                sgSendgoodsGoodsDomain.setSkuEocode(sgSendgoodsGoodsDomain.getSkuEocode() == null ? sgSendgoodsGoodsDomain.getSkuNo() : sgSendgoodsGoodsDomain.getSkuEocode());
            });
        });
        this.logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    public Map<String, OrgDepartDomain> getdepartMap(Integer page, Integer rows, String contractBillcodes) {
        HashMap<String, OrgDepartDomain> departDomainMap = new HashMap<String, OrgDepartDomain>();
        HashMap<String, Object> ocmap = new HashMap<String, Object>();
        ocmap.put("startRow", (page - 1) * rows);
        ocmap.put("endRow", rows);
        ocmap.put("contractType", "00");
        ocmap.put("tenantCode", tenantCode);
        ocmap.put("contractBillcode", contractBillcodes);
        HashMap<String, String> ocpMap = new HashMap<String, String>();
        ocpMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(ocmap));
        QueryResult ocContractReDomainSupQueryResultM = this.getQueryResutl("oc.contract.queryContractPageReDomain", ocpMap, OcContractReDomain.class);
        String userInfoCodes = "";
        HashMap<String, String> userCodesMap = new HashMap<String, String>();
        this.logger.info("\u8ba2\u5355\u5165\u53c2---------" + JsonUtil.buildNormalBinder().toJson(ocmap));
        if (CollectionUtils.isEmpty((Collection)ocContractReDomainSupQueryResultM.getList())) {
            return new HashMap<String, OrgDepartDomain>();
        }
        for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResultM.getList()) {
            userInfoCodes = userInfoCodes + ocContractReDomain.getMschannelCode() + ",";
            userCodesMap.put(ocContractReDomain.getMschannelCode(), ocContractReDomain.getContractBbillcode());
        }
        HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
        userInfoMap.put("startRow", (page - 1) * rows);
        userInfoMap.put("endRow", rows);
        userInfoMap.put("tenantCode", tenantCode);
        userInfoMap.put("userinfoCode", userInfoCodes);
        HashMap<String, String> userpMap = new HashMap<String, String>();
        userpMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(userInfoMap));
        this.logger.info("userInfo\u5165\u53c2---------" + JsonUtil.buildNormalBinder().toJson(userInfoMap));
        QueryResult userinfoDomainSupQueryResult = this.getQueryResutl("um.user.queryUserinfoPage", userpMap, UmUserinfoDomain.class);
        String deptCodes = "";
        HashMap deptCodeMap = new HashMap();
        if (CollectionUtils.isEmpty((Collection)userinfoDomainSupQueryResult.getList())) {
            return new HashMap<String, OrgDepartDomain>();
        }
        for (UmUserinfoDomain umUserinfoDomain : userinfoDomainSupQueryResult.getList()) {
            deptCodes = deptCodes + umUserinfoDomain.getDepartCode() + ",";
            if (!userCodesMap.containsKey(umUserinfoDomain.getUserinfoCode())) continue;
            deptCodeMap.put(umUserinfoDomain.getDepartCode(), userCodesMap.get(umUserinfoDomain.getUserinfoCode()));
        }
        HashMap<String, Object> deptMap = new HashMap<String, Object>();
        deptMap.put("startRow", (page - 1) * rows);
        deptMap.put("endRow", rows);
        deptMap.put("tenantCode", tenantCode);
        deptMap.put("departCode", deptCodes);
        HashMap<String, String> deptpMap = new HashMap<String, String>();
        deptpMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(deptMap));
        this.logger.info("\u95e8\u5e97\u5165\u53c2---------" + JsonUtil.buildNormalBinder().toJson(deptMap));
        QueryResult departDomainSupQueryResult = this.getQueryResutl("org.depart.queryDepartPage", deptpMap, OrgDepartDomain.class);
        if (CollectionUtils.isEmpty((Collection)departDomainSupQueryResult.getList())) {
            return new HashMap<String, OrgDepartDomain>();
        }
        for (OrgDepartDomain orgDepartDomain : departDomainSupQueryResult.getList()) {
            if (!deptCodeMap.containsKey(orgDepartDomain.getDepartCode())) continue;
            departDomainMap.put((String)deptCodeMap.get(orgDepartDomain.getDepartCode()), orgDepartDomain);
        }
        return departDomainMap;
    }
}

