/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.ftp;

import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.esb.core.support.ObjectService;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClientUtil
extends ObjectService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String url, int port, String username, String password, String path, String filename, String encoding, InputStream input) {
        boolean success = false;
        FTPClient ftp = null;
        try {
            ftp = this.createFtp(url, port, username, password, path, encoding);
            if (null == ftp) {
                boolean bl = success;
                return bl;
            }
            success = ftp.storeFile(filename, input);
            input.close();
            ftp.logout();
            success = true;
        }
        catch (IOException e) {
            this.logger.error("uploadFile", (Object)"==ftp uploadFile==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    this.logger.error("uploadFile", (Object)"==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
        return success;
    }

    public FTPClient createFtp(String url, int port, String username, String password, String path, String encoding) {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(url, port);
            if (!ftp.login(username, password)) {
                this.logger.error("createFtp", (Object)("==ftp login faile==" + username));
                return null;
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                return null;
            }
            if (StringUtils.isBlank((String)encoding)) {
                encoding = "UTF-8";
            }
            ftp.setControlEncoding(encoding);
            ftp.setFileType(2);
            ftp.enterLocalPassiveMode();
            if (!ftp.changeWorkingDirectory(path)) {
                String[] paths;
                for (String string : paths = path.split("/")) {
                    if ("".equals(string) || ftp.changeWorkingDirectory(string)) continue;
                    if (!ftp.makeDirectory(string)) {
                        ftp.disconnect();
                        this.logger.error("createFtp", (Object)("==ftp changeWorkingDirectory faile==" + path + "==" + string));
                        return null;
                    }
                    if (ftp.changeWorkingDirectory(string)) continue;
                    ftp.disconnect();
                    this.logger.error("createFtp", (Object)("==ftp changeWorkingDirectory faile==" + path + "==" + string));
                    return null;
                }
            }
        }
        catch (IOException e) {
            this.logger.error("createFtp", (Object)"==ftp createFtp==", (Throwable)e);
        }
        return ftp;
    }

    public boolean uploadFile(String url, int port, String username, String password, String path, String filename, String encoding, byte[] content) {
        ByteArrayInputStream input = new ByteArrayInputStream(content);
        return this.uploadFile(url, port, username, password, path, filename, encoding, input);
    }

    public static void main(String[] args) {
        String s = "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";
        System.out.println(Base64.decodeBase64((String)s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFileList(String url, int port, String username, String password, String path, String encoding, List<FileBean> fileBeanList) {
        if (null == fileBeanList || fileBeanList.isEmpty()) {
            return false;
        }
        boolean success = false;
        FTPClient ftp = this.createFtp(url, port, username, password, path, encoding);
        if (null == ftp) {
            return success;
        }
        try {
            ByteArrayInputStream input = null;
            success = true;
            for (FileBean fileBean : fileBeanList) {
                input = new ByteArrayInputStream(fileBean.getBytes());
                if (!ftp.storeFile(fileBean.getName(), (InputStream)input)) {
                    success = false;
                }
                ((InputStream)input).close();
            }
            ftp.logout();
        }
        catch (Exception e) {
            success = false;
            this.logger.error("uploadFileList", (Object)"==ftp uploadFileList==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    this.logger.error("uploadFileList", (Object)"==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downFile(String url, int port, String username, String password, String remotePath, String fileName, String encoding) {
        FTPClient ftp = this.createFtp(url, port, username, password, remotePath, encoding);
        try {
            FTPFile[] fs = ftp.listFiles();
            InputStream input = null;
            for (FTPFile ff : fs) {
                if (!ff.getName().equals(fileName)) continue;
                input = ftp.retrieveFileStream(ff.getName());
                break;
            }
            byte[] imgdata = null;
            if (null != input) {
                int ch;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                while ((ch = input.read()) != -1) {
                    bytestream.write(ch);
                }
                imgdata = bytestream.toByteArray();
                bytestream.close();
                input.close();
            }
            ftp.logout();
            byte[] byArray = imgdata;
            return byArray;
        }
        catch (Exception e) {
            this.logger.error("downFile", (Object)"==ftp downFile==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    this.logger.error("downFile", (Object)"==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
        return null;
    }
}

