/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.yqbsoft.laser.service.adapter.oss.ImageCMYKUtil;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class OssClientUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(OssClientUtil.class);
    private static String aliOSS = "0";
    private static String jdOSS = "1";

    public static String uploadOSS(Map<String, Object> paramMap, FileBean fileBean) {
        String accessKeyId = EmptyUtil.isEmpty((Object)paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty((Object)paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty((Object)paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String ossUrl = EmptyUtil.isEmpty((Object)paramMap.get("ossUrl")) ? "" : String.valueOf(paramMap.get("ossUrl"));
        String bucketName = EmptyUtil.isEmpty((Object)paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String objectNamePath = EmptyUtil.isEmpty((Object)paramMap.get("objectNamePath")) ? "" : String.valueOf(paramMap.get("objectNamePath"));
        String fileName = EmptyUtil.isEmpty((Object)paramMap.get("fileName")) ? "" : String.valueOf(paramMap.get("fileName"));
        String ossToype = EmptyUtil.isEmpty((Object)paramMap.get("ossType")) ? "" : String.valueOf(paramMap.get("ossType"));
        String tag = "-1";
        if (StringUtils.isBlank((String)accessKeyId) || StringUtils.isBlank((String)accessKeySecret) || StringUtils.isBlank((String)endPoint) || StringUtils.isBlank((String)bucketName) || EmptyUtil.isEmpty((Object)fileBean)) {
            logger.error("OssClientUtil.uploadOSS.null", paramMap);
            return tag;
        }
        try {
            if (StringUtils.isBlank((String)fileName)) {
                fileName = fileBean.getName();
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.startsWith("/")) {
                objectNamePath = objectNamePath.substring(1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.endsWith("//")) {
                objectNamePath = objectNamePath.substring(0, objectNamePath.length() - 1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && !objectNamePath.endsWith("/")) {
                objectNamePath = objectNamePath.concat("/");
            }
            logger.info("OssClientUtil.uploadOSS.info", (Object)(endPoint + "=" + objectNamePath + fileName));
            if (aliOSS.equals(ossToype)) {
                OSSClient aliClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
                boolean found = aliClient.doesObjectExist(bucketName, objectNamePath + fileName);
                if (found) {
                    aliClient.deleteObject(bucketName, objectNamePath + fileName);
                }
                return OssClientUtil.aliUpload(aliClient, bucketName, ossUrl, objectNamePath, fileName, fileBean);
            }
            if (jdOSS.equals(ossToype)) {
                AmazonS3 JdClient = OssClientUtil.loadJdOSS(endPoint, accessKeyId, accessKeySecret);
                return String.valueOf(OssClientUtil.jdUpload(JdClient, bucketName, objectNamePath, fileName, fileBean));
            }
            logger.error("OssClientUtil.uploadOSS.ossToype", (Object)ossToype);
            return tag;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.uploadOSS.e", paramMap, (Throwable)e);
            return tag;
        }
    }

    private static AmazonS3 loadJdOSS(String endPoint, String AKid, String AKSecret) {
        System.setProperty("com.amazonaws.services.s3.enableV4", "true");
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(endPoint, "cn-north-1");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(AKid, AKSecret);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        return s3;
    }

    private static OSSClient loadAliOSS(String endPoint, String accessKeyId, String accessKeySecret) {
        return new OSSClient(endPoint, accessKeyId, accessKeySecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String aliUpload(OSSClient ossClient, String bucketname, String OSSUrl, String objectNamePath, String fileName, FileBean fileBean) {
        String tag = "-1";
        try {
            ByteArrayInputStream content = OssClientUtil.imageZip(fileBean.getBytes(), fileName);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(fileBean.getSize().longValue());
            meta.setContentType(OssClientUtil.getContentType(fileName));
            ossClient.putObject(bucketname, objectNamePath + fileName, (InputStream)content, meta);
            if (OSSUrl.indexOf("{") >= 0) {
                OSSUrl = OSSUrl.replace("{objectNamePath}", objectNamePath);
                OSSUrl = OSSUrl.replace("{fileName}", fileName);
            } else {
                OSSUrl = OSSUrl + objectNamePath + fileName;
            }
            String string = OSSUrl;
            return string;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.AliUpload.e", (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String jdUpload(AmazonS3 s3, String bucketname, String objectNamePath, String filename, FileBean fileBean) {
        String tag = "-1";
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBean.getBytes());
            com.amazonaws.services.s3.model.ObjectMetadata objectMetadata = new com.amazonaws.services.s3.model.ObjectMetadata();
            objectMetadata.setContentLength(fileBean.getSize().longValue());
            s3.putObject(bucketname, objectNamePath + filename, (InputStream)inputStream, objectMetadata);
            URL url = s3.getUrl(bucketname, objectNamePath + filename);
            String string = String.valueOf(url);
            return string;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.JdUpload.e", (Throwable)e);
            String string = tag;
            return string;
        }
        finally {
            s3.shutdown();
        }
    }

    public static String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        if (".bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if (".gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if (".jpeg".equalsIgnoreCase(fileExtension) || ".jpg".equalsIgnoreCase(fileExtension) || ".png".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if (".html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if (".txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if (".vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if (".ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if (".doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if (".xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public static ByteArrayInputStream imageZip(byte[] bytes, String fileName) throws Exception {
        String formatName = fileName.substring(fileName.lastIndexOf(".")).toUpperCase();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String contentType = OssClientUtil.getContentType(fileName);
        if (contentType.indexOf("image") == -1) {
            return inputStream;
        }
        logger.info(" -- \u56fe\u7247\u538b\u7f29\u51c6\u5907 -- ", (Object)("\u6587\u4ef6\u540d\uff1a" + fileName + ",size={" + bytes.length / 1000 + "}KB"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = ImageCMYKUtil.readImage(inputStream);
        int newWidth = bufferedImage.getWidth() * 1;
        int newHeight = bufferedImage.getHeight() * 1;
        BufferedImage compressedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = compressedImage.createGraphics();
        g2d.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)compressedImage, formatName, outputStream);
        ByteArrayOutputStream baos = outputStream;
        byte[] bytes1 = baos.toByteArray();
        logger.info("  |-- \u56fe\u7247\u538b\u7f29\u5b8c\u6210 -- ", (Object)("\u6587\u4ef6\u540d\uff1a" + fileName + ",size={" + bytes1.length / 1000 + "}KB"));
        return new ByteArrayInputStream(bytes1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listFileName(Map paramMap) {
        logger.info("OssClientUtil.listFileName.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String prefix = EmptyUtil.isEmpty(paramMap.get("prefix")) ? "" : String.valueOf(paramMap.get("prefix"));
        String marker = EmptyUtil.isEmpty(paramMap.get("marker")) ? "" : String.valueOf(paramMap.get("marker"));
        Integer maxKeys = EmptyUtil.isEmpty(paramMap.get("maxKeys")) ? 100 : (Integer)paramMap.get("maxKeys");
        boolean hasNext = true;
        ArrayList<String> res = new ArrayList<String>();
        OSSClient ossClient = null;
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setPrefix(prefix);
            listObjectsRequest.setMarker(marker);
            listObjectsRequest.setMaxKeys(maxKeys);
            ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
            ObjectListing listing = ossClient.listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                System.out.println("====>" + objectSummary.getKey());
                res.add(objectSummary.getKey());
            }
        }
        catch (Exception e) {
            logger.error("OssClientUtil.listFileName.e", (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return res;
    }

    public static String deleteFiles(Map paramMap) {
        logger.info("OssClientUtil.listFileName.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        List keys = EmptyUtil.isEmpty(paramMap.get("keys")) ? null : (List)paramMap.get("keys");
        OSSClient ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
        DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(bucketName).withKeys(keys));
        List deletedObjects = deleteObjectsResult.getDeletedObjects();
        ossClient.shutdown();
        return deletedObjects.size() + "";
    }

    public static String createFolder(Map paramMap) {
        logger.info("OssClientUtil.listFileName.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String keySuffixWithSlash = EmptyUtil.isEmpty(paramMap.get("folder")) ? "" : String.valueOf(paramMap.get("folder"));
        OSSClient ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
        if (!ossClient.doesObjectExist(bucketName, keySuffixWithSlash)) {
            ossClient.putObject(bucketName, keySuffixWithSlash, (InputStream)new ByteArrayInputStream(new byte[0]));
            OSSObject object = ossClient.getObject(bucketName, keySuffixWithSlash);
            String fileDir = object.getKey();
            ossClient.shutdown();
            return fileDir;
        }
        return "-1";
    }
}

