/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.oss.service.impl;

import com.obs.services.ObsClient;
import com.obs.services.model.PutObjectResult;
import com.yqbsoft.laser.service.adapter.oss.OssClientUtil;
import com.yqbsoft.laser.service.adapter.oss.service.OssUploadService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="ossUploadService")
public class OssUploadServiceImpl
extends BaseServiceImpl
implements OssUploadService {
    public static final String SYS_CODE = "oss.oss.OssUploadServiceImpl";

    @Override
    public String aliOssUpload(Map<String, Object> paramMap, FileBean fileBean) {
        if (MapUtil.isEmpty(paramMap) || null == fileBean) {
            this.logger.error("oss.oss.OssUploadServiceImpl.aliOssUpload.param", paramMap);
            return "error";
        }
        try {
            paramMap.put("fileName", fileBean.getName());
            paramMap.put("ossType", "0");
            return OssClientUtil.uploadOSS(paramMap, fileBean);
        }
        catch (Exception e) {
            this.logger.error("oss.oss.OssUploadServiceImpl.aliOssUpload.e", paramMap);
            throw new ApiException("AliOssUpload is error");
        }
    }

    @Override
    public String jdOssUpload(Map<String, Object> paramMap, FileBean fileBean) {
        if (MapUtil.isEmpty(paramMap) || null == fileBean) {
            return "error";
        }
        try {
            paramMap.put("fileName", fileBean.getName());
            paramMap.put("ossType", "1");
            return OssClientUtil.uploadOSS(paramMap, fileBean);
        }
        catch (Exception e) {
            this.logger.error("oss.oss.OssUploadServiceImpl.jdOssUpload.e", paramMap);
            throw new ApiException("JdOssUpload is error");
        }
    }

    @Override
    public String hwOssUpload(Map<String, Object> paramMap, FileBean fileBean) throws Exception {
        String accessKeyId = EmptyUtil.isEmpty((Object)paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty((Object)paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty((Object)paramMap.get("ossUrl")) ? "" : String.valueOf(paramMap.get("ossUrl"));
        String bucketName = EmptyUtil.isEmpty((Object)paramMap.get("objectNamePath")) ? "" : String.valueOf(paramMap.get("objectNamePath"));
        String objectKey = fileBean.getOriginalFilename();
        ByteArrayInputStream in = new ByteArrayInputStream(fileBean.getBytes());
        ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);
        PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectKey, (InputStream)in);
        ((InputStream)in).close();
        obsClient.close();
        return putObjectResult.getObjectUrl();
    }

    @Override
    public List<String> aliListFileName(Map<String, Object> paramMap) {
        return OssClientUtil.listFileName(paramMap);
    }

    @Override
    public String aliDelelteFiles(Map<String, Object> paramMap) {
        return OssClientUtil.deleteFiles(paramMap);
    }

    @Override
    public String aliCreateFolder(Map<String, Object> paramMap) {
        return OssClientUtil.createFolder(paramMap);
    }
}

