/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.AESUtil;
import com.yqbsoft.laser.service.cd.CdCardpConstants;
import com.yqbsoft.laser.service.cd.dao.CdCardvirListMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardListDistributeDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirListDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirListReDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirProcessDomain;
import com.yqbsoft.laser.service.cd.domain.EditSkuDomain;
import com.yqbsoft.laser.service.cd.domain.OcContractDomain;
import com.yqbsoft.laser.service.cd.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.cd.domain.OcContractReDomain;
import com.yqbsoft.laser.service.cd.model.CdCardvirList;
import com.yqbsoft.laser.service.cd.service.CdCardvirListService;
import com.yqbsoft.laser.service.cd.service.CdCardvirProcessService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CdCardvirListImpl
extends BaseServiceImpl
implements CdCardvirListService {
    private static final String SYS_CODE = "cd.CARDP.CdCardvirListImpl";
    private CdCardvirListMapper cdCardvirListMapper;
    private CdCardvirProcessService cdCardvirProcessService;

    public void setCdCardvirListMapper(CdCardvirListMapper cdCardvirListMapper) {
        this.cdCardvirListMapper = cdCardvirListMapper;
    }

    public void setCdCardvirProcessService(CdCardvirProcessService cdCardvirProcessService) {
        this.cdCardvirProcessService = cdCardvirProcessService;
    }

    private Date getSysDate() {
        try {
            return this.cdCardvirListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardvirList(CdCardvirListDomain cdCardvirListDomain) {
        if (null == cdCardvirListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardvirListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardvirListDefault(CdCardvirList cdCardvirList) {
        String cardpPass;
        if (null == cdCardvirList) {
            return;
        }
        if (null == cdCardvirList.getDataState()) {
            cdCardvirList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cdCardvirList.getGmtCreate()) {
            cdCardvirList.setGmtCreate(date);
        }
        cdCardvirList.setGmtModified(date);
        if (StringUtils.isBlank((String)cdCardvirList.getCardpvirListCode())) {
            cdCardvirList.setCardpvirListCode(this.getNo(null, "CdCardvirList", "cdCardvirList", cdCardvirList.getTenantCode()));
        }
        if (StringUtils.isBlank((String)(cardpPass = cdCardvirList.getCardpRak()))) {
            return;
        }
        String key = CdCardvirListImpl.getKey();
        key = key + CdCardvirListImpl.getKey();
        String pass = this.aesencryption(cardpPass, key);
        cdCardvirList.setCardpRtype(key);
        cdCardvirList.setCardpPass(pass);
    }

    public static String getKey() {
        String res = "";
        for (int j = 0; j < 100; ++j) {
            int asd = (int)((Math.random() * 9.0 + 1.0) * 1.0E7);
            res = String.valueOf(asd);
        }
        return res;
    }

    public String aesencryption(String passWord, String key) {
        String encrypt = AESUtil.encrypt(passWord, key);
        String context = new String(encrypt);
        return context;
    }

    private int getCardvirListMaxCode() {
        int code = 0;
        try {
            return this.cdCardvirListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardvirListUpdataDefault(CdCardvirList cdCardvirList) {
        if (null == cdCardvirList) {
            return;
        }
        cdCardvirList.setGmtModified(this.getSysDate());
    }

    private void saveCardvirListModel(CdCardvirList cdCardvirList) throws ApiException {
        if (null == cdCardvirList) {
            return;
        }
        try {
            this.cdCardvirListMapper.insert(cdCardvirList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirListModel.ex", (Throwable)e);
        }
    }

    private void saveCardvirListBatchModel(List<CdCardvirList> cdCardvirListList) throws ApiException {
        if (null == cdCardvirListList || cdCardvirListList.isEmpty()) {
            return;
        }
        try {
            this.cdCardvirListMapper.insertBatch(cdCardvirListList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirListBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardvirList getCardvirListModelById(Integer cardpvirListId) {
        if (null == cardpvirListId) {
            return null;
        }
        try {
            return this.cdCardvirListMapper.selectByPrimaryKey(cardpvirListId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardvirList getCardvirListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardvirListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardvirListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByCode.num");
        }
    }

    private void deleteCardvirListModel(Integer cardpvirListId) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.deleteByPrimaryKey(cardpvirListId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.deleteCardvirListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.deleteCardvirListModel.num");
        }
    }

    private void updateCardvirListModel(CdCardvirList cdCardvirList) throws ApiException {
        if (null == cdCardvirList) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateByPrimaryKey(cdCardvirList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModel.num");
        }
    }

    private void updateStateCardvirListModel(Integer cardpvirListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cardpvirListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpvirListId", cardpvirListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModel.null");
        }
    }

    private void updateStateCardvirListModelByCode(String tenantCode, String cardpvirListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModelByCode.null");
        }
    }

    private CdCardvirList makeCardvirList(CdCardvirListDomain cdCardvirListDomain, CdCardvirList cdCardvirList) {
        if (null == cdCardvirListDomain) {
            return null;
        }
        if (null == cdCardvirList) {
            cdCardvirList = new CdCardvirList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvirList, (Object)cdCardvirListDomain);
            return cdCardvirList;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.makeCardvirList", (Throwable)e);
            return null;
        }
    }

    private CdCardvirListReDomain makeCdCardvirListReDomain(CdCardvirList cdCardvirList) {
        if (null == cdCardvirList) {
            return null;
        }
        CdCardvirListReDomain cdCardvirListReDomain = new CdCardvirListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvirListReDomain, (Object)cdCardvirList);
            return cdCardvirListReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.makeCdCardvirListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardvirList> queryCardvirListModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardvirListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardvirListModel", (Throwable)e);
            return null;
        }
    }

    private int countCardvirList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardvirListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.countCardvirList", (Throwable)e);
        }
        return i;
    }

    private CdCardvirList createCdCardvirList(CdCardvirListDomain cdCardvirListDomain) {
        String msg = this.checkCardvirList(cdCardvirListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirList.checkCardvirList", msg);
        }
        CdCardvirList cdCardvirList = this.makeCardvirList(cdCardvirListDomain, null);
        this.setCardvirListDefault(cdCardvirList);
        return cdCardvirList;
    }

    @Override
    public String saveCardvirList(CdCardvirListDomain cdCardvirListDomain) throws ApiException {
        CdCardvirList cdCardvirList = this.createCdCardvirList(cdCardvirListDomain);
        this.saveCardvirListModel(cdCardvirList);
        return cdCardvirList.getCardpvirListCode();
    }

    @Override
    public String saveCardvirListBatch(List<CdCardvirListDomain> cdCardvirListDomainList) throws ApiException {
        if (null == cdCardvirListDomainList || cdCardvirListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardvirList> cdCardvirListList = new ArrayList<CdCardvirList>();
        String code = "";
        String cardpBatchNo = this.getNo("0", "CdCardvir", "cardpBatchNo", cdCardvirListDomainList.get(0).getTenantCode());
        for (CdCardvirListDomain cdCardvirListDomain : cdCardvirListDomainList) {
            if (StringUtils.isBlank((String)cdCardvirListDomain.getCardpBatch())) {
                cdCardvirListDomain.setCardpBatch(cardpBatchNo);
            }
            CdCardvirList cdCardvirList = this.createCdCardvirList(cdCardvirListDomain);
            code = cdCardvirList.getCardpvirListCode();
            cdCardvirListList.add(cdCardvirList);
        }
        this.saveCardvirListBatchModel(cdCardvirListList);
        return code;
    }

    @Override
    public void updateCardvirListState(Integer cardpvirListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        this.updateStateCardvirListModel(cardpvirListId, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvirListStateByCode(String tenantCode, String cardpvirListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCardvirListModelByCode(tenantCode, cardpvirListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvirList(CdCardvirListDomain cdCardvirListDomain) throws ApiException {
        String msg = this.checkCardvirList(cdCardvirListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirList.checkCardvirList", msg);
        }
        CdCardvirList oldCdCardvirList = this.getCardvirListModelById(cdCardvirListDomain.getCardpvirListId());
        if (null == oldCdCardvirList) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardvirList cdCardvirList = this.makeCardvirList(cdCardvirListDomain, oldCdCardvirList);
        this.setCardvirListUpdataDefault(cdCardvirList);
        this.updateCardvirListModel(cdCardvirList);
    }

    @Override
    public CdCardvirList getCardvirList(Integer cardpvirListId) {
        if (null == cardpvirListId) {
            return null;
        }
        return this.getCardvirListModelById(cardpvirListId);
    }

    @Override
    public void deleteCardvirList(Integer cardpvirListId) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        this.deleteCardvirListModel(cardpvirListId);
    }

    @Override
    public QueryResult<CdCardvirList> queryCardvirListPage(Map<String, Object> map) {
        List<CdCardvirList> cdCardvirListList = this.queryCardvirListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardvirList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardvirListList);
        return queryResult;
    }

    @Override
    public CdCardvirList getCardvirListByCode(String tenantCode, String cardpvirListCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        return this.getCardvirListModelByCode(map);
    }

    @Override
    public void deleteCardvirListByCode(String tenantCode, String cardpvirListCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        this.delCardvirListModelByCode(map);
    }

    @Override
    public void deleteCardvirListByMap(Map<String, Object> map) throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.deleteCardvirListByMap {map}", map);
        this.delCardvirListModelByMap(map);
    }

    private void delCardvirListModelByMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.delByMap(map);
            map.put("handelSize", i);
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap {map}", map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap", (Throwable)e);
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap handel is null", map);
        }
    }

    @Override
    public void updateCardvirListByMap(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty() || map.get("tenantCode") == null) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap map is null", map);
        }
        if (map.get("cardvirListCode") == null && map.get("cardvirListCodeStr") == null && map.get("cardpBatch") == null && map.get("cardpBatchStr") == null) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap need params is null", map);
            return;
        }
        this.updateCardvirListModelByMap(map);
    }

    private void createCardProcess(Map<String, Object> map) {
        try {
            CdCardvirProcessDomain cdCardvirProcessDomain = new CdCardvirProcessDomain();
            Integer businessType = CdCardpConstants.BUSINESS_TYPE_0;
            String memo = null;
            Integer dataState = CdCardpConstants.CARD_PROCESS_STATE_f1;
            if (map.get("tenantCode") != null) {
                cdCardvirProcessDomain.setTenantCode(map.get("tenantCode").toString());
            } else {
                cdCardvirProcessDomain.setTenantCode("00000000");
            }
            if (map.get("cardvirListCode") != null) {
                cdCardvirProcessDomain.setCardpvirListCode(map.get("cardvirListCode").toString());
            }
            if (map.get("cardpBatch") != null) {
                cdCardvirProcessDomain.setCardpBatch(map.get("cardpBatch").toString());
            }
            if (map.get("userName") != null) {
                cdCardvirProcessDomain.setUserName(map.get("userName").toString());
            }
            if (map.get("userCode") != null) {
                cdCardvirProcessDomain.setUserCode(map.get("userCode").toString());
            }
            if (map.get("memo") != null) {
                cdCardvirProcessDomain.setMemo(map.get("memo").toString());
            }
            cdCardvirProcessDomain.setBusniessContent(JsonUtil.buildNormalBinder().toJson(map));
            if (map.get("handelSize") != null && Integer.valueOf(map.get("handelSize").toString()) > 0) {
                dataState = CdCardpConstants.CARD_PROCESS_STATE_0;
            }
            if (map.get("businessType") != null) {
                businessType = Integer.valueOf(map.get("businessType").toString());
            }
            if (map.get("contractBillcode") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_7;
            }
            if (map.get("cardProvideState") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_7;
            }
            if (map.get("cardSendState") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_8;
            }
            if (map.get("cardStartState") != null) {
                businessType = CdCardpConstants.START_STATE_0 == Integer.valueOf(map.get("cardStartState").toString()) ? CdCardpConstants.BUSINESS_TYPE_3 : CdCardpConstants.BUSINESS_TYPE_1;
            }
            if (map.get("cardStartStateBatch") != null) {
                businessType = CdCardpConstants.START_STATE_BATCH_0 == Integer.valueOf(map.get("cardStartStateBatch").toString()) ? CdCardpConstants.BUSINESS_TYPE_4 : CdCardpConstants.BUSINESS_TYPE_2;
            }
            if (map.get("cardpEnd") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_5;
                if (map.get("cardpBatch") != null || map.get("cardpBatchStr") != null) {
                    businessType = CdCardpConstants.BUSINESS_TYPE_6;
                }
            }
            cdCardvirProcessDomain.setBusniessType(businessType);
            if (StringUtils.isBlank((String)cdCardvirProcessDomain.getMemo())) {
                for (CdCardpConstants.CardProcessType cardProcessType : CdCardpConstants.CardProcessType.values()) {
                    if (cardProcessType.getBusinessType() != businessType) continue;
                    memo = cardProcessType.getBusinessDesc();
                }
                cdCardvirProcessDomain.setMemo(memo);
            }
            cdCardvirProcessDomain.setDataState(dataState);
            this.cdCardvirProcessService.saveCardvirProcess(cdCardvirProcessDomain);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.createCardProcess ex", (Throwable)e);
        }
    }

    private void updateCardvirListModelByMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateByMap(map);
            map.put("handelSize", i);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap", (Throwable)e);
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModelByMap.ex", (Throwable)e);
        }
        finally {
            this.createCardProcess(map);
        }
        if (i <= 0) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap handel is null", map);
        }
    }

    @Override
    public void updateValidExpire() throws ApiException {
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateValidExpire();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidExpire ex", (Throwable)e);
        }
        finally {
            if (i > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_VALID_UN.getBusinessType());
                map.put("handelSize", i);
                this.createCardProcess(map);
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidExpire ===== \u66f4\u65b0\u8fc7\u671f\u5361\u5377 job =====", (Object)("size:" + i));
            }
        }
    }

    @Override
    public void updateValidGoodsNum() throws ApiException {
        long start = System.currentTimeMillis();
        List<Map<String, Object>> varList = this.querySkuNumByCardList(null);
        this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum querySkuNumByCardList", (Object)("time:" + (System.currentTimeMillis() - start)));
        if (varList == null || ListUtil.isEmpty(varList)) {
            return;
        }
        for (Map<String, Object> map : varList) {
            if (map.get("skuCode") == null || map.get("skuNo") == null || map.get("goodsCode") == null || map.get("goodsNum") == null || map.get("saleNum") == null || map.get("tenantCode") == null || map.get("cardListNum") == null) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum params is null", (Object)JsonUtil.buildNormalBinder().toJson(map));
                continue;
            }
            BigDecimal goodsSupplyNumFinal = BigDecimal.ZERO;
            BigDecimal goodsSupplyNum = new BigDecimal(map.get("goodsSupplynum").toString());
            BigDecimal saleNum = new BigDecimal(map.get("saleNum").toString());
            BigDecimal goodsNum = new BigDecimal(map.get("goodsNum").toString());
            BigDecimal goodsNumValid = new BigDecimal(map.get("cardListNum").toString());
            BigDecimal goodsNumUpdate = goodsNumValid.subtract(goodsNum);
            if (saleNum.compareTo(goodsNum.subtract(goodsSupplyNum)) != 0) {
                goodsSupplyNumFinal = goodsNumValid.subtract(saleNum);
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_SKU_NUM_EX.getBusinessType());
            } else {
                if (goodsNumUpdate.compareTo(BigDecimal.ZERO) == 0) continue;
                goodsSupplyNumFinal = goodsSupplyNum.add(goodsNumUpdate);
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_SKU_NUM.getBusinessType());
            }
            EditSkuDomain editSkuDomain = new EditSkuDomain();
            editSkuDomain.setSkuCode(map.get("skuCode").toString());
            editSkuDomain.setSkuNo(map.get("skuNo").toString());
            editSkuDomain.setGoodsCode(map.get("goodsCode").toString());
            editSkuDomain.setTenantCode(map.get("tenantCode").toString());
            editSkuDomain.setGoodsSupplynum(goodsSupplyNumFinal);
            editSkuDomain.setGoodsNum(goodsNumValid);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
            try {
                this.internalInvoke("rs.resource.sendUpdateSkuEdit", paramMap);
            }
            catch (Exception e) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum ex", (Throwable)e);
            }
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum ", (Object)JsonUtil.buildNormalBinder().toJson(map));
            this.createCardProcess(map);
        }
        this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum end", (Object)("time:" + (System.currentTimeMillis() - start)));
    }

    private BigDecimal countGoodsSupplyNum(Map<String, Object> map, Map<String, Object> saleNumMap, BigDecimal goodsNum, BigDecimal goodsSupplyNum) {
        String skuCode = map.get("skuCode").toString();
        if (MapUtil.isEmpty(saleNumMap) || saleNumMap.get(skuCode) == null) {
            return goodsSupplyNum;
        }
        BigDecimal goodsSaleNumValid = BigDecimal.ZERO;
        BigDecimal goodsSaleNum = BigDecimal.ZERO;
        goodsSaleNumValid = new BigDecimal(saleNumMap.get(skuCode).toString());
        goodsSaleNum = goodsNum.subtract(goodsSupplyNum);
        if (goodsSaleNum.compareTo(goodsSaleNumValid) != 0) {
            goodsSupplyNum = goodsNum.subtract(goodsSaleNumValid);
            map.put("goodsSaleNumValid", goodsSaleNumValid);
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum goodsSupplyNum ex", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
        return goodsSupplyNum;
    }

    @Override
    public List<Map<String, Object>> queryCardListValid(Map<String, Object> map) {
        this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardListValid ===== \u6709\u6548\u5361\u5377\u6570\u91cf\u548c\u5546\u54c1\u5e93\u5b58 ===== {map}", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<Map<String, Object>> varList = this.cdCardvirListMapper.queryCardListValid(map);
        if (ListUtil.isNotEmpty(varList)) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardListValid {varList}", (Object)JsonUtil.buildNormalBinder().toJson(varList));
        }
        return varList;
    }

    public List<Map<String, Object>> querySkuNumByCardList(Map<String, Object> map) {
        List<Map<String, Object>> varList = this.cdCardvirListMapper.querySkuNumByCardList(map);
        return varList;
    }

    public Map<String, Object> querySkuContractSaleNum(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<Map<String, Object>> varList = this.cdCardvirListMapper.querySkuContractSaleNum(map);
            if (ListUtil.isNotEmpty(varList)) {
                for (Map<String, Object> entry : varList) {
                    result.put(entry.get("skuCode").toString(), entry.get("saleNum"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.querySkuContractSaleNum ex", (Throwable)e);
        }
        return result;
    }

    @Override
    public String distributeCardList(List<CdCardListDistributeDomain> cardListDistributeDomainList) throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList", (Object)JsonUtil.buildNormalBinder().toJson(cardListDistributeDomainList));
        if (cardListDistributeDomainList == null || ListUtil.isEmpty(cardListDistributeDomainList)) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList params is null");
            return "error";
        }
        for (CdCardListDistributeDomain cdCardListDistributeDomain : cardListDistributeDomainList) {
            if (!StringUtils.isBlank((String)cdCardListDistributeDomain.getContractBillcode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getSkuCode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getContractGoodsCode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getMemberBcode())) continue;
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList cdCardvirListDomain params is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardListDistributeDomain));
            return "error";
        }
        for (CdCardListDistributeDomain cdCardListDistributeDomain : cardListDistributeDomainList) {
            if (!"error".equals(this.provideCardListByVersion(cdCardListDistributeDomain))) continue;
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList provideCardListByVersion ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardListDistributeDomain));
            throw new ApiException("provideCardListByVersion ex");
        }
        return "success";
    }

    @Override
    public String distributeCardListDomain(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain start");
        if (ocContractDomain == null) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain ocContractReDomain is null");
            return "error";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain getGoodsList is null", (Object)JsonUtil.buildNormalBinder().toJson(ocContractDomain.getGoodsList()));
            return "error";
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractBillcode", ocContractDomain.getContractBillcode());
            map.put("skuCode", ocContractGoodsDomain.getSkuCode());
            map.put("cardProperty", ocContractGoodsDomain.getContractGoodsCode());
            map.put("tenantCode", ocContractDomain.getTenantCode());
            QueryResult<CdCardvirList> queryResult = this.queryCardvirListPage(map);
            if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain \u8ba2\u5355\u5df2\u53d1\u653e\u5361\u5377", (Object)JsonUtil.buildNormalBinder().toJson(map));
                return "success";
            }
            if (!"error".equals(this.provideCardListByVersion(ocContractGoodsDomain, ocContractDomain))) continue;
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain provideCardListByVersion ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain));
            throw new ApiException("provideCardListByVersion ex");
        }
        return "success";
    }

    private String provideCardListByVersion(OcContractGoodsDomain contractGoodsDomain, OcContractDomain ocContractReDomain) {
        int count = 0;
        while (true) {
            if (count++ > CdCardpConstants.REPEAT_COUNTS) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain provideCardListByVersion repeat count ex", (Object)("counts:" + count));
                return "error";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("skuCode", contractGoodsDomain.getSkuCode());
            params.put("cardStartState", CdCardpConstants.START_STATE_0);
            params.put("cardStartStateBatch", CdCardpConstants.START_STATE_BATCH_0);
            params.put("cardProvideState", CdCardpConstants.PROVIDE_STATE_0);
            params.put("cardpEndQstart", new Date());
            List<CdCardvirList> queryResult = this.cdCardvirListMapper.query(params);
            if (queryResult == null || ListUtil.isEmpty(queryResult)) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain cdCardvirList query is null", (Object)JsonUtil.buildNormalBinder().toJson(params));
                return "error";
            }
            CdCardvirList cdCardvirList = queryResult.get(new Random().nextInt(queryResult.size()));
            CdCardvirList cdCardvirListUp = new CdCardvirList();
            cdCardvirListUp.setCardpvirListId(cdCardvirList.getCardpvirListId());
            cdCardvirListUp.setVersion(cdCardvirList.getVersion());
            cdCardvirListUp.setContractBillcode(contractGoodsDomain.getContractBillcode());
            cdCardvirListUp.setUserinfoCode(contractGoodsDomain.getMemberBcode());
            cdCardvirListUp.setUserinfoName(contractGoodsDomain.getMemberBname());
            cdCardvirListUp.setCardProperty(contractGoodsDomain.getContractGoodsCode());
            cdCardvirListUp.setCardProvideState(CdCardpConstants.PROVIDE_STATE_1);
            cdCardvirListUp.setCardProvideCreate(new Date());
            int i = this.cdCardvirListMapper.updateByPrimaryKeySelective(cdCardvirListUp);
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain updateByPrimaryKeySelective.i", (Object)("i:" + i + ",count:" + count));
            if (i != 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int oi = 0;
                try {
                    HashMap<String, String> mapOc = new HashMap<String, String>();
                    ocContractReDomain.setContractBlance(cdCardvirList.getCardpNumber());
                    ocContractReDomain.setGoodsSupplierCode(cdCardvirList.getCardpvirListCode());
                    ocContractReDomain.setTenantCode(cdCardvirList.getTenantCode());
                    mapOc.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
                    this.internalInvoke("oc.contract.updateContractNative", mapOc);
                    oi = 1;
                }
                catch (Exception e) {
                    this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain synUpdateContract.ex", (Throwable)e);
                    throw new ApiException("exception synUpdateContract");
                }
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_DISTRIBUTE.getBusinessType());
                map.put("handelSize", i);
                map.put("handelSizeOi", oi);
                map.put("cardvirListCode", cdCardvirList.getCardpvirListCode());
                map.put("cdCardListDistributeDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
                this.createCardProcess(map);
                return "success";
            }
            if (i != 0) continue;
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardListDomain updateByPrimaryKeySelective.0.ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardvirListUp));
        }
    }

    private String provideCardListByVersion(CdCardListDistributeDomain cdCardListDistributeDomain) {
        int count = 0;
        while (true) {
            if (count++ >= CdCardpConstants.REPEAT_COUNTS) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList provideCardListByVersion repeat count ex", (Object)("counts:" + count));
                return "error";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("skuCode", cdCardListDistributeDomain.getSkuCode());
            params.put("cardStartState", CdCardpConstants.START_STATE_0);
            params.put("cardStartStateBatch", CdCardpConstants.START_STATE_BATCH_0);
            params.put("cardProvideState", CdCardpConstants.PROVIDE_STATE_0);
            params.put("cardpEndQstart", new Date());
            List<CdCardvirList> queryResult = this.cdCardvirListMapper.query(params);
            if (queryResult == null || ListUtil.isEmpty(queryResult)) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList cdCardvirList query is null", (Object)JsonUtil.buildNormalBinder().toJson(params));
                return "error";
            }
            CdCardvirList cdCardvirList = queryResult.get(new Random().nextInt(queryResult.size()));
            CdCardvirList cdCardvirListUp = new CdCardvirList();
            cdCardvirListUp.setCardpvirListId(cdCardvirList.getCardpvirListId());
            cdCardvirListUp.setVersion(cdCardvirList.getVersion());
            cdCardvirListUp.setContractBillcode(cdCardListDistributeDomain.getContractBillcode());
            cdCardvirListUp.setUserinfoCode(cdCardListDistributeDomain.getMemberBcode());
            cdCardvirListUp.setUserinfoName(cdCardListDistributeDomain.getMemberBname());
            cdCardvirListUp.setCardProperty(cdCardListDistributeDomain.getContractGoodsCode());
            cdCardvirListUp.setCardProvideState(CdCardpConstants.PROVIDE_STATE_1);
            cdCardvirListUp.setCardProvideCreate(new Date());
            int i = this.cdCardvirListMapper.updateByPrimaryKeySelective(cdCardvirListUp);
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList updateByPrimaryKeySelective.i", (Object)("i:" + i + ",count:" + count));
            if (i == 1) {
                HashMap<String, String> mapSend = new HashMap<String, String>();
                HashMap<String, Object> map = new HashMap<String, Object>();
                int oi = 0;
                try {
                    map.put("contractBillcode", cdCardListDistributeDomain.getContractBillcode());
                    map.put("tenantCode", cdCardvirList.getTenantCode());
                    mapSend.put("map", JsonUtil.buildNormalBinder().toJson(map));
                    String queryReslutStr = this.internalInvoke("oc.contract.queryContractPage", mapSend);
                    if (StringUtils.isBlank((String)queryReslutStr)) {
                        map.put("contractBlance", cdCardvirList.getCardpNumber());
                        oi = this.cdCardvirListMapper.synUpdateContract(map);
                        this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList queryContractPage is null", (Object)JsonUtil.buildNormalBinder().toJson(map));
                    } else {
                        OcContractReDomain contractReDomain = new OcContractReDomain();
                        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryReslutStr, SupQueryResult.class);
                        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractReDomain.class);
                        if (ListUtil.isNotEmpty((Collection)list)) {
                            contractReDomain = (OcContractReDomain)list.get(0);
                        }
                        if (contractReDomain.getContractId() == null) {
                            map.put("contractBlance", cdCardvirList.getCardpNumber());
                            oi = this.cdCardvirListMapper.synUpdateContract(map);
                            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList queryReslutStr.ex", (Object)queryReslutStr);
                        } else {
                            HashMap<String, String> mapOc = new HashMap<String, String>();
                            contractReDomain.setContractBlance(cdCardvirList.getCardpNumber());
                            contractReDomain.setGoodsSupplierCode(cdCardvirList.getCardpvirListCode());
                            contractReDomain.setTenantCode(cdCardvirList.getTenantCode());
                            mapOc.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
                            this.internalInvoke("oc.contract.updateContractNative", mapOc);
                            oi = 1;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList synUpdateContract.ex", (Throwable)e);
                    throw new ApiException("exception synUpdateContract");
                }
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_DISTRIBUTE.getBusinessType());
                map.put("handelSize", i);
                map.put("handelSizeOi", oi);
                map.put("cardvirListCode", cdCardvirList.getCardpvirListCode());
                map.put("cdCardListDistributeDomain", JsonUtil.buildNormalBinder().toJson((Object)cdCardListDistributeDomain));
                this.createCardProcess(map);
                this.test(cdCardvirList);
                return "success";
            }
            if (i == 0) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList updateByPrimaryKeySelective.0.ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardvirListUp));
                continue;
            }
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList updateByPrimaryKeySelective.i.ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardvirListUp));
        }
    }

    private void test(CdCardvirList cdCardvirList) {
        long start = System.currentTimeMillis();
        if ("versionTest".equals(cdCardvirList.getMemo())) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList thread sleep start", (Object)("time:" + (System.currentTimeMillis() - start)));
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.error("cd.CARDP.CdCardvirListImpl.distributeCardList thread sleep end", (Object)("time:" + (System.currentTimeMillis() - start)));
        }
        if ("exceptionSystemTest".equals(cdCardvirList.getMemo())) {
            int n = 1 / 0;
        }
        if ("exceptionThrowTest".equals(cdCardvirList.getMemo())) {
            throw new ApiException("exception");
        }
    }

    @Override
    public String sendCardList(List<CdCardListDistributeDomain> cardListDistributeDomainList) throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.sendCardList", (Object)JsonUtil.buildNormalBinder().toJson(cardListDistributeDomainList));
        if (cardListDistributeDomainList == null || ListUtil.isEmpty(cardListDistributeDomainList)) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.sendCardList params is null");
            return "error";
        }
        for (CdCardListDistributeDomain cdCardListDistributeDomain : cardListDistributeDomainList) {
            if (!StringUtils.isBlank((String)cdCardListDistributeDomain.getContractBillcode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getSkuCode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getContractGoodsCode()) && !StringUtils.isBlank((String)cdCardListDistributeDomain.getMemberBcode())) continue;
            this.logger.error("cd.CARDP.CdCardvirListImpl.sendCardList cdCardvirListDomain params is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardListDistributeDomain));
            return "error";
        }
        for (CdCardListDistributeDomain cdCardListDistributeDomain : cardListDistributeDomainList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractBillcode", cdCardListDistributeDomain.getContractBillcode());
            QueryResult<CdCardvirList> queryResult = this.queryCardvirListPage(map);
            if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.sendCardList queryCardvirListPage is null", (Object)JsonUtil.buildNormalBinder().toJson(map));
                return "error";
            }
            CdCardvirList cdCardvirList = (CdCardvirList)queryResult.getList().get(0);
            this.logger.error("cd.CARDP.CdCardvirListImpl.sendCardList sendCardList to wx", (Object)JsonUtil.buildNormalBinder().toJson((Object)cdCardvirList));
        }
        return "success";
    }
}

