/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.CdCardpConstants;
import com.yqbsoft.laser.service.cd.dao.CdCardpApplyMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardpApplyDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardpApplyReDomain;
import com.yqbsoft.laser.service.cd.model.CdCardp;
import com.yqbsoft.laser.service.cd.model.CdCardpApply;
import com.yqbsoft.laser.service.cd.service.CdCardpApplyService;
import com.yqbsoft.laser.service.cd.service.CdCardpCardService;
import com.yqbsoft.laser.service.cd.service.CdCardplistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdCardpApplyImpl
extends BaseServiceImpl
implements CdCardpApplyService {
    private static final String SYS_CODE = "cd.CARDP.CdCardpApplyImpl";
    private CdCardpApplyMapper cdCardpApplyMapper;
    private CdCardpCardService cdCardpCardService;
    private CdCardplistService cdCardplistService;

    public void setCdCardpApplyMapper(CdCardpApplyMapper cdCardpApplyMapper) {
        this.cdCardpApplyMapper = cdCardpApplyMapper;
    }

    public CdCardpApplyMapper getCdCardpApplyMapper() {
        return this.cdCardpApplyMapper;
    }

    public CdCardpCardService getCdCardpCardService() {
        return this.cdCardpCardService;
    }

    public void setCdCardpCardService(CdCardpCardService cdCardpCardService) {
        this.cdCardpCardService = cdCardpCardService;
    }

    public CdCardplistService getCdCardplistService() {
        return this.cdCardplistService;
    }

    public void setCdCardplistService(CdCardplistService cdCardplistService) {
        this.cdCardplistService = cdCardplistService;
    }

    private Date getSysDate() {
        try {
            return this.cdCardpApplyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardpApply(CdCardpApplyDomain cdCardpApplyDomain) {
        if (null == cdCardpApplyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpApplyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardpApplyDefault(CdCardpApply cdCardpApply) {
        if (null == cdCardpApply) {
            return;
        }
        if (null == cdCardpApply.getDataState()) {
            cdCardpApply.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cdCardpApply.getGmtCreate()) {
            cdCardpApply.setGmtCreate(date);
        }
        cdCardpApply.setGmtModified(date);
        if (StringUtils.isBlank((String)cdCardpApply.getCardpApplyCode())) {
            cdCardpApply.setCardpApplyCode(this.getNo(null, "CdCardpApply", "cdCardpApply", cdCardpApply.getTenantCode()));
        }
    }

    private int getCardpApplyMaxCode() {
        int code = 0;
        try {
            return this.cdCardpApplyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.getCardpApplyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardpApplyUpdataDefault(CdCardpApply cdCardpApply) {
        if (null == cdCardpApply) {
            return;
        }
        cdCardpApply.setGmtModified(this.getSysDate());
    }

    private void saveCardpApplyModel(CdCardpApply cdCardpApply) throws ApiException {
        if (null == cdCardpApply) {
            return;
        }
        try {
            this.cdCardpApplyMapper.insert(cdCardpApply);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.saveCardpApplyModel.ex", (Throwable)e);
        }
    }

    private void saveCardpApplyBatchModel(List<CdCardpApply> cdCardpApplyList) throws ApiException {
        if (null == cdCardpApplyList || cdCardpApplyList.isEmpty()) {
            return;
        }
        try {
            this.cdCardpApplyMapper.insertBatch(cdCardpApplyList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.saveCardpApplyBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardpApply getCardpApplyModelById(Integer cardpApplyId) {
        if (null == cardpApplyId) {
            return null;
        }
        try {
            return this.cdCardpApplyMapper.selectByPrimaryKey(cardpApplyId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.getCardpApplyModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardpApply getCardpApplyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardpApplyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.getCardpApplyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardpApplyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.delCardpApplyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.delCardpApplyModelByCode.num");
        }
    }

    private void deleteCardpApplyModel(Integer cardpApplyId) throws ApiException {
        if (null == cardpApplyId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.deleteByPrimaryKey(cardpApplyId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.deleteCardpApplyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.deleteCardpApplyModel.num");
        }
    }

    private void updateCardpApplyModel(CdCardpApply cdCardpApply) throws ApiException {
        if (null == cdCardpApply) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.updateByPrimaryKey(cdCardpApply);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateCardpApplyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateCardpApplyModel.num");
        }
    }

    private void updateStateCardpApplyModel(Integer cardpApplyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cardpApplyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpApplyId", cardpApplyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateStateCardpApplyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateStateCardpApplyModel.null");
        }
    }

    private void updateStateCardpApplyModelByCode(String tenantCode, String cardpApplyCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cardpApplyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpApplyCode", cardpApplyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateStateCardpApplyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateStateCardpApplyModelByCode.null");
        }
    }

    private CdCardpApply makeCardpApply(CdCardpApplyDomain cdCardpApplyDomain, CdCardpApply cdCardpApply) {
        if (null == cdCardpApplyDomain) {
            return null;
        }
        if (null == cdCardpApply) {
            cdCardpApply = new CdCardpApply();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpApply, (Object)cdCardpApplyDomain);
            return cdCardpApply;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.makeCardpApply", (Throwable)e);
            return null;
        }
    }

    private CdCardpApplyReDomain makeCdCardpApplyReDomain(CdCardpApply cdCardpApply) {
        if (null == cdCardpApply) {
            return null;
        }
        CdCardpApplyReDomain cdCardpApplyReDomain = new CdCardpApplyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpApplyReDomain, (Object)cdCardpApply);
            return cdCardpApplyReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.makeCdCardpApplyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardpApply> queryCardpApplyModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardpApplyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.queryCardpApplyModel", (Throwable)e);
            return null;
        }
    }

    private int countCardpApply(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardpApplyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpApplyImpl.countCardpApply", (Throwable)e);
        }
        return i;
    }

    private CdCardpApply createCdCardpApply(CdCardpApplyDomain cdCardpApplyDomain) {
        String msg = this.checkCardpApply(cdCardpApplyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.saveCardpApply.checkCardpApply", msg);
        }
        CdCardpApply cdCardpApply = this.makeCardpApply(cdCardpApplyDomain, null);
        this.setCardpApplyDefault(cdCardpApply);
        return cdCardpApply;
    }

    @Override
    public String saveCardpApply(CdCardpApplyDomain cdCardpApplyDomain) throws ApiException {
        CdCardp cardpByCode;
        CdCardpApply cdCardpApply = this.createCdCardpApply(cdCardpApplyDomain);
        this.saveCardpApplyModel(cdCardpApply);
        if ("0".equals(cdCardpApply.getCardpApplyType())) {
            CdCardp cardpByCode2 = this.cdCardpCardService.getCardpByCode(cdCardpApply.getTenantCode(), cdCardpApply.getCardpCode());
            if (0 != cardpByCode2.getDataState()) {
                this.cdCardpCardService.updateCardpState(cardpByCode2.getCardpId(), 0, cardpByCode2.getDataState());
            }
        } else if ("1".equals(cdCardpApply.getCardpApplyType())) {
            CdCardp cardpByCode3 = this.cdCardpCardService.getCardpByCode(cdCardpApply.getTenantCode(), cdCardpApply.getCardpCode());
            if (0 != cardpByCode3.getDataState()) {
                this.cdCardpCardService.updateCardpState(cardpByCode3.getCardpId(), 0, cardpByCode3.getDataState());
            }
        } else if ("2".equals(cdCardpApply.getCardpApplyType()) && 0 != (cardpByCode = this.cdCardpCardService.getCardpByCode(cdCardpApply.getTenantCode(), cdCardpApply.getCardpCode())).getDataState()) {
            this.cdCardpCardService.updateCardpState(cardpByCode.getCardpId(), 0, cardpByCode.getDataState());
        }
        return cdCardpApply.getCardpApplyCode();
    }

    @Override
    public String saveCardpApplyBatch(List<CdCardpApplyDomain> cdCardpApplyDomainList) throws ApiException {
        if (null == cdCardpApplyDomainList || cdCardpApplyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardpApply> cdCardpApplyList = new ArrayList<CdCardpApply>();
        String code = "";
        for (CdCardpApplyDomain cdCardpApplyDomain : cdCardpApplyDomainList) {
            CdCardpApply cdCardpApply = this.createCdCardpApply(cdCardpApplyDomain);
            code = cdCardpApply.getCardpApplyCode();
            cdCardpApplyList.add(cdCardpApply);
        }
        this.saveCardpApplyBatchModel(cdCardpApplyList);
        return code;
    }

    @Override
    public void updateCardpApplyState(Integer cardpApplyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cardpApplyId) {
            return;
        }
        this.updateStateCardpApplyModel(cardpApplyId, dataState, oldDataState, map);
    }

    @Override
    public void updateCardpApplyStateByCode(String tenantCode, String cardpApplyCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cardpApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCardpApplyModelByCode(tenantCode, cardpApplyCode, dataState, oldDataState, map);
        CdCardpApply cardpApplyByCode = this.getCardpApplyByCode(tenantCode, cardpApplyCode);
        if (null == cardpApplyByCode) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateCardpApplyStateByCode.null", "\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        if ("0".equals(cardpApplyByCode.getCardpApplyType())) {
            CdCardp cardpByCode;
            if (CdCardpConstants.dataState1 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
            } else if (CdCardpConstants.dataState2 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 2, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 2, null, cdmap);
            } else if (CdCardpConstants.dataState_1 == dataState && -1 != (cardpByCode = this.cdCardpCardService.getCardpByCode(cardpApplyByCode.getTenantCode(), cardpApplyByCode.getCardpCode())).getDataState()) {
                this.cdCardpCardService.updateCardpState(cardpByCode.getCardpId(), -1, cardpByCode.getDataState());
            }
        } else if ("1".equals(cardpApplyByCode.getCardpApplyType())) {
            CdCardp cardpByCode;
            if (CdCardpConstants.dataState1 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                cdmap.put("validState", 0);
                cdmap.put("cardpEnd", cardpApplyByCode.getCardpEnd());
                cdmap.put("cardpStart", cardpApplyByCode.getCardpStart());
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
            } else if (CdCardpConstants.dataState2 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 2, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 2, null, cdmap);
            } else if (CdCardpConstants.dataState_1 == dataState && -1 != (cardpByCode = this.cdCardpCardService.getCardpByCode(cardpApplyByCode.getTenantCode(), cardpApplyByCode.getCardpCode())).getDataState()) {
                this.cdCardpCardService.updateCardpState(cardpByCode.getCardpId(), -1, cardpByCode.getDataState());
            }
        } else if ("2".equals(cardpApplyByCode.getCardpApplyType())) {
            CdCardp cardpByCode;
            if (CdCardpConstants.dataState1 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                cdmap.put("cancelState", 2);
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
            } else if (CdCardpConstants.dataState2 == dataState) {
                HashMap<String, Object> cdmap = new HashMap<String, Object>();
                cdmap.put("userCode", cardpApplyByCode.getUserCode());
                cdmap.put("userName", cardpApplyByCode.getUserName());
                cdmap.put("verifyDate", new Date());
                cdmap.put("cancelState", 3);
                this.cdCardpCardService.updateCardpStateByCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
                this.cdCardplistService.updateCardplistStateBycardpCodeMap(tenantCode, cardpApplyByCode.getCardpCode(), 1, null, cdmap);
            } else if (CdCardpConstants.dataState_1 == dataState && -1 != (cardpByCode = this.cdCardpCardService.getCardpByCode(cardpApplyByCode.getTenantCode(), cardpApplyByCode.getCardpCode())).getDataState()) {
                this.cdCardpCardService.updateCardpState(cardpByCode.getCardpId(), -1, cardpByCode.getDataState());
            }
        }
    }

    @Override
    public void updateCardpApply(CdCardpApplyDomain cdCardpApplyDomain) throws ApiException {
        String msg = this.checkCardpApply(cdCardpApplyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateCardpApply.checkCardpApply", msg);
        }
        CdCardpApply oldCdCardpApply = this.getCardpApplyModelById(cdCardpApplyDomain.getCardpApplyId());
        if (null == oldCdCardpApply) {
            throw new ApiException("cd.CARDP.CdCardpApplyImpl.updateCardpApply.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardpApply cdCardpApply = this.makeCardpApply(cdCardpApplyDomain, oldCdCardpApply);
        this.setCardpApplyUpdataDefault(cdCardpApply);
        this.updateCardpApplyModel(cdCardpApply);
    }

    @Override
    public CdCardpApply getCardpApply(Integer cardpApplyId) {
        if (null == cardpApplyId) {
            return null;
        }
        return this.getCardpApplyModelById(cardpApplyId);
    }

    @Override
    public void deleteCardpApply(Integer cardpApplyId) throws ApiException {
        if (null == cardpApplyId) {
            return;
        }
        this.deleteCardpApplyModel(cardpApplyId);
    }

    @Override
    public QueryResult<CdCardpApply> queryCardpApplyPage(Map<String, Object> map) {
        List<CdCardpApply> cdCardpApplyList = this.queryCardpApplyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardpApply(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardpApplyList);
        return queryResult;
    }

    @Override
    public CdCardpApply getCardpApplyByCode(String tenantCode, String cardpApplyCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpApplyCode", cardpApplyCode);
        return this.getCardpApplyModelByCode(map);
    }

    @Override
    public void deleteCardpApplyByCode(String tenantCode, String cardpApplyCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpApplyCode", cardpApplyCode);
        this.delCardpApplyModelByCode(map);
    }
}

