/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.dao.CmChannelBarMapper;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelBarDomain;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelBar;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelBarService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmChannelBarServiceImpl
extends BaseServiceImpl
implements CmChannelBarService {
    public static final String SYS_CODE = "cm.CmChannelBarServiceImpl";
    private CmChannelBarMapper cmChannelBarMapper;

    public void setCmChannelBarMapper(CmChannelBarMapper cmChannelBarMapper) {
        this.cmChannelBarMapper = cmChannelBarMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmChannelBarMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelBar(CmChannelBarDomain cmChannelBarDomain) {
        if (null == cmChannelBarDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setChannelBarDefault(CmChannelBar cmChannelBar) {
        if (null == cmChannelBar) {
            return;
        }
        if (null == cmChannelBar.getDataState()) {
            cmChannelBar.setDataState(0);
        }
        if (null == cmChannelBar.getGmtCreate()) {
            cmChannelBar.setGmtCreate(this.getSysDate());
        }
        cmChannelBar.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmChannelBar.getChannelBarSeqno())) {
            cmChannelBar.setChannelBarSeqno(this.createUUIDString());
        }
    }

    private int getChannelBarMaxCode() {
        int code = 0;
        try {
            return this.cmChannelBarMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getChannelBarMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelBarUpdataDefault(CmChannelBar cmChannelBar) {
        if (null == cmChannelBar) {
            return;
        }
        cmChannelBar.setGmtModified(this.getSysDate());
    }

    private void saveChannelBarModel(CmChannelBar cmChannelBar) throws ApiException {
        if (null == cmChannelBar) {
            return;
        }
        try {
            this.cmChannelBarMapper.insert(cmChannelBar);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.saveChannelBarModel.ex", (Throwable)e);
        }
    }

    private CmChannelBar getChannelBarModelById(Integer channelBarId) {
        if (null == channelBarId) {
            return null;
        }
        try {
            return this.cmChannelBarMapper.selectByPrimaryKey(channelBarId);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getChannelBarModelById", (Throwable)e);
            return null;
        }
    }

    public CmChannelBar getChannelBarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmChannelBarMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getChannelBarModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delChannelBarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelBarMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.delChannelBarModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelBarServiceImpl.delChannelBarModelByCode.num");
        }
    }

    private void deleteChannelBarModel(Integer channelBarId) throws ApiException {
        if (null == channelBarId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelBarMapper.deleteByPrimaryKey(channelBarId);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.deleteChannelBarModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelBarServiceImpl.deleteChannelBarModel.num");
        }
    }

    private void updateChannelBarModel(CmChannelBar cmChannelBar) throws ApiException {
        if (null == cmChannelBar) {
            return;
        }
        try {
            this.cmChannelBarMapper.updateByPrimaryKeySelective(cmChannelBar);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateChannelBarModel.ex", (Throwable)e);
        }
    }

    private void updateStateChannelBarModel(String channelBarSeqno, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (StringUtils.isEmpty((String)channelBarSeqno) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelBarSeqno", channelBarSeqno);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.cmChannelBarMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateStateChannelBarModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateStateChannelBarModel.null");
        }
    }

    private void updateStateChannelBarModel(Integer channelBarId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelBarId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelBarId", channelBarId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmChannelBarMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateStateChannelBarModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateStateChannelBarModel.null");
        }
    }

    private CmChannelBar makeChannelBar(CmChannelBarDomain cmChannelBarDomain, CmChannelBar cmChannelBar) {
        if (null == cmChannelBarDomain) {
            return null;
        }
        if (null == cmChannelBar) {
            cmChannelBar = new CmChannelBar();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelBar, (Object)cmChannelBarDomain);
            return cmChannelBar;
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.makeChannelBar", (Throwable)e);
            return null;
        }
    }

    private List<CmChannelBar> queryChannelBarModelPage(Map<String, Object> parammap) {
        try {
            return this.cmChannelBarMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.queryChannelBarModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelBar(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmChannelBarMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.countChannelBar", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveChannelBar(CmChannelBarDomain cmChannelBarDomain) throws ApiException {
        String msg = this.checkChannelBar(cmChannelBarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelBarServiceImpl.saveChannelBar.checkChannelBar", msg);
        }
        CmChannelBar cmChannelBar = this.makeChannelBar(cmChannelBarDomain, null);
        this.setChannelBarDefault(cmChannelBar);
        this.saveChannelBarModel(cmChannelBar);
    }

    @Override
    public void updateChannelBarState(Integer channelBarId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelBarModel(channelBarId, dataState, oldDataState);
    }

    @Override
    public void updateChannelBar(CmChannelBarDomain cmChannelBarDomain) throws ApiException {
        String msg = this.checkChannelBar(cmChannelBarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelBarServiceImpl.updateChannelBar.checkChannelBar", msg);
        }
        CmChannelBar cmChannelBar = this.makeChannelBar(cmChannelBarDomain, null);
        this.setChannelBarUpdataDefault(cmChannelBar);
        this.updateChannelBarModel(cmChannelBar);
        this.updateStateChannelBarModel(cmChannelBarDomain.getChannelBarSeqno(), (Integer)1, (Integer)0);
    }

    @Override
    public void updateBarState(CmChannelBarDomain cmChannelBarDomain, Integer dataState, Integer oldDataState) {
        this.updateStateChannelBarModel(cmChannelBarDomain.getChannelBarSeqno(), dataState, oldDataState);
    }

    @Override
    public CmChannelBar getChannelBar(Integer channelBarId) {
        return this.getChannelBarModelById(channelBarId);
    }

    @Override
    public void deleteChannelBar(Integer channelBarId) throws ApiException {
        this.deleteChannelBarModel(channelBarId);
    }

    @Override
    public QueryResult<CmChannelBar> queryChannelBarPage(Map<String, Object> map) {
        List<CmChannelBar> cmChannelBarList = this.queryChannelBarModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelBar(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmChannelBarList);
        return queryResult;
    }

    @Override
    public CmChannelBar getChannelBarByCode(Map<String, Object> map) {
        return this.getChannelBarModelByCode(map);
    }

    @Override
    public void delChannelBarByCode(Map<String, Object> map) throws ApiException {
        this.delChannelBarModelByCode(map);
    }

    @Override
    public CmChannelBar getCmChannelBarByState(Map<String, Object> stateMap) {
        if (null == stateMap) {
            return null;
        }
        try {
            return this.cmChannelBarMapper.getState(stateMap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getChannelBarModelById", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CmChannelBar> getSuccess(Map<String, Object> map) {
        try {
            return this.cmChannelBarMapper.getSuccess(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelBarServiceImpl.getSuccess", (Throwable)e);
            return null;
        }
    }
}

