/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cls.service.impl;

import com.yqbsoft.laser.service.cls.dao.ClsClaimsMapper;
import com.yqbsoft.laser.service.cls.domain.ClsClaimsDomain;
import com.yqbsoft.laser.service.cls.domain.ClsClaimsReDomain;
import com.yqbsoft.laser.service.cls.model.ClsClaims;
import com.yqbsoft.laser.service.cls.service.ClsClaimsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClsClaimsServiceImpl
extends BaseServiceImpl
implements ClsClaimsService {
    private static final String SYS_CODE = "cls.ClsClaimsServiceImpl";
    private ClsClaimsMapper clsClaimsMapper;

    public void setClsClaimsMapper(ClsClaimsMapper clsClaimsMapper) {
        this.clsClaimsMapper = clsClaimsMapper;
    }

    private Date getSysDate() {
        try {
            return this.clsClaimsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkclaims(ClsClaimsDomain clsClaimsDomain) {
        if (null == clsClaimsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)clsClaimsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setclaimsDefault(ClsClaims clsClaims) {
        if (null == clsClaims) {
            return;
        }
        if (null == clsClaims.getDataState()) {
            clsClaims.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == clsClaims.getGmtCreate()) {
            clsClaims.setGmtCreate(date);
        }
        clsClaims.setGmtModified(date);
        if (StringUtils.isBlank((String)clsClaims.getClaimsCode())) {
            clsClaims.setClaimsCode(this.getNo(null, "ClsClaims", "clsClaims", clsClaims.getTenantCode()));
        }
    }

    private int getclaimsMaxCode() {
        int code = 0;
        try {
            return this.clsClaimsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.getclaimsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setclaimsUpdataDefault(ClsClaims clsClaims) {
        if (null == clsClaims) {
            return;
        }
        clsClaims.setGmtModified(this.getSysDate());
    }

    private void saveclaimsModel(ClsClaims clsClaims) throws ApiException {
        if (null == clsClaims) {
            return;
        }
        try {
            this.clsClaimsMapper.insert(clsClaims);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.saveclaimsModel.ex", (Throwable)e);
        }
    }

    private void saveclaimsBatchModel(List<ClsClaims> clsClaimsList) throws ApiException {
        if (null == clsClaimsList || clsClaimsList.isEmpty()) {
            return;
        }
        try {
            this.clsClaimsMapper.insertBatch(clsClaimsList);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.saveclaimsBatchModel.ex", (Throwable)e);
        }
    }

    private ClsClaims getclaimsModelById(Integer claimsId) {
        if (null == claimsId) {
            return null;
        }
        try {
            return this.clsClaimsMapper.selectByPrimaryKey(claimsId);
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.getclaimsModelById", (Throwable)e);
            return null;
        }
    }

    private ClsClaims getclaimsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.clsClaimsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.getclaimsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delclaimsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.clsClaimsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.delclaimsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cls.ClsClaimsServiceImpl.delclaimsModelByCode.num");
        }
    }

    private void deleteclaimsModel(Integer claimsId) throws ApiException {
        if (null == claimsId) {
            return;
        }
        int i = 0;
        try {
            i = this.clsClaimsMapper.deleteByPrimaryKey(claimsId);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.deleteclaimsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cls.ClsClaimsServiceImpl.deleteclaimsModel.num");
        }
    }

    private void updateclaimsModel(ClsClaims clsClaims) throws ApiException {
        if (null == clsClaims) {
            return;
        }
        int i = 0;
        try {
            i = this.clsClaimsMapper.updateByPrimaryKey(clsClaims);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateclaimsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateclaimsModel.num");
        }
    }

    private void updateStateclaimsModel(Integer claimsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == claimsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("claimsId", claimsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.clsClaimsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateStateclaimsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateStateclaimsModel.null");
        }
    }

    private void updateStateclaimsModelByCode(String tenantCode, String claimsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)claimsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("claimsCode", claimsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.clsClaimsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateStateclaimsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateStateclaimsModelByCode.null");
        }
    }

    private ClsClaims makeclaims(ClsClaimsDomain clsClaimsDomain, ClsClaims clsClaims) {
        if (null == clsClaimsDomain) {
            return null;
        }
        if (null == clsClaims) {
            clsClaims = new ClsClaims();
        }
        try {
            BeanUtils.copyAllPropertys((Object)clsClaims, (Object)clsClaimsDomain);
            return clsClaims;
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.makeclaims", (Throwable)e);
            return null;
        }
    }

    private ClsClaimsReDomain makeClsClaimsReDomain(ClsClaims clsClaims) {
        if (null == clsClaims) {
            return null;
        }
        ClsClaimsReDomain clsClaimsReDomain = new ClsClaimsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)clsClaimsReDomain, (Object)clsClaims);
            return clsClaimsReDomain;
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.makeClsClaimsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ClsClaims> queryclaimsModelPage(Map<String, Object> parammap) {
        try {
            return this.clsClaimsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.queryclaimsModel", (Throwable)e);
            return null;
        }
    }

    private int countclaims(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.clsClaimsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cls.ClsClaimsServiceImpl.countclaims", (Throwable)e);
        }
        return i;
    }

    private ClsClaims createClsClaims(ClsClaimsDomain clsClaimsDomain) {
        String msg = this.checkclaims(clsClaimsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cls.ClsClaimsServiceImpl.saveclaims.checkclaims", msg);
        }
        ClsClaims clsClaims = this.makeclaims(clsClaimsDomain, null);
        this.setclaimsDefault(clsClaims);
        return clsClaims;
    }

    @Override
    public String saveclaims(ClsClaimsDomain clsClaimsDomain) throws ApiException {
        ClsClaims clsClaims = this.createClsClaims(clsClaimsDomain);
        this.saveclaimsModel(clsClaims);
        return clsClaims.getClaimsCode();
    }

    @Override
    public String saveclaimsBatch(List<ClsClaimsDomain> clsClaimsDomainList) throws ApiException {
        if (null == clsClaimsDomainList || clsClaimsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ClsClaims> clsClaimsList = new ArrayList<ClsClaims>();
        String code = "";
        for (ClsClaimsDomain clsClaimsDomain : clsClaimsDomainList) {
            ClsClaims clsClaims = this.createClsClaims(clsClaimsDomain);
            code = clsClaims.getClaimsCode();
            clsClaimsList.add(clsClaims);
        }
        this.saveclaimsBatchModel(clsClaimsList);
        return code;
    }

    @Override
    public void updateclaimsState(Integer claimsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == claimsId) {
            return;
        }
        this.updateStateclaimsModel(claimsId, dataState, oldDataState, map);
    }

    @Override
    public void updateclaimsStateByCode(String tenantCode, String claimsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)claimsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateclaimsModelByCode(tenantCode, claimsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateclaims(ClsClaimsDomain clsClaimsDomain) throws ApiException {
        String msg = this.checkclaims(clsClaimsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateclaims.checkclaims", msg);
        }
        ClsClaims oldClsClaims = this.getclaimsModelById(clsClaimsDomain.getClaimsId());
        if (null == oldClsClaims) {
            throw new ApiException("cls.ClsClaimsServiceImpl.updateclaims.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ClsClaims clsClaims = this.makeclaims(clsClaimsDomain, oldClsClaims);
        this.setclaimsUpdataDefault(clsClaims);
        this.updateclaimsModel(clsClaims);
    }

    @Override
    public ClsClaims getclaims(Integer claimsId) {
        if (null == claimsId) {
            return null;
        }
        return this.getclaimsModelById(claimsId);
    }

    @Override
    public void deleteclaims(Integer claimsId) throws ApiException {
        if (null == claimsId) {
            return;
        }
        this.deleteclaimsModel(claimsId);
    }

    @Override
    public QueryResult<ClsClaims> queryclaimsPage(Map<String, Object> map) {
        List<ClsClaims> clsClaimsList = this.queryclaimsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countclaims(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(clsClaimsList);
        return queryResult;
    }

    @Override
    public ClsClaims getclaimsByCode(String tenantCode, String claimsCode) throws ApiException {
        if (StringUtils.isBlank((String)claimsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("claimsCode", claimsCode);
        return this.getclaimsModelByCode(map);
    }

    @Override
    public void deleteclaimsByCode(String tenantCode, String claimsCode) throws ApiException {
        if (StringUtils.isBlank((String)claimsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("claimsCode", claimsCode);
        this.delclaimsModelByCode(map);
    }
}

