/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.biz.ApprovalServiceBiz;
import com.yqbsoft.laser.service.contract.enums.ApprovalTypeEnum;
import com.yqbsoft.laser.service.contract.model.OcApprovalDetail;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.contract.requery.ApprovalApplyRequest;
import com.yqbsoft.laser.service.contract.requery.ApprovalApproveRequest;
import com.yqbsoft.laser.service.contract.requery.ApprovalRejectRequest;
import com.yqbsoft.laser.service.contract.service.OcApprovalService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="ocApprovalService")
public class OcApprovalServiceImpl
extends BaseServiceImpl
implements OcApprovalService {
    private final ApprovalServiceBiz approvalServiceBiz;

    @Override
    public SupQueryResult<OcApprovalInstance> getApprovalList(Map<String, Object> map) {
        return this.approvalServiceBiz.getApprovalList(map);
    }

    @Override
    public OcApprovalInstance applyApproval(ApprovalApplyRequest applyRequest) {
        return this.approvalServiceBiz.applyApproval(applyRequest.getBizId(), ApprovalTypeEnum.require(applyRequest.getApprovalType()), applyRequest.getApplyUserId(), applyRequest.getApplyUserName());
    }

    @Override
    public OcApprovalDetail getApprovalDetail(Long approvalId) {
        return this.approvalServiceBiz.getApprovalDetail(approvalId);
    }

    @Override
    public void approve(ApprovalApproveRequest approveRequest) {
        this.approvalServiceBiz.approve(approveRequest.getApprovalId(), approveRequest.getUserId(), approveRequest.getUserName(), approveRequest.getRemark());
    }

    @Override
    public void reject(ApprovalRejectRequest rejectRequest) {
        this.approvalServiceBiz.reject(rejectRequest.getApprovalId(), rejectRequest.getUserId(), rejectRequest.getUserName(), rejectRequest.getReason());
    }

    public OcApprovalServiceImpl(ApprovalServiceBiz approvalServiceBiz) {
        this.approvalServiceBiz = approvalServiceBiz;
    }
}

