/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.es;

import com.yqbsoft.laser.service.contract.es.SyncTradeFuture;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import com.yqbsoft.laser.service.suppercore.cache.repository.InvokeFuture;
import com.yqbsoft.laser.service.tool.util.StringUtils;

public class ContractQueryCall {
    private static final String sys_code = "oc.CONTRACT.call";
    protected static final OpenLogUtil logger = new OpenLogUtil(ContractQueryCall.class);
    public static final String PTEQUERY_CALL = "ocContract-state";
    public static final long DEFAULT_TIME = 5000L;
    private boolean synFlag = false;
    private String correlationId;
    private long timeout = 0L;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public static void putSync(String type, String correlationId, SyncTradeFuture syncInvokeFuture, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == syncInvokeFuture) {
            return;
        }
        CacheBean bean = new CacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setFuture((InvokeFuture)syncInvokeFuture);
        bean.setCacheKey(type);
        BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).put(correlationId, (Object)bean);
    }

    public static InvokeFuture getSync(String type, String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).remove(correlationId);
        return bean != null ? bean.getFuture() : null;
    }

    public boolean isSynFlag() {
        return this.synFlag;
    }

    public void setSynFlag(boolean synFlag) {
        this.synFlag = synFlag;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void call(String type, String correlationId, String obj) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("oc.CONTRACT.call.call", (Object)"correlationId is null");
            return;
        }
        SupDisUtil.set((String)(type + "-" + correlationId), (String)obj, (int)300);
        SupDisUtil.set((String)(type + "-" + correlationId + "-" + obj), (String)obj, (int)300);
        InvokeFuture invokeFuture = ContractQueryCall.getSync(type, correlationId);
        if (null != invokeFuture) {
            invokeFuture.setDone((Object)obj);
        }
    }
}

