/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcShopsetMapper;
import com.yqbsoft.laser.service.contract.domain.OcRecflowPserviceReDomain;
import com.yqbsoft.laser.service.contract.domain.OcShopsetDomain;
import com.yqbsoft.laser.service.contract.domain.OcShopsetReDomain;
import com.yqbsoft.laser.service.contract.model.OcShopset;
import com.yqbsoft.laser.service.contract.service.OcShopsetService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.freemarker.FreemarkerUtil;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcShopsetServiceImpl
extends BaseServiceImpl
implements OcShopsetService {
    private static final String SYS_CODE = "oc.CONTRACT.OcShopsetServiceImpl";
    private OcShopsetMapper ocShopsetMapper;

    public void setOcShopsetMapper(OcShopsetMapper ocShopsetMapper) {
        this.ocShopsetMapper = ocShopsetMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocShopsetMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkshopset(OcShopsetDomain ocShopsetDomain) {
        if (null == ocShopsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocShopsetDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setshopsetDefault(OcShopset ocShopset) {
        if (null == ocShopset) {
            return;
        }
        if (null == ocShopset.getDataState()) {
            ocShopset.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocShopset.getGmtCreate()) {
            ocShopset.setGmtCreate(date);
        }
        ocShopset.setGmtModified(date);
        if (StringUtils.isBlank((String)ocShopset.getShopsetCode())) {
            ocShopset.setShopsetCode(this.getNo(null, "OcShopset", "ocShopset", ocShopset.getTenantCode()));
        }
    }

    private int getshopsetMaxCode() {
        int code = 0;
        try {
            return this.ocShopsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.getshopsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setshopsetUpdataDefault(OcShopset ocShopset) {
        if (null == ocShopset) {
            return;
        }
        ocShopset.setGmtModified(this.getSysDate());
    }

    private void saveshopsetModel(OcShopset ocShopset) throws ApiException {
        if (null == ocShopset) {
            return;
        }
        try {
            this.ocShopsetMapper.insert(ocShopset);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.saveshopsetModel.ex", (Throwable)e);
        }
    }

    private void saveshopsetBatchModel(List<OcShopset> ocShopsetList) throws ApiException {
        if (null == ocShopsetList || ocShopsetList.isEmpty()) {
            return;
        }
        try {
            this.ocShopsetMapper.insertBatch(ocShopsetList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.saveshopsetBatchModel.ex", (Throwable)e);
        }
    }

    private OcShopset getshopsetModelById(Integer shopsetId) {
        if (null == shopsetId) {
            return null;
        }
        try {
            return this.ocShopsetMapper.selectByPrimaryKey(shopsetId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.getshopsetModelById", (Throwable)e);
            return null;
        }
    }

    private OcShopset getshopsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocShopsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.getshopsetModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delshopsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShopsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.delshopsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.delshopsetModelByCode.num");
        }
    }

    private void deleteshopsetModel(Integer shopsetId) throws ApiException {
        if (null == shopsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShopsetMapper.deleteByPrimaryKey(shopsetId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.deleteshopsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.deleteshopsetModel.num");
        }
    }

    private void updateshopsetModel(OcShopset ocShopset) throws ApiException {
        if (null == ocShopset) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShopsetMapper.updateByPrimaryKey(ocShopset);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateshopsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateshopsetModel.num");
        }
    }

    private void updateStateshopsetModel(Integer shopsetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == shopsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopsetId", shopsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocShopsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateStateshopsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateStateshopsetModel.null");
        }
    }

    private void updateStateshopsetModelByCode(String tenantCode, String shopsetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)shopsetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopsetCode", shopsetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocShopsetMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateStateshopsetModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateStateshopsetModelByCode.null");
        }
    }

    private OcShopset makeshopset(OcShopsetDomain ocShopsetDomain, OcShopset ocShopset) {
        if (null == ocShopsetDomain) {
            return null;
        }
        if (null == ocShopset) {
            ocShopset = new OcShopset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShopset, (Object)ocShopsetDomain);
            return ocShopset;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.makeshopset", (Throwable)e);
            return null;
        }
    }

    private OcShopsetReDomain makeOcShopsetReDomain(OcShopset ocShopset) {
        if (null == ocShopset) {
            return null;
        }
        OcShopsetReDomain ocShopsetReDomain = new OcShopsetReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShopsetReDomain, (Object)ocShopset);
            return ocShopsetReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.makeOcShopsetReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcShopset> queryshopsetModelPage(Map<String, Object> parammap) {
        try {
            return this.ocShopsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.queryshopsetModel", (Throwable)e);
            return null;
        }
    }

    private int countshopset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocShopsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.countshopset", (Throwable)e);
        }
        return i;
    }

    private OcShopset createOcShopset(OcShopsetDomain ocShopsetDomain) {
        String msg = this.checkshopset(ocShopsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.saveshopset.checkshopset", msg);
        }
        OcShopset ocShopset = this.makeshopset(ocShopsetDomain, null);
        this.setshopsetDefault(ocShopset);
        return ocShopset;
    }

    @Override
    public String saveshopset(OcShopsetDomain ocShopsetDomain) throws ApiException {
        OcShopset ocShopset = this.createOcShopset(ocShopsetDomain);
        this.saveshopsetModel(ocShopset);
        return ocShopset.getShopsetCode();
    }

    @Override
    public String saveshopsetBatch(List<OcShopsetDomain> ocShopsetDomainList) throws ApiException {
        if (null == ocShopsetDomainList || ocShopsetDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcShopset> ocShopsetList = new ArrayList<OcShopset>();
        String code = "";
        for (OcShopsetDomain ocShopsetDomain : ocShopsetDomainList) {
            OcShopset ocShopset = this.createOcShopset(ocShopsetDomain);
            code = ocShopset.getShopsetCode();
            ocShopsetList.add(ocShopset);
        }
        this.saveshopsetBatchModel(ocShopsetList);
        return code;
    }

    @Override
    public void updateshopsetState(Integer shopsetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == shopsetId) {
            return;
        }
        this.updateStateshopsetModel(shopsetId, dataState, oldDataState, map);
    }

    @Override
    public void updateshopsetStateByCode(String tenantCode, String shopsetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)shopsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateshopsetModelByCode(tenantCode, shopsetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateshopset(OcShopsetDomain ocShopsetDomain) throws ApiException {
        String msg = this.checkshopset(ocShopsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateshopset.checkshopset", msg);
        }
        OcShopset oldOcShopset = this.getshopsetModelById(ocShopsetDomain.getShopsetId());
        if (null == oldOcShopset) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.updateshopset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcShopset ocShopset = this.makeshopset(ocShopsetDomain, oldOcShopset);
        this.setshopsetUpdataDefault(ocShopset);
        this.updateshopsetModel(ocShopset);
    }

    @Override
    public OcShopset getshopset(Integer shopsetId) {
        if (null == shopsetId) {
            return null;
        }
        return this.getshopsetModelById(shopsetId);
    }

    @Override
    public void deleteshopset(Integer shopsetId) throws ApiException {
        if (null == shopsetId) {
            return;
        }
        this.deleteshopsetModel(shopsetId);
    }

    @Override
    public QueryResult<OcShopset> queryshopsetPage(Map<String, Object> map) {
        List<OcShopset> ocShopsetList = this.queryshopsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countshopset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocShopsetList);
        return queryResult;
    }

    @Override
    public OcShopset getshopsetByCode(String tenantCode, String shopsetCode) throws ApiException {
        if (StringUtils.isBlank((String)shopsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopsetCode", shopsetCode);
        return this.getshopsetModelByCode(map);
    }

    @Override
    public void deleteshopsetByCode(String tenantCode, String shopsetCode) throws ApiException {
        if (StringUtils.isBlank((String)shopsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopsetCode", shopsetCode);
        this.delshopsetModelByCode(map);
    }

    @Override
    public List<OcShopset> queryShopsetByType(String tenantCode, String shopsetType) throws ApiException {
        if (StringUtils.isBlank((String)shopsetType) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return this.queryShopsetByType(this.getQueryMapParam("tenantCode,shopsetType", new Object[]{tenantCode, shopsetType}));
    }

    @Override
    public List<OcShopset> queryShopsetByTypemap(Map<String, Object> map) throws ApiException {
        return this.queryShopsetByType(map);
    }

    public List<OcShopset> queryShopsetByType(Map<String, Object> parammap) throws ApiException {
        if (MapUtil.isEmpty(parammap)) {
            return null;
        }
        String shopsetType = (String)parammap.get("shopsetType");
        String tenantCode = (String)parammap.get("tenantCode");
        if (StringUtils.isBlank((String)shopsetType) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<OcShopset> ocShopsetList = this.queryshopsetModelPage(this.getQueryMapParam("shopsetType,tenantCode", new Object[]{shopsetType, tenantCode}));
        if (ListUtil.isEmpty(ocShopsetList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> remap = null;
        for (OcShopset ocShopset : ocShopsetList) {
            OcRecflowPserviceReDomain ocRecflowPserviceReDomain;
            if (StringUtils.isBlank((String)ocShopset.getShopsetInfo()) || null == (ocRecflowPserviceReDomain = this.getPservice(ocShopset.getCflowPserviceCode(), ocShopset.getTenantCode()))) continue;
            map.put("ocShopset", ocShopset);
            if (StringUtils.isNotBlank((String)ocShopset.getShopsetRemark())) {
                JsonUtil.buildNormalBinder();
                map.putAll(JsonUtil.getJsonToMap((String)ocShopset.getShopsetRemark()));
            }
            map.putAll(parammap);
            remap = this.callService(ocRecflowPserviceReDomain, map);
            if (!MapUtil.isNotEmpty(remap)) continue;
            ocShopset.setShopsetInfo(FreemarkerUtil.returnTranslateByString(map, (String)ocShopset.getShopsetInfo()));
        }
        return ocShopsetList;
    }

    private OcRecflowPserviceReDomain getPservice(String cflowPserviceCode, String tenantCode) {
        if (StringUtils.isBlank((String)cflowPserviceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (cflowPserviceCode.indexOf("mock") >= 0) {
            OcRecflowPserviceReDomain ocRecflowPserviceReDomain = new OcRecflowPserviceReDomain();
            ocRecflowPserviceReDomain.setRecflowPserviceCode(cflowPserviceCode);
            ocRecflowPserviceReDomain.setTenantCode(tenantCode);
            ocRecflowPserviceReDomain.setDataState(1);
            ocRecflowPserviceReDomain.setDataCalltype("API");
            ocRecflowPserviceReDomain.setDataCallurl("mock");
            return ocRecflowPserviceReDomain;
        }
        OcRecflowPserviceReDomain ocRecflowPserviceReDomain = (OcRecflowPserviceReDomain)DisUtil.getMapJson((String)"OcRecflowPservice", (String)(cflowPserviceCode + "-" + tenantCode), OcRecflowPserviceReDomain.class);
        if (null == ocRecflowPserviceReDomain) {
            ocRecflowPserviceReDomain = (OcRecflowPserviceReDomain)DisUtil.getMapJson((String)"OcRecflowPservice", (String)(cflowPserviceCode + "-" + "00000000"), OcRecflowPserviceReDomain.class);
        }
        if (null == ocRecflowPserviceReDomain) {
            throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.getPservice.noservice", cflowPserviceCode + "-" + tenantCode);
        }
        return ocRecflowPserviceReDomain;
    }

    private Map<String, Object> callService(OcRecflowPserviceReDomain ocRecflowPserviceReDomain, Map<String, Object> map) {
        if (null == ocRecflowPserviceReDomain) {
            return null;
        }
        if ("mock".equals(ocRecflowPserviceReDomain.getDataCallurl())) {
            return null;
        }
        String paramStr = SoaUtil.makeParam((String)ocRecflowPserviceReDomain.getDataParam(), (String)ocRecflowPserviceReDomain.getDataCom(), map);
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)ocRecflowPserviceReDomain.getDataCalltype(), (String)ocRecflowPserviceReDomain.getDataCallurl(), (String)paramStr, null);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.callService.error.e", (Object)ocRecflowPserviceReDomain.getDataCallurl(), (Throwable)e);
            return null;
        }
        OutMessage outMessage = null;
        String res = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError()) {
                this.logger.error("oc.CONTRACT.OcShopsetServiceImpl.callService.error.obj", (Object)(outMessage.getReObj() + "======" + outMessage.isError() + "======" + ocRecflowPserviceReDomain.getDataCallurl()));
                throw new ApiException("oc.CONTRACT.OcShopsetServiceImpl.callService.error", ocRecflowPserviceReDomain.getDataCallurl());
            }
            if (null != outMessage.getReObj()) {
                res = outMessage.getReObj().toString();
            }
        } else {
            res = (String)obj;
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(res, String.class, Object.class);
    }
}

