/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractEditMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractEditDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractEditReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractEdit;
import com.yqbsoft.laser.service.contract.service.OcContractEditService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractEditServiceImpl
extends BaseServiceImpl
implements OcContractEditService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractEditServiceImpl";
    private OcContractEditMapper ocContractEditMapper;

    public void setOcContractEditMapper(OcContractEditMapper ocContractEditMapper) {
        this.ocContractEditMapper = ocContractEditMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractEditMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractEdit(OcContractEditDomain ocContractEditDomain) {
        if (null == ocContractEditDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractEditDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractEditDefault(OcContractEdit ocContractEdit) {
        if (null == ocContractEdit) {
            return;
        }
        if (null == ocContractEdit.getDataState()) {
            ocContractEdit.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractEdit.getGmtCreate()) {
            ocContractEdit.setGmtCreate(date);
        }
        ocContractEdit.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractEdit.getContractEditCode())) {
            ocContractEdit.setContractEditCode(this.getNo(null, "OcContractEdit", "ocContractEdit", ocContractEdit.getTenantCode()));
        }
    }

    private int getContractEditMaxCode() {
        int code = 0;
        try {
            return this.ocContractEditMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.getContractEditMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractEditUpdataDefault(OcContractEdit ocContractEdit) {
        if (null == ocContractEdit) {
            return;
        }
        ocContractEdit.setGmtModified(this.getSysDate());
    }

    private void saveContractEditModel(OcContractEdit ocContractEdit) throws ApiException {
        if (null == ocContractEdit) {
            return;
        }
        try {
            this.ocContractEditMapper.insert(ocContractEdit);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.saveContractEditModel.ex", (Throwable)e);
        }
    }

    private void saveContractEditBatchModel(List<OcContractEdit> ocContractEditList) throws ApiException {
        if (null == ocContractEditList || ocContractEditList.isEmpty()) {
            return;
        }
        try {
            this.ocContractEditMapper.insertBatch(ocContractEditList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.saveContractEditBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractEdit getContractEditModelById(Integer contractEditId) {
        if (null == contractEditId) {
            return null;
        }
        try {
            return this.ocContractEditMapper.selectByPrimaryKey(contractEditId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.getContractEditModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractEdit getContractEditModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractEditMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.getContractEditModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractEditModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractEditMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.delContractEditModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.delContractEditModelByCode.num");
        }
    }

    private void deleteContractEditModel(Integer contractEditId) throws ApiException {
        if (null == contractEditId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractEditMapper.deleteByPrimaryKey(contractEditId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.deleteContractEditModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.deleteContractEditModel.num");
        }
    }

    private void updateContractEditModel(OcContractEdit ocContractEdit) throws ApiException {
        if (null == ocContractEdit) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractEditMapper.updateByPrimaryKey(ocContractEdit);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateContractEditModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateContractEditModel.num");
        }
    }

    private void updateStateContractEditModel(Integer contractEditId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractEditId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractEditId", contractEditId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractEditMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateStateContractEditModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateStateContractEditModel.null");
        }
    }

    private void updateStateContractEditModelByCode(String tenantCode, String contractEditCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractEditCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractEditCode", contractEditCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractEditMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateStateContractEditModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateStateContractEditModelByCode.null");
        }
    }

    private OcContractEdit makeContractEdit(OcContractEditDomain ocContractEditDomain, OcContractEdit ocContractEdit) {
        if (null == ocContractEditDomain) {
            return null;
        }
        if (null == ocContractEdit) {
            ocContractEdit = new OcContractEdit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractEdit, (Object)ocContractEditDomain);
            return ocContractEdit;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.makeContractEdit", (Throwable)e);
            return null;
        }
    }

    private OcContractEditReDomain makeOcContractEditReDomain(OcContractEdit ocContractEdit) {
        if (null == ocContractEdit) {
            return null;
        }
        OcContractEditReDomain ocContractEditReDomain = new OcContractEditReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractEditReDomain, (Object)ocContractEdit);
            return ocContractEditReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.makeOcContractEditReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractEdit> queryContractEditModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractEditMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.queryContractEditModel", (Throwable)e);
            return null;
        }
    }

    private int countContractEdit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractEditMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractEditServiceImpl.countContractEdit", (Throwable)e);
        }
        return i;
    }

    private OcContractEdit createOcContractEdit(OcContractEditDomain ocContractEditDomain) {
        String msg = this.checkContractEdit(ocContractEditDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.saveContractEdit.checkContractEdit", msg);
        }
        OcContractEdit ocContractEdit = this.makeContractEdit(ocContractEditDomain, null);
        this.setContractEditDefault(ocContractEdit);
        return ocContractEdit;
    }

    @Override
    public String saveContractEdit(OcContractEditDomain ocContractEditDomain) throws ApiException {
        OcContractEdit ocContractEdit = this.createOcContractEdit(ocContractEditDomain);
        this.saveContractEditModel(ocContractEdit);
        return ocContractEdit.getContractEditCode();
    }

    @Override
    public String saveContractEditBatch(List<OcContractEditDomain> ocContractEditDomainList) throws ApiException {
        if (null == ocContractEditDomainList || ocContractEditDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractEdit> ocContractEditList = new ArrayList<OcContractEdit>();
        String code = "";
        for (OcContractEditDomain ocContractEditDomain : ocContractEditDomainList) {
            OcContractEdit ocContractEdit = this.createOcContractEdit(ocContractEditDomain);
            code = ocContractEdit.getContractEditCode();
            ocContractEditList.add(ocContractEdit);
        }
        this.saveContractEditBatchModel(ocContractEditList);
        return code;
    }

    @Override
    public void updateContractEditState(Integer contractEditId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractEditId) {
            return;
        }
        this.updateStateContractEditModel(contractEditId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractEditStateByCode(String tenantCode, String contractEditCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractEditCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractEditModelByCode(tenantCode, contractEditCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractEdit(OcContractEditDomain ocContractEditDomain) throws ApiException {
        String msg = this.checkContractEdit(ocContractEditDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateContractEdit.checkContractEdit", msg);
        }
        OcContractEdit oldOcContractEdit = this.getContractEditModelById(ocContractEditDomain.getContractEditId());
        if (null == oldOcContractEdit) {
            throw new ApiException("oc.CONTRACT.OcContractEditServiceImpl.updateContractEdit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractEdit ocContractEdit = this.makeContractEdit(ocContractEditDomain, oldOcContractEdit);
        this.setContractEditUpdataDefault(ocContractEdit);
        this.updateContractEditModel(ocContractEdit);
    }

    @Override
    public OcContractEdit getContractEdit(Integer contractEditId) {
        if (null == contractEditId) {
            return null;
        }
        return this.getContractEditModelById(contractEditId);
    }

    @Override
    public void deleteContractEdit(Integer contractEditId) throws ApiException {
        if (null == contractEditId) {
            return;
        }
        this.deleteContractEditModel(contractEditId);
    }

    @Override
    public QueryResult<OcContractEdit> queryContractEditPage(Map<String, Object> map) {
        List<OcContractEdit> ocContractEditList = this.queryContractEditModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractEdit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractEditList);
        return queryResult;
    }

    @Override
    public OcContractEdit getContractEditByCode(String tenantCode, String contractEditCode) throws ApiException {
        if (StringUtils.isBlank((String)contractEditCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractEditCode", contractEditCode);
        return this.getContractEditModelByCode(map);
    }

    @Override
    public void deleteContractEditByCode(String tenantCode, String contractEditCode) throws ApiException {
        if (StringUtils.isBlank((String)contractEditCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractEditCode", contractEditCode);
        this.delContractEditModelByCode(map);
    }
}

