/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractproMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractproDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractproReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractpro;
import com.yqbsoft.laser.service.contract.service.OcContractproService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OcContractproServiceImpl
extends BaseServiceImpl
implements OcContractproService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractproServiceImpl";
    private OcContractproMapper ocContractproMapper;
    private static Map<String, Object> CONTRACT_PRO_OBJ = new ConcurrentHashMap<String, Object>();

    public void setOcContractproMapper(OcContractproMapper ocContractproMapper) {
        this.ocContractproMapper = ocContractproMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkcontractpro(OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractproDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setcontractproDefault(OcContractpro ocContractpro) {
        if (null == ocContractpro) {
            return;
        }
        if (null == ocContractpro.getDataState()) {
            ocContractpro.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractpro.getGmtCreate()) {
            ocContractpro.setGmtCreate(date);
        }
        ocContractpro.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractpro.getContractproBillcode())) {
            ocContractpro.setContractproBillcode(this.getNo(null, "OcContractpro", "ocContractpro", ocContractpro.getTenantCode()));
        }
    }

    private int getcontractproMaxCode() {
        int code = 0;
        try {
            return this.ocContractproMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.getcontractproMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setcontractproUpdataDefault(OcContractpro ocContractpro) {
        if (null == ocContractpro) {
            return;
        }
        ocContractpro.setGmtModified(this.getSysDate());
    }

    private void savecontractproModel(OcContractpro ocContractpro) throws ApiException {
        if (null == ocContractpro) {
            return;
        }
        try {
            this.ocContractproMapper.insert(ocContractpro);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.savecontractproModel.ex", (Throwable)e);
        }
    }

    private void savecontractproBatchModel(List<OcContractpro> ocContractproList) throws ApiException {
        if (null == ocContractproList || ocContractproList.isEmpty()) {
            return;
        }
        try {
            this.ocContractproMapper.insertBatch(ocContractproList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.savecontractproBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractpro getcontractproModelById(Integer contractproId) {
        if (null == contractproId) {
            return null;
        }
        try {
            return this.ocContractproMapper.selectByPrimaryKey(contractproId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.getcontractproModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractpro getcontractproModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractproMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.getcontractproModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delcontractproModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractproMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.delcontractproModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.delcontractproModelByCode.num");
        }
    }

    private void deletecontractproModel(Integer contractproId) throws ApiException {
        if (null == contractproId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractproMapper.deleteByPrimaryKey(contractproId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.deletecontractproModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.deletecontractproModel.num");
        }
    }

    private void updatecontractproModel(OcContractpro ocContractpro) throws ApiException {
        if (null == ocContractpro) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractproMapper.updateByPrimaryKey(ocContractpro);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updatecontractproModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updatecontractproModel.num");
        }
    }

    private void updateStatecontractproModel(Integer contractproId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractproId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractproId", contractproId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractproMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updateStatecontractproModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updateStatecontractproModel.null");
        }
    }

    private void updateStatecontractproModelByCode(String tenantCode, String contractproBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractproBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproBillcode", contractproBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractproMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updateStatecontractproModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updateStatecontractproModelByCode.null");
        }
    }

    private OcContractpro makecontractpro(OcContractproDomain ocContractproDomain, OcContractpro ocContractpro) {
        if (null == ocContractproDomain) {
            return null;
        }
        if (null == ocContractpro) {
            ocContractpro = new OcContractpro();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractpro, (Object)ocContractproDomain);
            return ocContractpro;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.makecontractpro", (Throwable)e);
            return null;
        }
    }

    private OcContractproReDomain makeOcContractproReDomain(OcContractpro ocContractpro) {
        if (null == ocContractpro) {
            return null;
        }
        OcContractproReDomain ocContractproReDomain = new OcContractproReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractproReDomain, (Object)ocContractpro);
            return ocContractproReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.makeOcContractproReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractpro> querycontractproModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractproMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.querycontractproModel", (Throwable)e);
            return null;
        }
    }

    private int countcontractpro(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractproMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.countcontractpro", (Throwable)e);
        }
        return i;
    }

    private OcContractpro createOcContractpro(OcContractproDomain ocContractproDomain) {
        String msg = this.checkcontractpro(ocContractproDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.savecontractpro.checkcontractpro", msg);
        }
        OcContractpro ocContractpro = this.makecontractpro(ocContractproDomain, null);
        this.setcontractproDefault(ocContractpro);
        return ocContractpro;
    }

    @Override
    public String savecontractpro(OcContractproDomain ocContractproDomain) throws ApiException {
        OcContractpro ocContractpro = this.createOcContractpro(ocContractproDomain);
        this.savecontractproModel(ocContractpro);
        return ocContractpro.getContractproBillcode();
    }

    @Override
    public String savecontractproBatch(List<OcContractproDomain> ocContractproDomainList) throws ApiException {
        if (null == ocContractproDomainList || ocContractproDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractpro> ocContractproList = new ArrayList<OcContractpro>();
        String code = "";
        for (OcContractproDomain ocContractproDomain : ocContractproDomainList) {
            OcContractpro ocContractpro = this.createOcContractpro(ocContractproDomain);
            code = ocContractpro.getContractproBillcode();
            ocContractproList.add(ocContractpro);
        }
        this.savecontractproBatchModel(ocContractproList);
        return code;
    }

    @Override
    public void updatecontractproState(Integer contractproId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatecontractproModel(contractproId, dataState, oldDataState, map);
    }

    @Override
    public void updatecontractproStateByCode(String tenantCode, String contractproBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatecontractproModelByCode(tenantCode, contractproBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updatecontractpro(OcContractproDomain ocContractproDomain) throws ApiException {
        String msg = this.checkcontractpro(ocContractproDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updatecontractpro.checkcontractpro", msg);
        }
        OcContractpro oldOcContractpro = this.getcontractproModelById(ocContractproDomain.getContractproId());
        if (null == oldOcContractpro) {
            throw new ApiException("oc.CONTRACT.OcContractproServiceImpl.updatecontractpro.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractpro ocContractpro = this.makecontractpro(ocContractproDomain, oldOcContractpro);
        this.setcontractproUpdataDefault(ocContractpro);
        this.updatecontractproModel(ocContractpro);
    }

    @Override
    public OcContractpro getcontractpro(Integer contractproId) {
        return this.getcontractproModelById(contractproId);
    }

    @Override
    public void deletecontractpro(Integer contractproId) throws ApiException {
        this.deletecontractproModel(contractproId);
    }

    @Override
    public QueryResult<OcContractpro> querycontractproPage(Map<String, Object> map) {
        List<OcContractpro> ocContractproList = this.querycontractproModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countcontractpro(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractproList);
        return queryResult;
    }

    @Override
    public OcContractpro getcontractproByCode(String tenantCode, String contractproBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractproBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproBillcode", contractproBillcode);
        return this.getcontractproModelByCode(map);
    }

    @Override
    public void deletecontractproByCode(String tenantCode, String contractproBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractproBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproBillcode", contractproBillcode);
        this.delcontractproModelByCode(map);
    }

    @Override
    public List<OcContractpro> querycontractproByOrderCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return this.querycontractproModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
    }

    @Override
    public String createContractPro(Map<String, Object> map) {
        StringBuffer sbKey = new StringBuffer();
        map.keySet().stream().forEach(k -> {
            if (k.contains("key")) {
                sbKey.append(map.get(k)).append("-");
            }
        });
        sbKey.append(DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
        String key = sbKey.toString();
        String orderCount = DisUtil.getDisCache().getRemot(key);
        if (StringUtils.isNotBlank((String)orderCount)) {
            if (CONTRACT_PRO_OBJ.containsKey(key)) {
                if (Integer.parseInt(CONTRACT_PRO_OBJ.get(key) + "") > Integer.valueOf(orderCount)) {
                    orderCount = CONTRACT_PRO_OBJ.get(key) + "";
                }
                orderCount = Integer.valueOf(orderCount) + 1 + "";
            } else {
                orderCount = Integer.valueOf(orderCount) + 1 + "";
                CONTRACT_PRO_OBJ.put(key, orderCount);
            }
        } else {
            orderCount = "0001";
        }
        DisUtil.getDisCache().set(key, orderCount, 86400);
        try {
            DecimalFormat df = new DecimalFormat("0000");
            String daySn = df.format(Integer.parseInt(orderCount));
            OcContractproDomain pro = new OcContractproDomain();
            pro.setContractBillcode(map.get("contractBillcode") == null ? "" : map.get("contractBbillcode").toString());
            pro.setContractBbillcode(map.get("contractBbillcode") == null ? "" : map.get("contractBbillcode").toString());
            pro.setContractNbillcode(map.get("contractNbillcode") == null ? "" : map.get("contractNbillcode").toString());
            pro.setContractNbbillcode(map.get("contractNbbillcode") == null ? "" : map.get("contractNbbillcode").toString());
            pro.setContractproKey(map.get("proKey").toString());
            pro.setContractproName(map.get("proName").toString());
            pro.setContractproValue(daySn);
            pro.setTenantCode(map.get("tenantCode").toString());
            this.savecontractpro(pro);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractproServiceImpl.createContractPro.ex", (Object)e.getMessage());
        }
        return "success";
    }
}

