/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpRechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpRechargeServiceImpl
extends BaseServiceImpl
implements CrpRechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpRechargeServiceImpl";
    private CrpChannelsendService crpChannelsendService;
    private CrpRechargeMapper crpRechargeMapper;
    private CrpChannelsendBaseService crpChannelsendBaseService;

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public CrpChannelsendBaseService getCrpChannelsendBaseService() {
        return this.crpChannelsendBaseService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    public void setCrpRechargeMapper(CrpRechargeMapper crpRechargeMapper) {
        this.crpRechargeMapper = crpRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpRechargeDomain crpRechargeDomain) {
        if (null == crpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        if (null == crpRecharge.getDataState()) {
            crpRecharge.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == crpRecharge.getGmtCreate()) {
            crpRecharge.setGmtCreate(date);
        }
        crpRecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpRecharge.getRechargeCode())) {
            crpRecharge.setRechargeCode(this.getNo(null, "CrpRecharge", "crpRecharge", crpRecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpRechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        crpRecharge.setGmtModified(this.getSysDate());
    }

    @Override
    public List<CrpChannelsend> saveCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        CrpRecharge ctCustrel = this.createCrpRecharge(crpRechargeDomain);
        this.saveCrpModel(ctCustrel);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "insert");
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpRecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getRechargeCode());
            pmChannelsendDomain.setChannelsendType("crpRecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private void saveCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        try {
            this.crpRechargeMapper.insert(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpRecharge> crpRechargeList) throws ApiException {
        if (null == crpRechargeList || crpRechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpRechargeMapper.insertBatch(crpRechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpRecharge getCrpModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.crpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpRecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateByPrimaryKey(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpRecharge makeCrp(CrpRechargeDomain crpRechargeDomain, CrpRecharge crpRecharge) {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (null == crpRecharge) {
            crpRecharge = new CrpRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpRecharge, (Object)crpRechargeDomain);
            return crpRecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpRechargeReDomain makeCrpRechargeReDomain(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        CrpRechargeReDomain crpRechargeReDomain = new CrpRechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpRechargeReDomain, (Object)crpRecharge);
            return crpRechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrpRechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpRechargeReDomain> queryCrpModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryCrpRechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpRechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.countCrpRechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpRecharge createCrpRecharge(CrpRechargeDomain crpRechargeDomain) {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.makeCrp(crpRechargeDomain, null);
        this.setCrpDefault(crpRecharge);
        return crpRecharge;
    }

    @Override
    public List<CrpChannelsend> saveCrpRechargeBatch(List<CrpRechargeDomain> crpRechargeDomainList) throws ApiException {
        if (null == crpRechargeDomainList || crpRechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        for (CrpRechargeDomain crpRechargeDomain : crpRechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpRecharge(crpRechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(rechargeId, dataState, oldDataState, map);
        if (dataState != 2) {
            return null;
        }
        CrpRecharge crpRecharge = this.getCrpRecharge(rechargeId);
        this.handlerCrpRecharge(crpRecharge);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public String sendRechargeCrp(CpRechargeDomain cpRechargeDomain) throws ApiException {
        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)cpRechargeDomain);
            crpUrechargeDomain.setRechargeAllmoney(cpRechargeDomain.getRechargeMoney());
            crpUrechargeDomain.setRechargeSmoney(cpRechargeDomain.getRechargeMoney());
            crpUrechargeDomain.setUserinfoCode(cpRechargeDomain.getUserinfoCode());
            crpUrechargeDomain.setUserinfoName(cpRechargeDomain.getUserName());
            crpUrechargeDomain.setRechargeName2(cpRechargeDomain.getUserinfoName());
            String saveCrpUrecharge = this.crpChannelsendBaseService.saveCrpUrecharge(crpUrechargeDomain);
            if (StringUtils.isNotBlank((String)saveCrpUrecharge)) {
                return "success";
            }
            return "erro";
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
            return "erro";
        }
    }

    private void handlerCrpRecharge(CrpRecharge crpRecharge) {
        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)crpRecharge);
            crpUrechargeDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargeDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
            this.crpChannelsendBaseService.saveCrpUrecharge(crpUrechargeDomain);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpRecharge> crpRechargeList, String dri) {
        if (ListUtil.isEmpty(crpRechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge recharge : crpRechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(recharge.getRechargeCode());
            crpChannelsendDomain.setChannelsendType("crpRecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)recharge));
            crpChannelsendDomain.setTenantCode(recharge.getTenantCode());
            disChannelsendDomainList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeStateByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, rechargeCode, dataState, oldDataState, map);
        CrpRecharge orgDepartemp = this.getCrpByCode(tenantCode, rechargeCode);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.getCrpModelById(crpRechargeDomain.getRechargeId());
        if (null == crpRecharge) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        crpRecharge.setRechargePeriod(crpRechargeDomain.getRechargePeriod());
        crpRecharge.setRechargeMoney(crpRechargeDomain.getRechargeMoney());
        crpRecharge.setRechargeName8(crpRechargeDomain.getRechargeName8());
        crpRecharge.setRechargeName9(crpRechargeDomain.getRechargeName9());
        crpRecharge.setRechargeName10(crpRechargeDomain.getRechargeName10());
        crpRecharge.setRechargeState(crpRechargeDomain.getRechargeState());
        crpRecharge.setRechargeUrl4(crpRechargeDomain.getRechargeUrl4());
        if (crpRecharge.getRechargeState() == 2) {
            crpRecharge.setDataState(7);
        }
        this.setCrpUpdataDefault(crpRecharge);
        this.updateCrpModel(crpRecharge);
        if (crpRecharge.getRechargeState() != 2) {
            return null;
        }
        this.handlerCrpRecharge(crpRecharge);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> auditCrpRecharge(Map<String, Object> map) throws ApiException {
        Integer rechargeId = Integer.parseInt(map.get("rechargeId").toString());
        Integer dataState = Integer.parseInt(map.get("dataState").toString());
        CrpRecharge crpRecharge = this.getCrpModelById(rechargeId);
        if (null == crpRecharge) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        crpRecharge.setDataState(dataState);
        if (dataState == 6) {
            crpRecharge.setMemo(map.get("memo").toString());
        }
        this.setCrpUpdataDefault(crpRecharge);
        this.updateCrpModel(crpRecharge);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpRecharge getCrpRecharge(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        return this.getCrpModelById(rechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpRecharge(Integer rechargeId) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpRecharge(rechargeId);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(rechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpRecharge> queryCrpPage(Map<String, Object> map) {
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpRechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public QueryResult<CrpRechargeReDomain> queryCrpRechargePageList(Map<String, Object> map) {
        List<CrpRechargeReDomain> crpRechargeList = this.queryCrpModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public CrpRecharge getCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public List<CrpChannelsend> deleteCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpByCode(tenantCode, rechargeCode);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }
}

