/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpFtpConstants;
import com.yqbsoft.laser.service.crp.dao.CrpRechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.model.OcContract;
import com.yqbsoft.laser.service.crp.model.OcContractSettl;
import com.yqbsoft.laser.service.crp.model.SgSendgoodsGoods;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuter;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuterDt;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpRechargeServiceImpl
extends BaseServiceImpl
implements CrpRechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpRechargeServiceImpl";
    private CrpChannelsendService crpChannelsendService;
    private CrpRechargeMapper crpRechargeMapper;
    private CrpUrechargeService crpUrechargeService;
    private CrpChannelsendBaseService crpChannelsendBaseService;

    public CrpUrechargeService getCrpUrechargeService() {
        return this.crpUrechargeService;
    }

    public void setCrpUrechargeService(CrpUrechargeService crpUrechargeService) {
        this.crpUrechargeService = crpUrechargeService;
    }

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public CrpChannelsendBaseService getCrpChannelsendBaseService() {
        return this.crpChannelsendBaseService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    public void setCrpRechargeMapper(CrpRechargeMapper crpRechargeMapper) {
        this.crpRechargeMapper = crpRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpRechargeDomain crpRechargeDomain) {
        if (null == crpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        if (null == crpRecharge.getDataState()) {
            crpRecharge.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == crpRecharge.getGmtCreate()) {
            crpRecharge.setGmtCreate(date);
        }
        crpRecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpRecharge.getRechargeCode())) {
            crpRecharge.setRechargeCode(this.getNo(null, "CrpRecharge", "crpRecharge", crpRecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpRechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        crpRecharge.setGmtModified(this.getSysDate());
    }

    @Override
    public List<CrpChannelsend> saveCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        CrpRecharge ctCustrel = this.createCrpRecharge(crpRechargeDomain);
        this.saveCrpModel(ctCustrel);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "insert");
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpRecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getRechargeCode());
            pmChannelsendDomain.setChannelsendType("crpRecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private void saveCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        try {
            this.crpRechargeMapper.insert(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpRecharge> crpRechargeList) throws ApiException {
        if (null == crpRechargeList || crpRechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpRechargeMapper.insertBatch(crpRechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpRecharge getCrpModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.crpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpRecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateByPrimaryKey(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpRecharge makeCrp(CrpRechargeDomain crpRechargeDomain, CrpRecharge crpRecharge) {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (null == crpRecharge) {
            crpRecharge = new CrpRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpRecharge, (Object)crpRechargeDomain);
            return crpRecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpRechargeReDomain makeCrpRechargeReDomain(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        CrpRechargeReDomain crpRechargeReDomain = new CrpRechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpRechargeReDomain, (Object)crpRecharge);
            return crpRechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrpRechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpRechargeReDomain> queryCrpModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryCrpRechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpRechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.countCrpRechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpRecharge createCrpRecharge(CrpRechargeDomain crpRechargeDomain) {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.makeCrp(crpRechargeDomain, null);
        this.setCrpDefault(crpRecharge);
        return crpRecharge;
    }

    @Override
    public List<CrpChannelsend> saveCrpRechargeBatch(List<CrpRechargeDomain> crpRechargeDomainList) throws ApiException {
        if (null == crpRechargeDomainList || crpRechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        for (CrpRechargeDomain crpRechargeDomain : crpRechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpRecharge(crpRechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(rechargeId, dataState, oldDataState, map);
        if (dataState != 2) {
            return null;
        }
        CrpRecharge crpRecharge = this.getCrpRecharge(rechargeId);
        this.handlerCrpRecharge(crpRecharge);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    private void handlerCrpRecharge(CrpRecharge crpRecharge) {
        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)crpRecharge);
            crpUrechargeDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargeDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
            crpUrechargeDomain.setRechargeOpcode(crpRecharge.getRechargeOpcode());
            if (crpRecharge.getTenantCode().equals("568457092274532359")) {
                crpUrechargeDomain.setRechargeName8(String.valueOf(crpRecharge.getRechargeId()));
                this.crpChannelsendBaseService.saveCrpUrechargeByYg(crpUrechargeDomain);
            } else {
                this.crpChannelsendBaseService.saveCrpUrecharge(crpUrechargeDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpRecharge> crpRechargeList, String dri) {
        if (ListUtil.isEmpty(crpRechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge recharge : crpRechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(recharge.getRechargeCode());
            crpChannelsendDomain.setChannelsendType("crpRecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)recharge));
            crpChannelsendDomain.setTenantCode(recharge.getTenantCode());
            disChannelsendDomainList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeStateByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, rechargeCode, dataState, oldDataState, map);
        CrpRecharge orgDepartemp = this.getCrpByCode(tenantCode, rechargeCode);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.getCrpModelById(crpRechargeDomain.getRechargeId());
        if (null == crpRecharge) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        if (crpRecharge.getTenantCode().equals("568457092274532359")) {
            CrpRecharge crpRecharges = this.makeCrp(crpRechargeDomain, crpRecharge);
            this.setCrpUpdataDefault(crpRecharges);
            this.updateCrpModel(crpRecharges);
            if (crpRecharges.getDataState() == 2) {
                this.handlerCrpRecharge(crpRecharges);
            }
            list.add(crpRecharges);
        } else {
            crpRecharge.setRechargePeriod(crpRechargeDomain.getRechargePeriod());
            crpRecharge.setRechargeMoney(crpRechargeDomain.getRechargeMoney());
            crpRecharge.setRechargeName8(crpRechargeDomain.getRechargeName8());
            crpRecharge.setRechargeName9(crpRechargeDomain.getRechargeName9());
            crpRecharge.setRechargeName10(crpRechargeDomain.getRechargeName10());
            crpRecharge.setRechargeState(crpRechargeDomain.getRechargeState());
            crpRecharge.setRechargeUrl4(crpRechargeDomain.getRechargeUrl4());
            if (crpRecharge.getRechargeState() == 2) {
                crpRecharge.setDataState(7);
            }
            this.setCrpUpdataDefault(crpRecharge);
            this.updateCrpModel(crpRecharge);
            if (crpRecharge.getRechargeState() != 2) {
                return null;
            }
            this.handlerCrpRecharge(crpRecharge);
            list.add(crpRecharge);
        }
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> auditCrpRecharge(Map<String, Object> map) throws ApiException {
        Integer rechargeId = Integer.parseInt(map.get("rechargeId").toString());
        Integer dataState = Integer.parseInt(map.get("dataState").toString());
        CrpRecharge crpRecharge = this.getCrpModelById(rechargeId);
        if (null == crpRecharge) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        crpRecharge.setDataState(dataState);
        crpRecharge.setRechargeName1(map.get("rechargeName1") != null ? map.get("rechargeName1").toString() : null);
        crpRecharge.setRechargeName10(map.get("rechargeName10") != null ? map.get("rechargeName10").toString() : null);
        if (dataState == 6) {
            crpRecharge.setMemo(map.get("memo").toString());
        }
        this.setCrpUpdataDefault(crpRecharge);
        this.updateCrpModel(crpRecharge);
        if (dataState == 2) {
            this.handlerCrpRecharge(crpRecharge);
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpRecharge getCrpRecharge(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        return this.getCrpModelById(rechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpRecharge(Integer rechargeId) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpRecharge(rechargeId);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(rechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpRecharge> queryCrpPage(Map<String, Object> map) {
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public QueryResult<CrpRechargeReDomain> queryCrpRechargePageList(Map<String, Object> map) {
        List<CrpRechargeReDomain> crpRechargeList = this.queryCrpModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpRechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public CrpRecharge getCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public List<CrpChannelsend> deleteCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpByCode(tenantCode, rechargeCode);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeDeail(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("rechargeType", "0");
        map.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        map.put("rechargeState", CrpFtpConstants.RECHARGE_STATE_0);
        map.put("rechargeName7", "1");
        map.put("rechargeName3Str", "date");
        Integer i = 0;
        Boolean flag = true;
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal upMoney = BigDecimal.ZERO;
        SgSendgoodsReDomain sendgoodsReDomain = null;
        ArrayList<SgSendgoodsGoodsDomain> sendgoodsGoodsDomainList = null;
        do {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            QueryResult<CrpRecharge> queryResult = this.queryCrpPage(map);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.queryResult1", map);
                map.put("rechargeType", "1");
                queryResult = this.queryCrpPage(map);
            }
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.queryResult2", JsonUtil.buildNonNullBinder().toJson(map));
            }
            BigDecimal availableCredit = BigDecimal.ZERO;
            CrpRecharge crpRecharge = (CrpRecharge)queryResult.getList().get(0);
            if ("0".equals(crpRecharge.getRechargeName5())) {
                availableCredit = crpRecharge.getRechargeMoney();
            } else if ("1".equals(crpRecharge.getRechargeName5())) {
                availableCredit = crpRecharge.getRechargeMoney().divide(new BigDecimal(2));
            }
            if (null == crpRechargeDomain.getRechargeName10() || "".equals(crpRechargeDomain.getRechargeName10())) {
                throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.rechargeName10", JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
            }
            money = new BigDecimal(crpRechargeDomain.getRechargeName10());
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("tenantCode", crpRechargeDomain.getTenantCode());
            map1.put("contractBillcode", crpRechargeDomain.getRechargeOpcode());
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map1));
            String json = (String)this.getInternalRouter().inInvoke("oc.contract.getContractModelByCodes", sendMap);
            OcContract ocContract = (OcContract)JsonUtil.buildNonDefaultBinder().getJsonToObject(json, OcContract.class);
            if (null == ocContract) {
                throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.contrac", "\u8ba2\u5355\u6570\u636e\u9519\u8bef", JsonUtil.buildNonNullBinder().toJson(sendMap));
            }
            sendgoodsReDomain = new SgSendgoodsReDomain();
            sendgoodsGoodsDomainList = new ArrayList<SgSendgoodsGoodsDomain>();
            if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark()) && ("9".equals(crpRechargeDomain.getRechargeType()) || "8".equals(crpRechargeDomain.getRechargeType()))) {
                BigDecimal sendAmount;
                Boolean moneyFlag = false;
                if (null == ocContract.getContractPaymoney() || "".equals(ocContract.getContractPaymoney())) {
                    this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.contractPaymoney", (Object)ocContract.getContractBillcode());
                    ocContract.setContractPaymoney(BigDecimal.ZERO);
                }
                BigDecimal remainAmount = ocContract.getDataBmoney().subtract(ocContract.getContractPaymoney());
                map1.put("contractSettlBlance", "REB");
                String jsonList = (String)this.getInternalRouter().inInvoke("oc.contract.queryContractSettlPage", sendMap);
                SupQueryResult querynulListQuery = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonList, SupQueryResult.class);
                if (null != querynulListQuery && ListUtil.isNotEmpty((Collection)querynulListQuery.getList())) {
                    OcContractSettl ocContractSettl = (OcContractSettl)querynulListQuery.getList().get(0);
                    if (null == ocContractSettl.getContractSettlGmoney() || "".equals(ocContractSettl.getContractSettlGmoney())) {
                        this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractSettl));
                        throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u8fd4\u5229\u7ed3\u7b97\u6570\u636e\u9519\u8bef");
                    }
                    if ((remainAmount = remainAmount.subtract(ocContractSettl.getContractSettlGmoney())).compareTo(BigDecimal.ZERO) <= 0) {
                        this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", (Object)remainAmount);
                        throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u91d1\u989d\u9519\u8bef");
                    }
                }
                map1.remove("contractSettlBlance");
                map1.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
                map1.put("colValue9", -1);
                String sendGoodsJson = (String)this.getInternalRouter().inInvoke("sg.sendgoods.getSgSendGoods", sendMap);
                SgSendgoodsReDomain sgSendgoodsReDomain = (SgSendgoodsReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendGoodsJson, SgSendgoodsReDomain.class);
                if (null == sgSendgoodsReDomain || ListUtil.isEmpty(sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList())) {
                    this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.sgSendgoodsReDomain", (Object)remainAmount);
                    throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u53d1\u8d27\u5355\u6570\u636e\u9519\u8bef");
                }
                BigDecimal sendGoodsBmoney = sgSendgoodsReDomain.getDataBmoney();
                BigDecimal proportiMoney = sendGoodsBmoney.divide(ocContract.getDataBmoney()).setScale(8, 4);
                this.logger.info("service.adapter.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.sendGoodsBmoney", (Object)proportiMoney);
                money = sendAmount = proportiMoney.multiply(remainAmount).setScale(2, 4);
                try {
                    BeanUtils.copyAllPropertys((Object)sendgoodsReDomain, (Object)sgSendgoodsReDomain);
                    sendgoodsReDomain.setSgSendgoodsGoodsDomainList(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ocContract.getContractPaymoney().compareTo(BigDecimal.ZERO) == 0 && (null == querynulListQuery || ListUtil.isEmpty((Collection)querynulListQuery.getList()))) {
                    this.makeSendGoodsMoney(null, sendgoodsGoodsDomainList, sgSendgoodsReDomain);
                } else {
                    sendgoodsReDomain.setContractPaymoney(sendAmount);
                    this.makeSendGoodsMoney(sendAmount, sendgoodsGoodsDomainList, sgSendgoodsReDomain);
                }
                sendgoodsReDomain.setSgSendgoodsGoodsDomainList(sendgoodsGoodsDomainList);
            }
            if (availableCredit.compareTo(crpRecharge.getRechargeAmoney()) >= 0) {
                availableCredit = crpRecharge.getRechargeAmoney();
            }
            HashMap<String, Object> crpMap = new HashMap<String, Object>();
            if (availableCredit.compareTo(money) >= 0) {
                upMoney = availableCredit.subtract(money);
                crpRecharge.setRechargeAmoney(upMoney);
            } else {
                upMoney = availableCredit;
                BigDecimal availableCr = money.subtract(availableCredit);
                sendMap.clear();
                map.clear();
                sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
                sendMap.put("faccountType", "101");
                sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
                map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
                QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
                if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    throw new ApiException("service.adapter.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", ((Object)map).toString());
                }
                VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
                BigDecimal faccountAmount = vdFaccountOuter.getFaccountAmount();
                if (faccountAmount.compareTo(availableCr) < 0) {
                    throw new ApiException("service.adapter.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", faccountAmount + "," + availableCr);
                }
                vdFaccountOuter.setFaccountAmount(faccountAmount.subtract(availableCr));
                map = new HashMap();
                map.put("vdFaccountOuterDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
                this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuter", map);
                VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
                try {
                    BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuter);
                    vdFaccountOuterDt.setOrderAmount(availableCr);
                    vdFaccountOuterDt.setFaccountAfamount(vdFaccountOuter.getFaccountAmount());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                map = new HashMap();
                map.put("vdFaccountOuterDtDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
                this.getInternalRouter().inInvoke("vd.faccountOuter.saveFaccountOuterDt", map);
            }
            if (StringUtils.isBlank((String)crpRecharge.getRechargeUrl4())) {
                crpMap.put("rechargeUrl4Str", "1");
            } else {
                Integer integer = Integer.valueOf(crpRecharge.getRechargeUrl4());
                crpMap.put("rechargeUrl4Str", integer.toString());
            }
            crpMap.put("tenantCode", crpRecharge.getTenantCode());
            crpMap.put("rechargeUrl4", crpRecharge.getRechargeUrl4());
            crpMap.put("rechargeAmoney", crpRecharge.getRechargeAmoney());
            crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
            crpMap.put("gmtModified", crpRecharge.getGmtModified());
            Integer count = this.updateStateByCodeAndModified(crpMap);
            if (count < 1 && i > 80) {
                throw new ApiException("service.adapter.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", JsonUtil.buildNonNullBinder().toJson(crpMap));
            }
            if (count <= 0) continue;
            flag = false;
        } while (flag.booleanValue());
        map.remove("rechargeType");
        map.remove("rechargeState");
        map.remove("rechargeName7");
        map.remove("rechargeName3Str");
        map.put("rechargeOpcode", crpRechargeDomain.getRechargeOpcode());
        map.put("money", money);
        map.put("rechargeRemark", crpRechargeDomain.getRechargeRemark());
        map.put("sendGoods", sendgoodsReDomain);
        return this.crpUrechargeService.updateCrpUrecharges(map, upMoney);
    }

    public void makeSendGoodsMoney(BigDecimal sendGoodsBmoney, List<SgSendgoodsGoodsDomain> goodsDomainList, SgSendgoodsReDomain sgSendgoodsReDomain) {
        int i = 0;
        BigDecimal goodspecMoney = BigDecimal.ZERO;
        BigDecimal allMoney = BigDecimal.ZERO;
        for (SgSendgoodsGoodsDomain sendgoodsGoodsDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList()) {
            ++i;
            if (null == sendGoodsBmoney || "".equals(sendGoodsBmoney)) {
                sendgoodsGoodsDomain.setGoodsSpec(sendgoodsGoodsDomain.getContractGoodsMoney().toString());
                continue;
            }
            if (i != sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList().size()) {
                goodspecMoney = sendgoodsGoodsDomain.getContractGoodsMoney().divide(sendGoodsBmoney).setScale(8, 4).multiply(sendGoodsBmoney);
                sendgoodsGoodsDomain.setGoodsSpec(goodspecMoney.toString());
                allMoney = allMoney.add(goodspecMoney);
                continue;
            }
            allMoney = sendGoodsBmoney.subtract(allMoney);
            sendgoodsGoodsDomain.setGoodsSpec(allMoney.toString());
        }
    }

    private Integer updateStateByCodeAndModified(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateStateByCodeAndModified.map", map);
            return null;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCodeAndModified(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        return i;
    }

    @Override
    public String updateCrpVd(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
        sendMap.put("faccountType", "101");
        sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", ((Object)map).toString());
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpVd.rechargeName10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        HashMap<String, HashMap<String, String>> sendMaps = new HashMap<String, HashMap<String, String>>();
        map = new HashMap();
        map.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        sendMaps.put("map", map);
        QueryResult sendgoodsGoodsQueryResult = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", sendMap, SgSendgoodsGoods.class);
        if (null == sendgoodsGoodsQueryResult || ListUtil.isEmpty((Collection)sendgoodsGoodsQueryResult.getList())) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.sendgoodsGoodsQueryResult.null", JsonUtil.buildNonNullBinder().toJson(sendMaps));
        }
        VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
        BigDecimal faccountAmount = vdFaccountOuter.getFaccountAmount();
        if (null == faccountAmount || "".equals(faccountAmount)) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpVd.faccountAmount", (Object)JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            return "error";
        }
        BigDecimal consMoney = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if (faccountAmount.compareTo(consMoney) < 0) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.updateCrpVd.faccountAmount", (Object)("consMoney:" + consMoney + ",faccountAmount:" + faccountAmount));
            return "error";
        }
        BigDecimal remaMoney = faccountAmount.subtract(consMoney);
        vdFaccountOuter.setFaccountAmount(remaMoney);
        map = new HashMap();
        map.put("vdFaccountOuterDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
        this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuter", map);
        VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuter);
            vdFaccountOuterDt.setOrderAmount(consMoney);
            vdFaccountOuterDt.setFaccountAfamount(vdFaccountOuter.getFaccountAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map = new HashMap();
        map.put("vdFaccountOuterDtDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterDt));
        this.getInternalRouter().inInvoke("vd.faccountOuter.saveFaccountOuterDt", map);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.remove("contractBlance");
        objectMap.put("contractPaygmoney", consMoney);
        objectMap.put("contractBillcode", crpRechargeDomain.getRechargeOpcode());
        objectMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        this.getInternalRouter().inInvoke("oc.contract.updateContractPayAndSgContract", objectMap);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ArrayList<OcContractGoodsDomain> ocContractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (SgSendgoodsGoods goods : sendgoodsGoodsQueryResult.getList()) {
            ocContractGoodsDomain.setContractGoodsCode(goods.getContractGoodsCode());
            ocContractGoodsDomain.setTenantCode(goods.getTenantCode());
            ocContractGoodsDomain.setContractGoodsSendnum(goods.getGoodsCamount());
            ocContractGoodsDomainList.add(ocContractGoodsDomain);
        }
        HashMap<String, String> ocMap = new HashMap<String, String>();
        ocMap.put("ocContractGoodsDomains", JsonUtil.buildNormalBinder().toJson(ocContractGoodsDomainList));
        this.getInternalRouter().inInvoke("oc.contract.updateContractGoodsSenNumAndSgContract", ocMap);
        return "success";
    }
}

