/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpConstants;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class CrpRechargeBaseServiceImpl
extends BaseServiceImpl
implements CrpRechargeBaseService {
    private static final String SYS_CODE = "service.crp.CrpRechargeBaseServiceImpl";
    private CrpChannelsendBaseService crpChannelsendBaseService;
    CrpRechargeService crpRechargeService;

    public void setCrpRechargeService(CrpRechargeService crpRechargeService) {
        this.crpRechargeService = crpRechargeService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    @Override
    public String saveRechargeBase(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain || StringUtil.isBlank((String)crpRechargeDomain.getRechargeOpcode()) || StringUtil.isBlank((String)crpRechargeDomain.getUserinfoCode())) {
            this.logger.error("service.crp.CrpRechargeBaseServiceImpl.saveRechargeBase", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        this.crpChannelsendBaseService.sendChangeApply(crpRechargeDomain);
        return "success";
    }

    @Override
    public String updateSendUrechargeBase(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("cpRechargeDomain"))) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImplupdateSendUrechargeBase.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpChannelsendBaseService.updateSendAutoUrechargeStr(map);
        return "success";
    }

    @Override
    public String loadSendUrechargeBase(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_OPEN);
        map.put("rechargeType", "0");
        map.put("rechargeStartQend", new Date());
        map.put("rechargeEndQstart", new Date());
        map.put("rechargeName10", "0");
        QueryResult<CrpRecharge> qlist = this.crpRechargeService.queryCrpPage(map);
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStar(crpRecharge);
            }
        }
        map.remove("rechargeStartQend");
        map.remove("rechargeEndQstart");
        map.put("rechargeEndQend", new Date());
        qlist = this.crpRechargeService.queryCrpPage(map);
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEnd(crpRecharge);
            }
        }
        return null;
    }
}

