/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargelistMapper;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistReDomain;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrechargelist;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargelistServiceImpl
extends BaseServiceImpl
implements CrpUrechargelistService {
    private static final String SYS_CODE = "service.crp.CrpUrechargelistServiceImpl";
    private CrpUrechargelistMapper crpUrechargelistMapper;
    private CrpChannelsendService crpChannelsendService;
    private CrpUrechargeService crpUrechargeService;

    public void setCrpUrechargeService(CrpUrechargeService crpUrechargeService) {
        this.crpUrechargeService = crpUrechargeService;
    }

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public void setCrpUrechargelistMapper(CrpUrechargelistMapper crpUrechargelistMapper) {
        this.crpUrechargelistMapper = crpUrechargelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpUrechargelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeType())) {
            msg = msg + "RechargeType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getUserinfoCode())) {
            msg = msg + "UserinfoCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getUrechargelistDir())) {
            msg = msg + "UrechargelistDir\u4e3a\u7a7a;";
        }
        if (null == crpUrechargelistDomain.getRechargeSmoney()) {
            msg = msg + "RechargeSmoney\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrechargelist crpUrechargelist) {
        if (null == crpUrechargelist) {
            return;
        }
        if (null == crpUrechargelist.getDataState()) {
            crpUrechargelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrechargelist.getGmtCreate()) {
            crpUrechargelist.setGmtCreate(date);
        }
        crpUrechargelist.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrechargelist.getUrechargelistCode())) {
            crpUrechargelist.setUrechargelistCode(this.getNo(null, "CrpUrechargelist", "crpUrechargelist", crpUrechargelist.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrechargelist crpUrechargelist) {
        if (null == crpUrechargelist) {
            return;
        }
        crpUrechargelist.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrechargelist crpUrechargelist) throws ApiException {
        if (null == crpUrechargelist) {
            return;
        }
        try {
            this.crpUrechargelistMapper.insert(crpUrechargelist);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrechargelist> crpUrechargelistList) throws ApiException {
        if (null == crpUrechargelistList || crpUrechargelistList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargelistMapper.insertBatch(crpUrechargelistList);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrechargelist getCrpModelById(Integer urechargelistId) {
        if (null == urechargelistId) {
            return null;
        }
        try {
            return this.crpUrechargelistMapper.selectByPrimaryKey(urechargelistId);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargelist getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargelistId) throws ApiException {
        if (null == urechargelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.deleteByPrimaryKey(urechargelistId);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrechargelist crpUrechargelist) throws ApiException {
        if (null == crpUrechargelist) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.updateByPrimaryKey(crpUrechargelist);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargelistId", urechargelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpSmoneyModel(String tenantCode, BigDecimal rechargeSmoney, String urechargelistCode, String memo) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeSmoney", rechargeSmoney);
        map.put("urechargelistCode", urechargelistCode);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.updateSmoneyByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateStateCrpSmoneyModel.ex", (Throwable)e);
        }
    }

    private void updateCrpUrechlistToOrderModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.updateSmoneyByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrpUrechlistToOrderModel.ex", (Throwable)e);
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargelistCode", urechargelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrechargelist makeCrp(CrpUrechargelistDomain crpUrechargelistDomain, CrpUrechargelist crpUrechargelist) {
        if (null == crpUrechargelistDomain) {
            return null;
        }
        if (null == crpUrechargelist) {
            crpUrechargelist = new CrpUrechargelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelist, (Object)crpUrechargelistDomain);
            return crpUrechargelist;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargelistReDomain makeCrpUrechargelistReDomain(CrpUrechargelist crpUrechargelist) {
        if (null == crpUrechargelist) {
            return null;
        }
        CrpUrechargelistReDomain crpUrechargelistReDomain = new CrpUrechargelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistReDomain, (Object)crpUrechargelist);
            return crpUrechargelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.makeCrpUrechargelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrechargelist> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargelistServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrechargelist createCrpUrechargelist(CrpUrechargelistDomain crpUrechargelistDomain) {
        String msg = this.checkCrp(crpUrechargelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrechargelist crpUrechargelist = this.makeCrp(crpUrechargelistDomain, null);
        this.setCrpDefault(crpUrechargelist);
        return crpUrechargelist;
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargelist(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        CrpUrechargelist crpUrechargelist = this.createCrpUrechargelist(crpUrechargelistDomain);
        this.saveCrpModel(crpUrechargelist);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(crpUrechargelist);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargelistToMake(CrpUrechargelistDomain crpUrechargelistDomain, CrpUrechargelistDomain copyRechargelistDomain) throws ApiException {
        CrpUrechargelist crpUrechargelist = this.createCrpUrechargelist(copyRechargelistDomain);
        this.saveCrpModel(crpUrechargelist);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(crpUrechargelist);
        return this.buidPmChannelsend(list, "insert");
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpUrechargelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrechargelist promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargelistCode());
            pmChannelsendDomain.setChannelsendType("crpUrechargelist");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargelistBatch(List<CrpUrechargelistDomain> crpUrechargelistDomainList) throws ApiException {
        if (null == crpUrechargelistDomainList || crpUrechargelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> crpUrechargelistList = new ArrayList<CrpChannelsend>();
        for (CrpUrechargelistDomain crpUrechargelistDomain : crpUrechargelistDomainList) {
            List<CrpChannelsend> list = this.saveCrpUrechargelist(crpUrechargelistDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crpUrechargelistList.addAll(list);
        }
        return crpUrechargelistList;
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpUrechargelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrechargelist promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargelistCode());
            pmChannelsendDomain.setChannelsendType("crpUrechargelist");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargelistState(Integer urechargelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(urechargelistId, dataState, oldDataState, map);
        CrpUrechargelist orgDepartemp = this.getCrpUrechargelist(urechargelistId);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargelistStateByCode(String tenantCode, String urechargelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, urechargelistCode, dataState, oldDataState, map);
        CrpUrechargelist orgDepartemp = this.getCrpUrechargelistByCode(tenantCode, urechargelistCode);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargelist(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrechargelist oldCrpUrechargelist = this.getCrpModelById(crpUrechargelistDomain.getUrechargelistId());
        if (null == oldCrpUrechargelist) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrechargelist crpUrechargelist = this.makeCrp(crpUrechargelistDomain, oldCrpUrechargelist);
        this.setCrpUpdataDefault(crpUrechargelist);
        this.updateCrpModel(crpUrechargelist);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(oldCrpUrechargelist);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpUrechargelist getCrpUrechargelist(Integer urechargelistId) {
        if (null == urechargelistId) {
            return null;
        }
        return this.getCrpModelById(urechargelistId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrechargelist(Integer urechargelistId) throws ApiException {
        CrpUrechargelist orgDepartemp = this.getCrpUrechargelist(urechargelistId);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(orgDepartemp);
        this.deleteCrpModel(urechargelistId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpUrechargelist> queryCrpUrechargelistPage(Map<String, Object> map) {
        List<CrpUrechargelist> crpUrechargelistList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargelistList);
        return queryResult;
    }

    @Override
    public CrpUrechargelist getCrpUrechargelistByCode(String tenantCode, String urechargelistCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargelistCode", urechargelistCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrechargelistByCode(String tenantCode, String urechargelistCode) throws ApiException {
        CrpUrechargelist orgDepartemp = this.getCrpUrechargelistByCode(tenantCode, urechargelistCode);
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargelistCode", urechargelistCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public void updateCrpUrechargelistSmoney(String tenantCode, BigDecimal rechargeSmoney, String urechargelistCode, String memo) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || null == rechargeSmoney || StringUtils.isBlank((String)urechargelistCode)) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl\u53c2\u6570\u4e3a\u7a7a1");
        }
        this.updateStateCrpSmoneyModel(tenantCode, rechargeSmoney, urechargelistCode, memo);
    }

    @Override
    public void updateCrpUrechlistToOrder(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || null == map.get("tenantCode") || null == map.get("urechargelistCode")) {
            throw new ApiException("service.crp.CrpUrechargelistServiceImpl.updateCrpUrechlistToOrder", "\u53c2\u6570\u4e3a\u7a7a1");
        }
        this.updateCrpUrechlistToOrderModel(map);
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargelistToBlance(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        CrpUrechargelist crpUrechargelist = this.createCrpUrechargelist(crpUrechargelistDomain);
        this.saveCrpModel(crpUrechargelist);
        HashMap map = new HashMap();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        stringObjectMap.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        stringObjectMap.put("rechargeEnd", crpUrechargelistDomain.getRechargeEnd());
        stringObjectMap.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
        stringObjectMap.put("rechargeStart", crpUrechargelistDomain.getRechargeStart());
        QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(stringObjectMap);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
            BigDecimal decimal = BigDecimal.ZERO;
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeName10())) {
                crpUrechargelistDomain.setRechargeName10("0");
            }
            if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
                decimal = new BigDecimal(crpUrechargelistDomain.getRechargeName10()).multiply(new BigDecimal("-1"));
            }
            HashMap<String, Object> uMap = new HashMap<String, Object>();
            uMap.put("tenantCode", crpUrecharge.getTenantCode());
            uMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            uMap.put("userinfoCode", crpUrecharge.getUserinfoCode());
            uMap.put("rechargeSmoney", decimal);
            if ("25".equals(crpUrechargelistDomain.getRechargeType())) {
                uMap.put("type", "11");
            }
            this.crpUrechargeService.updateUrechargeBlanceByCode(uMap);
        }
        ArrayList<CrpUrechargelist> list = new ArrayList<CrpUrechargelist>();
        list.add(crpUrechargelist);
        return this.buidPmChannelsend(list, "insert");
    }
}

